(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1884438,      49811]
NotebookOptionsPosition[   1848417,      48725]
NotebookOutlinePosition[   1848949,      48746]
CellTagsIndexPosition[   1848906,      48743]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 StyleBox["\nCCOP - Connection Coefficients for Orthogonal Polynomials",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 "\n",
 StyleBox["\nP",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["ascal ",
  FontSize->18,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Maroni\n",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Laboratoire Jacques-Louis Lions - CNRS",
  FontSize->12,
  FontWeight->"Plain"],
 "\n",
 StyleBox["Universit\[EAcute] Pierre et Marie Curie \nBoite courrier 187,\n\
75252 Paris cedex 05, France\nEmail: maroni@ann.jussieu.fr\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["\nZ",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[EAcute]lia ",
  FontSize->18,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["da Rocha ",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["(corresponding author)",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["\n",
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Departamento de Matem\[AAcute]tica - CMUP\nFaculdade de \
Ci\[EHat]ncias da Universidade do Porto\nRua do Campo Alegre n.687, 4169 - \
007 Porto, Portugal\nEmail: mrdioh@fc.up.pt \n\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["July",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["2012 ",
  FontSize->18,
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["___________________________________________________________________\
________________________________",
  FontSize->12],
 StyleBox["\n\nThis software is related to the article:\n\nP. Maroni, Z. da \
Rocha, Connection coefficients for orthogonal polynomials: \nsymbolic \
computations, verifications and demonstrations in the ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[" language, \nNumerical Algorithms, 63-3 (2013) 507-520.\n\nRefer \
to this Software and Tutorial as:\n\nP. Maroni, Z. da Rocha, Software ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["CCOP - CONNECTION COEFFICIENTS FOR ORTHOGONAL POLYNOMIALS",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox[", \nNumerical Algorithms, (2013), www.netlib.org/numeralgo/   na34 \
package\n\nP. Maroni, Z. da Rocha, Software ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["CCOP",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["  - TUTORIAL, \nNumerical Algorithms, 40 p. (2013), \
www.netlib.org/numeralgo/ \n\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["CCOP",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox[" version ",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic"],
 StyleBox["1.0",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["\nWolfram ",
  FontSize->12,
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["Mathematica",
     FontSize->14,
     FontWeight->"Plain"], 
    StyleBox["\[RegisteredTrademark]",
     FontSize->10]], TraditionalForm]]],
 StyleBox[" ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["8.0.4.0",
  FontSize->12,
  FontSlant->"Italic"],
 StyleBox["\n",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["___________________________________________________________________\
________________________________",
  FontSize->12]
}], "Section",
 CellChangeTimes->{{3.4559276614736*^9, 3.455927668383087*^9}, {
   3.455927924656355*^9, 3.455927938245006*^9}, {3.455999141463578*^9, 
   3.4559992635930433`*^9}, {3.456508600396578*^9, 3.4565086326770163`*^9}, {
   3.473788655082548*^9, 3.473788656260908*^9}, 3.490793838698908*^9, {
   3.494673814323554*^9, 3.4946738201282463`*^9}, {3.533377646005364*^9, 
   3.5333776548867607`*^9}, {3.53366471471255*^9, 3.533664844350284*^9}, {
   3.533664875234655*^9, 3.533664897479549*^9}, {3.5336661453802757`*^9, 
   3.533666146122656*^9}, {3.533666193089673*^9, 3.533666210512691*^9}, {
   3.5336662434433727`*^9, 3.533666243633697*^9}, {3.533666305890287*^9, 
   3.5336663113591127`*^9}, {3.533666526056782*^9, 3.5336665406824636`*^9}, {
   3.53475271826875*^9, 3.534752723089593*^9}, {3.543311507697164*^9, 
   3.5433115084091597`*^9}, {3.543568696869503*^9, 3.543568715780306*^9}, {
   3.545638638769746*^9, 3.545638639192396*^9}, {3.545733837974769*^9, 
   3.545733838715391*^9}, {3.5481574141428747`*^9, 3.5481574278957977`*^9}, {
   3.548406911647938*^9, 3.548406929770262*^9}, {3.5529350257592163`*^9, 
   3.552935088842393*^9}, {3.552935148408827*^9, 3.552935167558544*^9}, {
   3.552935566201271*^9, 3.552935602075018*^9}, {3.552936678587846*^9, 
   3.5529366795877132`*^9}, {3.611606202260964*^9, 3.611606207090089*^9}, 
   3.6116062425173473`*^9, {3.663458144784342*^9, 3.663458173059586*^9}, {
   3.6634590139521523`*^9, 3.663459043424827*^9}}],

Cell[CellGroupData[{

Cell["\<\
References
\
\>", "Section",
 CellChangeTimes->{
  3.455999327645267*^9, {3.455999368230609*^9, 3.455999370458517*^9}}],

Cell[TextData[{
 StyleBox["Main reference:\n\n[1] ",
  FontWeight->"Bold"],
 "P. Maroni, Z. da Rocha, Connection coefficients for orthogonal polynomials: \
\nsymbolic computations, verifications and demonstrations in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language, \nsubmitted for publication,",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["Numerical Algorithms, (20XX) yyy-zzz",
  FontSize->12,
  FontWeight->"Plain"],
 ".",
 StyleBox["\n\nSecondary references:",
  FontWeight->"Bold"],
 "\n\n[2] P. Maroni, Z. da Rocha, Connection coefficients for orthogonal \
polynomials and the canonical sequence, \nPreprints CMUP, Centro de Matem\
\[AAcute]tica da Universidade do Porto, 29, 1-18, 2007, \n\
(http://cmup.fc.up.pt/cmup/v2/frames/publications.htm).\n\n[3] P. Maroni, Z. \
da Rocha, Connection coefficients between orthogonal polynomials and the \
canonical sequence: \nan approach based on symbolic computation, Numerical \
Algorithms, 47-3 (2008) 291-314.\n\n[4] P. Maroni, Z. da Rocha, Software ",
 StyleBox["CCOP - ",
  FontSlant->"Italic"],
 "CONNECTION COEFFICIENTS FOR ORTHOGONAL POLYNOMIALS",
 StyleBox[" - ",
  FontSlant->"Italic"],
 "Version 1.0",
 StyleBox[" - ",
  FontSlant->"Italic"],
 "TUTORIAL, library NUMERALGO, NETLIB, package na34, 2012. \
http://www.netlib.org/numeralgo/\n\n",
 StyleBox["[5]", "Code",
  FontWeight->"Plain"],
 " T. S. Chihara, An Introduction to Orthogonal Polynomials, Gordon and \
Breach, New York, 1978.\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" references:\n\n",
  FontWeight->"Bold"],
 "- Help of ",
 StyleBox["Wolfram ",
  FontSize->12,
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["Mathematica",
     FontSize->14,
     FontWeight->"Plain"], 
    StyleBox["\[RegisteredTrademark]",
     FontSize->9]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox[" ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["8.0.4.0.",
  FontSize->12,
  FontSlant->"Italic"],
 "\n- VIRTUAL BOOK - ",
 StyleBox["Wolfram ",
  FontSize->12,
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["Mathematica",
     FontSize->14,
     FontWeight->"Plain"], 
    StyleBox["\[RegisteredTrademark]",
     FontSize->9]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox[" ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["8.0.4.0",
  FontSize->12,
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold"],
 "-",
 StyleBox[" ",
  FontWeight->"Bold"],
 "Stephen Wolfram, The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Book, 4th ed., Wolfram Media/Cambridge University Press, 1999.\n"
}], "Text",
 CellChangeTimes->{
  3.4559984988377457`*^9, {3.455998549676031*^9, 3.4559987626113863`*^9}, {
   3.4559988589321003`*^9, 3.4559988767013083`*^9}, {3.4559989644956713`*^9, 
   3.45599898719733*^9}, {3.455999030817161*^9, 3.4559991209055557`*^9}, {
   3.456095712639648*^9, 3.456095731888475*^9}, {3.456095776634776*^9, 
   3.456095792849874*^9}, {3.456095851541576*^9, 3.456095852984091*^9}, {
   3.456096284667911*^9, 3.4560963043612947`*^9}, {3.4560985146458817`*^9, 
   3.456098537299735*^9}, {3.456098595311919*^9, 3.456098598630106*^9}, {
   3.4564283188243303`*^9, 3.456428344256515*^9}, {3.456428377042542*^9, 
   3.456428428314249*^9}, {3.45901772221168*^9, 3.459017725882051*^9}, {
   3.459206763806233*^9, 3.4592067642675867`*^9}, {3.459208112954527*^9, 
   3.459208174436763*^9}, {3.459208265797551*^9, 3.459208356730126*^9}, {
   3.459208446490821*^9, 3.459208447151874*^9}, {3.459448389305338*^9, 
   3.459448436909717*^9}, {3.467190620884581*^9, 3.4671906254328012`*^9}, {
   3.490793811736623*^9, 3.4907938133685503`*^9}, {3.5249414957017384`*^9, 
   3.5249415210362797`*^9}, {3.533377726496294*^9, 3.5333777616944027`*^9}, {
   3.5333778042918367`*^9, 3.5333778058547583`*^9}, {3.533665046043292*^9, 
   3.533665058644264*^9}, {3.533665102188899*^9, 3.5336651573732758`*^9}, {
   3.533666025379519*^9, 3.5336660462675247`*^9}, {3.5347525676587753`*^9, 
   3.5347525694134007`*^9}, {3.534752757002232*^9, 3.5347527982383633`*^9}, {
   3.543311396327881*^9, 3.543311464835535*^9}, {3.543311498177331*^9, 
   3.543311501209607*^9}, {3.5433115383744698`*^9, 3.543311556670629*^9}, {
   3.548406960461597*^9, 3.548406990215907*^9}, 3.552935185476717*^9, {
   3.552935233256816*^9, 3.5529354565678787`*^9}, {3.552935496400187*^9, 
   3.552935496880436*^9}, {3.55293585577579*^9, 3.552935904582568*^9}, {
   3.552935951603696*^9, 3.5529360312949867`*^9}, {3.552936199437147*^9, 
   3.552936201426919*^9}, {3.552936667456716*^9, 3.552936668524624*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Main Commands
\
\>", "Section",
 CellChangeTimes->{{3.455999505296259*^9, 3.455999521281426*^9}, {
   3.479035643828837*^9, 3.479035660823258*^9}, {3.5123288126263638`*^9, 
   3.512328824142625*^9}, {3.512406762817041*^9, 3.512406765901464*^9}, 
   3.51240690698989*^9, {3.5124072102025127`*^9, 3.512407210777067*^9}, {
   3.512408127475237*^9, 3.512408137568891*^9}, {3.518028212168378*^9, 
   3.5180282186371613`*^9}, {3.518028271137792*^9, 3.518028274937405*^9}, {
   3.518033442735268*^9, 3.518033459396215*^9}, {3.5193203871016607`*^9, 
   3.519320387508142*^9}, {3.51946925766288*^9, 3.519469261621482*^9}, {
   3.519493894746057*^9, 3.5194939480850563`*^9}, {3.533665411309813*^9, 
   3.533665427581416*^9}, 3.533666115866794*^9}],

Cell[CellGroupData[{

Cell["\<\
Main Commands for Standard Cases
\
\>", "Subsection",
 CellChangeTimes->{
  3.455999327645267*^9, {3.455999368230609*^9, 3.455999389061823*^9}, {
   3.45599948920284*^9, 3.455999490120635*^9}, {3.5336656716923323`*^9, 
   3.533665676408781*^9}, {3.5336666082834873`*^9, 3.533666610920321*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\n\nCommand:\nCC[rc, rct][p][pt][n, m]\n\n\
Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "computes recursively the connection coefficient",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], 
    StyleBox[":=",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    RowBox[{
     SubscriptBox["\[Lambda]", 
      RowBox[{"n", ",", "m"}]], 
     StyleBox[
      RowBox[{"(", 
       RowBox[{"P", "\[LeftArrow]", 
        FormBox[
         StyleBox[
          OverscriptBox["P", "~"],
          FontWeight->"Bold",
          FontSlant->"Italic"],
         TraditionalForm]}], ")"}],
      FontWeight->"Bold",
      FontSlant->"Italic"]}]}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "defined in (9), using the initial \nconditions (10)-(12) and the recurrence \
relation (13) of [1].\n\n",
 StyleBox["Arguments:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nof the two polynomials sequences ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows:\n",
 StyleBox["rc[p_ _ _][n_]:=...[...; Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; \nrct[pt_ _ _][n_]:=...[...; Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "are the indexes of the connection coefficients; they must be integers.\n\n\
",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["commands used:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["Factor",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " or",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["Together",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontSlant->"Italic"],
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "- ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.455928077131528*^9, 3.455928096499886*^9}, 
   3.455928286907866*^9, {3.455993488924452*^9, 3.4559937047339077`*^9}, 
   3.455994256282959*^9, {3.455994328550445*^9, 3.45599432963067*^9}, {
   3.455994698557404*^9, 3.455994777081648*^9}, {3.455998100824592*^9, 
   3.455998228299487*^9}, {3.4560958419553537`*^9, 3.456095845855631*^9}, {
   3.4560963162369347`*^9, 3.456096317587572*^9}, {3.456096534818819*^9, 
   3.456096536193598*^9}, {3.456096781784152*^9, 3.456096785741691*^9}, {
   3.4560968322150307`*^9, 3.4560968482882147`*^9}, {3.456096974259197*^9, 
   3.456096975473351*^9}, {3.45609847655756*^9, 3.456098477194537*^9}, {
   3.456178438461453*^9, 3.456178449327036*^9}, {3.456178493030501*^9, 
   3.456178519159245*^9}, {3.4561785536931133`*^9, 3.4561786474338837`*^9}, {
   3.456178684132923*^9, 3.4561787385011883`*^9}, {3.456178780364626*^9, 
   3.456178788713217*^9}, {3.456178824512126*^9, 3.4561789751196537`*^9}, {
   3.459208216926894*^9, 3.459208229443322*^9}, {3.4612618353283587`*^9, 
   3.461261861469544*^9}, {3.463353461349633*^9, 3.463353471351657*^9}, {
   3.463959659317404*^9, 3.463959750402326*^9}, 3.4640897581099243`*^9, 
   3.467190614020132*^9, {3.467190781423593*^9, 3.4671908065977087`*^9}, {
   3.490695894718878*^9, 3.49069591361966*^9}, {3.490702038856143*^9, 
   3.490702181542609*^9}, {3.490787519784935*^9, 3.490787555069593*^9}, {
   3.494311381769135*^9, 3.494311382819392*^9}, {3.524941640999222*^9, 
   3.524941660523137*^9}, {3.543568794583671*^9, 3.5435688099506817`*^9}, {
   3.543568947196487*^9, 3.5435689637559643`*^9}, {3.5435689985227118`*^9, 
   3.543569000656686*^9}, {3.543569064390491*^9, 3.543569068028781*^9}, {
   3.5435691011160917`*^9, 3.5435691040656567`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "CC", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"n", " ", "<", " ", "0"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CC", "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "n", "]"}], ",", 
          RowBox[{"n", "<", "0"}]}], "]"}]}], ",", 
       RowBox[{"m_", "/;", 
        RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CC", "[", 
          RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
        "]"}], "[", 
       RowBox[{"n", ",", "m"}], "]"}], "=", "0"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"m", " ", "<", " ", "0"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CC", "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
       RowBox[{"m_", "/;", 
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "m", "]"}], ",", 
          RowBox[{"m", "<", "0"}]}], "]"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CC", "[", 
          RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
        "]"}], "[", 
       RowBox[{"n", ",", "m"}], "]"}], "=", "0"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"n", "=", "m"}], " ", ",", " ", 
     RowBox[{"n", " ", "\[GreaterEqual]", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CC", "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "n", "]"}], ",", 
          RowBox[{"n", "\[GreaterEqual]", "0"}]}], "]"}]}], ",", 
       RowBox[{"n_", "/;", 
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "n", "]"}], ",", 
          RowBox[{"n", "\[GreaterEqual]", "0"}]}], "]"}]}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CC", "[", 
          RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
        "]"}], "[", 
       RowBox[{"n", ",", "n"}], "]"}], "=", "1"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"n", " ", "=", " ", "1"}], " ", ",", " ", 
     RowBox[{"m", " ", "=", " ", "0"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CC", "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{"1", ",", "0"}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CC", "[", 
          RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
        "]"}], "[", 
       RowBox[{"1", ",", "0"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{"Factor", "[", 
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"rct", "[", "pt", "]"}], "[", "0", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"rc", "[", "p", "]"}], "[", "0", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], " ", "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"n", " ", ",", " ", "m"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CC", "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
       RowBox[{"m_", "/;", 
        RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CC", "[", 
          RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
        "]"}], "[", 
       RowBox[{"n", ",", "m"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{"If", "[", "  ", 
       RowBox[{
        RowBox[{"And", "[", 
         RowBox[{
          RowBox[{"n", "\[GreaterEqual]", " ", "0"}], ",", " ", 
          RowBox[{"n", "\[LessEqual]", " ", 
           RowBox[{"m", "-", "1"}]}]}], "]"}], ",", "    ", 
        RowBox[{"Return", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Return", "[", "  ", 
          RowBox[{"Factor", "[", 
           RowBox[{
           "FullSimplify", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"rct", "[", "pt", "]"}], "[", "m", "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", 
                RowBox[{
                 RowBox[{
                  RowBox[{"rc", "[", "p", "]"}], "[", 
                  RowBox[{"n", "-", "1"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CC", "[", 
                  RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], 
                "[", "pt", "]"}], "[", 
               RowBox[{
                RowBox[{"n", "-", "1"}], ",", "m"}], "]"}]}], "-", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rc", "[", "p", "]"}], "[", 
                RowBox[{"n", "-", "1"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CC", "[", 
                  RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], 
                "[", "pt", "]"}], "[", 
               RowBox[{
                RowBox[{"n", "-", "2"}], ",", "m"}], "]"}]}], "+", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rct", "[", "pt", "]"}], "[", 
                RowBox[{"m", "+", "1"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"CC", "[", 
                  RowBox[{"rc", ",", " ", "rct"}], "]"}], "[", "p", "]"}], 
                "[", "pt", "]"}], "[", 
               RowBox[{
                RowBox[{"n", "-", "1"}], ",", 
                RowBox[{"m", "+", "1"}]}], "]"}]}], "+", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"CC", "[", 
                 RowBox[{"rc", ",", "rct"}], "]"}], "[", "p", "]"}], "[", 
               "pt", "]"}], "[", 
              RowBox[{
               RowBox[{"n", "-", "1"}], ",", 
               RowBox[{"m", "-", "1"}]}], "]"}]}], "\[IndentingNewLine]", 
            "                                             ", "]"}], "]"}], 
          "\[IndentingNewLine]", "     ", "]"}], " ", ";"}]}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"end", " ", "of", " ", "Return"}], " ", "*)"}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], " ", ";"}], 
   " ", 
   RowBox[{"(*", " ", 
    RowBox[{"end", " ", "of", " ", "If"}], " ", "*)"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.3929257911441317`*^9, 3.3929258190379477`*^9}, {
   3.3929346097739573`*^9, 3.392934668807335*^9}, 3.4559283165048428`*^9, {
   3.455990374801427*^9, 3.455990723292803*^9}, {3.455991218057041*^9, 
   3.455991235178624*^9}, {3.455993736048595*^9, 3.455993872080352*^9}, {
   3.455998346965885*^9, 3.45599838323552*^9}, {3.45616870609648*^9, 
   3.45616870971168*^9}, {3.456169032571134*^9, 3.456169037467429*^9}, {
   3.4639596185779467`*^9, 3.46395965071336*^9}, {3.5463311923560266`*^9, 
   3.546331198984761*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\n\nCommand:\nMOP[rc][p][n, x]\n\nDescription:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " computes recursively the monic orthogonal polynomial of degree ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " in the variable ",
 StyleBox["x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 ", using the \ninitial conditions (3) and the recurrence relation (4) of \
[1].\n\n",
 StyleBox["Arguments:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the name of the command that defines de recurrence coefficients ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 "; it must be a symbol.\n- ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows ",
 StyleBox["rc[p_ _ _][n_]:=...[...; Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "is the sequence of parameters of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}],
     FontWeight->"Bold"], ",", " ", 
    RowBox[{"if", " ", "any"}]}], TraditionalForm]]],
 ".",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "is the degree, it must be an integer.\n- ",
 StyleBox["x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "is the variable, it should be a symbol or a numeric expression.\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["Collect",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 StyleBox["Factor",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " or",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["Together",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontSlant->"Italic"],
 StyleBox["Simplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "or",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "- ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 ".\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.4420176809575043`*^9, 3.442017773921256*^9}, {
   3.455991853617888*^9, 3.4559918590492687`*^9}, {3.4559920961705*^9, 
   3.455992132486353*^9}, {3.455992607608842*^9, 3.45599262211971*^9}, {
   3.455992770711318*^9, 3.455992886058496*^9}, {3.455992933538419*^9, 
   3.455993194870343*^9}, {3.455993234048728*^9, 3.455993355341359*^9}, {
   3.455994524020197*^9, 3.455994543205265*^9}, {3.455994574904429*^9, 
   3.45599465999788*^9}, {3.45599824093858*^9, 3.455998321973089*^9}, {
   3.4560959329424343`*^9, 3.456095962657651*^9}, {3.456096524257821*^9, 
   3.4560965246581373`*^9}, {3.456096750493835*^9, 3.456096767677223*^9}, {
   3.4560968596872807`*^9, 3.4560968717486477`*^9}, {3.45609699403301*^9, 
   3.4560969961469707`*^9}, 3.456098468617469*^9, {3.4561791926262827`*^9, 
   3.456179214914122*^9}, {3.4561792487978363`*^9, 3.4561793302752037`*^9}, {
   3.456428548470182*^9, 3.456428561800123*^9}, {3.459448565102902*^9, 
   3.459448590742124*^9}, {3.461261925296393*^9, 3.4612619286144753`*^9}, {
   3.4633535232254868`*^9, 3.463353530003064*^9}, {3.463959786612514*^9, 
   3.463959815320731*^9}, 3.467190640099015*^9, {3.46719076918676*^9, 
   3.467190774867733*^9}, {3.4671908172767897`*^9, 3.467190820476058*^9}, {
   3.490695852257134*^9, 3.490695869710619*^9}, {3.490702194605386*^9, 
   3.490702209902391*^9}, {3.490787622058675*^9, 3.4907876223370123`*^9}, {
   3.494311389359354*^9, 3.4943113900828*^9}, {3.5249417285206537`*^9, 
   3.5249417385018806`*^9}, 3.534752917275516*^9, {3.543568871026496*^9, 
   3.543568873274328*^9}, {3.5435690219871073`*^9, 3.543569024815551*^9}, {
   3.543569147795144*^9, 3.543569200882477*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "MOP", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "rc_Symbol", "]"}], "[", "p___", "]"}], "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{"IntegerQ", "[", "n", "]"}], ",", 
         RowBox[{"n", "<", "0"}]}], "]"}]}], ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
      RowBox[{"n", ",", "x"}], "]"}], "=", "0"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "rc_Symbol", "]"}], "[", "p___", "]"}], "[", 
     RowBox[{"0", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
      RowBox[{"0", ",", "x"}], "]"}], "=", "1"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "rc_Symbol", "]"}], "[", "p___", "]"}], "[", 
     RowBox[{"1", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
      RowBox[{"1", ",", "x"}], "]"}], "=", "\[IndentingNewLine]", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"x", "-", 
       RowBox[{
        RowBox[{
         RowBox[{"rc", "[", "p", "]"}], "[", "0", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "  ", "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "rc_Symbol", "]"}], "[", "p___", "]"}], "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"And", "[", 
        RowBox[{
         RowBox[{"IntegerQ", "[", "n", "]"}], " ", ",", " ", 
         RowBox[{"n", "\[GreaterEqual]", "2"}]}], "]"}]}], ",", "x_"}], "]"}],
     ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
      RowBox[{"n", ",", "x"}], "]"}], "=", "\[IndentingNewLine]", 
     RowBox[{"If", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"NumericQ", "[", "x", "]"}], "===", "False"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{
        StyleBox["Return", "Input"], 
        StyleBox["[", "Input"], 
        StyleBox[" ", "Input"], 
        RowBox[{
         StyleBox["Collect", "Input"], 
         StyleBox["[", "Input"], 
         StyleBox[" ", "Input"], 
         RowBox[{
          RowBox[{"FullSimplify", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", 
               RowBox[{
                RowBox[{
                 RowBox[{"rc", "[", "p", "]"}], "[", 
                 RowBox[{"n", "-", "1"}], "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{
               RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
              RowBox[{
               RowBox[{"n", "-", "1"}], ",", "x"}], "]"}]}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"rc", "[", "p", "]"}], "[", 
               RowBox[{"n", "-", "1"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "*", 
             RowBox[{
              RowBox[{
               RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
              RowBox[{
               RowBox[{"n", "-", "2"}], ",", "x"}], "]"}]}]}], " ", "]"}], 
          ",", "x", ",", "Factor"}], "]"}], " ", "]"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", " ", 
        RowBox[{"FullSimplify", "[", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", 
             RowBox[{
              RowBox[{
               RowBox[{"rc", "[", "p", "]"}], "[", 
               RowBox[{"n", "-", "1"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", "x"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"n", "-", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "2"}], ",", "x"}], "]"}]}]}], "  ", "]"}], " ",
         "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
   StyleBox[";", "Input"]}], 
  StyleBox["  ", "Input"], 
  RowBox[{
   StyleBox["(*", "Input"], " ", 
   RowBox[{"end", " ", "of", " ", "If"}], " ", 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQvetl1fta95eOpu8EPoLovFn6+xSWvnR8FOZ2DUTr
zda/DaLDb98C0/uyzIVigXTK+mOyINrs6TMlEL3oyjoVEH2ldI8viP6+Jy8F
RC9LmZkBou+KH80G0fcPn80H0Ub5/EUgmkVftBZEx7B8AtNquZOugGiT3fpX
QfTJGxz3QPSd/TJPQHTF6kdsJ/a/dKwJlxYH0UoTXsiD6JkWn5VAtNWrLREg
+l69VjyI/mGm4jr3wEtHO3lTNxC9YHGxyjIg/eS2nxqIzlgvYAiiZx3xMALR
Vgz1ZiA6r+qRHYhuOarmAqK1/uqGg+g5j3rTQfQP/rsZIFrO7lcRiNbjvVkN
lvddXngESOt89i0G0TneJeUgOv/Jz2oQLe15cuWvcy8dBWbMWg2iAboP0kI=

  "]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\n\nCommand:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["verificationRCC[rc, rct][p][pt][nmax]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["verificationRCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " makes a verification of the first connection coefficients, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], 
   StyleBox[":=",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"P", "\[LeftArrow]", 
       FormBox[
        StyleBox[
         OverscriptBox["P", "~"],
         FontWeight->"Bold",
         FontSlant->"Italic"],
        TraditionalForm]}], ")"}],
     FontWeight->"Bold",
     FontSlant->"Italic"]}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", computed \nrecursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command up to an index",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["n=nmax",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["verificationRCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is based on the definition (9) of the connection coefficients [1]. \n\n",
 StyleBox["Arguments:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nof the two polynomials sequences ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows: \n",
 StyleBox["rc[p_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; \nrct[pt_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of  ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["nmax",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "must be a non negative integer.\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Other commands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used",
  FontWeight->"Bold"],
 StyleBox[":",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 StyleBox["MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["- Returns ",
  FontSlant->"Italic"],
 StyleBox["True",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "if the the verification is correct, returns ",
 StyleBox["False",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " otherwise.\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.392926362394573*^9, 3.3929263874612722`*^9}, {
   3.445041884572825*^9, 3.4450419270114098`*^9}, {3.445043163908527*^9, 
   3.4450431820779*^9}, {3.4559921596444893`*^9, 3.455992266405746*^9}, {
   3.455992626278857*^9, 3.455992634725102*^9}, {3.455993890876494*^9, 
   3.455994249085552*^9}, {3.455994321830415*^9, 3.455994427588355*^9}, {
   3.455994465542967*^9, 3.455994473444655*^9}, {3.455994846819931*^9, 
   3.455994874220186*^9}, 3.4559953653696213`*^9, {3.4559956114816713`*^9, 
   3.455995732923661*^9}, {3.455998079975266*^9, 3.4559980859563913`*^9}, {
   3.4560960135112543`*^9, 3.4560960234240913`*^9}, 3.456096516847876*^9, {
   3.456096716506753*^9, 3.456096736107627*^9}, {3.456096886977641*^9, 
   3.456096889760026*^9}, {3.4560970024349194`*^9, 3.4560970113260508`*^9}, {
   3.4560970518598003`*^9, 3.4560970559400463`*^9}, 3.456098462759444*^9, {
   3.456166953329802*^9, 3.456166954892913*^9}, {3.456179444769671*^9, 
   3.456179451557356*^9}, {3.456428630725175*^9, 3.4564286377007523`*^9}, {
   3.4564286703846483`*^9, 3.456428671015847*^9}, {3.456428704495812*^9, 
   3.456428723230451*^9}, {3.459448703163455*^9, 3.4594487435241528`*^9}, {
   3.463959938999771*^9, 3.4639599457919188`*^9}, 3.464089732609139*^9, {
   3.4671907585595407`*^9, 3.46719076378999*^9}, {3.467190827575775*^9, 
   3.467190833298676*^9}, 3.490695820467181*^9, {3.490702219842561*^9, 
   3.490702245083105*^9}, {3.4907876630955877`*^9, 3.490787665927211*^9}, {
   3.4942337380991297`*^9, 3.4942337417204638`*^9}, {3.494311398542922*^9, 
   3.494311399218316*^9}, {3.524941822728837*^9, 3.52494182334464*^9}, {
   3.54356889106462*^9, 3.543568900112322*^9}, 3.543569040344213*^9, {
   3.543569236713209*^9, 3.543569267669486*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "verificationRCC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"verificationRCC", "[", 
       RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
      "]"}], "[", "pt___", "]"}], "[", 
    RowBox[{"nmax_", "/;", 
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "nmax", "]"}], ",", 
       RowBox[{"nmax", "\[GreaterEqual]", " ", "0"}]}], "]"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"answer", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"True", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}]}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"FullSimplify", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"MOP", "[", "rc", "]"}], "[", "p", "]"}], "[", 
            RowBox[{"n", ",", "x"}], "]"}], "-", 
           RowBox[{
            UnderoverscriptBox["\[Sum]", 
             RowBox[{"\[Nu]", "=", "0"}], "n"], 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"CC", "[", 
                 RowBox[{"rc", ",", "rct"}], "]"}], "[", "p", "]"}], "[", 
               "pt", "]"}], "[", 
              RowBox[{"n", ",", "\[Nu]"}], "]"}], "*", 
             RowBox[{
              RowBox[{
               RowBox[{"MOP", "[", "rct", "]"}], "[", "pt", "]"}], "[", 
              RowBox[{"\[Nu]", ",", "x"}], "]"}]}]}]}], "]"}], "===", "0"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "nmax"}], "}"}]}], "]"}], "===", 
      "answer"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.392415234428773*^9, 3.3924154807247868`*^9}, {
   3.392415524954288*^9, 3.392415548459386*^9}, {3.3924156139319153`*^9, 
   3.392415628149811*^9}, {3.392419683093563*^9, 3.392419705848914*^9}, {
   3.392419769517412*^9, 3.392419770097595*^9}, {3.392420016848542*^9, 
   3.392420019700411*^9}, {3.392926005195595*^9, 3.3929260635820217`*^9}, {
   3.392926102497188*^9, 3.392926144688653*^9}, {3.392926182727726*^9, 
   3.392926312047316*^9}, 3.392934668834374*^9, {3.3929352655740957`*^9, 
   3.392935266512579*^9}, {3.392935869967526*^9, 3.392935894675129*^9}, {
   3.392940763111229*^9, 3.392940766139928*^9}, {3.442018160574643*^9, 
   3.442018232313221*^9}, {3.442142205221711*^9, 3.4421422217819*^9}, {
   3.442143121549752*^9, 3.4421431684870358`*^9}, 3.445040559006914*^9, 
   3.445041931519014*^9, {3.445043802934175*^9, 3.445043912498735*^9}, {
   3.445043946587873*^9, 3.445043970511285*^9}, {3.445045553710153*^9, 
   3.445045557846627*^9}, {3.455994818217222*^9, 3.455994834018417*^9}, {
   3.455994884086143*^9, 3.455994923272443*^9}, 3.461262125312758*^9, {
   3.463959954566248*^9, 3.463959962064053*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["verificationDCC[dcc][rc, rct][p][pt][nmax]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\t\t\t\t\t\n",
 StyleBox["verificationDCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "makes a comparison between the values of the connection coefficients, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], 
   StyleBox[":=",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"P", "\[LeftArrow]", 
       FormBox[
        StyleBox[
         OverscriptBox["P", "~"],
         FontWeight->"Bold",
         FontSlant->"Italic"],
        TraditionalForm]}], ")"}],
     FontWeight->"Bold",
     FontSlant->"Italic"]}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \ncomputed by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command and the ones computed using a direct closed formula, this up to \
the index ",
 StyleBox["n=nmax",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n ",
 StyleBox["Arguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-  ",
 StyleBox["dcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the name of the command that implements the direct closed formula; it \
must be a symbol.\n-  ",
 StyleBox["dcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows: ",
 StyleBox["dcc[p_ _ _][pt_ _ _][n_, m_]:=...[...;Return[",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nof the two polynomials sequences ",
 StyleBox["P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows: \n",
 StyleBox["rc[p_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; \nrct[pt_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n-  ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["nmax",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "must be a non negative integer.\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Other commands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["CC",
  FontSlant->"Italic"],
 StyleBox[".",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["- Returns ",
  FontSlant->"Italic"],
 StyleBox["True",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "if the verification is correct, returns ",
 StyleBox["False",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "otherwise.\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.392926362394573*^9, 3.3929263874612722`*^9}, {
   3.445041884572825*^9, 3.4450419270114098`*^9}, {3.445043157735765*^9, 
   3.445043189493137*^9}, {3.455992658143374*^9, 3.4559926624866953`*^9}, {
   3.4559953359915752`*^9, 3.4559955040463657`*^9}, {3.455995552101054*^9, 
   3.455995585650694*^9}, {3.45599576183508*^9, 3.455995809640695*^9}, {
   3.4559959315488453`*^9, 3.455995975308693*^9}, {3.455996044495893*^9, 
   3.4559960600025253`*^9}, {3.4559978764012003`*^9, 3.455997876990651*^9}, {
   3.455998004379006*^9, 3.455998062778204*^9}, {3.456096104220319*^9, 
   3.4560961291786337`*^9}, {3.45609616562779*^9, 3.456096167134397*^9}, {
   3.4560965000888853`*^9, 3.456096508297366*^9}, {3.456096695193911*^9, 
   3.4560967012576313`*^9}, {3.456096897725449*^9, 3.456096915560155*^9}, {
   3.456097017929758*^9, 3.45609704088102*^9}, 3.456098457081415*^9, {
   3.456166987782228*^9, 3.4561669892122517`*^9}, {3.456179466342843*^9, 
   3.456179483547386*^9}, {3.4564287585148563`*^9, 3.4564287651707487`*^9}, {
   3.4564287981074753`*^9, 3.456428832257275*^9}, {3.459448808760591*^9, 
   3.459448811313445*^9}, {3.4612620401336927`*^9, 3.4612620876853237`*^9}, {
   3.461262157497304*^9, 3.461262158881757*^9}, {3.463960025655016*^9, 
   3.463960051457622*^9}, {3.4639600944500723`*^9, 3.4639601405510817`*^9}, {
   3.463960180039195*^9, 3.463960205070711*^9}, {3.464089702532823*^9, 
   3.464089718102479*^9}, {3.467190651338147*^9, 3.46719067235207*^9}, {
   3.467190746854725*^9, 3.467190752632926*^9}, 3.490702258962463*^9, {
   3.490787699756452*^9, 3.4907877331472*^9}, {3.494233726021441*^9, 
   3.494233729529295*^9}, {3.494311405438792*^9, 3.494311406201782*^9}, {
   3.5435689199909897`*^9, 3.543568932349636*^9}, {3.543569306619431*^9, 
   3.5435693635746813`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "verificationDCC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"verificationDCC", "[", "dcc_Symbol", "]"}], "[", 
       RowBox[{"rc_Symbol", ",", "rct_Symbol"}], "]"}], "[", "p___", "]"}], 
     "[", "pt___", "]"}], "[", 
    RowBox[{"nmax_", "/;", 
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "nmax", "]"}], ",", 
       RowBox[{"nmax", "\[GreaterEqual]", " ", "0"}]}], "]"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"answer", "=", 
       RowBox[{"Table", "[", 
        RowBox[{"True", ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "0", ",", "nmax"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FullSimplify", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{"n", ",", "m"}], "]"}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"CC", "[", 
               RowBox[{"rc", ",", "rct"}], "]"}], "[", "p", "]"}], "[", "pt", 
             "]"}], "[", 
            RowBox[{"n", ",", "m"}], "]"}]}], "]"}], "===", "0"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "nmax"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "===", 
      "answer"}]}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.392415234428773*^9, 3.3924154807247868`*^9}, {
   3.392415524954288*^9, 3.392415548459386*^9}, {3.3924156139319153`*^9, 
   3.392415628149811*^9}, {3.392419683093563*^9, 3.392419705848914*^9}, {
   3.392419769517412*^9, 3.392419770097595*^9}, {3.392420016848542*^9, 
   3.392420019700411*^9}, {3.392926005195595*^9, 3.3929260635820217`*^9}, {
   3.392926102497188*^9, 3.392926144688653*^9}, {3.392926182727726*^9, 
   3.392926312047316*^9}, 3.392934668834374*^9, {3.3929352655740957`*^9, 
   3.392935266512579*^9}, {3.392935869967526*^9, 3.392935894675129*^9}, {
   3.392940763111229*^9, 3.392940766139928*^9}, {3.442018160574643*^9, 
   3.442018232313221*^9}, {3.442142205221711*^9, 3.4421422217819*^9}, {
   3.442143121549752*^9, 3.4421431684870358`*^9}, 3.445040559006914*^9, 
   3.445041931519014*^9, {3.445043192034705*^9, 3.445043401426803*^9}, {
   3.445043557322804*^9, 3.445043558292547*^9}, 3.445044001289222*^9, {
   3.4450440605037813`*^9, 3.4450441041184072`*^9}, {3.445044140568099*^9, 
   3.44504415792255*^9}, {3.445045607765195*^9, 3.445045623084434*^9}, {
   3.45599582895266*^9, 3.45599589985045*^9}, {3.456180824552553*^9, 
   3.4561808284049473`*^9}, {3.456183185465798*^9, 3.4561832498235292`*^9}, {
   3.463959973291843*^9, 3.463959983545079*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\n\nCommand: \ndemonstrationDCC[dcc][rc, \
rct][p][pt][n, m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\t\t\t\t\t\n",
 StyleBox["demonstrationDCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "tries to demonstrate the direct closed formula for the connection \
coefficients for every ",
 StyleBox["n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 StyleBox["m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Arguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-  ",
 StyleBox["dcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the name of the command that implements the direct closed formula; it \
must be a symbol.\n-  ",
 StyleBox["dcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows: ",
 StyleBox["dcc[p_ _ _][pt_ _ _][n_, m_]:=...[...;Return[",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nof the two polynomials sequences ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as folows:\n ",
 StyleBox["rc[p_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; \n rct[pt_ _ _][n_]:=...[...;Return[{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", 
     RowBox[{"n", " "}]], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of  ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "are symbols and represent non negative integers such that ",
 StyleBox["0\[LessEqual]m\[LessEqual]n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\n",
  FontSlant->"Italic"],
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "with",
 StyleBox[" ",
  FontSlant->"Italic"],
 "or without ",
 StyleBox["Assumptions",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["- Returns ",
  FontSlant->"Italic"],
 StyleBox["True",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " achivies the demonstration, returns ",
 StyleBox["False",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " otherwise.\t\t\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.392926362394573*^9, 3.3929263874612722`*^9}, {
   3.392932594997485*^9, 3.3929326184120817`*^9}, 3.3929344226756077`*^9, {
   3.4559926728935843`*^9, 3.455992675472065*^9}, {3.4559961020886097`*^9, 
   3.455996166144621*^9}, {3.4559977949830027`*^9, 3.455997872082302*^9}, {
   3.455997925270845*^9, 3.455997981298929*^9}, {3.4560962004258757`*^9, 
   3.456096239561738*^9}, {3.456096456573588*^9, 3.4560964922118607`*^9}, {
   3.456096648766358*^9, 3.456096675166298*^9}, 3.4560968243758707`*^9, {
   3.4560969508554163`*^9, 3.456096951707849*^9}, 3.456098449473267*^9, {
   3.456179498362137*^9, 3.456179513777499*^9}, {3.456428848840014*^9, 
   3.456428885760819*^9}, {3.457351018571213*^9, 3.457351019034925*^9}, {
   3.4574244630661087`*^9, 3.45742446447383*^9}, {3.458301134776372*^9, 
   3.458301136645226*^9}, {3.4594488873285427`*^9, 3.4594488937385807`*^9}, {
   3.461262179106614*^9, 3.461262185994306*^9}, {3.461262252915538*^9, 
   3.4612622890285187`*^9}, {3.463960169720886*^9, 3.463960175467787*^9}, {
   3.463960221602626*^9, 3.463960224074647*^9}, {3.46408960400147*^9, 
   3.464089608879101*^9}, 3.464089692268777*^9, {3.467190678821279*^9, 
   3.467190684817253*^9}, {3.467190735496254*^9, 3.467190741141295*^9}, {
   3.4671908495299664`*^9, 3.467190853084651*^9}, {3.481872931674178*^9, 
   3.4818729317100773`*^9}, 3.490702268642871*^9, {3.490787775386944*^9, 
   3.4907877862163343`*^9}, {3.4943114115732718`*^9, 
   3.4943114122889442`*^9}, {3.524941945601351*^9, 3.52494196806319*^9}, {
   3.543569383707597*^9, 3.54356942253057*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "demonstrationDCC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"demonstrationDCC", "[", "dcc_Symbol", "]"}], "[", 
        RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
       "]"}], "[", "pt___", "]"}], "[", 
     RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"And", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"m", "=", "0"}], " ", ",", " ", 
       RowBox[{"n", "=", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{"1", ",", "0"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"rct", "[", "pt", "]"}], "[", "0", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"rc", "[", "p", "]"}], "[", "0", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "===", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", "0"}], " ", ",", " ", 
        RowBox[{"n", "=", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", "  ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{"2", ",", "0"}], "]"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", "0", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", "1", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{"1", ",", "0"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"rc", "[", "p", "]"}], "[", "1", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"rct", "[", "pt", "]"}], "[", "1", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], " ", "\[IndentingNewLine]", 
        "\t\t\t", "]"}], "===", "0"}], " ", ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", "0"}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterEqual]", "3"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", "  ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{"n", ",", "0"}], "]"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"rct", "[", "pt", "]"}], "[", "0", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"rc", "[", "p", "]"}], "[", 
               RowBox[{"n", "-", "1"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", "0"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"n", "-", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "2"}], ",", "0"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", "1", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", "1"}], "]"}]}]}], " ", ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterEqual]", "3"}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t   ", "]"}], "===", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterEqual]", "2"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", "  ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{"n", ",", 
            RowBox[{"n", "-", "1"}]}], "]"}], "-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", 
              RowBox[{"n", "-", "1"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", 
              RowBox[{"n", "-", "1"}], "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"n", "-", "2"}]}], "]"}]}], " ", ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterEqual]", "2"}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t   ", "]"}], "===", "0"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"0", "<", "m", "<", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterEqual]", "3"}]}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", "  ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{"n", ",", "m"}], "]"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"rct", "[", "pt", "]"}], "[", "m", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"rc", "[", "p", "]"}], "[", 
               RowBox[{"n", "-", "1"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", "m"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"n", "-", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "2"}], ",", "m"}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{"m", "+", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"n", "-", "1"}], ",", 
             RowBox[{"m", "+", "1"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"m", "-", "1"}]}], "]"}]}], " ", ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", 
            RowBox[{"Element", "[", 
             RowBox[{"m", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterEqual]", "3"}], ",", " ", 
            RowBox[{"m", ">", "0"}], ",", " ", 
            RowBox[{"m", "<", 
             RowBox[{"n", "-", "1"}]}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t   ", "]"}], "===", "0"}]}], 
     "\[IndentingNewLine]", "  ", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"end", " ", "of", " ", "And"}], " ", "*)"}], "  "}]}], "Input",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.44504420642476*^9, 
   3.44504420904922*^9}, {3.445045075803726*^9, 3.445045115244755*^9}, {
   3.445045183956438*^9, 3.445045186660989*^9}, {3.4450452309471807`*^9, 
   3.4450452332893267`*^9}, {3.455996302676022*^9, 3.4559966508037024`*^9}, {
   3.456183716774783*^9, 3.456183720787897*^9}, {3.457423414095571*^9, 
   3.457423419279791*^9}, {3.4574234554235764`*^9, 3.45742345956501*^9}, {
   3.4574280607768307`*^9, 3.45742809119781*^9}, {3.463959993094989*^9, 
   3.463959999719458*^9}, {3.4818729317497377`*^9, 3.481872931783136*^9}, {
   3.524943106394752*^9, 3.524943109963068*^9}, {3.524943190948132*^9, 
   3.524943225724956*^9}, {3.524943322199788*^9, 3.524943396542387*^9}, {
   3.533378338064028*^9, 3.533378359959827*^9}, {3.533666974511697*^9, 
   3.533667028669158*^9}, {3.534756294324627*^9, 3.534756303011733*^9}, {
   3.5433120464188423`*^9, 3.543312061942629*^9}, 3.5433121049796047`*^9, {
   3.5433176300813217`*^9, 3.5433176471777287`*^9}, {3.543331626206069*^9, 
   3.543331626798696*^9}, {3.5433317881962337`*^9, 3.543331788755748*^9}, {
   3.54333187844631*^9, 3.5433318790699253`*^9}, {3.543332127765645*^9, 
   3.543332128021106*^9}, {3.543569526328964*^9, 3.5435697057029667`*^9}, {
   3.543569737941852*^9, 3.543569856521718*^9}, {3.5435699161363277`*^9, 
   3.543570119668312*^9}, {3.543570162930682*^9, 3.543570168376862*^9}, {
   3.5435703197394333`*^9, 3.543570417616671*^9}, {3.5435757020552998`*^9, 
   3.543575703549988*^9}, {3.5435757774505453`*^9, 3.543575779959833*^9}, {
   3.545647919487432*^9, 3.545647922852051*^9}, {3.545733023602982*^9, 
   3.5457330271589518`*^9}, {3.546947491602043*^9, 3.5469475080485783`*^9}, {
   3.5472039755376577`*^9, 3.547204053649962*^9}, {3.547204215569914*^9, 
   3.547204232680716*^9}, {3.547204856395464*^9, 3.547204859488311*^9}, {
   3.5472050719415693`*^9, 3.547205073627469*^9}}],

Cell["\<\

(**************************************************************************** \

Version, without Assumption, corresponding to the main recurrence relation \
with the 
shift n \[RightArrow] n+2 and m \[RightArrow] m+1.
*****************************************************************************)\
\>", "Text",
 CellChangeTimes->CompressedData["
1:eJwdzH0o3HEAx/HbyREX/6w2kjwXajPF/GHyxUyRKzZnHra67m6/GadM7GKa
Q5bylPJs3fGH/JT543C71Txmw9xQF1H8w+n383AeVody2/fz++PT66/PO1BR
mqUSi0SiIDo4+Y1R1D7jiL6p6gMcUDb766h+hglBY35xMIz/PBcDEzuvEqFJ
W0KgeWtRCU89wlVwsGv1o43lSGxHYA0MMGl56G59Y4chfU4H3Ah7cQUzZbu3
MCIp3AmvDdZHy9O0N/WyEEpWuo2hMxwpj/WZgEde85K6OY5I/zJu8Kz5xBO2
3S2Twt873ekN1IrnahkM8wieurFwZNXVIbh9W5kSes6R995awT+GDH16Mk/K
138I+sh3WbgZ/fgrZJWp32F8fvsCrJcmKRXZPDmcdKrhxuu1bDtVUpOQCy0a
aZxLDv1FyAUrTm9a5Gqe+Be8bYVl435dVuqIm7kH/pINDcAHrPgLfOjOVC0V
8eSeKqEa7p/n7V1Qx3xNB7Az6F/BJfUTE1kIjz2f2pJLeHLga+eh+afmEr4b
7XdAnS5KP0u9P3wmyGpmo3gqcyclDlbaxurgK0tHo2CasQWuiZ/0wv+9wyL3

  "]],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "demonstrationDCC", "]"}], ";", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"demonstrationDCC", "[", "dcc_Symbol", "]"}], "[", 
        RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
       "]"}], "[", "pt___", "]"}], "[", 
     RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
        RowBox[{
         RowBox[{"n", "+", "2"}], ",", 
         RowBox[{"m", "+", "1"}]}], "]"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"rct", "[", "pt", "]"}], "[", 
            RowBox[{"m", "+", "1"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"rc", "[", "p", "]"}], "[", 
            RowBox[{"n", "+", "1"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"m", "+", "1"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"rc", "[", "p", "]"}], "[", 
          RowBox[{"n", "+", "1"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{"n", ",", 
          RowBox[{"m", "+", "1"}]}], "]"}]}], "-", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"rct", "[", "pt", "]"}], "[", 
          RowBox[{"m", "+", "2"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", 
          RowBox[{"m", "+", "2"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
        RowBox[{
         RowBox[{"n", "+", "1"}], ",", "m"}], "]"}]}], " ", "]"}], "===", 
     "0"}]}], ";"}], "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.44504420642476*^9, 
   3.44504420904922*^9}, {3.445045075803726*^9, 3.445045115244755*^9}, {
   3.445045183956438*^9, 3.445045186660989*^9}, {3.4450452309471807`*^9, 
   3.4450452332893267`*^9}, {3.455996302676022*^9, 3.4559966508037024`*^9}, {
   3.456183716774783*^9, 3.456183720787897*^9}, {3.457423414095571*^9, 
   3.457423419279791*^9}, {3.4574234554235764`*^9, 3.45742345956501*^9}, {
   3.4574280607768307`*^9, 3.45742809119781*^9}, {3.463959993094989*^9, 
   3.463959999719458*^9}, {3.4818729317497377`*^9, 3.481872931783136*^9}, {
   3.524943106394752*^9, 3.524943109963068*^9}, {3.524943190948132*^9, 
   3.524943225724956*^9}, {3.524943322199788*^9, 3.524943396542387*^9}, {
   3.533378338064028*^9, 3.533378359959827*^9}, {3.533666974511697*^9, 
   3.5336670099528837`*^9}, {3.534756288388526*^9, 3.534756290723958*^9}, {
   3.543317623841609*^9, 3.543317627292495*^9}, {3.5435757368965387`*^9, 
   3.543575757813435*^9}, {3.543575789103489*^9, 3.543575792083274*^9}, {
   3.545648091250999*^9, 3.54564809794984*^9}, {3.5457328588420277`*^9, 
   3.545732909753257*^9}, {3.545733863972972*^9, 3.5457338653565063`*^9}, {
   3.5469473781577053`*^9, 3.546947415472033*^9}, {3.5469474834618807`*^9, 
   3.546947516895925*^9}, {3.547204865515931*^9, 3.547204871520397*^9}, {
   3.547287942044759*^9, 3.5472880021251717`*^9}, {3.547288605465633*^9, 
   3.5472886366189413`*^9}, {3.547288693633834*^9, 3.547288721287451*^9}, 
   3.54728875958116*^9, {3.547289011828476*^9, 3.5472890176750097`*^9}}],

Cell["\<\

(****************************************************** 
Version, without Assumptions, with the main recurrence relation. 
*******************************************************)\
\>", "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQB2IQvW1nRlKj+0vHBV3VFSB6bkqvXBOQllm4FUxvic5R
BtE2HYdMQbTDtB8OIHpHZa4jiN5141gKiH7HpZkKohdNP1v7bNVLR7PJinUg
WmFH5SsQzXE1/T2IVpn97zuIvqQW+gNE+/nf+wuitZw0/4HonwuvGp7aDzRv
e2QsiGY7PWOL6oGXjiVmkltB9Gu+w2zNh1468nzJYAfRH3rfcoPoCSJFPCD6
zO0Z3q1AuiwkzR9Eq3Epb/917qXjWdbvYPrW33IX1Y8vHYv5K8H0+YU+C7yd
XzmWXNwHpiXD760C0deNzNeD6FUpbrtBtE30xCMguoXHKSUp+JXj823/0kD0
pfgLwe+BNFudXQSIPpfHY8EcBtSnFQ6my9796gtPe+UoF5PZD6KLNshMvwqk
V7LvmgmiT/gvngui9VYxzQPR+hwZ1SezXjmKp9rVgOgnH6PufwLS66R2PAXR
05T+x3wG0g0Z2rEgeu7nnZ+dc185PtA9AqbdKldpvwLSUgc89UG0zBGZOSC6
SX/nIhANAKMqCBc=
  "]],

Cell[BoxData[
 RowBox[{"(*", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", "demonstrationDCC", "]"}], ";", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"demonstrationDCC", "[", "dcc_Symbol", "]"}], "[", 
        RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
       "]"}], "[", "pt___", "]"}], "[", 
     RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FullSimplify", "[", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
        RowBox[{"n", ",", "m"}], "]"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"rct", "[", "pt", "]"}], "[", "m", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"rc", "[", "p", "]"}], "[", 
            RowBox[{"n", "-", "1"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "m"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"rc", "[", "p", "]"}], "[", 
          RowBox[{"n", "-", "1"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{
          RowBox[{"n", "-", "2"}], ",", "m"}], "]"}]}], "-", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"rct", "[", "pt", "]"}], "[", 
          RowBox[{"m", "+", "1"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", 
          RowBox[{"m", "+", "1"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{
         RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
        RowBox[{
         RowBox[{"n", "-", "1"}], ",", 
         RowBox[{"m", "-", "1"}]}], "]"}]}], " ", "]"}], "===", "0"}]}], 
   ";"}], "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}]], "Input",\

 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.44504420642476*^9, 
   3.44504420904922*^9}, {3.445045075803726*^9, 3.445045115244755*^9}, {
   3.445045183956438*^9, 3.445045186660989*^9}, {3.4450452309471807`*^9, 
   3.4450452332893267`*^9}, {3.455996302676022*^9, 3.4559966508037024`*^9}, {
   3.456183716774783*^9, 3.456183720787897*^9}, {3.457423414095571*^9, 
   3.457423419279791*^9}, {3.4574234554235764`*^9, 3.45742345956501*^9}, {
   3.4574280607768307`*^9, 3.45742809119781*^9}, {3.463959993094989*^9, 
   3.463959999719458*^9}, {3.4818729317497377`*^9, 3.481872931783136*^9}, {
   3.524943106394752*^9, 3.524943109963068*^9}, {3.524943190948132*^9, 
   3.524943225724956*^9}, {3.524943322199788*^9, 3.524943396542387*^9}, {
   3.533378338064028*^9, 3.533378359959827*^9}, {3.533666974511697*^9, 
   3.5336670099528837`*^9}, {3.534756288388526*^9, 3.534756290723958*^9}, {
   3.543317623841609*^9, 3.543317627292495*^9}, {3.5435757368965387`*^9, 
   3.543575757813435*^9}, {3.543575789103489*^9, 3.543575792083274*^9}, {
   3.545648091250999*^9, 3.54564809794984*^9}, {3.5457328588420277`*^9, 
   3.545732909753257*^9}, {3.545733863972972*^9, 3.5457338653565063`*^9}, {
   3.546947485810988*^9, 3.5469474861306*^9}, {3.547287901327304*^9, 
   3.5472879303047*^9}, {3.547288800898939*^9, 3.547288830191359*^9}, 
   3.547289008854491*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Main Command for Symmetric Cases
\
\>", "Subsection",
 CellChangeTimes->{
  3.455999327645267*^9, {3.455999368230609*^9, 3.455999389061823*^9}, {
   3.45599948920284*^9, 3.455999490120635*^9}, {3.4573506042470512`*^9, 
   3.457350620371624*^9}, {3.533666615736147*^9, 3.53366661885574*^9}, {
   3.533666850919704*^9, 3.533666854895442*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\nCommand: \ndemonstrationSymDCC[symdcc][rc, \
rct][p][pt][n, m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\t\t\t\t\t\n",
 StyleBox["demonstrationSymDCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "tries to demonstrate the direct closed formulas for the connection \
coefficients\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], 
   StyleBox[":=",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"P", "\[LeftArrow]", 
       FormBox[
        StyleBox[
         OverscriptBox["P", "~"],
         FontWeight->"Bold",
         FontSlant->"Italic"],
        TraditionalForm]}], ")"}],
     FontWeight->"Bold",
     FontSlant->"Italic"]}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", when ",
 Cell[BoxData[
  RowBox[{"P", " ", 
   StyleBox["and",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   FormBox[
    StyleBox[
     OverscriptBox["P", "~"],
     FontWeight->"Bold",
     FontSlant->"Italic"],
    TraditionalForm]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are symmetrical polynomial sequences, that is,  \n",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["= 0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox[
     SubscriptBox["\[Beta]", 
      RowBox[{"n", " "}]], "~"],
    FontWeight->"Bold"], TraditionalForm]]],
 StyleBox["= 0,  n \[GreaterEqual] 0.",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  In this case ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "-", "1"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = 0 ",
  FontWeight->"Bold"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox["= 0",
  FontWeight->"Bold"],
 ",",
 StyleBox["  0\[LessEqual] m\[LessEqual] n-1, n \[GreaterEqual] 1,",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\n",
  FontWeight->"Bold"],
 " and there are different formulas for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 " ,",
 StyleBox[" 0\[LessEqual] m\[LessEqual] n-1 , n \[GreaterEqual] 1. \n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "This commands implements the recurrence relations (15) and (16)  of [1].\n\n\
",
 StyleBox["Arguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "- ",
 StyleBox["symdcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the name of the command that implements the direct closed formulas, it \
must be a symbol.\n- ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients, ",
 StyleBox["{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nof the two symmetrical polynomials sequences ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows:\n ",
 StyleBox["rc[p_ _ _][n_]:=...[...;Return[{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ]; rct[pt_ _ _][n_]:=...[...;Return[{0,",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}] ];",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "are symbols and represent non negative integers such that ",
 StyleBox["0\[LessEqual]m\[LessEqual]n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["- Returns ",
  FontSlant->"Italic"],
 StyleBox["True",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " achivies the demonstration, returns ",
 StyleBox["False",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " otherwise.\t\t\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.392926362394573*^9, 3.3929263874612722`*^9}, {
   3.392932594997485*^9, 3.3929326184120817`*^9}, 3.3929344226756077`*^9, {
   3.4559926728935843`*^9, 3.455992675472065*^9}, {3.4559961020886097`*^9, 
   3.455996166144621*^9}, {3.4559977949830027`*^9, 3.455997872082302*^9}, {
   3.455997925270845*^9, 3.455997981298929*^9}, {3.4560962004258757`*^9, 
   3.456096239561738*^9}, {3.456096456573588*^9, 3.4560964922118607`*^9}, {
   3.456096648766358*^9, 3.456096675166298*^9}, 3.4560968243758707`*^9, {
   3.4560969508554163`*^9, 3.456096951707849*^9}, 3.456098449473267*^9, {
   3.456179498362137*^9, 3.456179513777499*^9}, {3.456428848840014*^9, 
   3.456428885760819*^9}, {3.457350744587739*^9, 3.457350745749967*^9}, {
   3.4573507779622717`*^9, 3.4573509065936613`*^9}, {3.45735098493381*^9, 
   3.457350991706945*^9}, {3.457422054661615*^9, 3.45742206562928*^9}, {
   3.45742211013476*^9, 3.457422114119658*^9}, {3.4574221465387*^9, 
   3.4574222303133698`*^9}, {3.4574222710241833`*^9, 
   3.4574224986559343`*^9}, {3.457422532890088*^9, 3.457422597121397*^9}, {
   3.457424069884609*^9, 3.457424293894966*^9}, {3.457424326133894*^9, 
   3.457424343581615*^9}, {3.457424378798506*^9, 3.457424402545363*^9}, {
   3.4574244336739798`*^9, 3.45742444363076*^9}, {3.458301074535924*^9, 
   3.458301095160421*^9}, {3.459208526356152*^9, 3.459208537152739*^9}, {
   3.459208578046657*^9, 3.459208642224683*^9}, {3.461262370517214*^9, 
   3.461262374219345*^9}, {3.4612624184212723`*^9, 3.461262421382493*^9}, {
   3.463960253167616*^9, 3.4639602578154087`*^9}, {3.464089646131819*^9, 
   3.464089671676443*^9}, {3.467190691974615*^9, 3.467190731039401*^9}, {
   3.467190862839398*^9, 3.4671908888212757`*^9}, {3.467191532978797*^9, 
   3.467191567454364*^9}, {3.481873084503292*^9, 3.481873084546323*^9}, {
   3.4818731153492393`*^9, 3.4818731154157124`*^9}, {3.490699911690658*^9, 
   3.490699915647849*^9}, 3.490700531453526*^9, {3.4907022830671673`*^9, 
   3.490702306118679*^9}, {3.4907878339494267`*^9, 3.490787848188673*^9}, {
   3.494311365279652*^9, 3.494311367744256*^9}, {3.5249420198549557`*^9, 
   3.524942022939927*^9}, {3.524942056329906*^9, 3.524942061241201*^9}, {
   3.534844018786765*^9, 3.53484401932117*^9}, {3.543570463677326*^9, 
   3.5435705129749117`*^9}, {3.543570544134975*^9, 3.5435706521220512`*^9}, {
   3.543570723224*^9, 3.543570820368733*^9}, {3.543570860309203*^9, 
   3.543570861385935*^9}, {3.5435709061494293`*^9, 3.543570919393621*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "demonstrationSymDCC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"demonstrationSymDCC", "[", "symdcc_Symbol", "]"}], "[", 
        RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
       "]"}], "[", "pt___", "]"}], "[", 
     RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"And", "[", "  ", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"m", "=", "0"}], " ", ",", " ", 
       RowBox[{"n", "=", 
        RowBox[{"1", " ", "-", " ", 
         RowBox[{"n", " ", "even"}]}]}], ",", " ", 
       RowBox[{"m", " ", "even"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{"2", ",", "0"}], "]"}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"rc", "[", "p", "]"}], "[", "1", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"rct", "[", "pt", "]"}], "[", "1", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], " ", "\[IndentingNewLine]", 
        "\t\t  ", "]"}], "===", "0"}], " ", ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", "0"}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterSlantEqual]", 
         RowBox[{"2", " ", "-", " ", 
          RowBox[{"n", " ", "even"}]}]}], ",", " ", 
        RowBox[{"m", " ", "even"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", "0"}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}], ",", "0"}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", "1", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "1"}], "]"}]}]}], 
         ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", 
            RowBox[{"n", "\[GreaterSlantEqual]", "2"}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t\t ", "]"}], "===", "0"}], " ", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterSlantEqual]", 
         RowBox[{"2", " ", "-", " ", 
          RowBox[{"n", " ", "even"}]}]}], ",", " ", 
        RowBox[{"m", " ", "even"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{"rc", "[", "p", "]"}], "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "-", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"rct", "[", "pt", "]"}], "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "2"}], ")"}]}]}]}], "]"}]}], ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterSlantEqual]", "2"}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t\t ", "]"}], "===", "0"}], " ", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"0", "<", "m", "<", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterSlantEqual]", 
         RowBox[{"3", " ", "-", " ", 
          RowBox[{"n", " ", "even"}]}]}], ",", " ", 
        RowBox[{"m", " ", "even"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", "m"}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}], ",", 
             RowBox[{"2", "*", "m"}]}], "]"}]}], "-", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", "m"}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", "m"}]}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "-", "1"}], ")"}]}]}]}], "]"}]}], ",", " ", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", 
            RowBox[{"Element", "[", 
             RowBox[{"m", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterSlantEqual]", "3"}], ",", " ", 
            RowBox[{"m", ">", "0"}], ",", " ", 
            RowBox[{"m", "<", 
             RowBox[{"n", "-", "1"}]}]}], " ", "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t\t ", "]"}], "===", "0"}], " ", ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", "0"}], " ", ",", " ", 
        RowBox[{"n", "=", 
         RowBox[{"1", " ", "-", " ", 
          RowBox[{"n", " ", "odd"}]}]}], ",", " ", 
        RowBox[{"m", " ", "odd"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{"3", ",", "1"}], "]"}], "+", 
         RowBox[{
          RowBox[{
           RowBox[{"rc", "[", "p", "]"}], "[", "2", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"rct", "[", "pt", "]"}], "[", "2", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", 
         RowBox[{
          RowBox[{
           RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{"2", ",", "0"}], "]"}]}], "\[IndentingNewLine]", "\t\t    ",
         "]"}], "===", "0"}], ",", "\[IndentingNewLine]", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"m", "=", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterSlantEqual]", 
         RowBox[{"2", " ", "-", " ", 
          RowBox[{"n", " ", "odd"}]}]}], ",", " ", 
        RowBox[{"m", " ", "odd"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "n"}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}]}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{"rc", "[", "p", "]"}], "[", 
            RowBox[{"2", "*", "n"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "-", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"rct", "[", "pt", "]"}], "[", 
            RowBox[{"2", "*", "n"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}]}], ",", " ", 
         "\[IndentingNewLine]", "\t", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterSlantEqual]", "2"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "\t\t ", "]"}], "===", "0"}], ",", "\t\t", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"0", "\[LessSlantEqual]", "m", "<", 
         RowBox[{"n", "-", "1"}]}], " ", ",", " ", 
        RowBox[{"n", "\[GreaterSlantEqual]", 
         RowBox[{"2", " ", "-", " ", 
          RowBox[{"n", " ", "odd"}]}]}], ",", " ", 
        RowBox[{"m", " ", "odd"}]}], " ", "*)"}], 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "n"}]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "m"}]}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"2", "*", "n"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", "m"}]}]}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", "n"}], ",", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", "m"}]}], "]"}]}], ",", " ", 
         "\[IndentingNewLine]", "\t", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"And", 
           StyleBox["[", "Code"], 
           RowBox[{
            RowBox[{"Element", "[", 
             RowBox[{"n", ",", "Integers"}], "]"}], ",", 
            RowBox[{"Element", "[", 
             RowBox[{"m", ",", "Integers"}], "]"}], ",", " ", 
            RowBox[{"n", "\[GreaterSlantEqual]", "2"}], ",", 
            RowBox[{"m", "\[GreaterSlantEqual]", "0"}], ",", " ", 
            RowBox[{"m", "<", 
             RowBox[{"n", "-", "1"}]}]}], " ", "]"}]}]}], " ", 
        "\[IndentingNewLine]", "\t\t", "]"}], "===", "0"}]}], "\t\t", 
     "\[IndentingNewLine]", "\t", "]"}]}], ";"}], "  "}]}], "Input",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.421809310919284*^9, 
   3.421809572053434*^9}, {3.421809603141906*^9, 3.42180960423031*^9}, 
   3.4218096727871103`*^9, {3.421809994013063*^9, 3.421809999298283*^9}, {
   3.421810078070912*^9, 3.421810136546454*^9}, {3.421969229115234*^9, 
   3.42196924937212*^9}, {3.421969321080101*^9, 3.4219693245827723`*^9}, {
   3.4219701841210833`*^9, 3.421970197061084*^9}, {3.421970230459333*^9, 
   3.421970231239197*^9}, {3.42214102384061*^9, 3.422141086650599*^9}, {
   3.422225877214126*^9, 3.422225898557538*^9}, {3.42222596386862*^9, 
   3.422225972386592*^9}, {3.457422656244882*^9, 3.457422659025906*^9}, {
   3.457423039149973*^9, 3.457423283113783*^9}, {3.457426822415946*^9, 
   3.457426903159569*^9}, {3.457426955344779*^9, 3.457427018376491*^9}, {
   3.458301186700097*^9, 3.458301314313905*^9}, {3.458301390137986*^9, 
   3.4583014205139723`*^9}, {3.458301520604051*^9, 3.4583015313445377`*^9}, 
   3.4586310241590853`*^9, {3.458634909970498*^9, 3.4586349158180847`*^9}, {
   3.463960296525209*^9, 3.463960306504467*^9}, {3.479456967539282*^9, 
   3.479456984007347*^9}, {3.48187640780192*^9, 3.481876407981122*^9}, {
   3.5206152330804787`*^9, 3.52061525225404*^9}, {3.520615913546826*^9, 
   3.5206159364047823`*^9}, {3.5206160981368313`*^9, 
   3.5206161198534117`*^9}, {3.520616210704461*^9, 3.520616372790416*^9}, 
   3.5206164456671457`*^9, {3.52061647731216*^9, 3.5206164851500797`*^9}, {
   3.5206167001382*^9, 3.520616850196419*^9}, {3.520617192347003*^9, 
   3.520617204025031*^9}, {3.520617316841694*^9, 3.520617386340106*^9}, {
   3.5206174801029243`*^9, 3.5206174848776827`*^9}, {3.524943422767331*^9, 
   3.524943455042617*^9}, {3.524943491173636*^9, 3.52494349533311*^9}, {
   3.53366715280875*^9, 3.5336671757618027`*^9}, {3.534755854538931*^9, 
   3.534755870298094*^9}, {3.5347561176245832`*^9, 3.534756240127033*^9}, {
   3.534767086679982*^9, 3.53476708974086*^9}, {3.5348439480696*^9, 
   3.534843967166044*^9}, {3.543312619990409*^9, 3.5433126781219788`*^9}, {
   3.5433127353955793`*^9, 3.543312772439519*^9}, {3.543312836387491*^9, 
   3.54331286260949*^9}, {3.543313062741579*^9, 3.543313104240951*^9}, {
   3.543313186947722*^9, 3.543313188755026*^9}, {3.543313428188569*^9, 
   3.543313431635386*^9}, {3.5433144706863937`*^9, 3.543314473732998*^9}, {
   3.54331481687853*^9, 3.5433148208938837`*^9}, {3.543314900733068*^9, 
   3.543314925686397*^9}, {3.54331497986082*^9, 3.5433150113534727`*^9}, {
   3.543315108427966*^9, 3.543315114889629*^9}, {3.5435710857866983`*^9, 
   3.5435711153834047`*^9}, {3.543571164275947*^9, 3.543571178410941*^9}, {
   3.54357121443937*^9, 3.543571214838396*^9}, {3.5435712709312887`*^9, 
   3.543571318542405*^9}, {3.543571379843948*^9, 3.543571380523775*^9}, {
   3.543571413584011*^9, 3.543571429039193*^9}, {3.543571507837388*^9, 
   3.543571535743596*^9}, {3.543571576992034*^9, 3.5435716723032007`*^9}, {
   3.543574209834156*^9, 3.543574213525277*^9}, {3.543575842723619*^9, 
   3.543575882518785*^9}, {3.543575999326448*^9, 3.543576002278817*^9}, {
   3.543649378388115*^9, 3.543649380968647*^9}, {3.543649902756527*^9, 
   3.543649930563308*^9}, {3.54364999322425*^9, 3.543649993678267*^9}, {
   3.543650130541648*^9, 3.543650131029806*^9}, {3.54365019160188*^9, 
   3.543650192209299*^9}, {3.545646069615005*^9, 3.54564607464537*^9}, {
   3.545646130147582*^9, 3.545646147705393*^9}, {3.545647010042444*^9, 
   3.545647016319045*^9}, {3.545732940470495*^9, 3.5457329440760183`*^9}, {
   3.546947947157885*^9, 3.546947974868565*^9}, {3.547205241534192*^9, 
   3.5472053212459917`*^9}, {3.5472053807602997`*^9, 
   3.5472053833643923`*^9}, {3.5472057456305933`*^9, 
   3.5472058349458733`*^9}, {3.5472058818792667`*^9, 3.547205910156641*^9}, {
   3.5472062942694597`*^9, 3.547206440734379*^9}, {3.547206591191846*^9, 
   3.547206693339776*^9}, 3.547207666925767*^9, {3.5472816525387917`*^9, 
   3.54728169636716*^9}, {3.547282227503386*^9, 3.5472822687471*^9}, 
   3.547282595496303*^9}],

Cell["\<\

(******************************************************************************
 
Version, without Assumptions, corresponding to the main recurrence relations \
with the shift 
n \[RightArrow] n+1 and m \[RightArrow] m+1, for the even indexes, and n -> \
n+1, for the odd indexes. 

******************************************************************************\
*)\
\>", "Text",
 CellChangeTimes->{{3.547288076704426*^9, 3.54728816433042*^9}, {
  3.547288228915125*^9, 3.547288256031436*^9}, {3.547288324850103*^9, 
  3.5472884129221497`*^9}, {3.547288479088582*^9, 3.547288515684051*^9}, {
  3.547288563819973*^9, 3.547288573055188*^9}, {3.547288872950276*^9, 
  3.547288950860651*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Clear", "[", "demonstrationSymDCC", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"demonstrationSymDCC", "[", "symdcc_Symbol", "]"}], "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"And", "[", " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], ",", 
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", "n"}], ",", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}], "+", "1"}]}], "]"}]}], "-", 
          
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
            RowBox[{
             RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], 
         "\[IndentingNewLine]", "\t\t\t ", "]"}], "  ", "===", "0"}], ",", 
       "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], "+", "1"}], ",", 
            RowBox[{
             RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], ",", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], ",", 
            RowBox[{"2", "*", "m"}]}], "]"}]}], " ", "\[IndentingNewLine]", 
         "\t\t\t", "]"}], " ", "===", "0"}]}], "\t\t\t", 
      "\[IndentingNewLine]", "\t", "]"}]}], ";"}], " ", "\[IndentingNewLine]",
    "*)"}], " "}]], "Input",
 CellChangeTimes->{{3.547288076704426*^9, 3.54728816433042*^9}, {
   3.547288228915125*^9, 3.547288256031436*^9}, {3.547288324850103*^9, 
   3.5472884129221497`*^9}, {3.547288479088582*^9, 3.547288515684051*^9}, {
   3.547288563819973*^9, 3.547288573055188*^9}, 3.547288872950276*^9}],

Cell["\<\
(********************************************************************* 
Version, without Assumptions, corresponding to the main recurrence relations.
*********************************************************************)\
\>", "Text",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.421809310919284*^9, 
   3.421809572053434*^9}, {3.421809603141906*^9, 3.42180960423031*^9}, 
   3.4218096727871103`*^9, {3.421809994013063*^9, 3.421809999298283*^9}, {
   3.421810078070912*^9, 3.421810136546454*^9}, {3.421969229115234*^9, 
   3.42196924937212*^9}, {3.421969321080101*^9, 3.4219693245827723`*^9}, {
   3.4219701841210833`*^9, 3.421970197061084*^9}, {3.421970230459333*^9, 
   3.421970231239197*^9}, {3.42214102384061*^9, 3.422141086650599*^9}, {
   3.422225877214126*^9, 3.422225898557538*^9}, {3.42222596386862*^9, 
   3.422225972386592*^9}, {3.457422656244882*^9, 3.457422659025906*^9}, {
   3.457423039149973*^9, 3.457423283113783*^9}, {3.457426822415946*^9, 
   3.457426903159569*^9}, {3.457426955344779*^9, 3.457427018376491*^9}, {
   3.458301186700097*^9, 3.458301314313905*^9}, {3.458301390137986*^9, 
   3.4583014205139723`*^9}, {3.458301520604051*^9, 3.4583015313445377`*^9}, 
   3.4586310241590853`*^9, {3.458634909970498*^9, 3.4586349158180847`*^9}, {
   3.463960296525209*^9, 3.463960306504467*^9}, {3.479456967539282*^9, 
   3.479456984007347*^9}, {3.48187640780192*^9, 3.481876407981122*^9}, {
   3.5206152330804787`*^9, 3.52061525225404*^9}, {3.520615913546826*^9, 
   3.5206159364047823`*^9}, {3.5206160981368313`*^9, 
   3.5206161198534117`*^9}, {3.520616210704461*^9, 3.520616372790416*^9}, 
   3.5206164456671457`*^9, {3.52061647731216*^9, 3.5206164851500797`*^9}, {
   3.5206167001382*^9, 3.520616850196419*^9}, {3.520617192347003*^9, 
   3.520617204025031*^9}, {3.520617316841694*^9, 3.520617386340106*^9}, {
   3.5206174801029243`*^9, 3.5206174848776827`*^9}, {3.524943422767331*^9, 
   3.524943455042617*^9}, {3.524943491173636*^9, 3.52494349533311*^9}, {
   3.53366715280875*^9, 3.5336671757618027`*^9}, {3.534755854538931*^9, 
   3.534755870298094*^9}, {3.5347561176245832`*^9, 3.534756240127033*^9}, {
   3.534767086679982*^9, 3.53476708974086*^9}, {3.5348439480696*^9, 
   3.534843967166044*^9}, {3.5433125897791*^9, 3.5433125968816347`*^9}, {
   3.54331284065835*^9, 3.5433128441142273`*^9}, {3.543313378335141*^9, 
   3.5433133786123037`*^9}, {3.543576017404036*^9, 3.543576024274906*^9}, {
   3.54573297399393*^9, 3.545732976391757*^9}, 3.545733890389124*^9, {
   3.546947762857119*^9, 3.546947763248741*^9}, {3.547287796996706*^9, 
   3.5472878531987953`*^9}, 3.547288103933895*^9, {3.5472884437212133`*^9, 
   3.5472884679512053`*^9}, {3.5472889635433903`*^9, 3.5472889841542463`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Clear", "[", "demonstrationSymDCC", "]"}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"demonstrationSymDCC", "[", "symdcc_Symbol", "]"}], "[", 
         RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
        "]"}], "[", "pt___", "]"}], "[", 
      RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"And", "[", " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", "m"}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}], ",", 
             RowBox[{"2", "*", "m"}]}], "]"}]}], "-", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "m"}], "+", "1"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "-", "1"}], ")"}]}], "+", "1"}]}], "]"}]}], 
         "\[IndentingNewLine]", "\t\t\t ", "]"}], "  ", "===", "0"}], ",", 
       "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"FullSimplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
            RowBox[{
             RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "+", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rc", "[", "p", "]"}], "[", 
             RowBox[{"2", "*", "n"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "-", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"rct", "[", "pt", "]"}], "[", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{
             RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", "n"}], ",", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"symdcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
           RowBox[{
            RowBox[{"2", "*", "n"}], ",", 
            RowBox[{"2", "*", "m"}]}], "]"}]}], " ", "\[IndentingNewLine]", 
         "\t\t\t", "]"}], " ", "===", "0"}]}], "\t\t\t", 
      "\[IndentingNewLine]", "\t", "]"}]}], ";"}], " ", "\[IndentingNewLine]",
    "*)"}], " "}]], "Input",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.421809310919284*^9, 
   3.421809572053434*^9}, {3.421809603141906*^9, 3.42180960423031*^9}, 
   3.4218096727871103`*^9, {3.421809994013063*^9, 3.421809999298283*^9}, {
   3.421810078070912*^9, 3.421810136546454*^9}, {3.421969229115234*^9, 
   3.42196924937212*^9}, {3.421969321080101*^9, 3.4219693245827723`*^9}, {
   3.4219701841210833`*^9, 3.421970197061084*^9}, {3.421970230459333*^9, 
   3.421970231239197*^9}, {3.42214102384061*^9, 3.422141086650599*^9}, {
   3.422225877214126*^9, 3.422225898557538*^9}, {3.42222596386862*^9, 
   3.422225972386592*^9}, {3.457422656244882*^9, 3.457422659025906*^9}, {
   3.457423039149973*^9, 3.457423283113783*^9}, {3.457426822415946*^9, 
   3.457426903159569*^9}, {3.457426955344779*^9, 3.457427018376491*^9}, {
   3.458301186700097*^9, 3.458301314313905*^9}, {3.458301390137986*^9, 
   3.4583014205139723`*^9}, {3.458301520604051*^9, 3.4583015313445377`*^9}, 
   3.4586310241590853`*^9, {3.458634909970498*^9, 3.4586349158180847`*^9}, {
   3.463960296525209*^9, 3.463960306504467*^9}, {3.479456967539282*^9, 
   3.479456984007347*^9}, {3.48187640780192*^9, 3.481876407981122*^9}, {
   3.5206152330804787`*^9, 3.52061525225404*^9}, {3.520615913546826*^9, 
   3.5206159364047823`*^9}, {3.5206160981368313`*^9, 
   3.5206161198534117`*^9}, {3.520616210704461*^9, 3.520616372790416*^9}, 
   3.5206164456671457`*^9, {3.52061647731216*^9, 3.5206164851500797`*^9}, {
   3.5206167001382*^9, 3.520616850196419*^9}, {3.520617192347003*^9, 
   3.520617204025031*^9}, {3.520617316841694*^9, 3.520617386340106*^9}, {
   3.5206174801029243`*^9, 3.5206174848776827`*^9}, {3.524943422767331*^9, 
   3.524943455042617*^9}, {3.524943491173636*^9, 3.52494349533311*^9}, {
   3.53366715280875*^9, 3.5336671757618027`*^9}, {3.534755854538931*^9, 
   3.534755870298094*^9}, {3.5347561176245832`*^9, 3.534756240127033*^9}, {
   3.534767086679982*^9, 3.53476708974086*^9}, {3.5348439480696*^9, 
   3.534843967166044*^9}, {3.5433125897791*^9, 3.5433125968816347`*^9}, {
   3.54331284065835*^9, 3.5433128441142273`*^9}, {3.543313378335141*^9, 
   3.5433133786123037`*^9}, {3.543576017404036*^9, 3.543576024274906*^9}, {
   3.54573297399393*^9, 3.545732976391757*^9}, 3.545733890389124*^9, {
   3.546947762857119*^9, 3.546947763248741*^9}, {3.547287796996706*^9, 
   3.5472878531987953`*^9}, 3.547288103933895*^9, {3.5472884437212133`*^9, 
   3.5472884679512053`*^9}, 3.5472889635433903`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Main Command for Special Cases (4 ",
 StyleBox["different formulas for even and odd indexes",
  FontSize->10],
 ")\n"
}], "Subsection",
 CellChangeTimes->{
  3.455999327645267*^9, {3.455999368230609*^9, 3.455999389061823*^9}, {
   3.45599948920284*^9, 3.455999490120635*^9}, {3.4573506042470512`*^9, 
   3.457350620371624*^9}, {3.5196657843543587`*^9, 3.519665826309312*^9}, 
   3.519665946318585*^9, {3.5224312938309383`*^9, 3.522431294358047*^9}, 
   3.533666862990995*^9}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\nCommand: \ndemonstrationEvenOddDCC[dcc][rc, \
rct][p][pt][n, m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\t\t\t\t\t\n",
 StyleBox["demonstrationEvenOddDCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "tries to demonstrate the direct closed formulas for the connection \
coefficients\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], 
   StyleBox[":=",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], 
    StyleBox[
     RowBox[{"(", 
      RowBox[{"P", "\[LeftArrow]", 
       FormBox[
        StyleBox[
         OverscriptBox["P", "~"],
         FontWeight->"Bold",
         FontSlant->"Italic"],
        TraditionalForm]}], ")"}],
     FontWeight->"Bold",
     FontSlant->"Italic"]}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", when there are different formulas for even and odd indexes ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 StyleBox["m:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = ... ; ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = ... ;",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = ... ;",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = ... ;",
  FontWeight->"Bold"],
 " \n",
 StyleBox["\ndemonstrationEvenOddDCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " implements the initial conditions (10)-(12) and the recurrence relations \
(13) of [1].\n\n",
 StyleBox["Arguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "- ",
 StyleBox["dcc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the name of the command that implements the direct closed formulas for \
the connection coefficients,\n it must be a symbol.\n- ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the names of the commands that define the recurrence coefficients ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" {",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Beta]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    SubscriptBox["\[Gamma]", "n"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nof the two polynomials sequences ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 "; they must be symbols.\n-  ",
 StyleBox["rc",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" rct",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be defined as follows: ",
 StyleBox["rc[p_ _ _][n_]:=...; rct[pt_ _ _][n_]:=...;",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["p",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and ",
 StyleBox["pt",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["are ",
  FontSlant->"Italic"],
 "the sequences of parameters of ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 ", if any.",
 StyleBox["\n- ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "are symbols and represent non negative integers such that ",
 StyleBox["0\[LessEqual]m\[LessEqual]n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Mathematica",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" commands used:",
  FontWeight->"Bold"],
 "\n- ",
 StyleBox["FullSimplify",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["Result:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["- Returns ",
  FontSlant->"Italic"],
 StyleBox["True",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " achivies the demonstration, returns ",
 StyleBox["False",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " otherwise.\t\t\n",
 StyleBox["___________________________________________________________________\
____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.392926362394573*^9, 3.3929263874612722`*^9}, {
   3.392932594997485*^9, 3.3929326184120817`*^9}, 3.3929344226756077`*^9, {
   3.4559926728935843`*^9, 3.455992675472065*^9}, {3.4559961020886097`*^9, 
   3.455996166144621*^9}, {3.4559977949830027`*^9, 3.455997872082302*^9}, {
   3.455997925270845*^9, 3.455997981298929*^9}, {3.4560962004258757`*^9, 
   3.456096239561738*^9}, {3.456096456573588*^9, 3.4560964922118607`*^9}, {
   3.456096648766358*^9, 3.456096675166298*^9}, 3.4560968243758707`*^9, {
   3.4560969508554163`*^9, 3.456096951707849*^9}, 3.456098449473267*^9, {
   3.456179498362137*^9, 3.456179513777499*^9}, {3.456428848840014*^9, 
   3.456428885760819*^9}, {3.457350744587739*^9, 3.457350745749967*^9}, {
   3.4573507779622717`*^9, 3.4573509065936613`*^9}, {3.45735098493381*^9, 
   3.457350991706945*^9}, {3.457422054661615*^9, 3.45742206562928*^9}, {
   3.45742211013476*^9, 3.457422114119658*^9}, {3.4574221465387*^9, 
   3.4574222303133698`*^9}, {3.4574222710241833`*^9, 
   3.4574224986559343`*^9}, {3.457422532890088*^9, 3.457422597121397*^9}, {
   3.457424069884609*^9, 3.457424293894966*^9}, {3.457424326133894*^9, 
   3.457424343581615*^9}, {3.457424378798506*^9, 3.457424402545363*^9}, {
   3.4574244336739798`*^9, 3.45742444363076*^9}, {3.458301074535924*^9, 
   3.458301095160421*^9}, {3.459208526356152*^9, 3.459208537152739*^9}, {
   3.459208578046657*^9, 3.459208642224683*^9}, {3.461262370517214*^9, 
   3.461262374219345*^9}, {3.4612624184212723`*^9, 3.461262421382493*^9}, {
   3.463960253167616*^9, 3.4639602578154087`*^9}, {3.464089646131819*^9, 
   3.464089671676443*^9}, {3.467190691974615*^9, 3.467190731039401*^9}, {
   3.467190862839398*^9, 3.4671908888212757`*^9}, {3.467191532978797*^9, 
   3.467191567454364*^9}, {3.481876407243284*^9, 3.481876407277647*^9}, {
   3.519665854523789*^9, 3.519666172750991*^9}, {3.5196662312253723`*^9, 
   3.519666281263998*^9}, {3.519666324475997*^9, 3.519666348739669*^9}, {
   3.519668697383101*^9, 3.519668708526731*^9}, {3.5196687875564938`*^9, 
   3.5196687902635727`*^9}, {3.519669095506214*^9, 3.5196691002707567`*^9}, {
   3.534753196450883*^9, 3.534753228431099*^9}, {3.5348440037014847`*^9, 
   3.534844006426736*^9}, {3.543571750523159*^9, 3.543571771917349*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["demonstrationEvenOddDCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         StyleBox["demonstrationEvenOddDCC",
          FontWeight->"Bold",
          FontSlant->"Italic"], "[", "dcc_Symbol", "]"}], "[", 
        RowBox[{"rc_Symbol", ",", " ", "rct_Symbol"}], "]"}], "[", "p___", 
       "]"}], "[", "pt___", "]"}], "[", 
     RowBox[{"n_Symbol", ",", "m_Symbol"}], "]"}], ":=", " ", 
    RowBox[{"And", "[", "      ", 
     RowBox[{
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{
           RowBox[{"2", "*", "n"}], ",", 
           RowBox[{"2", "*", "m"}]}], "]"}], "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rct", "[", "pt", "]"}], "[", 
                RowBox[{"2", "*", "m"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{
                RowBox[{"rc", "[", "p", "]"}], "[", 
                RowBox[{
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{"2", "*", "m"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", 
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], ",", 
              RowBox[{"2", "*", "m"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "-", "1"}], ")"}]}], "+", "1"}]}], "]"}]}], 
          "\[IndentingNewLine]", "\t\t\t", ")"}]}], "]"}], " ", "===", "0"}], 
      "  ", ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{
           RowBox[{"2", "*", "n"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rct", "[", "pt", "]"}], "[", 
                RowBox[{
                 RowBox[{"2", "*", "m"}], "+", "1"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{
                RowBox[{"rc", "[", "p", "]"}], "[", 
                RowBox[{
                 RowBox[{"2", "*", 
                  RowBox[{"(", 
                   RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", 
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "+", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
             RowBox[{"2", "*", "m"}]}], "]"}]}], "\[IndentingNewLine]", 
          "\t\t\t", ")"}]}], "   ", "]"}], "  ", "===", "0"}], " ", ",", " ", 
      
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
           RowBox[{"2", "*", "m"}]}], "]"}], "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rct", "[", "pt", "]"}], "[", 
                RowBox[{"2", "*", "m"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{
                RowBox[{"rc", "[", "p", "]"}], "[", 
                RowBox[{"2", "*", "n"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "n"}], ",", 
              RowBox[{"2", "*", "m"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", 
              RowBox[{"2", "*", "n"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{"2", "*", "m"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
           
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "n"}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", "n"}], ",", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "-", "1"}], ")"}]}], "+", "1"}]}], "]"}]}], 
          "\[IndentingNewLine]", "\t\t\t", ")"}]}], "  ", "]"}], "===", "0"}],
       " ", ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"rct", "[", "pt", "]"}], "[", 
                RowBox[{
                 RowBox[{"2", "*", "m"}], "+", "1"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{
                RowBox[{"rc", "[", "p", "]"}], "[", 
                RowBox[{"2", "*", "n"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "n"}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "-", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rc", "[", "p", "]"}], "[", 
              RowBox[{"2", "*", "n"}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}]}], "+", "1"}], ",", 
              RowBox[{
               RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]}], "+", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"rct", "[", "pt", "]"}], "[", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}], "]"}], "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{
             RowBox[{
              RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
             RowBox[{
              RowBox[{"2", "*", "n"}], ",", 
              RowBox[{"2", "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"dcc", "[", "p", "]"}], "[", "pt", "]"}], "[", 
            RowBox[{
             RowBox[{"2", "*", "n"}], ",", 
             RowBox[{"2", "*", "m"}]}], "]"}]}], "\[IndentingNewLine]", 
          "\t\t\t", ")"}]}], " ", "]"}], "===", "0"}]}], " ", 
     "\[IndentingNewLine]", "\t", "]"}]}], ";"}], " "}]}], "Input",
 CellChangeTimes->{{3.39293262727267*^9, 3.392932803860672*^9}, {
   3.392934132418532*^9, 3.3929341336759167`*^9}, {3.392934171386194*^9, 
   3.39293431807913*^9}, {3.392934407768341*^9, 3.3929344114211082`*^9}, {
   3.392934694213956*^9, 3.392934697282584*^9}, {3.421809310919284*^9, 
   3.421809572053434*^9}, {3.421809603141906*^9, 3.42180960423031*^9}, 
   3.4218096727871103`*^9, {3.421809994013063*^9, 3.421809999298283*^9}, {
   3.421810078070912*^9, 3.421810136546454*^9}, {3.421969229115234*^9, 
   3.42196924937212*^9}, {3.421969321080101*^9, 3.4219693245827723`*^9}, {
   3.4219701841210833`*^9, 3.421970197061084*^9}, {3.421970230459333*^9, 
   3.421970231239197*^9}, {3.42214102384061*^9, 3.422141086650599*^9}, {
   3.422225877214126*^9, 3.422225898557538*^9}, {3.42222596386862*^9, 
   3.422225972386592*^9}, {3.457422656244882*^9, 3.457422659025906*^9}, {
   3.457423039149973*^9, 3.457423283113783*^9}, {3.457426822415946*^9, 
   3.457426903159569*^9}, {3.457426955344779*^9, 3.457427018376491*^9}, {
   3.458301186700097*^9, 3.458301314313905*^9}, {3.458301390137986*^9, 
   3.4583014205139723`*^9}, {3.458301520604051*^9, 3.4583015313445377`*^9}, 
   3.4586310241590853`*^9, {3.458634909970498*^9, 3.4586349158180847`*^9}, {
   3.463960296525209*^9, 3.463960306504467*^9}, {3.479456967539282*^9, 
   3.479457040971241*^9}, {3.481876407318054*^9, 3.481876407568377*^9}, {
   3.511285407349745*^9, 3.511285415278267*^9}, {3.51966650644173*^9, 
   3.519666531263647*^9}, {3.519668247740364*^9, 3.519668329227244*^9}, {
   3.519668633535941*^9, 3.5196686348171673`*^9}, {3.519669010226614*^9, 
   3.519669084159773*^9}, {3.5196695974395247`*^9, 3.519669614035304*^9}, {
   3.519674679701508*^9, 3.519674684281358*^9}, {3.519675501979663*^9, 
   3.519675509785287*^9}, {3.5197523800590754`*^9, 3.519752435518772*^9}, {
   3.519752950478059*^9, 3.519752965486689*^9}, {3.519753368185398*^9, 
   3.5197534464920177`*^9}, {3.519753943310857*^9, 3.519753976264147*^9}, {
   3.5197540136628036`*^9, 3.5197540422913513`*^9}, 3.519754124336904*^9, {
   3.519754379992036*^9, 3.519754442186491*^9}, {3.519754549904705*^9, 
   3.5197545571404047`*^9}, {3.519754689139542*^9, 3.519754700823599*^9}, {
   3.5197548148030663`*^9, 3.5197548702555447`*^9}, {3.519754928851272*^9, 
   3.519754929402306*^9}, {3.519754967969035*^9, 3.519754990711022*^9}, {
   3.5197550329278717`*^9, 3.5197550566073713`*^9}, {3.519755188865308*^9, 
   3.519755227955153*^9}, {3.519755296862784*^9, 3.519755305016177*^9}, {
   3.519755367731221*^9, 3.5197555073331413`*^9}, {3.519756868339081*^9, 
   3.51975687254838*^9}, {3.519848794561501*^9, 3.519848928592037*^9}, {
   3.5198499973945208`*^9, 3.519850007062109*^9}, {3.5198501745495653`*^9, 
   3.519850250817768*^9}, {3.519850290430065*^9, 3.5198503374602613`*^9}, {
   3.5198507502052097`*^9, 3.5198508056329327`*^9}, {3.521137000484193*^9, 
   3.521137072572294*^9}, {3.5336672040204363`*^9, 3.533667209392901*^9}, {
   3.5347563449404783`*^9, 3.534756346601214*^9}, {3.534767188728015*^9, 
   3.534767190061822*^9}, {3.534843974401754*^9, 3.534843976806169*^9}, {
   3.545732549371863*^9, 3.545732558605339*^9}, {3.545732791330493*^9, 
   3.545732795209949*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
_________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190719078233*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Canonic Case
\
\>", "Subsection",
 CellChangeTimes->{{3.455999505296259*^9, 3.455999521281426*^9}, {
  3.479035643828837*^9, 3.479035660823258*^9}, {3.47903605096025*^9, 
  3.479036055085745*^9}, {3.533666081247715*^9, 3.533666082092723*^9}, {
  3.5336666269029617`*^9, 3.53366662767109*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CanonicalC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n\n",
 StyleBox["Description:\nCanonicalC[][n]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  is the recurrence coefficients {",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]]],
 "} of the canonical polynomials (see (5) of [1]).",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is an integer.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456099325890123*^9, 3.456099365334386*^9}, {3.456179531024519*^9, 
   3.456179531290577*^9}, {3.460708992942174*^9, 3.460709007985496*^9}, 
   3.461263501764373*^9, 3.4641418234608917`*^9, {3.467190155131351*^9, 
   3.467190159595455*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "CanonicalC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CanonicalC", "[", "]"}], "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"CanonicalC", "[", "]"}], "[", "n", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.456099185812929*^9, 3.456099204090173*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n \n Recurrence coefficients of the canonical polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.4561677333402243`*^9, 3.456167740757716*^9}, {
   3.456168017260594*^9, 3.4561680483121643`*^9}, {3.456178023252879*^9, 
   3.456178025366869*^9}, {3.467190165250267*^9, 3.4671901695716343`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CanonicalC", "[", "]"}], "[", "n", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.456178033054655*^9, 3.4561780904185867`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456178091817037*^9, 3.4561796041617804`*^9, 3.456181839564402*^9, 
   3.456429213314001*^9, 3.45742362103339*^9, 3.457427112326015*^9, 
   3.4586348751218*^9, 3.4590176846817093`*^9, 3.4594925272694473`*^9, 
   3.4594925790786343`*^9, 3.4594943666265087`*^9, 3.460703240171648*^9, 
   3.460975685191782*^9, 3.461924642608131*^9, 3.467192304937249*^9, 
   3.479105042198022*^9, 3.479455572748541*^9, 3.511274319677074*^9, 
   3.5112824927403507`*^9, 3.5112825937340603`*^9, 3.511286113448148*^9, 
   3.511289418978795*^9, 3.51238320005208*^9, 3.512393900008377*^9, 
   3.512397122410366*^9, 3.512406199385482*^9, 3.51802946982222*^9, 
   3.5180302362478228`*^9, 3.518030979455605*^9, 3.518110370768718*^9, 
   3.519319801903368*^9, 3.519323342056982*^9, 3.519405832446228*^9, 
   3.5194519778008223`*^9, 3.519454104144684*^9, 3.5194568137525253`*^9, 
   3.519492999761937*^9, 3.519537686756016*^9, 3.519579929180369*^9, 
   3.5195838440315*^9, 3.519669637194006*^9, 3.519674500843129*^9, 
   3.519674899100477*^9, 3.519751094952681*^9, 3.5198378698613453`*^9, 
   3.519848990084264*^9, 3.5199217920618258`*^9, 3.520360195495186*^9, 
   3.520360475260998*^9, 3.520443539304966*^9, 3.520528075292577*^9, 
   3.520529979813134*^9, 3.520530634369115*^9, 3.520619737611594*^9, 
   3.5206219098081427`*^9, 3.5210452099998083`*^9, 3.5211345791390553`*^9, 
   3.521140059245013*^9, 3.521142385220192*^9, 3.521142452487602*^9, 
   3.521185218257616*^9, 3.521218887009359*^9, 3.521353768071637*^9, 
   3.524397022728732*^9, 3.53349187752033*^9, 3.53349547660187*^9, 
   3.5334956827744226`*^9, 3.533501714384302*^9, 3.533504762652396*^9, {
   3.533505833749247*^9, 3.533505841887364*^9}, 3.534753386729649*^9, 
   3.543312350965537*^9, 3.5433132921433153`*^9, 3.54331554659853*^9, 
   3.543316033174054*^9, 3.543317092679805*^9, 3.543317335778921*^9, {
   3.5433176609153833`*^9, 3.543317668999745*^9}, 3.543331649968745*^9, 
   3.543573401595957*^9, 3.543573625781958*^9, 3.5435745497110443`*^9, 
   3.54357635217*^9, 3.543577132205353*^9, 3.5436488664928417`*^9, 
   3.543649632730844*^9, {3.5456396414145937`*^9, 3.545639651205023*^9}, 
   3.545644330305222*^9, 3.545648138114295*^9, 3.545726658967836*^9, 
   3.545732435618206*^9, 3.545735067636449*^9, {3.546947529877994*^9, 
   3.546947534945776*^9}, 3.547204895407901*^9, 3.5472053979269333`*^9, 
   3.547281402726059*^9, 3.547283535806233*^9, 3.54840177048201*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CanonicalC", "[", "]"}], "[", "5", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.456178033054655*^9, 3.4561780904185867`*^9}, {
  3.4561795639950953`*^9, 3.4561795647669163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456178091817037*^9, 3.456179565423213*^9, 3.456179604325994*^9, 
   3.456181839672338*^9, 3.4564292140487127`*^9, 3.4574236210722027`*^9, 
   3.457427112362671*^9, 3.45863487515483*^9, 3.459017684805155*^9, 
   3.459492528359139*^9, 3.459492579188325*^9, 3.4594943667372017`*^9, 
   3.460703241904297*^9, 3.460975685238584*^9, 3.4619246426506853`*^9, 
   3.4671923052392797`*^9, 3.4791050422665854`*^9, 3.479455572818466*^9, 
   3.5112743197273417`*^9, 3.511282492796791*^9, 3.5112825937696*^9, 
   3.511286113501952*^9, 3.511289419050737*^9, 3.512383200091198*^9, 
   3.5123939001006193`*^9, 3.512397122478752*^9, 3.512406199445365*^9, 
   3.51802946990739*^9, 3.518030236284568*^9, 3.518030979493829*^9, 
   3.5181103708243847`*^9, 3.519319801953546*^9, 3.519323342115683*^9, 
   3.519405832485176*^9, 3.5194519778632927`*^9, 3.5194541041810923`*^9, 
   3.5194568137963877`*^9, 3.519492999818206*^9, 3.51953768680793*^9, 
   3.519579929251748*^9, 3.5195838441180077`*^9, 3.519669637254147*^9, 
   3.519674500902095*^9, 3.519674899144725*^9, 3.519751094997589*^9, 
   3.5198378699510393`*^9, 3.5198489901401653`*^9, 3.519921792103409*^9, 
   3.5203601955352097`*^9, 3.520360475299395*^9, 3.520443539392372*^9, 
   3.5205280753359127`*^9, 3.5205299798736687`*^9, 3.520530634408668*^9, 
   3.520619737699197*^9, 3.520621909871142*^9, 3.5210452100427923`*^9, 
   3.521134579179249*^9, 3.521140059329615*^9, 3.521142385281049*^9, 
   3.52114245252742*^9, 3.521185218297393*^9, 3.521218887048072*^9, 
   3.521353768110059*^9, 3.524397022788467*^9, 3.533491877564495*^9, 
   3.5334954766446733`*^9, 3.533495682819253*^9, 3.533501714473278*^9, 
   3.5335047626942377`*^9, {3.53350583379277*^9, 3.5335058419282637`*^9}, 
   3.534753386780678*^9, 3.5433123510051527`*^9, 3.5433132921784887`*^9, 
   3.54331554663811*^9, 3.5433160332129307`*^9, 3.543317092729019*^9, 
   3.5433173358158827`*^9, {3.5433176609739933`*^9, 3.5433176690410137`*^9}, 
   3.5433316500088253`*^9, 3.543573401636191*^9, 3.5435736258196697`*^9, 
   3.5435745497479773`*^9, 3.543576352205605*^9, 3.5435771322415667`*^9, 
   3.543648866526568*^9, 3.543649632773144*^9, {3.545639641456334*^9, 
   3.545639651240391*^9}, 3.545644330340448*^9, 3.5456481381503696`*^9, 
   3.545726659007893*^9, 3.54573243565525*^9, 3.545735067671239*^9, {
   3.546947529917021*^9, 3.546947534982956*^9}, 3.547204895442354*^9, 
   3.547205397960863*^9, 3.5472814027637367`*^9, 3.547283535839933*^9, 
   3.548401770511457*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CanonicalP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n\n",
 StyleBox["Description:\nCanonicalP[][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  is the canonical polynomial of degree ",
 StyleBox["n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "in the variable",
 StyleBox[" x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is an integer.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "- ",
 StyleBox["x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the variable,",
 StyleBox[" x ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a numberic expression.\n\nC",
 StyleBox["ommands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n-  ",
 StyleBox["CanonicalC, MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nResult:\n- ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["If",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["n\[GreaterEqual]0",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["x", "n"],
    FontWeight->"Bold",
    FontColor->GrayLevel[0]], TraditionalForm]]],
 ". If n<0, ",
 StyleBox["0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456099325890123*^9, 3.45609942265534*^9}, {3.456099468882846*^9, 
   3.456099491490749*^9}, {3.456099530560175*^9, 3.456099571024584*^9}, {
   3.456099694839814*^9, 3.456099778895808*^9}, {3.456167089636743*^9, 
   3.4561670933887663`*^9}, 3.456167178740604*^9, {3.456167220096726*^9, 
   3.456167236564622*^9}, {3.456179537830872*^9, 3.456179538110845*^9}, {
   3.456428979565681*^9, 3.456428993615675*^9}, {3.4594924458679333`*^9, 
   3.4594924490114326`*^9}, {3.459492493897195*^9, 3.459492497886063*^9}, 
   3.464141830920779*^9, {3.467190174994046*^9, 3.46719017988138*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "CanonicalP", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CanonicalP", "[", "]"}], "[", 
    RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CanonicalP", "[", "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "CanonicalC", "]"}], "[", "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.456099213061154*^9, 3.456099222446316*^9}, {
  3.456178208095496*^9, 3.4561782437113523`*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nCanonical polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.4561781139349422`*^9, 
   3.4561781193241663`*^9}, {3.4671901838478193`*^9, 3.467190188285677*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CanonicalP", "[", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MOP", "[", "CanonicalC", "]"}], "[", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 CellChangeTimes->{{3.456179604455103*^9, 3.45617961019346*^9}, 
   3.4561818397851677`*^9, 3.4565089245498047`*^9, 3.457423621115253*^9, 
   3.45742711241359*^9, 3.4586348751972647`*^9, 3.459017684962406*^9, {
   3.45949253528719*^9, 3.459492537887157*^9}, 3.459492579353506*^9, 
   3.459494366897234*^9, 3.460703249088904*^9, 3.460975685302092*^9, 
   3.4619246427083387`*^9, 3.46719230553321*^9, 3.4791050423233747`*^9, 
   3.4794555728963118`*^9, 3.5112743197804127`*^9, 3.5112824928887978`*^9, 
   3.511282593883149*^9, 3.511286113562804*^9, 3.5112894191105747`*^9, 
   3.5123832001854477`*^9, 3.5123939001747913`*^9, 3.512397122577243*^9, 
   3.5124061995312862`*^9, 3.518029469970955*^9, 3.518030236352685*^9, 
   3.5180309796062183`*^9, 3.518110370884053*^9, 3.5193198020473747`*^9, 
   3.51932334218757*^9, 3.51940583256273*^9, 3.519451977933159*^9, 
   3.519454104260523*^9, 3.519456813868031*^9, 3.5194929999073257`*^9, 
   3.519537686885789*^9, 3.519579929331438*^9, 3.519583844184683*^9, 
   3.519669637310112*^9, 3.519674500974815*^9, 3.519674899234247*^9, 
   3.519751095069859*^9, 3.5198378700262012`*^9, 3.519848990211841*^9, 
   3.519921792177202*^9, 3.520360195661175*^9, 3.520360475377228*^9, 
   3.520443539469296*^9, 3.520528075408058*^9, 3.520529979944888*^9, 
   3.520530634468191*^9, 3.520619737794986*^9, 3.5206219099417543`*^9, 
   3.521045210099497*^9, 3.521134579238516*^9, 3.521140059410841*^9, 
   3.521142385336508*^9, 3.521142452605029*^9, 3.52118521837317*^9, 
   3.521218887108601*^9, 3.5213537681860247`*^9, 3.5243970228610287`*^9, 
   3.533491877643896*^9, 3.533495476716753*^9, 3.533495682891234*^9, 
   3.533501714548724*^9, 3.533504762767159*^9, {3.533505833881706*^9, 
   3.533505842005268*^9}, 3.53475338685966*^9, 3.5433123510666*^9, 
   3.543313292240926*^9, 3.543315546698921*^9, 3.543316033274055*^9, 
   3.543317092791766*^9, 3.54331733587924*^9, {3.5433176610315857`*^9, 
   3.543317669119609*^9}, 3.543331650067192*^9, 3.543573401695613*^9, 
   3.543573625899448*^9, 3.543574549812459*^9, 3.5435763522688227`*^9, 
   3.543577132304191*^9, 3.5436488665926332`*^9, 3.5436496328302813`*^9, {
   3.545639641516507*^9, 3.5456396513059464`*^9}, 3.545644330404231*^9, 
   3.545648138230851*^9, 3.5457266590842752`*^9, 3.545732435717018*^9, 
   3.5457350677346888`*^9, {3.546947529992444*^9, 3.546947535062284*^9}, 
   3.547204895522605*^9, 3.547205398025682*^9, 3.5472814028244953`*^9, 
   3.547283535905464*^9, 3.548401770569853*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CanonicalP", "[", "]"}], "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.392925475533779*^9, {3.392925660271556*^9, 3.392925665282696*^9}, {
   3.4561781807809258`*^9, 3.456178185167856*^9}, 3.4565089307389717`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "1", ",", "x", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "3"], ",", 
   SuperscriptBox["x", "4"], ",", 
   SuperscriptBox["x", "5"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.442142460540533*^9, 3.442142538362048*^9, 3.442146258746646*^9, 
   3.456167830414748*^9, 3.456178188046455*^9, 3.456178261278429*^9, 
   3.4561796046499166`*^9, 3.456181839981682*^9, 3.456429222119369*^9, 
   3.456508932494136*^9, 3.4574236216117153`*^9, 3.4574271124712753`*^9, 
   3.458634875310536*^9, 3.4590176859419937`*^9, 3.459492539524247*^9, 
   3.459492580547709*^9, 3.4594943671956577`*^9, 3.46070325653211*^9, 
   3.4609756853588047`*^9, 3.461924642754815*^9, 3.467192305821835*^9, 
   3.479105042724977*^9, 3.479455573266083*^9, 3.511274320051744*^9, 
   3.511282492990376*^9, 3.5112825939407*^9, 3.511286113640614*^9, 
   3.511289419168685*^9, 3.512383200567143*^9, 3.512393900216239*^9, 
   3.5123971226326733`*^9, 3.512406199575205*^9, 3.518029470484036*^9, 
   3.518030236425641*^9, 3.5180309796649313`*^9, 3.518110371775375*^9, 
   3.519319802365024*^9, 3.5193233422660913`*^9, 3.5194058328410683`*^9, 
   3.519451978221685*^9, 3.519454104310873*^9, 3.519456813943942*^9, 
   3.519493001445994*^9, 3.519537687195208*^9, 3.519579929645051*^9, 
   3.519583844239891*^9, 3.519669637899515*^9, 3.5196745010489597`*^9, 
   3.519674899297621*^9, 3.519751095375801*^9, 3.519837870366371*^9, 
   3.519848990252531*^9, 3.5199217924894667`*^9, 3.520360195721842*^9, 
   3.520360475414798*^9, 3.520443539820269*^9, 3.52052807572814*^9, 
   3.520529980045373*^9, 3.5205306345459146`*^9, 3.520619737856217*^9, 
   3.5206219099793663`*^9, 3.5210452104011183`*^9, 3.521134579668046*^9, 
   3.521140059755431*^9, 3.5211423853969193`*^9, 3.521142452643208*^9, 
   3.521185218465724*^9, 3.5212188873791656`*^9, 3.5213537684729357`*^9, 
   3.5243970228998013`*^9, 3.533491878020234*^9, 3.533495476776177*^9, 
   3.533495682934309*^9, 3.533501715198298*^9, 3.5335047628056307`*^9, {
   3.533505833960506*^9, 3.533505842062387*^9}, 3.534753387223575*^9, 
   3.543312351348131*^9, 3.543313292296116*^9, 3.543315546738119*^9, 
   3.5433160333100348`*^9, 3.5433170928494387`*^9, 3.543317335917078*^9, {
   3.543317661067659*^9, 3.543317669156827*^9}, 3.543331650102899*^9, 
   3.543573402011236*^9, 3.543573625935919*^9, 3.543574549847554*^9, 
   3.543576352323354*^9, 3.5435771323601418`*^9, 3.543648866872868*^9, 
   3.543649632885437*^9, {3.545639641793728*^9, 3.545639651340638*^9}, 
   3.54564433044042*^9, 3.545648138266926*^9, 3.545726659122942*^9, 
   3.545732435772087*^9, 3.5457350677721357`*^9, {3.546947530366969*^9, 
   3.54694753510436*^9}, 3.547204895852579*^9, 3.5472053980606947`*^9, 
   3.547281403146502*^9, 3.547283535945657*^9, 3.5484017708855352`*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Test Examples
\
\>", "Section",
 CellChangeTimes->{{3.455999505296259*^9, 3.455999521281426*^9}, {
  3.494188728653463*^9, 3.494188731392417*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Charlier \n",
 FontColor->RGBColor[0, 0, 1]]], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
   3.456099245982315*^9, 3.456099250448112*^9}, {3.459023407087305*^9, 
   3.459023411224269*^9}, 3.494188735568239*^9}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CharlierC[\[Alpha]][n]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nCharlierC[\[Alpha]][n]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-th recurrence coefficients, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["},",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of the monic ",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials \n(see, for example, (31) of [1] and [5]).",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Alpha]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\[NotEqual]0).\n- If ",
 StyleBox["\[Alpha]=0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then ",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["=0, n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\[GreaterEqual]",
 StyleBox["1.\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or an integer.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- If n>0, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n=0, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"0", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", 0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n<0, ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.459492833431967*^9, 
   3.459492864353343*^9}, {3.461262474718816*^9, 3.461262483653211*^9}, 
   3.464141784068646*^9, {3.4642910692978973`*^9, 3.464291071427699*^9}, {
   3.467189959449627*^9, 3.467189969001009*^9}, 3.467190585311316*^9, {
   3.490788448435904*^9, 3.490788449504915*^9}, {3.4907903631387577`*^9, 
   3.490790364039235*^9}, {3.524942192313139*^9, 3.5249422179078627`*^9}, {
   3.533665695687749*^9, 3.533665696295485*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "CharlierC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CharlierC", "[", 
      StyleBox[
       RowBox[{
        StyleBox["\[Alpha]",
         FontWeight->"Bold",
         FontSlant->"Italic"], "_"}]], "]"}], "[", "n_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"CharlierC", "[", 
       StyleBox["\[Alpha]",
        FontWeight->"Bold",
        FontSlant->"Italic"], "]"}], "[", "n", "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"checking", " ", "the", " ", "arguments"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           StyleBox["\[Alpha]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "===", "0"}], ",", "\[IndentingNewLine]", 
          "     ", 
          RowBox[{
          "Print", "[", 
           "\"\<the parameter is zero; Charlier polynomials are not regular;\n\
             second recurrence coefficients are zero.\>\"", "]"}]}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"(*", "  ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"NumericQ", "[", "n", "]"}], ",", 
            RowBox[{"n", "<", "0"}]}], "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"n", "===", "0"}], ",", 
            RowBox[{"n", "===", "0."}]}], "]"}], ",", " ", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", "0"}], "}"}], "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"n", "+", 
              StyleBox["\[Alpha]",
               FontWeight->"Bold",
               FontSlant->"Italic"]}], ",", 
             RowBox[{
              StyleBox["\[Alpha]",
               FontWeight->"Bold",
               FontSlant->"Italic"], "*", "n"}]}], "}"}], "]"}]}], "]"}], 
        ";"}]}], "\[IndentingNewLine]", "]"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"end", " ", "of", " ", "Module"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.392925547374865*^9, 3.392925557228488*^9}, {
   3.456098636747405*^9, 3.456098682265583*^9}, 3.456167550424859*^9, {
   3.456167615149438*^9, 3.456167628742049*^9}, {3.456167921623927*^9, 
   3.456167943174554*^9}, {3.456179648470574*^9, 3.456179663892076*^9}, {
   3.45661578511791*^9, 3.456615785251096*^9}, {3.459492901935306*^9, 
   3.459492904016068*^9}, {3.4610556825913563`*^9, 3.4610556936318502`*^9}, {
   3.4612632445083933`*^9, 3.461263287416947*^9}, {3.534753428058342*^9, 
   3.534753435183217*^9}, {3.534754135650419*^9, 3.534754137071392*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190061669941*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CharlierC", "[", "\[Alpha]", "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{3.3929254979328823`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"n", "+", "\[Alpha]"}], ",", 
   RowBox[{"n", " ", "\[Alpha]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.3929254985477467`*^9, 3.392925595030994*^9, 3.442018577185676*^9, 
   3.4421425497325993`*^9, 3.4421462296646023`*^9, 3.442146303330542*^9, 
   3.456167493668043*^9, 3.456181330775948*^9, {3.4561818402249937`*^9, 
   3.456181865314349*^9}, 3.456429233330202*^9, 3.457423621673809*^9, 
   3.4574271125183907`*^9, 3.458634875364769*^9, 3.4590176861056147`*^9, 
   3.459492945033823*^9, 3.459494367360963*^9, 3.460975401670394*^9, {
   3.461055724697876*^9, 3.461055744953418*^9}, 3.461263321129005*^9, 
   3.461924362750288*^9, 3.467191594276279*^9, 3.4907938658401823`*^9, 
   3.494189005583206*^9, 3.494242946987279*^9, 3.494673832029595*^9, 
   3.524942101675799*^9, 3.524943538490102*^9, 3.5333834833291893`*^9, 
   3.534753449758254*^9, 3.543317338632353*^9, 3.543317672223632*^9, 
   3.543331653885408*^9, 3.545648145673386*^9, 3.546947541918714*^9, 
   3.5472048997931337`*^9, 3.54720509846189*^9, 3.547206196628867*^9, 
   3.5484017709440317`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CharlierC", "[", "\[Alpha]", "]"}], "[", "n", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.3929254754059153`*^9, {3.456167672701239*^9, 3.4561676731344213`*^9}}],

Cell[BoxData[
 RowBox[{"n", "+", "\[Alpha]"}]], "Output",
 CellChangeTimes->{
  3.4421425590692053`*^9, 3.442146239120182*^9, 3.4561676737345533`*^9, 
   3.456181330902206*^9, {3.4561818403162117`*^9, 3.456181865398944*^9}, 
   3.456429235027712*^9, 3.457423621707386*^9, 3.4574271125523987`*^9, 
   3.458634875393938*^9, 3.459017686295082*^9, 3.459492945978696*^9, 
   3.459494367446245*^9, 3.460975401701427*^9, 3.461055750147883*^9, 
   3.46126333051027*^9, 3.461924362813528*^9, 3.467191594627365*^9, 
   3.490793865909758*^9, 3.494189005651716*^9, 3.494242947052861*^9, 
   3.4946738320994577`*^9, 3.5249421017447643`*^9, 3.5249435385565357`*^9, 
   3.5333834833865967`*^9, 3.534753454311782*^9, 3.543317338732567*^9, 
   3.5433176722933292`*^9, 3.543331653974847*^9, 3.54564814577318*^9, 
   3.546947541999263*^9, 3.5472048998278522`*^9, 3.5472050984979258`*^9, 
   3.547206196662817*^9, 3.5484017709756823`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CharlierC", "[", "\[Alpha]", "]"}], "[", "n", "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.3929254754059153`*^9, {3.456167672701239*^9, 3.456167683321616*^9}}],

Cell[BoxData[
 RowBox[{"n", " ", "\[Alpha]"}]], "Output",
 CellChangeTimes->{
  3.4421425590692053`*^9, 3.442146239120182*^9, {3.4561676737345533`*^9, 
   3.45616768403266*^9}, 3.456181331035928*^9, {3.456181840398921*^9, 
   3.456181865483429*^9}, 3.4564292366758842`*^9, 3.4574236217408733`*^9, 
   3.457427112584259*^9, 3.45863487542374*^9, 3.4590176863896008`*^9, 
   3.459492947052103*^9, 3.459494367514092*^9, 3.460975401730448*^9, 
   3.461055752227562*^9, 3.461263332098304*^9, 3.461924362844604*^9, 
   3.467191594729257*^9, 3.490793865946525*^9, 3.4941890056886387`*^9, 
   3.494242947090745*^9, 3.49467383213536*^9, 3.524942101776471*^9, 
   3.524943538591423*^9, 3.5333834834316874`*^9, 3.5347534558125277`*^9, 
   3.543317338770328*^9, 3.543317672348524*^9, 3.5433316540235767`*^9, 
   3.545648145806258*^9, 3.546947542039229*^9, 3.547204899862438*^9, 
   3.547205098548435*^9, 3.54720619669687*^9, 3.548401771009996*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CharlierC", "[", "\[Alpha]", "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.392925475273508*^9, {3.392925507630931*^9, 3.392925508541072*^9}, {
   3.3929256242649117`*^9, 3.392925625904984*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[Alpha]"}], ",", "\[Alpha]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "\[Alpha]"}], ",", 
     RowBox[{"2", " ", "\[Alpha]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "\[Alpha]"}], ",", 
     RowBox[{"3", " ", "\[Alpha]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "\[Alpha]"}], ",", 
     RowBox[{"4", " ", "\[Alpha]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", "\[Alpha]"}], ",", 
     RowBox[{"5", " ", "\[Alpha]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.392925501680955*^9, 3.3929255091696177`*^9}, {
   3.392925596836184*^9, 3.3929256264701443`*^9}, 3.442018584733432*^9, 
   3.442142552221183*^9, 3.442146235390911*^9, 3.456167511996201*^9, 
   3.45618133116856*^9, {3.456181840546123*^9, 3.456181865569351*^9}, 
   3.456429238566819*^9, 3.457423621776425*^9, 3.457427112613626*^9, 
   3.458634875454335*^9, 3.459017686488958*^9, 3.459492947982378*^9, 
   3.45949436758414*^9, 3.460975401764254*^9, 3.461055754156186*^9, 
   3.461263334194785*^9, 3.4619243628761263`*^9, 3.46719159482836*^9, 
   3.4907938659923697`*^9, 3.494189005736038*^9, 3.49424294711943*^9, 
   3.494673832169792*^9, 3.524942101812262*^9, 3.5249435386251698`*^9, 
   3.533383483467804*^9, 3.534753457582178*^9, 3.543317338802371*^9, 
   3.543317672376794*^9, 3.543331654056341*^9, 3.545648145840053*^9, 
   3.546947542089881*^9, 3.5472048999127703`*^9, 3.547205098581975*^9, 
   3.547206196744433*^9, 3.548401771081398*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CharlierC", "[", "0", "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{
  3.392925475346313*^9, {3.392925522354867*^9, 3.392925525004037*^9}}],

Cell[BoxData["\<\"the parameter is zero; Charlier polynomials are not \
regular;\\n             second recurrence coefficients are zero.\"\>"], \
"Print",
 CellChangeTimes->{
  3.456167583139155*^9, 3.456167645137842*^9, 3.4561813312671843`*^9, {
   3.456181840626917*^9, 3.456181865653352*^9}, 3.4564292402826366`*^9, 
   3.457423621887933*^9, 3.457427112672513*^9, 3.458634875519642*^9, 
   3.459017686692604*^9, 3.4594929514937572`*^9, 3.459494367729868*^9, 
   3.4609754018258944`*^9, 3.461055757674305*^9, 3.461924362941225*^9, 
   3.4671915950268307`*^9, 3.490793866076717*^9, 3.494189005801585*^9, 
   3.494242947188177*^9, 3.4946738322531357`*^9, 3.524942101879635*^9, 
   3.524943538709362*^9, 3.53338348353467*^9, 3.534753463053063*^9, 
   3.534754143894532*^9, 3.543317338870775*^9, 3.543317672461104*^9, 
   3.543331654140325*^9, 3.545648145908943*^9, 3.5469475421427183`*^9, 
   3.547204899946793*^9, 3.547205098645455*^9, 3.5472061967988*^9, 
   3.548401771110701*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"n", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.392925518674395*^9, 3.3929255255493317`*^9}, 
   3.392925598773353*^9, 3.392925630833559*^9, 3.442142554389305*^9, 
   3.442146237345064*^9, 3.456167516688628*^9, {3.456167558853547*^9, 
   3.456167583229744*^9}, 3.456167645212943*^9, 3.456181331331156*^9, {
   3.4561818406424828`*^9, 3.456181865660926*^9}, 3.456429240364893*^9, 
   3.457423621890923*^9, 3.457427112676817*^9, 3.4586348755219173`*^9, 
   3.459017686699665*^9, 3.459492951625277*^9, 3.4594943677461977`*^9, 
   3.460975401828177*^9, 3.461055757708314*^9, 3.461924362945546*^9, 
   3.4671915950476923`*^9, 3.490793866079754*^9, 3.494189005803063*^9, 
   3.494242947189662*^9, 3.49467383225558*^9, 3.524942101881831*^9, 
   3.5249435387115307`*^9, 3.533383483536895*^9, 3.534753463056958*^9, 
   3.534754143898459*^9, 3.543317338873538*^9, 3.543317672463936*^9, 
   3.543331654142963*^9, 3.545648145913069*^9, 3.546947542146748*^9, 
   3.547204899949225*^9, 3.547205098649076*^9, 3.547206196802153*^9, 
   3.548401771113056*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CharlierP[\[Alpha]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nCharlierP[\[Alpha]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the monic ",
 StyleBox["Charlier ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "polynomial of parameter ",
 StyleBox["\[Alpha]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of degree ",
 StyleBox["n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "in the variable",
 StyleBox[" x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "[1,4].",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Alpha]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\[NotEqual]0).\n- If ",
 StyleBox["\[Alpha]=0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then ",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is an integer.\n- ",
 StyleBox["x ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a numeric expression.\n\nC",
 StyleBox["ommands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n-  ",
 StyleBox["CharlierC, MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}],
     FontWeight->"Bold"]}], TraditionalForm]]],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456097951825645*^9, 3.456098239961841*^9}, {
   3.456098309216773*^9, 3.4560983428103247`*^9}, {3.4560983849839067`*^9, 
   3.4560983875073643`*^9}, 3.456098439313355*^9, {3.456099836665434*^9, 
   3.4560998719883966`*^9}, {3.45616715005504*^9, 3.456167164357448*^9}, {
   3.456167948743168*^9, 3.456167969476221*^9}, {3.456177870043385*^9, 
   3.4561778710179777`*^9}, {3.4561796764655333`*^9, 
   3.4561796900520887`*^9}, {3.456429312486883*^9, 3.456429382514854*^9}, {
   3.459492982379218*^9, 3.4594930286804247`*^9}, 3.4641417995104733`*^9, {
   3.467190068557035*^9, 3.467190075329557*^9}, 3.490789809955594*^9, {
   3.490790378192707*^9, 3.490790379085476*^9}, 3.524942260481573*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "CharlierP", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CharlierP", "[", 
     StyleBox[
      RowBox[{
       StyleBox["\[Alpha]",
        FontWeight->"Bold",
        FontSlant->"Italic"], "_"}]], "]"}], "[", 
    RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CharlierP", "[", 
      StyleBox["\[Alpha]",
       FontWeight->"Bold",
       FontSlant->"Italic"], "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"MOP", "[", "CharlierC", "]"}], "[", 
      StyleBox["\[Alpha]",
       FontWeight->"Bold",
       FontSlant->"Italic"], "]"}], "[", 
     RowBox[{"n", ",", " ", "x"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.392925563841031*^9, 3.392925576529078*^9}, {
   3.442018287322798*^9, 3.442018340937385*^9}, {3.4420185212085667`*^9, 
   3.442018526565257*^9}, {3.4421423285833063`*^9, 3.442142360155676*^9}, {
   3.4560982600803547`*^9, 3.456098264859057*^9}, {3.456098859994157*^9, 
   3.4560988627916603`*^9}, {3.456098932353162*^9, 3.45609894490342*^9}, {
   3.456167980227027*^9, 3.456167987363227*^9}, {3.4594931968227053`*^9, 
   3.45949323012667*^9}, 3.5347535362285137`*^9}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190082654965*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CharlierP", "[", "\[Alpha]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MOP", "[", "CharlierC", "]"}], "[", "\[Alpha]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 CellChangeTimes->{
  3.459493133652115*^9, {3.459493217088496*^9, 3.459493233520924*^9}, 
   3.459494367995864*^9, 3.4609754018745537`*^9, 3.46192436299398*^9, 
   3.467191595174193*^9, 3.4907938661404943`*^9, 3.494189005868519*^9, 
   3.494242947252722*^9, 3.4946738323131313`*^9, 3.524942101928754*^9, 
   3.5249435387590523`*^9, 3.533383483581843*^9, 3.53475354082795*^9, 
   3.543317338933504*^9, 3.543317672523828*^9, 3.5433316542226353`*^9, 
   3.545648145987403*^9, 3.546947542209127*^9, 3.54720490000852*^9, 
   3.5472050987116737`*^9, 3.547206196862377*^9, 3.548401771161237*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CharlierP", "[", "\[Alpha]", "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{
  3.392925475533779*^9, {3.392925660271556*^9, 3.392925665282696*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"0"},
     {"0"},
     {"1"},
     {
      RowBox[{"x", "-", "\[Alpha]"}]},
     {
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
       SuperscriptBox["\[Alpha]", "2"]}]},
     {
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       SuperscriptBox["\[Alpha]", "3"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          RowBox[{"3", " ", "\[Alpha]"}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["\[Alpha]", "4"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}], "-", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", 
          RowBox[{"12", " ", "\[Alpha]"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "5"], "-", 
       SuperscriptBox["\[Alpha]", "5"], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"6", " ", "\[Alpha]"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", 
          RowBox[{"11", " ", "\[Alpha]"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["\[Alpha]", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[Alpha]", "3"]}]}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"24", "+", 
          RowBox[{"30", " ", "\[Alpha]"}], "+", 
          RowBox[{"20", " ", 
           SuperscriptBox["\[Alpha]", "2"]}], "+", 
          RowBox[{"10", " ", 
           SuperscriptBox["\[Alpha]", "3"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["\[Alpha]", "4"]}]}], ")"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.442142460540533*^9, 3.442142538362048*^9, 3.442146258746646*^9, 
   3.456167830414748*^9, 3.4561813315770693`*^9, {3.456181841000005*^9, 
   3.4561818657566566`*^9}, 3.456429474028967*^9, 3.456446806105978*^9, 
   3.456447173981697*^9, {3.456508959600626*^9, 3.4565089685496683`*^9}, 
   3.457423623250279*^9, 3.457427113870325*^9, 3.458631434238742*^9, 
   3.4586348767124853`*^9, 3.4590176895009613`*^9, 3.459493051502335*^9, 
   3.459494373297721*^9, 3.460975403112864*^9, 3.461924364756556*^9, 
   3.467191599737199*^9, 3.4907938668263493`*^9, 3.494189005926344*^9, 
   3.494242947948592*^9, 3.4946738329345713`*^9, 3.52494210268114*^9, 
   3.524943539146894*^9, 3.533383484001976*^9, 3.534753547705659*^9, 
   3.5433173392950993`*^9, 3.543317672911806*^9, 3.543331654606803*^9, 
   3.545648146713483*^9, 3.546331240375333*^9, 3.5469475426628103`*^9, 
   3.5472049004788837`*^9, 3.5472050990850353`*^9, 3.547206197264679*^9, 
   3.548401771588974*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)6",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic \n",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457350055855905*^9, 
   3.457350073156341*^9}, {3.459493262721665*^9, 3.459493265012727*^9}, {
   3.4594934786852617`*^9, 3.459493481132813*^9}, {3.467190090240499*^9, 
   3.4671900948785973`*^9}, 3.467190572964321*^9, 3.524942307946501*^9, {
   3.534753616443688*^9, 3.534753617530575*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{"CharlierC", ",", "CharlierC"}], "]"}], "[", "\[Alpha]", 
       "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.467191103386351*^9, 
   3.467191103789814*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], "+", 
      OverscriptBox["\[Alpha]", "~"]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"], 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"], 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "5"]}], 
     RowBox[{"5", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"]}], 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"10", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "6"], 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "5"]}], 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"]}], 
     RowBox[{
      RowBox[{"-", "20"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{
    1}, {-$CellContext`\[Alpha] + OverTilde[$CellContext`\[Alpha]], 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^2, (-2) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {-($CellContext`\[Alpha] - OverTilde[$CellContext`\[Alpha]])^3, 
     3 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-3) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^4, (-4) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     6 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-4) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {-($CellContext`\[Alpha] - OverTilde[$CellContext`\[Alpha]])^5, 
     5 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^4, (-10) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     10 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-5) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^6, (-6) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^5, 
     15 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^4, (-20) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     15 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-6) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 1}}]]], "Output",
 CellChangeTimes->{
  3.392926973081232*^9, 3.393266360763041*^9, {3.456168526255616*^9, 
   3.4561685547367573`*^9}, 3.4561687384832973`*^9, {3.456169202878273*^9, 
   3.456169218687344*^9}, 3.456181337331645*^9, {3.4561818426204367`*^9, 
   3.4561818659610786`*^9}, 3.45742362446701*^9, 3.457427115159542*^9, 
   3.458631078909486*^9, 3.458631455240226*^9, 3.458634878376904*^9, 
   3.459017692221898*^9, 3.4594932831840973`*^9, 3.459494380830162*^9, 
   3.46097540486509*^9, 3.4619243660060587`*^9, 3.4671916025384693`*^9, 
   3.490793867249206*^9, 3.4941890061437073`*^9, 3.494242948349057*^9, 
   3.494673833355748*^9, 3.524942103086814*^9, 3.524943539574956*^9, 
   3.533383484461124*^9, 3.534753624300949*^9, 3.543317339742527*^9, 
   3.543317673354677*^9, 3.543331655054034*^9, 3.5456481472103558`*^9, 
   3.5463312463363457`*^9, 3.5469475427650547`*^9, 3.547204900571961*^9, 
   3.5472050991652613`*^9, 3.547206197358336*^9, 3.54840177178479*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed recursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command, up to ",
 StyleBox["n=20, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where\n",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.456184437961193*^9, 3.4561845022291403`*^9}, {
   3.456184823849684*^9, 3.456184825038542*^9}, {3.456184855520928*^9, 
   3.456184861948104*^9}, {3.456185190476099*^9, 3.456185193970113*^9}, {
   3.467190101496389*^9, 3.4671901097429657`*^9}, 3.467190568448094*^9, {
   3.53475364408033*^9, 3.534753656430071*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"verificationRCC", "[", 
        RowBox[{"CharlierC", ",", "CharlierC"}], "]"}], "[", "\[Alpha]", 
       "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", "20", "]"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"75.029844`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561813422335443`*^9, {3.456181862350334*^9, 
   3.456181875527793*^9}, 3.4574238997441387`*^9, 3.457427394497045*^9, 
   3.458631359709937*^9, 3.458631751522105*^9, 3.458635022256415*^9, 
   3.459018239321106*^9, 3.459493910306632*^9, 3.459494946922492*^9, 
   3.460975683966157*^9, 3.4619246414744883`*^9, 3.467192296233859*^9, 
   3.490793925793314*^9, 3.494189006170961*^9, 3.494243006650138*^9, 
   3.494673891733283*^9, 3.524942177754821*^9, 3.524943617180995*^9, 
   3.533383560461965*^9, 3.534753741051158*^9, 3.54331741639545*^9, 
   3.543317750837886*^9, 3.543331733241074*^9, 3.545648222819232*^9, 
   3.5469476176853867`*^9, 3.547204975491193*^9, 3.5472051764962263`*^9, 
   3.5472062752246943`*^9, 3.548401846860353*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Binomial", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["n", "TI"], 
      StyleBox[",", "MR"], " ", 
      StyleBox["m", "TI"]}], 
     StyleBox["]", "MR"]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.456180594579808*^9, 3.45618059553015*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {"1", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"1", "2", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "3", "3", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "4", "6", "4", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "5", "10", "10", "5", "1", "\<\"\"\>", "\<\"\"\>"},
    {"1", "6", "15", "20", "15", "6", "1", "\<\"\"\>"},
    {"1", "7", "21", "35", "35", "21", "7", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 5, 10,
     10, 5, 1}, {1, 6, 15, 20, 15, 6, 1}, {1, 7, 21, 35, 35, 21, 7, 
    1}}]]], "Output",
 CellChangeTimes->{
  3.456180596309375*^9, {3.456181862567135*^9, 3.456181875762442*^9}, 
   3.457423899836424*^9, 3.457427394579941*^9, 3.459018239483974*^9, 
   3.4594949470959663`*^9, 3.460975684104601*^9, 3.461924641573102*^9, 
   3.467192297103733*^9, 3.490793925885899*^9, 3.494189006208414*^9, 
   3.494243006698147*^9, 3.494673891808856*^9, 3.524942177815721*^9, 
   3.524943617235701*^9, 3.53338356052424*^9, 3.534754024537938*^9, 
   3.543317416465351*^9, 3.543317750898612*^9, 3.543331733354743*^9, 
   3.545648222922654*^9, 3.5469476178297777`*^9, 3.547204975589219*^9, 
   3.547205176554949*^9, 3.5472062752880993`*^9, 3.5484018469042263`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CharlierDCC[\[Alpha]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nCharlierDCC[\[Alpha]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " computes the connection coefficient",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes \nthe monic ",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials, using the direct closed formula (32) of [1] infered from the \
above results \nproduced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData[
  RowBox[{"P", " ", 
   StyleBox["and",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   FormBox[
    StyleBox[
     OverscriptBox["P", "~"],
     FontWeight->"Bold",
     FontSlant->"Italic"],
    TraditionalForm]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they should be symbols or integers.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.457424640835507*^9, 3.4574246415287323`*^9}, {
   3.4583020173029327`*^9, 3.4583020203183613`*^9}, {3.459493413095625*^9, 
   3.459493431474205*^9}, {3.45949380181355*^9, 3.4594938349417562`*^9}, {
   3.4612634637317533`*^9, 3.4612634641268263`*^9}, 3.464141812293663*^9, {
   3.467190116335059*^9, 3.467190121879775*^9}, {3.467190561293803*^9, 
   3.467190563542284*^9}, 3.49079039468078*^9, {3.5249423619118834`*^9, 
   3.524942362845944*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "CharlierDCC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CharlierDCC", "[", "\[Alpha]_", "]"}], "[", "\[Alpha]tilde_", 
     "]"}], "[", 
    RowBox[{"n_", ",", "m_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "-", "m"}], ")"}]}], "*", 
    RowBox[{
     StyleBox["Binomial", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["n", "TI"], 
      StyleBox[",", "MR"], " ", 
      StyleBox["m", "TI"]}], 
     StyleBox["]", "MR"]}], 
    StyleBox["*", "MR"], 
    RowBox[{
     RowBox[{
      StyleBox["(", "MR"], 
      RowBox[{"\[Alpha]", "-", "\[Alpha]tilde"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "-", "m"}], ")"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.392931961185553*^9, 3.39293212582408*^9}, {
   3.392934496282661*^9, 3.392934498632695*^9}, {3.393266113524909*^9, 
   3.393266116523674*^9}, {3.393266309101226*^9, 3.393266319770774*^9}, {
   3.445044982504593*^9, 3.445044986141055*^9}, 3.456182774112281*^9, {
   3.458302025384445*^9, 3.4583020282005568`*^9}, {3.5435746801650543`*^9, 
   3.543574699918213*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190125082407*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CharlierDCC", "[", "\[Alpha]", "]"}], "[", 
   OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
  RowBox[{"n", ",", "m"}], "]"}]], "Input",
 CellChangeTimes->{3.458302032245502*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"-", "m"}], "+", "n"}]], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "m"}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "-", 
     OverscriptBox["\[Alpha]", "~"]}], ")"}], 
   RowBox[{
    RowBox[{"-", "m"}], "+", "n"}]]}]], "Output",
 CellChangeTimes->{3.456182730547176*^9, 3.457423899889545*^9, 
  3.4574273946312447`*^9, 3.45863135986132*^9, 3.4586317516894207`*^9, 
  3.459018239576717*^9, 3.4594949472070417`*^9, 3.460975684173902*^9, 
  3.461924641633868*^9, 3.46719229732463*^9, 3.490793925936612*^9, 
  3.4941890062507887`*^9, 3.494243006741358*^9, 3.494673891876327*^9, 
  3.524942177881928*^9, 3.524943617270978*^9, 3.533383560588705*^9, 
  3.534754048888239*^9, 3.543317416527828*^9, 3.5433177509451447`*^9, 
  3.543331733420499*^9, 3.543573507859009*^9, 3.545648223000143*^9, 
  3.5469476179106483`*^9, 3.5472049756348467`*^9, 3.5472051766215963`*^9, 
  3.5472062753771257`*^9, 3.548401846937153*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CharlierDCC", "[", "\[Alpha]", "]"}], "[", 
   OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
  RowBox[{"n", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{
  3.458302032245502*^9, {3.543573781598599*^9, 3.543573782780723*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.456182730547176*^9, 3.457423899889545*^9, 
  3.4574273946312447`*^9, 3.45863135986132*^9, 3.4586317516894207`*^9, 
  3.459018239576717*^9, 3.4594949472070417`*^9, 3.460975684173902*^9, 
  3.461924641633868*^9, 3.46719229732463*^9, 3.490793925936612*^9, 
  3.4941890062507887`*^9, 3.494243006741358*^9, 3.494673891876327*^9, 
  3.524942177881928*^9, 3.524943617270978*^9, 3.533383560588705*^9, 
  3.534754048888239*^9, 3.543317416527828*^9, 3.5433177509451447`*^9, 
  3.543331733420499*^9, 3.543573507859009*^9, 3.543573783387451*^9, 
  3.5456482230395813`*^9, 3.546947617947257*^9, 3.547204975666638*^9, 
  3.5472051766579533`*^9, 3.54720627542284*^9, 3.5484018469661093`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CharlierDCC", "[", "\[Alpha]", "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.392932140063591*^9, 3.392932165358265*^9}, {
   3.3929345075168877`*^9, 3.3929345097989388`*^9}, {3.445045015319386*^9, 
   3.445045017993284*^9}, {3.456180686245266*^9, 3.456180687272883*^9}, 
   3.4583020434946423`*^9, {3.4671911376122932`*^9, 3.467191138068036*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {
     RowBox[{
      RowBox[{"-", "\[Alpha]"}], "+", 
      OverscriptBox["\[Alpha]", "~"]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"], 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"], 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "5"]}], 
     RowBox[{"5", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"]}], 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"10", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "5"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1", "\<\"\"\>"},
    {
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], "6"], 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "5"]}], 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "4"]}], 
     RowBox[{
      RowBox[{"-", "20"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "3"]}], 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], "2"]}], 
     RowBox[{
      RowBox[{"-", "6"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{
    1}, {-$CellContext`\[Alpha] + OverTilde[$CellContext`\[Alpha]], 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^2, (-2) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {-($CellContext`\[Alpha] - OverTilde[$CellContext`\[Alpha]])^3, 
     3 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-3) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^4, (-4) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     6 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-4) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {-($CellContext`\[Alpha] - OverTilde[$CellContext`\[Alpha]])^5, 
     5 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^4, (-10) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     10 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-5) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 
     1}, {($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]])^6, (-6) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^5, 
     15 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^4, (-20) ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^3, 
     15 ($CellContext`\[Alpha] - 
       OverTilde[$CellContext`\[Alpha]])^2, (-6) ($CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]), 1}}]]], "Output",
 CellChangeTimes->{{3.39293216828863*^9, 3.3929321768237057`*^9}, {
   3.392934512920949*^9, 3.392934520343773*^9}, 3.392934772887957*^9, 
   3.3932661279399967`*^9, 3.4450450237288218`*^9, {3.45618068834435*^9, 
   3.456180694269896*^9}, 3.456181234408778*^9, {3.456181865068555*^9, 
   3.4561818769148827`*^9}, 3.4574238999341707`*^9, 3.457427394673703*^9, 
   3.458631359955103*^9, 3.458631751791115*^9, 3.4590182396621237`*^9, 
   3.459494947306964*^9, 3.460975684233494*^9, 3.461924641687458*^9, 
   3.4671922981831293`*^9, 3.490793925977421*^9, 3.4941890062887173`*^9, 
   3.4942430067700243`*^9, 3.494673891914425*^9, 3.524942177924047*^9, 
   3.524943617306946*^9, 3.533383560622365*^9, 3.5347540586483593`*^9, 
   3.5433174165701113`*^9, 3.543317750988488*^9, 3.543331733455405*^9, 
   3.545648223097144*^9, 3.54694761800513*^9, 3.547204975692083*^9, 
   3.547205176709715*^9, 3.547206275462129*^9, 3.548401847004485*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command ",
 StyleBox["CharlierDCC[\[Alpha]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Plain"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " up to",
 StyleBox[" n=20",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, 
   3.460704954146987*^9, {3.4671901313567266`*^9, 3.467190135304528*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"verificationDCC", "[", "CharlierDCC", "]"}], "[", 
        RowBox[{"CharlierC", ",", "CharlierC"}], "]"}], "[", "\[Alpha]", 
       "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", "20", "]"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, 
   3.458302049606372*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.009881000000007134`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561807739243917`*^9, {3.45618091265759*^9, 
   3.456180922611292*^9}, 3.456181249638791*^9, 3.456181346678258*^9, {
   3.456181864826623*^9, 3.456181876695964*^9}, 3.456182891194395*^9, {
   3.456183292995904*^9, 3.456183301609206*^9}, 3.4574238999772577`*^9, 
   3.45742739471556*^9, 3.4586313600534678`*^9, 3.458631751899942*^9, 
   3.459018239764121*^9, 3.459494947408948*^9, 3.460975684286952*^9, 
   3.461924641736528*^9, 3.4671922982904263`*^9, 3.4907939260084267`*^9, 
   3.494189006318193*^9, 3.4942430068044767`*^9, 3.4946738919434023`*^9, 
   3.524942177956353*^9, 3.524943617337432*^9, 3.533383560654405*^9, 
   3.5347540656173687`*^9, 3.543317416615309*^9, 3.5433177510201674`*^9, 
   3.543331733487307*^9, 3.543573520856127*^9, 3.545648223136891*^9, 
   3.546947618048523*^9, 3.5472049757190027`*^9, 3.5472051767575073`*^9, 
   3.547206275507893*^9, 3.548401847032444*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\nDemonstration of the direct closed formula for",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) ), ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the monic \n",
 StyleBox["Charlier",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials,",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "translated by the command ",
 StyleBox["CharlierDCC[\[Alpha]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Plain"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, 3.458302065501041*^9, {3.46719014220504*^9, 
   3.467190148755619*^9}, 3.4671905539035673`*^9, {3.534756402369817*^9, 
   3.5347564268382673`*^9}, {3.5347675321078444`*^9, 
   3.5347675341499233`*^9}, {3.534844052252915*^9, 3.534844052995878*^9}, {
   3.545734217317185*^9, 3.545734247385516*^9}, {3.545734314264365*^9, 
   3.545734314597322*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationDCC", "[", "CharlierDCC", "]"}], "[", 
      RowBox[{"CharlierC", ",", "CharlierC"}], "]"}], "[", "\[Alpha]", "]"}], 
    "[", 
    OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.456183675404463*^9, 3.456183682545762*^9}, {
   3.4561837380969963`*^9, 3.4561837547918158`*^9}, 3.458302062734384*^9, {
   3.4590188640717697`*^9, 3.459018868647876*^9}, 3.481872931875482*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.36835800000000063`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.4561837585295763`*^9, 3.457423900701447*^9, 
  3.457427395230214*^9, 3.458631360873929*^9, 3.459018241062854*^9, 
  3.459018870641445*^9, 3.4594949487409678`*^9, 3.460975685077299*^9, 
  3.4619246425006866`*^9, 3.467192304294984*^9, 3.4907939263807993`*^9, 
  3.494189006355587*^9, 3.494243007225363*^9, 3.4946738923101387`*^9, 
  3.52494218283331*^9, 3.524942424555581*^9, 3.5249431622518053`*^9, 
  3.52494323917724*^9, 3.5249436178144093`*^9, 3.533383561214571*^9, 
  3.534754075453248*^9, 3.54331741709161*^9, 3.543317755695472*^9, 
  3.5433317383114643`*^9, 3.5433318103181067`*^9, 3.543331888943924*^9, 
  3.543332139870636*^9, 3.543573524513989*^9, 3.545648223504583*^9, 
  3.5469476188017607`*^9, 3.5472049761968603`*^9, 3.5472051770945663`*^9, 
  3.5472062758811007`*^9, 3.548401847553226*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Canonical and Laguerre \n",
 FontColor->RGBColor[0, 0, 1]]], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
   3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
   3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
   3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460529160209412*^9, 
   3.460529160850732*^9}, {3.460538651644092*^9, 3.460538676771216*^9}, 
   3.494188739273307*^9, 3.4941887986761*^9}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["LaguerreC[\[Alpha]][n] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nLaguerreC[\[Alpha]][n] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-th recurrence coefficients, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["},",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials \n(see, for example, (33) of [1], and [5]).",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Alpha] \[NotEqual] -n, n>0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ").\n- If ",
 StyleBox["\[Alpha] = -n , n>0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["= 0, n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\[GreaterEqual]",
 StyleBox["1.\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["-",
  FontSlant->"Italic"],
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "numeric expression.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or an integer.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- If n>0, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"n", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n=0, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", 
    RowBox[{"0", " "}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", 0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n<0, ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, 
   3.490790826685713*^9, {3.490790876444502*^9, 3.4907908777305202`*^9}, 
   3.494234788251326*^9, {3.494234842128851*^9, 3.494234865533502*^9}, {
   3.524942514853818*^9, 3.524942515443602*^9}, {3.533665757398575*^9, 
   3.533665757899374*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "LaguerreC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LaguerreC", "[", "\[Alpha]_", "]"}], "[", "n_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"LaguerreC", "[", "\[Alpha]", "]"}], "[", "n", "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"checking", " ", "the", " ", "arguments"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Alpha]", "]"}], ",", 
            RowBox[{"\[Alpha]", "<", "0"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "     ", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<warning concerning the parameter \[Alpha] =\>\"", ",", 
            "\[Alpha]", ",", " ", "\[IndentingNewLine]", 
            "                  ", 
            "\"\< \[Alpha] is a negative integer; Laguerre form is not \
regular;\n              some second recurrence coefficients are zero.\>\""}], 
           "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"NumericQ", "[", "n", "]"}], ",", 
            RowBox[{"n", "<", "0"}]}], "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"n", "===", "0"}], ",", 
            RowBox[{"n", "===", "0."}]}], "]"}], ",", " ", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Alpha]", "+", "1"}], ",", "0"}], "}"}], "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"2", "*", "n"}], "+", "\[Alpha]", "+", "1"}], ",", 
             RowBox[{"n", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "\[Alpha]"}], ")"}]}]}], "}"}], " ", "]"}]}],
          "]"}], ";"}]}], " ", "\[IndentingNewLine]", "]"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"end", " ", "of", " ", "Module"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.400452759660624*^9, 3.400452760193726*^9}, {
   3.460618217925473*^9, 3.460618279112927*^9}, {3.460618406882461*^9, 
   3.4606184492486887`*^9}, 3.460618513254024*^9, {3.461263833101872*^9, 
   3.461263849135838*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.4671902072591047`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaguerreC", "[", "\[Alpha]", "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{{3.4606183435764847`*^9, 3.4606183454584913`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}], "+", "\[Alpha]"}], ",", 
   RowBox[{"n", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "\[Alpha]"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.460618346327758*^9, 3.460618352151531*^9}, 
   3.460618520407537*^9, 3.4609756854908257`*^9, 3.461263889980612*^9, 
   3.4619246428595543`*^9, 3.467192306459722*^9, 3.4907939266744003`*^9, 
   3.494243007420422*^9, 3.494673892615396*^9, 3.524942183227874*^9, 
   3.5249436180059834`*^9, 3.53338356157397*^9, 3.534754170597286*^9, 
   3.543315579258771*^9, 3.543317417179544*^9, 3.543317755857429*^9, 
   3.543331926165996*^9, 3.5456482315868397`*^9, 3.548401847599107*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LaguerreC", "[", "\[Alpha]", "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.392925475273508*^9, {3.392925507630931*^9, 3.392925508541072*^9}, {
   3.3929256242649117`*^9, 3.392925625904984*^9}, 3.4573470986049547`*^9, 
   3.460618553569062*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[Alpha]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "\[Alpha]"}], ",", 
     RowBox[{"1", "+", "\[Alpha]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", "\[Alpha]"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"7", "+", "\[Alpha]"}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "\[Alpha]"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"9", "+", "\[Alpha]"}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "\[Alpha]"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"11", "+", "\[Alpha]"}], ",", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "\[Alpha]"}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.392925501680955*^9, 3.3929255091696177`*^9}, {
   3.392925596836184*^9, 3.3929256264701443`*^9}, 3.442018584733432*^9, 
   3.442142552221183*^9, 3.442146235390911*^9, 3.456167511996201*^9, 
   3.45618133116856*^9, {3.456181840546123*^9, 3.456181865569351*^9}, 
   3.456429238566819*^9, 3.457347099643879*^9, 3.457347908897703*^9, 
   3.4574239009258347`*^9, 3.457427395401219*^9, 3.458632500828349*^9, 
   3.458633029535616*^9, 3.458635088267296*^9, 3.459018241472501*^9, 
   3.459494949243528*^9, 3.459500255677944*^9, 3.460618554484255*^9, 
   3.460975685545719*^9, 3.4612638921363277`*^9, 3.4619246429023247`*^9, 
   3.467192306807551*^9, 3.490793926707891*^9, 3.494243007453472*^9, 
   3.494673892643354*^9, 3.52494218326291*^9, 3.524943618034069*^9, 
   3.533383561613662*^9, 3.534754172683523*^9, 3.543315579303637*^9, 
   3.543317417211706*^9, 3.543317755891068*^9, 3.54333192621881*^9, 
   3.545648231623968*^9, 3.5484018476187696`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaguerreC", "[", 
   RowBox[{"-", "1"}], "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{
  3.392925475273508*^9, {3.392925507630931*^9, 3.392925508541072*^9}, {
   3.3929256242649117`*^9, 3.392925625904984*^9}, 3.4573470986049547`*^9, {
   3.460618553569062*^9, 3.4606186012608757`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Alpha] =\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\" \[Alpha] is a negative integer; Laguerre form \
is not regular;\\n              some second recurrence coefficients are zero.\
\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Alpha] =", -1, 
   " \[Alpha] is a negative integer; Laguerre form is not regular;\n          \
    some second recurrence coefficients are zero."],
  Editable->False]], "Print",
 CellChangeTimes->{3.543315579375121*^9, 3.543317417279985*^9, 
  3.543317755974416*^9, 3.543331926315839*^9, 3.545648231691308*^9, 
  3.548401847650054*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "n"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.392925501680955*^9, 3.3929255091696177`*^9}, {
   3.392925596836184*^9, 3.3929256264701443`*^9}, 3.442018584733432*^9, 
   3.442142552221183*^9, 3.442146235390911*^9, 3.456167511996201*^9, 
   3.45618133116856*^9, {3.456181840546123*^9, 3.456181865569351*^9}, 
   3.456429238566819*^9, 3.457347099643879*^9, 3.457347908897703*^9, 
   3.4574239009258347`*^9, 3.457427395401219*^9, 3.458632500828349*^9, 
   3.458633029535616*^9, 3.458635088267296*^9, 3.459018241472501*^9, 
   3.459494949243528*^9, 3.459500255677944*^9, {3.460618554484255*^9, 
   3.460618602068022*^9}, 3.460975685662633*^9, 3.461263897706066*^9, 
   3.4619246429946003`*^9, 3.467192307401555*^9, 3.490793926779561*^9, 
   3.494243007515862*^9, 3.4946738927183104`*^9, 3.524942183330659*^9, 
   3.524943618085949*^9, 3.5333835616794662`*^9, {3.534754177975829*^9, 
   3.534754185292657*^9}, 3.5433155793782473`*^9, 3.543317417283627*^9, 
   3.5433177559773293`*^9, 3.543331926318519*^9, 3.545648231694434*^9, 
   3.54840184765246*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["LaguerreP[\[Alpha]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nLaguerreP[\[Alpha]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the monic ",
 StyleBox["Laguerre ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "polynomial of parameter ",
 StyleBox["\[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "of degree ",
 StyleBox["n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "in the variable",
 StyleBox[" x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 " [1,4].",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Alpha] \[NotEqual] -n, n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ").\n- If ",
 StyleBox["\[Alpha] = -n, n\[GreaterEqual]0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then",
 StyleBox[" Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["-",
  FontSlant->"Italic"],
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "numeric expression.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "must be an integer.\n- ",
 StyleBox["x ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a numberic expression.\n\nC",
 StyleBox["ommands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n-  ",
 StyleBox["LaguerreC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontSlant->"Italic"],
 StyleBox["MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}],
     FontWeight->"Bold"]}], TraditionalForm]]],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456097951825645*^9, 3.456098239961841*^9}, {
   3.456098309216773*^9, 3.4560983428103247`*^9}, {3.4560983849839067`*^9, 
   3.4560983875073643`*^9}, 3.456098439313355*^9, {3.456099836665434*^9, 
   3.4560998719883966`*^9}, {3.45616715005504*^9, 3.456167164357448*^9}, {
   3.456167948743168*^9, 3.456167969476221*^9}, {3.456177870043385*^9, 
   3.4561778710179777`*^9}, {3.4561796764655333`*^9, 
   3.4561796900520887`*^9}, {3.456429312486883*^9, 3.456429382514854*^9}, {
   3.457348009460874*^9, 3.457348073103057*^9}, {3.457348106198186*^9, 
   3.457348142099761*^9}, {3.4573501107711782`*^9, 3.457350123002945*^9}, {
   3.459207698778654*^9, 3.459207702021985*^9}, {3.4592078406453342`*^9, 
   3.459207850776989*^9}, {3.45920802645296*^9, 3.4592080408909273`*^9}, {
   3.4594936831695843`*^9, 3.459493719696416*^9}, {3.4607029046444902`*^9, 
   3.460703025841447*^9}, {3.461263915480507*^9, 3.461263918735242*^9}, 
   3.464141848527812*^9, {3.467190215047832*^9, 3.4671902212390738`*^9}, 
   3.490790900464788*^9, {3.4907913764879913`*^9, 3.490791378980451*^9}, {
   3.494234909586055*^9, 3.494234910183195*^9}, {3.494242730929047*^9, 
   3.494242734618211*^9}, 3.524942621464322*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "LaguerreP", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LaguerreP", "[", "\[Alpha]_", "]"}], "[", 
      RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"LaguerreP", "[", "\[Alpha]", "]"}], "[", 
       RowBox[{"n", ",", "x"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"MOP", "[", "LaguerreC", "]"}], "[", "\[Alpha]", "]"}], "[", 
       RowBox[{"n", ",", " ", "x"}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.392925563841031*^9, 3.392925576529078*^9}, {
   3.442018287322798*^9, 3.442018340937385*^9}, {3.4420185212085667`*^9, 
   3.442018526565257*^9}, {3.4421423285833063`*^9, 3.442142360155676*^9}, {
   3.4560982600803547`*^9, 3.456098264859057*^9}, {3.456098859994157*^9, 
   3.4560988627916603`*^9}, {3.456098932353162*^9, 3.45609894490342*^9}, {
   3.456167980227027*^9, 3.456167987363227*^9}, 3.457348162898199*^9, {
   3.457348206339057*^9, 3.457348231284315*^9}, {3.457348342380673*^9, 
   3.4573483431604033`*^9}, {3.4607030572954206`*^9, 3.460703094013452*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190225282712*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaguerreP", "[", "\[Alpha]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.460703178318563*^9, 3.46070318326053*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MOP", "[", "LaguerreC", "]"}], "[", "\[Alpha]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 CellChangeTimes->{3.459494949822443*^9, 3.459500256745141*^9, 
  3.4607031858923893`*^9, 3.460703271754188*^9, 3.4609756858909397`*^9, 
  3.461924643210326*^9, 3.467192308270678*^9, 3.490793927020685*^9, 
  3.494243007745996*^9, 3.494673892943231*^9, 3.524942183522176*^9, 
  3.5249436182826233`*^9, 3.533383561840501*^9, 3.534754234632915*^9, 
  3.543315579590045*^9, 3.543317417579804*^9, 3.5433177561868362`*^9, 
  3.543331926513382*^9, 3.5456482319038877`*^9, 3.548401847698976*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"LaguerreP", "[", "\[Alpha]", "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{
  3.392925475533779*^9, {3.392925660271556*^9, 3.392925665282696*^9}, 
   3.457348264098277*^9, {3.4607031916037893`*^9, 3.460703196575037*^9}, {
   3.4671911784058104`*^9, 3.46719117922386*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"0"},
     {"0"},
     {"1"},
     {
      RowBox[{
       RowBox[{"-", "1"}], "+", "x", "-", "\[Alpha]"}]},
     {
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{"3", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "4"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}]}], "-", 
       RowBox[{"4", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.442142460540533*^9, 3.442142538362048*^9, 3.442146258746646*^9, 
   3.456167830414748*^9, 3.4561813315770693`*^9, {3.456181841000005*^9, 
   3.4561818657566566`*^9}, 3.456429474028967*^9, 3.456446806105978*^9, 
   3.456447173981697*^9, {3.456508959600626*^9, 3.4565089685496683`*^9}, 
   3.457348269836331*^9, 3.4573483475638533`*^9, 3.4574239016267843`*^9, 
   3.457427396148436*^9, 3.458632526348812*^9, 3.458633051125935*^9, 
   3.4586351066941023`*^9, 3.4590182428335533`*^9, 3.459494950915102*^9, 
   3.459500259727697*^9, 3.4607031989638863`*^9, 3.460703276802681*^9, 
   3.460975341927726*^9, 3.460975687293858*^9, 3.461924644606758*^9, 
   3.4671923100050097`*^9, 3.490793927216816*^9, 3.494243007941721*^9, 
   3.4946738931391773`*^9, 3.5249421837678137`*^9, 3.5249436185245743`*^9, 
   3.53338356208046*^9, 3.534754236787059*^9, 3.543315579823834*^9, 
   3.543317417826778*^9, 3.543317756434165*^9, 3.543331926760153*^9, 
   3.54564823215086*^9, 3.548401847944447*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X\[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)5",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and \n",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.460703558359393*^9, 3.460703582905768*^9}, {
   3.460709308139473*^9, 3.460709310009841*^9}, {3.460709341217023*^9, 
   3.4607093669130898`*^9}, {3.461263959510046*^9, 3.4612639603397837`*^9}, {
   3.461264072541415*^9, 3.461264073679305*^9}, {3.467190233198913*^9, 
   3.467190237595634*^9}, 3.467190533567293*^9, {3.534754261879835*^9, 
   3.534754262414756*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{"CanonicalC", ",", "LaguerreC"}], "]"}], "[", "]"}], "[", 
      OverscriptBox[
       RowBox[{"\[Alpha]", "\[IndentingNewLine]"}], "~"], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.5347542638887663`*^9, 3.534754264464472*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"1", "+", 
      OverscriptBox["\[Alpha]", "~"]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {
    1 + OverTilde[$CellContext`\[Alpha]], 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]), 
     2 (2 + OverTilde[$CellContext`\[Alpha]]), 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]), 
     3 (2 + OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]), 
     3 (3 + OverTilde[$CellContext`\[Alpha]]), 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     4 (2 + OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     6 (3 + OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     4 (4 + OverTilde[$CellContext`\[Alpha]]), 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]) (5 + 
      OverTilde[$CellContext`\[Alpha]]), 
     5 (2 + OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]) (5 + 
      OverTilde[$CellContext`\[Alpha]]), 
     10 (3 + OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]) (5 + 
      OverTilde[$CellContext`\[Alpha]]), 
     10 (4 + OverTilde[$CellContext`\[Alpha]]) (5 + 
      OverTilde[$CellContext`\[Alpha]]), 
     5 (5 + OverTilde[$CellContext`\[Alpha]]), 1}}]]], "Output",
 CellChangeTimes->{
  3.392926973081232*^9, 3.393266360763041*^9, {3.456168526255616*^9, 
   3.4561685547367573`*^9}, 3.4561687384832973`*^9, {3.456169202878273*^9, 
   3.456169218687344*^9}, 3.456181337331645*^9, {3.4561818426204367`*^9, 
   3.4561818659610786`*^9}, 3.4573493762621117`*^9, {3.457349561085923*^9, 
   3.45734959017962*^9}, 3.457423902375195*^9, 3.4574273969065104`*^9, 
   3.4586325476312304`*^9, 3.458633071634368*^9, 3.458635149367424*^9, 
   3.4590182447998047`*^9, 3.459494953162136*^9, 3.4595002628562403`*^9, 
   3.460703625625293*^9, 3.4609756896914473`*^9, 3.461924646925459*^9, 
   3.467192315627796*^9, 3.490793927714183*^9, 3.494243008437117*^9, 
   3.494673893617219*^9, 3.5249421843981047`*^9, 3.524943619072035*^9, 
   3.5333835626964397`*^9, 3.534754270672348*^9, 3.5433155805145473`*^9, 
   3.543317418450735*^9, 3.543317757083087*^9, 3.543331927431776*^9, 
   3.5456482328429403`*^9, 3.548401848091927*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed recursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command, up to ",
 StyleBox["n=20.",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.456184437961193*^9, 3.4561845022291403`*^9}, {
   3.456184823849684*^9, 3.456184825038542*^9}, {3.456184855520928*^9, 
   3.456184861948104*^9}, {3.456185190476099*^9, 3.456185193970113*^9}, 
   3.457349397471188*^9, 3.4592078813280582`*^9, {3.460703632944169*^9, 
   3.460703657035294*^9}, {3.4671902440556393`*^9, 3.467190247992935*^9}, 
   3.467190529398933*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"verificationRCC", "[", 
       RowBox[{"CanonicalC", ",", "LaguerreC"}], "]"}], "[", "]"}], "[", 
     OverscriptBox[
      RowBox[{"\[Alpha]", "\[IndentingNewLine]"}], "~"], "]"}], "[", "20", 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.457349409694415*^9, 3.457349423527529*^9}, 3.457349545602831*^9, {
   3.460703665295685*^9, 3.460703693285269*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"106.08164200000003`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561813422335443`*^9, {3.456181862350334*^9, 
   3.456181875527793*^9}, 3.457349515845791*^9, 3.4574239911194963`*^9, 
   3.457427486142767*^9, 3.458632643325539*^9, 3.458633159648718*^9, 
   3.458635239152103*^9, 3.459018420198572*^9, 3.4594951349756937`*^9, 
   3.459500447950799*^9, 3.460704539761251*^9, 3.460976092350943*^9, 
   3.4619250497740183`*^9, 3.467193299671495*^9, 3.4907940108710403`*^9, 
   3.494243091746241*^9, 3.494673976846038*^9, 3.524942290314369*^9, 
   3.524943726133409*^9, 3.5333836710511093`*^9, 3.5347543870658207`*^9, 
   3.543315688791018*^9, 3.5433175261370068`*^9, 3.543317863792026*^9, 
   3.5433320345621023`*^9, 3.5456483394299717`*^9, 3.548401954248386*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Binomial", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["n", "TI"], 
      StyleBox[",", "MR"], " ", 
      StyleBox["m", "TI"]}], 
     StyleBox["]", "MR"]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.456180594579808*^9, 3.45618059553015*^9}, {
  3.457349611777651*^9, 3.457349612308737*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "2", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "3", "3", "1", "\<\"\"\>", "\<\"\"\>"},
    {"1", "4", "6", "4", "1", "\<\"\"\>"},
    {"1", "5", "10", "10", "5", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 5, 10,
     10, 5, 1}}]]], "Output",
 CellChangeTimes->{
  3.456180596309375*^9, {3.456181862567135*^9, 3.456181875762442*^9}, 
   3.457349612868793*^9, 3.4574239912263937`*^9, 3.4574274862426977`*^9, 
   3.458635239259832*^9, 3.459018420403212*^9, 3.459495135152157*^9, 
   3.459500448164667*^9, 3.460976092474457*^9, 3.461925049863064*^9, 
   3.467193300439815*^9, 3.490794010986525*^9, 3.494243091811157*^9, 
   3.4946739769007874`*^9, 3.524942290375805*^9, 3.5249437262026863`*^9, 
   3.533383671110886*^9, 3.5347543871320343`*^9, 3.543315688846682*^9, 
   3.543317526217444*^9, 3.543317863888092*^9, 3.543332034631122*^9, 
   3.5456483394625597`*^9, 3.548401954300806*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["CanonicalLaguerreDCC[][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nCanonicalLaguerreDCC[][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  computes the connection coefficient",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["(X \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nnotes the canonical polynomials and ",
 StyleBox["P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials, using the direct closed formula (34) \nof [1] infered from \
the above results produced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the parameter of ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["P", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " , (",
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" \[NotEqual] -n, n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ").\n- If ",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" = -n, n\[GreaterEqual]0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then",
 StyleBox[" Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["-",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " should be a symbol or a",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "numeric expression.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " should be symbols or integers.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.457424640835507*^9, 3.4574246415287323`*^9}, {
   3.4583020173029327`*^9, 3.4583020203183613`*^9}, {3.459493413095625*^9, 
   3.459493431474205*^9}, {3.45949380181355*^9, 3.4594938349417562`*^9}, {
   3.460704009963728*^9, 3.460704128339038*^9}, {3.46070910071244*^9, 
   3.460709102025635*^9}, {3.461264097897924*^9, 3.461264099307501*^9}, 
   3.46414186011729*^9, {3.467190254607497*^9, 3.4671902607671537`*^9}, {
   3.4671905205171747`*^9, 3.467190524695026*^9}, {3.490791536644548*^9, 
   3.490791537122423*^9}, {3.490791799925111*^9, 3.4907918004357862`*^9}, {
   3.4942349219914513`*^9, 3.494234968471719*^9}, {3.4942350236001883`*^9, 
   3.4942350442262497`*^9}, 3.494242749929722*^9, {3.494242804951816*^9, 
   3.49424282258082*^9}, {3.5249426812993727`*^9, 3.524942693337174*^9}, {
   3.534754314577044*^9, 3.534754321848374*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["CanonicalLaguerreDCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["CanonicalLaguerreDCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", "]"}], "[", "\[Alpha]tilde_", "]"}], "[", 
    RowBox[{"n_", ",", "m_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     StyleBox["Binomial", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["n", "TI"], 
      StyleBox[",", "MR"], " ", 
      StyleBox["m", "TI"]}], 
     StyleBox["]", "MR"]}], 
    StyleBox["*", "MR"], 
    RowBox[{
     StyleBox["Product", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      RowBox[{
       StyleBox["(", "MR"], 
       RowBox[{"\[Alpha]tilde", "+", "n", "-", "k"}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.392931961185553*^9, 3.39293212582408*^9}, {
   3.392934496282661*^9, 3.392934498632695*^9}, {3.393266113524909*^9, 
   3.393266116523674*^9}, {3.393266309101226*^9, 3.393266319770774*^9}, {
   3.445044982504593*^9, 3.445044986141055*^9}, 3.456182774112281*^9, {
   3.458302025384445*^9, 3.4583020282005568`*^9}, {3.460704142351891*^9, 
   3.460704159350383*^9}, {3.460704397709084*^9, 3.460704406293235*^9}, {
   3.460704525790222*^9, 3.460704569707205*^9}, {3.460704648136961*^9, 
   3.460704648705023*^9}, {3.460704692012968*^9, 3.4607046924410753`*^9}, {
   3.46070475630392*^9, 3.460704767297771*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.46719026457089*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["CanonicalLaguerreDCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], "[", 
   OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
  RowBox[{"n", ",", "m"}], "]"}]], "Input",
 CellChangeTimes->{
  3.458302032245502*^9, {3.4607041750677233`*^9, 3.460704177513834*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"-", "m"}], "+", "n"}]]}], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "m"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{"n", "+", 
    OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "-", "n", "-", 
     OverscriptBox["\[Alpha]", "~"]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.456182730547176*^9, 3.457423899889545*^9, 3.4574273946312447`*^9, 
   3.45863135986132*^9, 3.4586317516894207`*^9, 3.459018239576717*^9, 
   3.4594949472070417`*^9, 3.459500252830801*^9, 3.460704599424258*^9, 
   3.460976092600778*^9, 3.461925049991152*^9, 3.467193300759562*^9, 
   3.4907940111364937`*^9, 3.4942430919673758`*^9, 3.494673977055605*^9, 
   3.524942290603198*^9, 3.524943726265813*^9, 3.533383671693575*^9, 
   3.543315688911683*^9, 3.5433175262793007`*^9, 3.543317863952557*^9, 
   3.543332034696656*^9, {3.543573559083297*^9, 3.543573570535594*^9}, 
   3.545648339510709*^9, 3.548401954839644*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["CanonicalLaguerreDCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], "[", 
   OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
  RowBox[{"n", ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{
  3.458302032245502*^9, {3.4607041750677233`*^9, 3.460704177513834*^9}, {
   3.543573811292489*^9, 3.5435738116506853`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.543573812677072*^9, 3.545648339529965*^9, 
  3.548401954870419*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["CanonicalLaguerreDCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.392932140063591*^9, 3.392932165358265*^9}, {
   3.3929345075168877`*^9, 3.3929345097989388`*^9}, {3.445045015319386*^9, 
   3.445045017993284*^9}, {3.456180686245266*^9, 3.456180687272883*^9}, 
   3.4583020434946423`*^9, {3.460704180865122*^9, 3.460704183360785*^9}, {
   3.460704262117695*^9, 3.4607042710344543`*^9}, {3.467191355665429*^9, 
   3.467191356978389*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"1", "+", 
      OverscriptBox["\[Alpha]", "~"]}], 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        OverscriptBox["\[Alpha]", "~"]}], ")"}]}], "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {
    1 + OverTilde[$CellContext`\[Alpha]], 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]), 
     2 (2 + OverTilde[$CellContext`\[Alpha]]), 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]), 
     3 (2 + OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]), 
     3 (3 + OverTilde[$CellContext`\[Alpha]]), 
     1}, {(1 + OverTilde[$CellContext`\[Alpha]]) (2 + 
      OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     4 (2 + OverTilde[$CellContext`\[Alpha]]) (3 + 
      OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     6 (3 + OverTilde[$CellContext`\[Alpha]]) (4 + 
      OverTilde[$CellContext`\[Alpha]]), 
     4 (4 + OverTilde[$CellContext`\[Alpha]]), 1}}]]], "Output",
 CellChangeTimes->{{3.39293216828863*^9, 3.3929321768237057`*^9}, {
   3.392934512920949*^9, 3.392934520343773*^9}, 3.392934772887957*^9, 
   3.3932661279399967`*^9, 3.4450450237288218`*^9, {3.45618068834435*^9, 
   3.456180694269896*^9}, 3.456181234408778*^9, {3.456181865068555*^9, 
   3.4561818769148827`*^9}, 3.4574238999341707`*^9, 3.457427394673703*^9, 
   3.458631359955103*^9, 3.458631751791115*^9, 3.4590182396621237`*^9, 
   3.459494947306964*^9, 3.459500252928567*^9, {3.460704603271708*^9, 
   3.460704611254785*^9}, 3.460704697366686*^9, 3.46070477227878*^9, 
   3.4609760926748047`*^9, 3.461925050049111*^9, 3.467193301272479*^9, 
   3.490794011175825*^9, 3.494243092002865*^9, 3.494673977075077*^9, 
   3.5249422906446943`*^9, 3.5249437262921762`*^9, 3.533383671734153*^9, 
   3.543315688947926*^9, 3.543317526321047*^9, 3.543317863993167*^9, 
   3.543332034735622*^9, 3.545648339553466*^9, 3.548401954903326*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command ",
 StyleBox["CanonicalLaguerreDCC[][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Plain"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nup to",
 StyleBox[" n=20, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, {
   3.460704191759879*^9, 3.460704252235585*^9}, {3.467190270586628*^9, 
   3.467190274354574*^9}, 3.467190514902523*^9, {3.5347543876143436`*^9, 
   3.5347543912066917`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"verificationDCC", "[", 
         StyleBox["CanonicalLaguerreDCC",
          FontWeight->"Bold",
          FontSlant->"Italic"], "]"}], "[", 
        RowBox[{"CanonicalC", ",", "LaguerreC"}], "]"}], "[", "]"}], "[", 
      OverscriptBox["\[Alpha]", "~"], "]"}], "[", "20", "]"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, 
   3.458302049606372*^9, {3.460704278846921*^9, 3.460704292336178*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01794799999998986`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561807739243917`*^9, {3.45618091265759*^9, 
   3.456180922611292*^9}, 3.456181249638791*^9, 3.456181346678258*^9, {
   3.456181864826623*^9, 3.456181876695964*^9}, 3.456182891194395*^9, {
   3.456183292995904*^9, 3.456183301609206*^9}, 3.4574238999772577`*^9, 
   3.45742739471556*^9, 3.4586313600534678`*^9, 3.458631751899942*^9, 
   3.459018239764121*^9, 3.459494947408948*^9, 3.459500253042253*^9, 
   3.460704828781357*^9, 3.46097609273427*^9, 3.461925050095602*^9, 
   3.467193301528784*^9, 3.490794011209319*^9, 3.494243092034481*^9, 
   3.4946739770962677`*^9, 3.524942290691352*^9, 3.524943726321315*^9, 
   3.5333836717811623`*^9, 3.534754404144352*^9, 3.543315688995316*^9, 
   3.543317526368349*^9, 3.543317864041918*^9, 3.543332034782928*^9, 
   3.545648339585788*^9, 3.548401954932987*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nDemonstration of the direct closed formula for",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " translated by the command ",
 StyleBox["CanonicalLaguerreDCC[][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Alpha]", "~"],
   FontSlant->"Plain"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Laguerre",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, 3.458302065501041*^9, {3.4607043229504147`*^9, 
   3.46070436123173*^9}, {3.467190278596074*^9, 3.467190282622553*^9}, 
   3.467191487903591*^9, {3.534754397524479*^9, 3.534754398032542*^9}, {
   3.534756456660681*^9, 3.534756457187438*^9}, {3.5347675586243563`*^9, 
   3.534767560388098*^9}, {3.545734137811453*^9, 3.545734166784562*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationDCC", "[", 
       StyleBox["CanonicalLaguerreDCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "]"}], "[", 
      RowBox[{"CanonicalC", ",", "LaguerreC"}], "]"}], "[", "]"}], "[", 
    OverscriptBox["\[Alpha]", "~"], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.456183675404463*^9, 3.456183682545762*^9}, {
   3.4561837380969963`*^9, 3.4561837547918158`*^9}, 3.458302062734384*^9, {
   3.4590188640717697`*^9, 3.459018868647876*^9}, {3.4607043063586283`*^9, 
   3.460704317781745*^9}, 3.481872931955559*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.37234799999998813`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.4561837585295763`*^9, 3.457423900701447*^9, 
  3.457427395230214*^9, 3.458631360873929*^9, 3.459018241062854*^9, 
  3.459018870641445*^9, 3.4594949487409678`*^9, 3.459500255096175*^9, 
  3.460704838420474*^9, 3.4609760930690613`*^9, 3.4619250504178047`*^9, 
  3.4671933026071577`*^9, 3.490794011429707*^9, 3.494243092254418*^9, 
  3.49467397731458*^9, 3.524942294362803*^9, 3.524943268880694*^9, 
  3.5249437265707073`*^9, 3.533383672059292*^9, 3.53475440672407*^9, 
  3.5433155725200233`*^9, 3.543315689273193*^9, 3.54331752662077*^9, 
  3.543317868899432*^9, 3.543332035046378*^9, 3.543332147519024*^9, 
  3.5435736431288633`*^9, 3.5456483399681587`*^9, 3.5484019553102427`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Generalized Hermite (symmetric case) \n",
 FontColor->RGBColor[0, 0, 1]]], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
  3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
  3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
  3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460618134246276*^9, 
  3.460618134409368*^9}, {3.494188744992038*^9, 3.494188746567577*^9}, {
  3.494188793166123*^9, 3.49418880155576*^9}, {3.5336666409444513`*^9, 
  3.533666657573221*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["GenHermiteC[\[Mu]][n]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nGenHermiteC[\[Mu]][n] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-th recurrence coefficients, ",
 StyleBox["{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["},",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of the monic ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials \n(see (35) of [1], and [5]).",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Mu] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Mu] \[NotEqual] -n-",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ").\n- If ",
 StyleBox["\[Mu] = -n -",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", n\[GreaterEqual]0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}]], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["= 0, n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\[GreaterEqual]",
 StyleBox["1.\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or an integer.",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- If n>0, ",
 StyleBox["{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n\[LessEqual]0, ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460709178354385*^9, 3.460709182591982*^9}, {3.461264234670368*^9, 
   3.461264235185815*^9}, 3.4612648325660954`*^9, 3.464141868922496*^9, {
   3.46429134139329*^9, 3.4642913432924337`*^9}, {3.467190288743063*^9, 
   3.4671902949959793`*^9}, 3.4671914825480824`*^9, {3.490791964649231*^9, 
   3.490791988183959*^9}, {3.5249427892610617`*^9, 3.524942789985984*^9}, {
   3.5336657821215067`*^9, 3.5336657829295883`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "GenHermiteC", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GenHermiteC", "[", "\[Mu]_", "]"}], "[", "n_", "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"GenHermiteC", "[", "\[Mu]", "]"}], "[", "n", "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Mu]2", "=", 
         RowBox[{"\[Mu]", "+", 
          RowBox[{"1", "/", "2"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"checking", " ", "the", " ", "arguments"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Mu]2", "]"}], ",", 
            RowBox[{"\[Mu]2", "\[LessEqual]", "0"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<warning concerning the parameter \[Mu] =\>\"", ",", "\[Mu]", 
            ",", " ", "\[IndentingNewLine]", "             ", 
            "\"\<; \[Mu] satisfies \[Mu] === -n-1/2 , n >= 0;\n            \
the generalized Hermite form is not regular;\n\t\t\tthe second recurrence \
coefficient of order 2n+1 is zero.\>\""}], "]"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "  ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"NumericQ", "[", "n", "]"}], ",", 
            RowBox[{"n", "\[LessEqual]", "0"}]}], "]"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", " ", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "+", 
                RowBox[{"\[Mu]", "*", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}]}], ")"}], "/",
               "2"}]}], "}"}], "]"}]}], " ", "]"}]}]}], "\[IndentingNewLine]",
       "]"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"end", " ", "of", " ", "Module"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.4573469400040207`*^9, 3.457346972701222*^9}, 
   3.457347215417047*^9, {3.4573478368440523`*^9, 3.457347891497099*^9}, {
   3.457348797556572*^9, 3.4573487983603687`*^9}, 3.457423836540476*^9, {
   3.458632955217099*^9, 3.458632987716083*^9}, {3.459493652616747*^9, 
   3.459493656104611*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190301449587*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GenHermiteC", "[", "\[Mu]", "]"}], "[", "n", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           RowBox[{"-", "1"}], "+", "n"}]]}], ")"}], " ", "\[Mu]"}]}], 
     ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.421968315648576*^9, {3.42196903236728*^9, 3.421969048729724*^9}, 
   3.422140189592305*^9, 3.422140658124404*^9, 3.4221412705025663`*^9, 
   3.4221429051755667`*^9, 3.457347194051599*^9, 3.457347903073907*^9, 
   3.457423900751925*^9, 3.457427395282283*^9, 3.458632495916952*^9, 
   3.4586330232119513`*^9, 3.458635083761139*^9, 3.4590182412556343`*^9, 
   3.459494949001071*^9, 3.460976093163412*^9, 3.461925050478589*^9, 
   3.467193302895146*^9, 3.490794011486495*^9, 3.4942430922992563`*^9, 
   3.494673977341022*^9, 3.5206178818268967`*^9, 3.520618380729959*^9, 
   3.520621504881122*^9, 3.524942294473103*^9, 3.524943726620611*^9, 
   3.533383672159099*^9, 3.5347545169839773`*^9, 3.543312368761691*^9, 
   3.5433132991294003`*^9, 3.54331604448332*^9, 3.543317526677361*^9, 
   3.543317869007059*^9, 3.543576390352428*^9, 3.543577545940686*^9, 
   3.543648912257468*^9, 3.546948025225648*^9, 3.547205401530842*^9, 
   3.547207252778861*^9, 3.548401955365426*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteC", "[", "\[Mu]", "]"}], "[", "n", "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.3929254754059153`*^9, {3.456167672701239*^9, 3.4561676731344213`*^9}, 
   3.4573470801323023`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.4421425590692053`*^9, 3.442146239120182*^9, 3.4561676737345533`*^9, 
   3.456181330902206*^9, {3.4561818403162117`*^9, 3.456181865398944*^9}, 
   3.456429235027712*^9, 3.457347081201626*^9, 3.457347905305811*^9, 
   3.457423900792633*^9, 3.457427395321807*^9, 3.4586324974119987`*^9, 
   3.45863302586902*^9, 3.458635085306635*^9, 3.459018241327263*^9, 
   3.459494949081052*^9, 3.460976093222967*^9, 3.4619250505151253`*^9, 
   3.467193303120681*^9, 3.490794011526005*^9, 3.494243092335236*^9, 
   3.4946739773588257`*^9, 3.5206178818637733`*^9, 3.520618380766404*^9, 
   3.5206215049168797`*^9, 3.524942294529867*^9, 3.524943726651369*^9, 
   3.533383672196352*^9, 3.534754517065024*^9, 3.543313299196002*^9, 
   3.5433160445187693`*^9, 3.543317526715006*^9, 3.543317869045905*^9, 
   3.543576390400848*^9, 3.543577545979484*^9, 3.54364891229368*^9, 
   3.546948025262477*^9, 3.54720540156575*^9, 3.547207252814601*^9, 
   3.5484019553864613`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteC", "[", "\[Mu]", "]"}], "[", "n", "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellChangeTimes->{
  3.3929254754059153`*^9, {3.456167672701239*^9, 3.456167683321616*^9}, 
   3.457347084940196*^9}],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"n", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "n"}]]}], ")"}], " ", "\[Mu]"}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.4421425590692053`*^9, 3.442146239120182*^9, {3.4561676737345533`*^9, 
   3.45616768403266*^9}, 3.456181331035928*^9, {3.456181840398921*^9, 
   3.456181865483429*^9}, 3.4564292366758842`*^9, 3.4573470860174026`*^9, 
   3.457347906681525*^9, 3.4574239008842*^9, 3.4574273953614073`*^9, 
   3.458632499684396*^9, 3.458633027454648*^9, 3.45863508682543*^9, 
   3.459018241398911*^9, 3.4594949491601543`*^9, 3.4609760932783813`*^9, 
   3.461925050552185*^9, 3.467193303248377*^9, 3.490794011557397*^9, 
   3.4942430923687897`*^9, 3.494673977377041*^9, 3.520617881918735*^9, 
   3.52061838082087*^9, 3.520621504946704*^9, 3.524942294562417*^9, 
   3.5249437266875753`*^9, 3.533383672230254*^9, 3.534754517102602*^9, 
   3.5433132992315702`*^9, 3.543316044552692*^9, 3.543317526744072*^9, 
   3.543317869095305*^9, 3.543576390464303*^9, 3.5435775460128317`*^9, 
   3.543648912379383*^9, 3.5469480253088627`*^9, 3.5472054016227007`*^9, 
   3.547207252851362*^9, 3.548401955421289*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"GenHermiteC", "[", "\[Mu]", "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.392925475273508*^9, {3.392925507630931*^9, 3.392925508541072*^9}, {
   3.3929256242649117`*^9, 3.392925625904984*^9}, 3.4573470986049547`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.392925501680955*^9, 3.3929255091696177`*^9}, {
   3.392925596836184*^9, 3.3929256264701443`*^9}, 3.442018584733432*^9, 
   3.442142552221183*^9, 3.442146235390911*^9, 3.456167511996201*^9, 
   3.45618133116856*^9, {3.456181840546123*^9, 3.456181865569351*^9}, 
   3.456429238566819*^9, 3.457347099643879*^9, 3.457347908897703*^9, 
   3.4574239009258347`*^9, 3.457427395401219*^9, 3.458632500828349*^9, 
   3.458633029535616*^9, 3.458635088267296*^9, 3.459018241472501*^9, 
   3.459494949243528*^9, 3.460976093332057*^9, 3.461925050589978*^9, 
   3.46719330342071*^9, 3.4907940115928993`*^9, 3.49424309240114*^9, 
   3.49467397739548*^9, 3.520617881994916*^9, 3.520618380897402*^9, 
   3.520621504983992*^9, 3.524942294609418*^9, 3.524943726721519*^9, 
   3.5333836722644787`*^9, 3.5347545171524878`*^9, 3.5433132992832747`*^9, 
   3.54331604460392*^9, 3.543317526781336*^9, 3.543317869146822*^9, 
   3.543576390504279*^9, 3.543577546059287*^9, 3.543648912428452*^9, 
   3.546948025345656*^9, 3.547205401699442*^9, 3.547207252898288*^9, 
   3.5484019554496317`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GenHermiteC", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "/", "2"}], "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{
  3.392925475346313*^9, {3.392925522354867*^9, 3.392925525004037*^9}, {
   3.457347139701002*^9, 3.457347146176202*^9}, 3.45734720149341*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Mu] =\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], 
   "\[InvisibleSpace]", "\<\"; \[Mu] satisfies \[Mu] === -n-1/2 , n >= 0;\\n  \
          the generalized Hermite form is not regular;\\n\\t\\t\\tthe second \
recurrence coefficient of order 2n+1 is zero.\"\>"}],
  SequenceForm["warning concerning the parameter \[Mu] =", 
   Rational[-1, 2], 
   "; \[Mu] satisfies \[Mu] === -n-1/2 , n >= 0;\n            the generalized \
Hermite form is not regular;\n\t\t\tthe second recurrence coefficient of \
order 2n+1 is zero."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.457347202209647*^9, 3.4573472243159113`*^9}, 
   3.457347920480847*^9, 3.457348820225416*^9, 3.457423901006304*^9, 
   3.457427395481742*^9, 3.4586325044746313`*^9, 3.458633032988875*^9, 
   3.458635091721685*^9, 3.459018241622715*^9, 3.4594949494175463`*^9, 
   3.460976093501247*^9, 3.461925050665402*^9, 3.467193303883336*^9, 
   3.490794011659795*^9, 3.494243092486684*^9, 3.4946739774329348`*^9, 
   3.52061788208631*^9, 3.520618381134077*^9, 3.520621505069283*^9, 
   3.5249422946984863`*^9, 3.524943726788122*^9, 3.533383672326515*^9, 
   3.534754517253612*^9, 3.5433132993483763`*^9, 3.543316044671547*^9, 
   3.54331752684459*^9, 3.543317869246265*^9, 3.5435763905858593`*^9, 
   3.5435775461603107`*^9, 3.543648912510338*^9, 3.546948025380745*^9, 
   3.547205401735437*^9, 3.547207252948893*^9, 3.548401955483375*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{
           RowBox[{"-", "1"}], "+", "n"}]]}], ")"}]}], "+", "n"}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.392925518674395*^9, 3.3929255255493317`*^9}, 
   3.392925598773353*^9, 3.392925630833559*^9, 3.442142554389305*^9, 
   3.442146237345064*^9, 3.456167516688628*^9, {3.456167558853547*^9, 
   3.456167583229744*^9}, 3.456167645212943*^9, 3.456181331331156*^9, {
   3.4561818406424828`*^9, 3.456181865660926*^9}, 3.456429240364893*^9, 
   3.457347146838854*^9, {3.457347202246369*^9, 3.457347224322027*^9}, 
   3.457347920487443*^9, 3.45734882023217*^9, 3.457423901012752*^9, 
   3.457427395486274*^9, 3.458632504515554*^9, 3.4586330330304337`*^9, 
   3.458635091759836*^9, 3.45901824163094*^9, 3.45949494946581*^9, 
   3.4609760935134706`*^9, 3.461925050673904*^9, 3.4671933039897738`*^9, 
   3.490794011662239*^9, 3.494243092489634*^9, 3.494673977435317*^9, 
   3.520617882090822*^9, 3.520618381138974*^9, 3.520621505073798*^9, 
   3.524942294700783*^9, 3.52494372679088*^9, 3.5333836723302937`*^9, 
   3.534754517259363*^9, 3.5433132993521748`*^9, 3.543316044674818*^9, 
   3.543317526846863*^9, 3.5433178692493258`*^9, 3.543576390593052*^9, 
   3.543577546165782*^9, 3.543648912515888*^9, 3.546948025383346*^9, 
   3.5472054017379723`*^9, 3.547207252952325*^9, 3.548401955485861*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["GenHermiteP[\[Mu]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  \n\n",
 StyleBox["Description:\nGenHermiteP[\[Mu]][n,x]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  is the monic ",
 StyleBox["generalized Hermite ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "polynomial of parameter ",
 StyleBox["\[Mu]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of degree ",
 StyleBox["n \n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "in the variable",
 StyleBox[" x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 " [1,4].",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Mu] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "is a parameter (",
 StyleBox["\[Mu] \[NotEqual] -n-",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ").\n- If ",
 StyleBox["\[Mu] = -n -",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", n\[GreaterEqual]0 ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", then ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "must be an integer.\n- ",
 StyleBox["x ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or a numeric expression.\n\nC",
 StyleBox["ommands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n-  ",
 StyleBox["GenHermiteC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontSlant->"Italic"],
 StyleBox["MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}],
     FontWeight->"Bold"]}], TraditionalForm]]],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456097951825645*^9, 3.456098239961841*^9}, {
   3.456098309216773*^9, 3.4560983428103247`*^9}, {3.4560983849839067`*^9, 
   3.4560983875073643`*^9}, 3.456098439313355*^9, {3.456099836665434*^9, 
   3.4560998719883966`*^9}, {3.45616715005504*^9, 3.456167164357448*^9}, {
   3.456167948743168*^9, 3.456167969476221*^9}, {3.456177870043385*^9, 
   3.4561778710179777`*^9}, {3.4561796764655333`*^9, 
   3.4561796900520887`*^9}, {3.456429312486883*^9, 3.456429382514854*^9}, {
   3.457348009460874*^9, 3.457348073103057*^9}, {3.457348106198186*^9, 
   3.457348142099761*^9}, {3.4573501107711782`*^9, 3.457350123002945*^9}, {
   3.459207698778654*^9, 3.459207702021985*^9}, {3.4592078406453342`*^9, 
   3.459207850776989*^9}, {3.45920802645296*^9, 3.4592080408909273`*^9}, {
   3.4594936831695843`*^9, 3.459493719696416*^9}, {3.461264708276527*^9, 
   3.461264735369519*^9}, 3.4641418789090557`*^9, {3.4671903092313004`*^9, 
   3.467190314669394*^9}, 3.4671905067427053`*^9, 3.4907923163320847`*^9, {
   3.490792451767795*^9, 3.490792454532297*^9}, {3.490797497149479*^9, 
   3.4907974996184187`*^9}, 3.490797541593598*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "GenHermiteP", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"GenHermiteP", "[", "\[Mu]_", "]"}], "[", 
      RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteP", "[", "\[Mu]", "]"}], "[", 
       RowBox[{"n", ",", "x"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"MOP", "[", "GenHermiteC", "]"}], "[", 
        StyleBox["\[Mu]",
         FontWeight->"Bold",
         FontSlant->"Italic"], "]"}], "[", 
       RowBox[{"n", ",", " ", "x"}], "]"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.392925563841031*^9, 3.392925576529078*^9}, {
   3.442018287322798*^9, 3.442018340937385*^9}, {3.4420185212085667`*^9, 
   3.442018526565257*^9}, {3.4421423285833063`*^9, 3.442142360155676*^9}, {
   3.4560982600803547`*^9, 3.456098264859057*^9}, {3.456098859994157*^9, 
   3.4560988627916603`*^9}, {3.456098932353162*^9, 3.45609894490342*^9}, {
   3.456167980227027*^9, 3.456167987363227*^9}, 3.457348162898199*^9, {
   3.457348206339057*^9, 3.457348231284315*^9}, {3.457348342380673*^9, 
   3.4573483431604033`*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190318624034*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GenHermiteP", "[", "\[Mu]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MOP", "[", "GenHermiteC", "]"}], "[", "\[Mu]", "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 CellChangeTimes->{3.459494949822443*^9, 3.4609760937352743`*^9, 
  3.461925050897729*^9, 3.467193305397765*^9, 3.490794011820541*^9, 
  3.494243092628522*^9, 3.494673977515246*^9, 3.520617882300741*^9, 
  3.520618381330223*^9, 3.520621505260907*^9, 3.524942294891431*^9, 
  3.524943726932776*^9, 3.5333836724910097`*^9, 3.534754557780931*^9, 
  3.5433132995131617`*^9, 3.543316044834136*^9, 3.543317527010447*^9, 
  3.5433178694078217`*^9, 3.5435763907813463`*^9, 3.543577546357955*^9, 
  3.5436489127070637`*^9, 3.5469480254421864`*^9, 3.547205401813582*^9, 
  3.5472072530108557`*^9, 3.548401955532618*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"GenHermiteP", "[", "\[Mu]", "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "2"}], ",", "5"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{
  3.392925475533779*^9, {3.392925660271556*^9, 3.392925665282696*^9}, 
   3.457348264098277*^9}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"0"},
     {"0"},
     {"1"},
     {"x"},
     {
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "3"], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}]},
     {
      RowBox[{
       SuperscriptBox["x", "5"], "+", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "-", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          RowBox[{"2", " ", "\[Mu]"}]}], ")"}]}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.442142460540533*^9, 3.442142538362048*^9, 3.442146258746646*^9, 
   3.456167830414748*^9, 3.4561813315770693`*^9, {3.456181841000005*^9, 
   3.4561818657566566`*^9}, 3.456429474028967*^9, 3.456446806105978*^9, 
   3.456447173981697*^9, {3.456508959600626*^9, 3.4565089685496683`*^9}, 
   3.457348269836331*^9, 3.4573483475638533`*^9, 3.4574239016267843`*^9, 
   3.457427396148436*^9, 3.458632526348812*^9, 3.458633051125935*^9, 
   3.4586351066941023`*^9, 3.4590182428335533`*^9, 3.459494950915102*^9, 
   3.460976094206368*^9, 3.4619250513703947`*^9, 3.467193306766019*^9, 
   3.4907940119440107`*^9, 3.494243092751313*^9, 3.494673977637638*^9, 
   3.5206178823344*^9, 3.520618381388896*^9, 3.520621505451704*^9, 
   3.52494229504592*^9, 3.5249437270857363`*^9, 3.533383672643207*^9, 
   3.534754557984165*^9, 3.5433123867722473`*^9, 3.543313299662368*^9, 
   3.543316044987434*^9, 3.543317527163497*^9, 3.543317869561277*^9, 
   3.543576390927434*^9, 3.543577546502673*^9, 3.5436489132170143`*^9, 
   3.546948025594946*^9, 3.547205401965187*^9, 3.547207253163774*^9, 
   3.548401955686339*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)5",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic \n",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.467190327148881*^9, 3.467190331617157*^9}, 
   3.467190499498629*^9, {3.534756483272893*^9, 3.5347564839832363`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{"GenHermiteC", ",", "GenHermiteC"}], "]"}], "[", "\[Mu]", 
       "]"}], "[", 
      OverscriptBox[
       RowBox[{"\[Mu]", "\[IndentingNewLine]"}], "~"], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.467191421445492*^9, 
   3.4671914219598417`*^9}, {3.4907937912005987`*^9, 3.490793792120452*^9}, {
   3.534756486153865*^9, 3.534756486561301*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"-", "\[Mu]"}], "+", 
      OverscriptBox["\[Mu]", "~"]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{
      RowBox[{"-", "\[Mu]"}], "+", 
      OverscriptBox["\[Mu]", "~"]}], "0", "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", "1", "\<\"\"\>"},
    {"0", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {-$CellContext`\[Mu] + OverTilde[$CellContext`\[Mu]], 0, 1}, {
    0, -$CellContext`\[Mu] + OverTilde[$CellContext`\[Mu]], 0, 
     1}, {($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]) (
      1 + $CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 
     0, (-2) ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 0, 1}, {
    0, ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]) (
      1 + $CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 
     0, (-2) ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 0, 
     1}}]]], "Output",
 CellChangeTimes->{
  3.392926973081232*^9, 3.393266360763041*^9, {3.456168526255616*^9, 
   3.4561685547367573`*^9}, 3.4561687384832973`*^9, {3.456169202878273*^9, 
   3.456169218687344*^9}, 3.456181337331645*^9, {3.4561818426204367`*^9, 
   3.4561818659610786`*^9}, 3.4573493762621117`*^9, {3.457349561085923*^9, 
   3.45734959017962*^9}, 3.457423902375195*^9, 3.4574273969065104`*^9, 
   3.4586325476312304`*^9, 3.458633071634368*^9, 3.458635149367424*^9, 
   3.4590182447998047`*^9, 3.459494953162136*^9, 3.460976095129642*^9, 
   3.461925052115561*^9, 3.467193309944631*^9, 3.490794012312427*^9, 
   3.494243093121613*^9, 3.4946739778491488`*^9, 3.520617882730719*^9, 
   3.520618381800724*^9, 3.520621505916861*^9, 3.524942295516757*^9, 
   3.5249437274091673`*^9, 3.533383672966653*^9, 3.5347545706657743`*^9, 
   3.5347564873373632`*^9, 3.5433123985418673`*^9, 3.543313299989335*^9, 
   3.543316045309677*^9, 3.543317527483304*^9, 3.543317869884149*^9, 
   3.543573679592897*^9, 3.543576391305625*^9, 3.543577547009247*^9, 
   3.543648913664998*^9, 3.546948025630384*^9, 3.547205402001163*^9, 
   3.547207253198329*^9, 3.548401955722534*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed recursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command, up to ",
 StyleBox["n=20",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", where",
  FontSlant->"Italic"],
 "  \n",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials.\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.456184437961193*^9, 3.4561845022291403`*^9}, {
   3.456184823849684*^9, 3.456184825038542*^9}, {3.456184855520928*^9, 
   3.456184861948104*^9}, {3.456185190476099*^9, 3.456185193970113*^9}, 
   3.457349397471188*^9, 3.4592078813280582`*^9, {3.467190337756482*^9, 
   3.467190341733416*^9}, {3.467190491862782*^9, 3.467190494479518*^9}, {
   3.53475457517857*^9, 3.534754577824741*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"verificationRCC", "[", 
       RowBox[{"GenHermiteC", ",", "GenHermiteC"}], "]"}], "[", "\[Mu]", 
      "]"}], "[", 
     OverscriptBox[
      RowBox[{"\[Mu]", "\[IndentingNewLine]"}], "~"], "]"}], "[", "20", "]"}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.457349409694415*^9, 3.457349423527529*^9}, 3.457349545602831*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"27.780765000000002`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561813422335443`*^9, {3.456181862350334*^9, 
   3.456181875527793*^9}, 3.457349515845791*^9, 3.4574239911194963`*^9, 
   3.457427486142767*^9, 3.458632643325539*^9, 3.458633159648718*^9, 
   3.458635239152103*^9, 3.459018420198572*^9, 3.4594951349756937`*^9, 
   3.4609761854265413`*^9, 3.4619251425772963`*^9, 3.4671935149272118`*^9, 
   3.490794033921236*^9, 3.494243114723893*^9, 3.494673999545477*^9, 
   3.520617907857275*^9, 3.520618406619525*^9, 3.520621531939577*^9, 
   3.524942323179566*^9, 3.52494375511487*^9, 3.533383701030457*^9, 
   3.5347546172262907`*^9, 3.543312429015691*^9, 3.543313326061577*^9, 
   3.543316073158038*^9, 3.5433175551576147`*^9, 3.543317897559102*^9, 
   3.543573708535537*^9, 3.543576417325181*^9, 3.54357757365279*^9, 
   3.543648939800778*^9, 3.546948053407301*^9, 3.547205429599059*^9, 
   3.547207281378994*^9, 3.5484019835425787`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     StyleBox["Binomial", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["n", "TI"], 
      StyleBox[",", "MR"], " ", 
      StyleBox["m", "TI"]}], 
     StyleBox["]", "MR"]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", " ", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.456180594579808*^9, 3.45618059553015*^9}, {
  3.457349611777651*^9, 3.457349612308737*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "2", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", "3", "3", "1", "\<\"\"\>", "\<\"\"\>"},
    {"1", "4", "6", "4", "1", "\<\"\"\>"},
    {"1", "5", "10", "10", "5", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {1, 1}, {1, 2, 1}, {1, 3, 3, 1}, {1, 4, 6, 4, 1}, {1, 5, 10,
     10, 5, 1}}]]], "Output",
 CellChangeTimes->{
  3.456180596309375*^9, {3.456181862567135*^9, 3.456181875762442*^9}, 
   3.457349612868793*^9, 3.4574239912263937`*^9, 3.4574274862426977`*^9, 
   3.458635239259832*^9, 3.459018420403212*^9, 3.459495135152157*^9, 
   3.460976185550213*^9, 3.461925142671324*^9, 3.467193515509273*^9, 
   3.49079403403703*^9, 3.494243114828559*^9, 3.494673999606028*^9, 
   3.520617907954118*^9, 3.520618406683812*^9, 3.5206215320000763`*^9, 
   3.5249423233271627`*^9, 3.524943755233473*^9, 3.533383701164517*^9, 
   3.5347546172938433`*^9, 3.543313326200697*^9, 3.543316073225769*^9, 
   3.543317555215795*^9, 3.5433178976436377`*^9, 3.543576417385281*^9, 
   3.543577573748952*^9, 3.543648939952428*^9, 3.546948053547846*^9, 
   3.547205429705887*^9, 3.54720728155088*^9, 3.548401983642272*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:\nGenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "  \n\n",
 StyleBox["Description:\nGenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " computes the connection coefficients",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Mu], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox[
   StyleBox["\[Mu]",
    FontWeight->"Bold",
    FontSlant->"Italic"], "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\nnotes the monic ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials, using the direct closed formulas (36) e (37) of [1] infered \n\
from the above results produced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.\n\nWe recall that ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "-", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = 0 = ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 "  and there are different formulas for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "and",
 StyleBox[" \n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 " ,",
 StyleBox[" 0 \[LessEqual] m\[LessEqual] n , n \[GreaterEqual] 0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\[Mu]",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData[
  RowBox[{"P", " ", 
   StyleBox["and",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   FormBox[
    StyleBox[
     OverscriptBox["P", "~"],
     FontWeight->"Bold",
     FontSlant->"Italic"],
    TraditionalForm]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "=",
 StyleBox["P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox[
   StyleBox["\[Mu]",
    FontWeight->"Bold",
    FontSlant->"Italic"], "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -)",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " must be non negative integers.",
 StyleBox["\n\nResults:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206946840454*^9, 
   3.4592069867739677`*^9}, {3.4592070186188793`*^9, 3.4592070225564947`*^9}, 
   3.459207066181903*^9, {3.459207175953779*^9, 3.459207178208144*^9}, 
   3.459207511340993*^9, 3.459207896954505*^9, {3.459208073948215*^9, 
   3.459208074593696*^9}, {3.459493858664311*^9, 3.459493883999608*^9}, {
   3.459493915482909*^9, 3.459493962462356*^9}, {3.460709204660591*^9, 
   3.460709211081884*^9}, {3.461264866337172*^9, 3.461264868927164*^9}, 
   3.464141889698021*^9, {3.4671903476553707`*^9, 3.467190354461656*^9}, {
   3.467190478137621*^9, 3.4671904856087418`*^9}, {3.490792541722363*^9, 
   3.490792551262157*^9}, {3.4907929183794003`*^9, 3.49079292131316*^9}, {
   3.490797740541388*^9, 3.490797741514509*^9}, {3.494242870635502*^9, 
   3.494242871481161*^9}, {3.5249428791507*^9, 3.5249428823404007`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "GenHermiteDCC", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "n", " ", "and", " ", "m", " ", "must", " ", "be", " ", "fixed", " ", 
     "integers"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]_", "]"}], "[", "\[Mu]tilde_", 
       "]"}], "[", 
      RowBox[{
       RowBox[{"n_", "/;", 
        RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
       RowBox[{"m_", "/;", 
        RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", "\[Mu]tilde", 
        "]"}], "[", 
       RowBox[{"n", ",", "m"}], "]"}], "=", "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n1", ",", "m1"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", " ", 
          RowBox[{
           RowBox[{"Or", "[", " ", 
            RowBox[{
             RowBox[{"And", "[", 
              RowBox[{
               RowBox[{"EvenQ", "[", "n", "]"}], ",", 
               RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
             RowBox[{"And", "[", 
              RowBox[{
               RowBox[{"OddQ", "[", "n", "]"}], ",", 
               RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", " ", 
             RowBox[{"n", "<", "0"}], ",", " ", 
             RowBox[{"m", "<", "0"}], ",", " ", 
             RowBox[{"m", ">", "n"}]}], "]"}], ",", "  ", 
           RowBox[{"Return", "[", "0", "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", "\t", 
         RowBox[{"n1", "=", 
          RowBox[{"Quotient", "[", 
           RowBox[{"n", ",", "2"}], "]"}]}], ";", 
         RowBox[{"m1", "=", 
          RowBox[{"Quotient", "[", 
           RowBox[{"m", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", "  ", 
         RowBox[{"Return", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n1", "-", "m1"}], ")"}]}], "*", 
           RowBox[{"Binomial", "[", 
            RowBox[{"n1", ",", "m1"}], "]"}], "*", 
           RowBox[{"Product", "[", 
            RowBox[{
             RowBox[{"\[Mu]", "-", "\[Mu]tilde", "+", "i"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "0", ",", 
               RowBox[{"n1", "-", "m1", "-", "1"}]}], "}"}]}], "]"}]}], " ", 
          "]"}]}]}], "\[IndentingNewLine]", "]"}]}]}], ";"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.392931961185553*^9, 3.39293212582408*^9}, {
   3.392934496282661*^9, 3.392934498632695*^9}, {3.393266113524909*^9, 
   3.393266116523674*^9}, {3.393266309101226*^9, 3.393266319770774*^9}, {
   3.4004406596125097`*^9, 3.4004406700889463`*^9}, {3.4004407557359457`*^9, 
   3.4004407560011806`*^9}, 3.400440792087864*^9, {3.400456100393937*^9, 
   3.400456104294364*^9}, {3.4004561652606297`*^9, 3.400456169964426*^9}, {
   3.400456448664279*^9, 3.400456458755129*^9}, {3.4004564906324177`*^9, 
   3.4004564969536133`*^9}, {3.400456536304648*^9, 3.400456539337021*^9}, 
   3.4004567225927258`*^9, {3.421968159740698*^9, 3.421968193098731*^9}, {
   3.421968329333078*^9, 3.421968338697172*^9}, {3.4219685837282743`*^9, 
   3.421968605755486*^9}, {3.421970335481703*^9, 3.4219703604123077`*^9}, {
   3.421970403474091*^9, 3.421970496322236*^9}, {3.4219705896686974`*^9, 
   3.421970591220683*^9}, {3.421970630287154*^9, 3.4219706486523333`*^9}, {
   3.422141114478394*^9, 3.4221411388466578`*^9}, {3.422142000122465*^9, 
   3.422142004191039*^9}, {3.4221420383139553`*^9, 3.4221420518849287`*^9}, {
   3.457351421114421*^9, 3.457351422359048*^9}, {3.457425354714671*^9, 
   3.457425385194763*^9}, {3.457425429083395*^9, 3.4574254304217863`*^9}, {
   3.4583018635070677`*^9, 3.458301869723392*^9}, {3.459494003079454*^9, 
   3.4594940069386883`*^9}, {3.520618016300538*^9, 3.520618044800475*^9}, {
   3.5206182589850063`*^9, 3.520618265382646*^9}}],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190360521275*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
       OverscriptBox["\[Mu]", "~"], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", "TableForm", 
   "  "}]}]], "Input",
 CellChangeTimes->{{3.392932140063591*^9, 3.392932165358265*^9}, {
   3.3929345075168877`*^9, 3.3929345097989388`*^9}, 3.4004406789967737`*^9, 
   3.400456109399992*^9, {3.400456172235004*^9, 3.400456179286459*^9}, {
   3.422139398383716*^9, 3.422139403865944*^9}, {3.422141148751598*^9, 
   3.422141149536129*^9}, {3.422142060822968*^9, 3.422142086209729*^9}, {
   3.457351241494213*^9, 3.457351260834395*^9}, 3.458301884796269*^9, {
   3.458632782211887*^9, 3.4586327827699137`*^9}, {3.467191447611013*^9, 
   3.467191448359947*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"-", "\[Mu]"}], "+", 
      OverscriptBox["\[Mu]", "~"]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{
      RowBox[{"-", "\[Mu]"}], "+", 
      OverscriptBox["\[Mu]", "~"]}], "0", "1", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", "1", "\<\"\"\>"},
    {"0", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Mu]", "-", 
        OverscriptBox["\[Mu]", "~"]}], ")"}]}], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {-$CellContext`\[Mu] + OverTilde[$CellContext`\[Mu]], 0, 1}, {
    0, -$CellContext`\[Mu] + OverTilde[$CellContext`\[Mu]], 0, 
     1}, {($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]) (
      1 + $CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 
     0, (-2) ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 0, 1}, {
    0, ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]) (
      1 + $CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 
     0, (-2) ($CellContext`\[Mu] - OverTilde[$CellContext`\[Mu]]), 0, 
     1}}]]], "Output",
 CellChangeTimes->{{3.42214208200329*^9, 3.422142086756894*^9}, 
   3.422142944242831*^9, {3.457351236476617*^9, 3.457351261621443*^9}, 
   3.4573515576839523`*^9, 3.457423991286924*^9, 3.4574274862974663`*^9, {
   3.458632778478055*^9, 3.4586327833937283`*^9}, 3.458635239441538*^9, 
   3.459018420587809*^9, 3.459495135319706*^9, 3.46097618564118*^9, 
   3.4619251427507544`*^9, 3.467193515764598*^9, 3.490794034104989*^9, 
   3.494243114883251*^9, 3.494673999672803*^9, 3.5206179080231047`*^9, 
   3.520618406750889*^9, 3.520621532064937*^9, 3.524942323399192*^9, 
   3.5249437553145037`*^9, 3.5333837012362013`*^9, 3.5347553492423887`*^9, 
   3.543312441085205*^9, 3.543313326268032*^9, 3.5433160732930803`*^9, 
   3.5433175553005877`*^9, 3.543317897713551*^9, 3.543576417453339*^9, 
   3.543577573833498*^9, 3.543648940540257*^9, 3.546948053632017*^9, 
   3.5472054297716084`*^9, 3.547207281600236*^9, 3.5484019836896887`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command ",
 StyleBox["GenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \nup to",
 StyleBox[" n=20",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, {
   3.4573512923141203`*^9, 3.457351294586133*^9}, 3.458301889828017*^9, {
   3.467190365867782*^9, 3.467190370075944*^9}, 3.467191463420364*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Timing", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"verificationDCC", "[", "GenHermiteDCC", "]"}], "[", 
        RowBox[{"GenHermiteC", ",", "GenHermiteC"}], "]"}], "[", "\[Mu]", 
       "]"}], "[", 
      OverscriptBox[
       RowBox[{"\[Mu]", "\[IndentingNewLine]"}], "~"], "]"}], "[", "20", 
     "]"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, {
   3.45735132923214*^9, 3.45735135764904*^9}, 3.458301895875862*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.017120000000005575`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561807739243917`*^9, {3.45618091265759*^9, 
   3.456180922611292*^9}, 3.456181249638791*^9, 3.456181346678258*^9, {
   3.456181864826623*^9, 3.456181876695964*^9}, 3.456182891194395*^9, {
   3.456183292995904*^9, 3.456183301609206*^9}, 3.4573513592086763`*^9, 
   3.457423991335066*^9, 3.45742748634019*^9, 3.458632789128151*^9, 
   3.458635239563595*^9, 3.4590184209709463`*^9, 3.459495135475795*^9, 
   3.460976185704438*^9, 3.461925142802656*^9, 3.467193515909493*^9, 
   3.490794034141618*^9, 3.494243114918717*^9, 3.494673999708777*^9, 
   3.5206179080537567`*^9, 3.5206184067862463`*^9, 3.520621532100021*^9, 
   3.524942323434937*^9, 3.524943755348263*^9, 3.5333837012657213`*^9, 
   3.534755351941383*^9, 3.5433124446527653`*^9, 3.543313326301305*^9, 
   3.543316073345376*^9, 3.543317555332498*^9, 3.5433178977501583`*^9, 
   3.543573708947102*^9, 3.54357641749131*^9, 3.543577573884349*^9, 
   3.543648940566826*^9, 3.546948053686831*^9, 3.547205429808326*^9, 
   3.5472072816580553`*^9, 3.5484019837286386`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:\nGenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nGenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " translates the definitions (36) and (37) of [1] of the connection \
coefficients \n",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the monic ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials, for ",
 StyleBox["n",
  FontWeight->"Bold"],
 " and \n",
 StyleBox["m",
  FontWeight->"Bold"],
 " ",
 StyleBox["symbolic",
  FontWeight->"Bold"],
 ", in order to be used in calling statements of the ",
 StyleBox["demonstrationSymCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command.\n\nWe recall that ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "-", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" = 0 = ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 "  and there are different formulas for ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{"2", "n"}], ",", 
    RowBox[{"2", "m"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "and",
 StyleBox[" \n ",
  FontWeight->"Bold"],
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold"],
 " ,",
 StyleBox[" 0 \[LessEqual] m\[LessEqual] n , n \[GreaterEqual] 0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\[Mu]",
  FontWeight->"Bold"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData[
  RowBox[{"P", " ", 
   StyleBox["and",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   StyleBox[" ",
    FontWeight->"Plain",
    FontSlant->"Plain"], 
   FormBox[
    StyleBox[
     OverscriptBox["P", "~"],
     FontWeight->"Bold",
     FontSlant->"Italic"],
    TraditionalForm]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be ",
 StyleBox["symbols",
  FontWeight->"Bold"],
 ".",
 StyleBox["\n\nResults:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206934894661*^9, 
   3.459206935313037*^9}, {3.459207075845229*^9, 3.459207080901113*^9}, {
   3.4592072425801*^9, 3.459207445351715*^9}, 3.4592079216793823`*^9, {
   3.459208083864663*^9, 3.4592080848420362`*^9}, {3.4594940809507113`*^9, 
   3.459494093356348*^9}, {3.459494147042548*^9, 3.459494163725823*^9}, {
   3.46070922863503*^9, 3.460709234659382*^9}, {3.461264927963533*^9, 
   3.461264930287938*^9}, 3.46414189761309*^9, {3.467190375251593*^9, 
   3.467190384412608*^9}, {3.467190444412822*^9, 3.467190465917828*^9}, {
   3.490793108422368*^9, 3.490793126794648*^9}, {3.494242918657694*^9, 
   3.494242935431642*^9}, {3.494567185910108*^9, 3.4945671873633633`*^9}, {
   3.524942913131063*^9, 3.5249429159306393`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "n", " ", "and", " ", "m", " ", "should", " ", "be", " ", "symbols", " ", 
    "in", " ", "the", " ", "calling", " ", "statements"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]_", "]"}], "[", "\[Mu]tilde_", 
       "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n_"}], ",", "0"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Mu]", "-", "\[Mu]tilde", "+", "i"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]_", "]"}], "[", "\[Mu]tilde_", 
       "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n_"}], ",", 
       RowBox[{"2", "*", "m_"}]}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "m"}], ")"}]}], "*", 
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "m"}], "]"}], "*", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Mu]", "-", "\[Mu]tilde", "+", "i"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", 
          RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]_", "]"}], "[", "\[Mu]tilde_", 
       "]"}], "[", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "n_"}]}], ",", "1"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", "\[Mu]tilde", "]"}],
       "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", "0"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]_", "]"}], "[", "\[Mu]tilde_", 
       "]"}], "[", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "n_"}]}], ",", 
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "m_"}]}]}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", "\[Mu]tilde", "]"}],
       "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", 
       RowBox[{"2", "*", "m"}]}], "]"}]}], ";"}], "  ", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.457351463245995*^9, 3.4573514644508123`*^9}, {
   3.4574220152451057`*^9, 3.457422019703105*^9}, {3.457424982050632*^9, 
   3.4574250128903227`*^9}, {3.457425399940194*^9, 3.457425448970298*^9}, {
   3.458301903507666*^9, 3.4583019378516197`*^9}, {3.458633589377842*^9, 
   3.458633612768424*^9}, {3.4586337832035933`*^9, 3.458633810847975*^9}, {
   3.4586339832985764`*^9, 3.458634027638897*^9}, {3.458634066077437*^9, 
   3.458634087358349*^9}, {3.458634122687481*^9, 3.458634123299552*^9}, {
   3.4586342459954987`*^9, 3.458634246888205*^9}, {3.458634277786927*^9, 
   3.458634316140353*^9}, {3.458634565004809*^9, 3.458634573362322*^9}, {
   3.4586346351270313`*^9, 3.458634647175984*^9}, {3.4586352268199463`*^9, 
   3.458635238139607*^9}, {3.459017600898671*^9, 3.459017662520349*^9}, {
   3.459018594336074*^9, 3.459018688954773*^9}, {3.4590190316571608`*^9, 
   3.459019037895445*^9}, {3.459019351511736*^9, 3.459019377763008*^9}, {
   3.459019517641927*^9, 3.4590195560296173`*^9}, {3.459019621434972*^9, 
   3.459019622424024*^9}, {3.459019748734826*^9, 3.459019753227181*^9}, {
   3.459019787770114*^9, 3.459019791047526*^9}, 3.459019918136407*^9, {
   3.459020472621813*^9, 3.459020551031349*^9}, {3.459020619226182*^9, 
   3.459020672770493*^9}, {3.459022314326209*^9, 3.459022314933679*^9}, {
   3.459207202317782*^9, 3.45920720476257*^9}, {3.459207469909122*^9, 
   3.459207478879684*^9}, {3.4818763275703297`*^9, 3.481876337043709*^9}, {
   3.520615108768552*^9, 3.5206151165493097`*^9}, {3.520615768083313*^9, 
   3.520615776850347*^9}, {3.520616039685111*^9, 3.52061604260699*^9}, {
   3.520617286908259*^9, 3.520617302018393*^9}, {3.5206175370082483`*^9, 
   3.520617540349978*^9}, {3.5206180937599688`*^9, 3.5206180962374687`*^9}, {
   3.520618339401472*^9, 3.520618343591167*^9}, {3.520621424404729*^9, 
   3.520621428610758*^9}, {3.5433124541667557`*^9, 3.543312522407103*^9}, {
   3.5435740314228783`*^9, 3.543574107580864*^9}, {3.543574316760013*^9, 
   3.543574335339183*^9}, {3.543649460608436*^9, 3.543649607153514*^9}, {
   3.543650470658873*^9, 3.543650520165083*^9}, 3.545645648005205*^9}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n"
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206934894661*^9, 
   3.459206935313037*^9}, {3.459207075845229*^9, 3.459207080901113*^9}, {
   3.459207139502565*^9, 3.459207146258102*^9}, 3.467190390021891*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "m"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"-", "m"}], "+", "n"}]], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "m"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Mu]", "-", 
    OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Mu]", "-", 
     OverscriptBox["\[Mu]", "~"]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.543574139354521*^9, 3.543576417601676*^9, 3.543577574001767*^9, 
   3.543648940667794*^9, 3.5436496699800587`*^9, {3.5456458274288816`*^9, 
   3.545645836269606*^9}, 3.546948053985138*^9, 3.547205430017541*^9, 
   3.547207281716743*^9, 3.5484019837705593`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{3.5436496755810843`*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "n"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Mu]", "-", 
    OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Mu]", "-", 
     OverscriptBox["\[Mu]", "~"]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBuKolH3PLh556SjB/vQriLZ5Yd94CUiX8Ka0geiq2W4X
QfStyOfXeo++dJx6XOkXiH7ZdyC0D0gvFubLAtH3Cuz6QPSMtOhbIHpd3auH
IDpFft1HEP1O5PvssmMvHa8xWR73PPnS0erabSXJ0y8dj7E0T1W9+tKxoNXN
TZPplWNEVHzqXo5Xjsf3/DjZz/nKMfBbyzZu61eOAZtufwHRCx62VfMCaaaM
Ajtv51eOE13zPoJop8WrmFKDXzluunb8BFPYK8eCl5HCoWmvHDmMzpaC6L55
umfDgPSCzTlt4UB62g/LjSD6hUjr7CtAWmXGyfUg+lqKyZurQHrZkoM114C0
SOm00J9A+u2uno0guuzT1cQTWa8cT505YOWS+8px7euDzw4CaRUri3OHgPSG
Fz/VuQpeOQIA2x6+Ng==
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "n"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543649700459835*^9, 3.54364970081768*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.543574139354521*^9, 3.543576417601676*^9, 
  3.543577574001767*^9, 3.543648940667794*^9, 3.5436496699800587`*^9, 
  3.543649701364964*^9, 3.545645840854072*^9, 3.5469480540662518`*^9, 
  3.547205430092691*^9, 3.547207281807869*^9, 3.548401983837727*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4004565062101173`*^9, 3.400456526756568*^9}, {
   3.4219683831885557`*^9, 3.4219683836873817`*^9}, {3.4219685265151052`*^9, 
   3.4219685352814283`*^9}, {3.4219688407215567`*^9, 3.421968847473454*^9}, {
   3.422141229674203*^9, 3.422141230125195*^9}, {3.422142298114787*^9, 
   3.4221423301208363`*^9}, 3.458301977484851*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"-", "m"}], "+", "n"}]], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "m"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[Mu]", "-", 
    OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Mu]", "-", 
     OverscriptBox["\[Mu]", "~"]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->{{3.422142310607132*^9, 3.422142330936892*^9}, 
   3.4574239917894583`*^9, 3.457425114611507*^9, 3.457427486781425*^9, 
   3.4586328516663103`*^9, 3.458633189721225*^9, 3.458634730068296*^9, 
   3.458635321104061*^9, 3.4586353977278757`*^9, 3.459018423346548*^9, 
   3.459018706543545*^9, 3.459019442125452*^9, 3.4590196025853786`*^9, 
   3.459019891485942*^9, 3.459020500068747*^9, 3.459020561545006*^9, 
   3.459020687142277*^9, 3.459495135806177*^9, 3.460976185831455*^9, 
   3.461925142909758*^9, 3.467193516190776*^9, 3.4907940342410507`*^9, 
   3.4942431150201263`*^9, 3.4946739997947683`*^9, 3.520617908187696*^9, 
   3.520618406906567*^9, 3.520621532253335*^9, 3.524942323553605*^9, 
   3.5249437557786007`*^9, 3.5333837013714037`*^9, 3.534755398311511*^9, 
   3.5433125412439327`*^9, 3.543313326454186*^9, 3.5433160734792624`*^9, 
   3.543317555435307*^9, 3.543317897851631*^9, 3.543573737652945*^9, 
   3.543576417738514*^9, 3.543577574150434*^9, 3.5436489407853327`*^9, 
   3.5436496878221483`*^9, 3.545645842889979*^9, 3.546948054118299*^9, 
   3.547205430125328*^9, 3.547207281857676*^9, 3.548401983870748*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.4004565062101173`*^9, 3.400456526756568*^9}, {
   3.4219683831885557`*^9, 3.4219683836873817`*^9}, {3.4219685265151052`*^9, 
   3.4219685352814283`*^9}, {3.4219688407215567`*^9, 3.421968847473454*^9}, {
   3.422141229674203*^9, 3.422141230125195*^9}, {3.422142298114787*^9, 
   3.4221423301208363`*^9}, 3.458301977484851*^9, {3.543573744721388*^9, 
   3.5435737451357203`*^9}, 3.543649708889448*^9}],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "n"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Mu]", "-", 
    OverscriptBox["\[Mu]", "~"]}], ")"}], " ", 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Mu]", "-", 
     OverscriptBox["\[Mu]", "~"]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}]}], "]"}]}]], "Output",
 CellChangeTimes->{{3.422142310607132*^9, 3.422142330936892*^9}, 
   3.4574239917894583`*^9, 3.457425114611507*^9, 3.457427486781425*^9, 
   3.4586328516663103`*^9, 3.458633189721225*^9, 3.458634730068296*^9, 
   3.458635321104061*^9, 3.4586353977278757`*^9, 3.459018423346548*^9, 
   3.459018706543545*^9, 3.459019442125452*^9, 3.4590196025853786`*^9, 
   3.459019891485942*^9, 3.459020500068747*^9, 3.459020561545006*^9, 
   3.459020687142277*^9, 3.459495135806177*^9, 3.460976185831455*^9, 
   3.461925142909758*^9, 3.467193516190776*^9, 3.4907940342410507`*^9, 
   3.4942431150201263`*^9, 3.4946739997947683`*^9, 3.520617908187696*^9, 
   3.520618406906567*^9, 3.520621532253335*^9, 3.524942323553605*^9, 
   3.5249437557786007`*^9, 3.5333837013714037`*^9, 3.534755398311511*^9, 
   3.5433125412439327`*^9, 3.543313326454186*^9, 3.5433160734792624`*^9, 
   3.543317555435307*^9, 3.543317897851631*^9, {3.543573737652945*^9, 
   3.543573745859316*^9}, 3.5435764177884293`*^9, 3.543577574201189*^9, 
   3.543648941690662*^9, 3.543649709990032*^9, 3.545645845410231*^9, 
   3.546948054167717*^9, 3.547205430159504*^9, 3.5472072818906307`*^9, 
   3.54840198389218*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GenHermiteDCC", "[", "\[Mu]", "]"}], "[", 
   OverscriptBox["\[Mu]", "~"], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.543649723762411*^9, 3.5436497241124973`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.543649724733334*^9, 3.545645847542121*^9, 
  3.546948054217032*^9, 3.5472054301921988`*^9, 3.547207281940983*^9, 
  3.5484019839228077`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nDemonstration of the direct closed formulas (36) and (37)  for\n",
 Cell[BoxData[
  RowBox[{"  ", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Lambda]", 
      RowBox[{
       RowBox[{"2", "n"}], ",", 
       RowBox[{"2", "m"}]}]], 
     StyleBox["  ",
      FontWeight->"Bold"], "and", 
     StyleBox["  ",
      FontWeight->"Bold"], 
     SubscriptBox["\[Lambda]", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "n"}], "+", "1"}], ",", 
       RowBox[{
        RowBox[{"2", "m"}], "+", "1"}]}]]}], " ", ",", 
    StyleBox[
     RowBox[{"0", " ", "\[LessEqual]", " ", "m", "\[LessEqual]", " ", "n"}],
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[",",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[
     RowBox[{"n", " ", "\[GreaterEqual]", " ", "0"}],
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[",",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontWeight->"Bold",
     FontSlant->"Italic"], 
    SubscriptBox["\[Lambda]", 
     RowBox[{"n", ",", "m"}]], " "}]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  OverscriptBox["\[Alpha]", "~"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nwhere ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the monic ",
 StyleBox["generalized Hermite",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " polynomials, translated by the command  ",
 StyleBox["GenHermiteDCC[\[Mu]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  StyleBox[
   OverscriptBox["\[Mu]", "~"],
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
    3.3929346698865128`*^9},
  FontWeight->"Bold"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, {3.457351508577216*^9, 3.457351538077633*^9}, 
   3.457423674423217*^9, {3.457425152875874*^9, 3.457425278358103*^9}, {
   3.4612649649532347`*^9, 3.461264988795329*^9}, {3.467190396484603*^9, 
   3.467190433280266*^9}, 3.519673701129505*^9, {3.5249429907750607`*^9, 
   3.524942994212934*^9}, {3.5347564991301517`*^9, 3.534756508892427*^9}, {
   3.534767578720397*^9, 3.534767580106791*^9}, {3.5456458738285313`*^9, 
   3.545645883927971*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationSymDCC", "[", "GenHermiteDCC", "]"}], "[", 
      RowBox[{"GenHermiteC", ",", " ", "GenHermiteC"}], "]"}], "[", "\[Mu]", 
     "]"}], "[", 
    OverscriptBox["\[Mu]", "~"], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4219689682529163`*^9, 3.421969026997492*^9}, 
   3.4573515919389563`*^9, 3.458301984477057*^9, {3.4590210893451366`*^9, 
   3.459021095824616*^9}, 3.481873084937743*^9, 3.4818731152814083`*^9, {
   3.5433136898737097`*^9, 3.54331369202487*^9}, {3.545646045777421*^9, 
   3.545646048672518*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9123799999999846`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4219690681587677`*^9, 3.42196946705931*^9, 3.42197029629172*^9, 
   3.421970758437779*^9, 3.422140197685143*^9, 3.4221412931574287`*^9, 
   3.4221417047348833`*^9, 3.422142349161212*^9, 3.422142979078932*^9, 
   3.457423992642181*^9, 3.457427490533082*^9, 3.458632865729512*^9, 
   3.458633200087824*^9, 3.458635549426002*^9, 3.4590184328730593`*^9, 
   3.4590187192864017`*^9, 3.4590194952376747`*^9, 3.459019613224717*^9, 
   3.4590199029261913`*^9, 3.459020509059804*^9, 3.459020704766768*^9, 
   3.459021096804945*^9, 3.459495137791923*^9, 3.460976186794701*^9, 
   3.461925143833646*^9, 3.46719351853379*^9, 3.490794034865858*^9, 
   3.494243115644041*^9, 3.49467400041648*^9, 3.520617909089293*^9, 
   3.520618407792671*^9, 3.520621533138646*^9, 3.5249423244783993`*^9, 
   3.524943284722941*^9, {3.524943476930759*^9, 3.524943505512203*^9}, 
   3.524943756708761*^9, 3.5333837023003063`*^9, 3.534755415063651*^9, 
   3.5347554562074203`*^9, 3.5347557118403597`*^9, 3.534755905169405*^9, 
   3.543312550216366*^9, 3.543312805030683*^9, 3.543312876268147*^9, 
   3.543313259129401*^9, 3.543313329142091*^9, 3.543313641923985*^9, 
   3.543313692537184*^9, 3.543314490165729*^9, 3.543314637646399*^9, 
   3.543314854700356*^9, 3.543314941528809*^9, 3.543315041607237*^9, 
   3.543316074335759*^9, 3.543317556316512*^9, 3.543317898763809*^9, 
   3.543574369227747*^9, 3.5435764279954157`*^9, 3.543577588746419*^9, 
   3.543648956826169*^9, 3.54364926058965*^9, 3.543649736245039*^9, 
   3.543649959747168*^9, {3.543650004727002*^9, 3.543650008671794*^9}, {
   3.543650147620666*^9, 3.543650150762827*^9}, 3.543650534138357*^9, 
   3.545646050336965*^9, 3.545646120172182*^9, 3.545646166190104*^9, 
   3.5456471139652987`*^9, 3.546948055530673*^9, 3.546948342989835*^9, 
   3.5472054311752577`*^9, 3.547207282908094*^9, 3.5484019852166*^9}]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Symmetric semi-classical polynomials of class 1
\
\>", "Section",
 CellChangeTimes->{{3.455999505296259*^9, 3.455999521281426*^9}, {
   3.479035643828837*^9, 3.479035660823258*^9}, {3.5123288126263638`*^9, 
   3.512328824142625*^9}, {3.512406762817041*^9, 3.512406765901464*^9}, 
   3.51240690698989*^9, {3.5124072102025127`*^9, 3.512407210777067*^9}, {
   3.512408127475237*^9, 3.512408137568891*^9}, {3.518028212168378*^9, 
   3.5180282186371613`*^9}, {3.518028271137792*^9, 3.518028274937405*^9}, {
   3.518033442735268*^9, 3.518033459396215*^9}, {3.5193203871016607`*^9, 
   3.519320387508142*^9}, {3.51946925766288*^9, 3.519469261621482*^9}, {
   3.519493894746057*^9, 3.5194939480850563`*^9}, 3.519500104886158*^9, {
   3.533665605847321*^9, 3.533665608366396*^9}, 3.533666117890956*^9}],

Cell[TextData[{
 StyleBox["References :",
  FontWeight->"Bold"],
 "\n \n ",
 StyleBox["[5]", "Code",
  FontWeight->"Plain"],
 " T. S. Chihara, An Introduction to Orthogonal Polynomials, Gordon and \
Breach, New York, 1978. (page 156)\n \n [6]  J. Alaya, P. Maroni, Symmetric \
Laguerre-Hahn forms of class s=1,\n Integral Transform and Special Functions, \
(1996) 4(4)301-320.  (page 317)\n  "
}], "Text",
 CellChangeTimes->{{3.519499628330615*^9, 3.519499636066749*^9}, {
   3.519499811508768*^9, 3.519499881305213*^9}, {3.5195001243517036`*^9, 
   3.519500128520115*^9}, {3.519925817439189*^9, 3.519925824046853*^9}, {
   3.520444630383071*^9, 3.520444775162516*^9}, {3.520450566747612*^9, 
   3.520450597941475*^9}, {3.533665543468439*^9, 3.5336655862150908`*^9}, {
   3.533665817856848*^9, 3.533665838103812*^9}, 3.533665937074032*^9, {
   3.53366668772674*^9, 3.533666692994643*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Main Commands",
  FontColor->GrayLevel[0]],
 StyleBox["\n",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
  3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
  3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
  3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460529160209412*^9, 
  3.460529160850732*^9}, {3.460538651644092*^9, 3.460538676771216*^9}, {
  3.479035782738468*^9, 3.479035797646721*^9}, {3.512329140345154*^9, 
  3.512329145004119*^9}, {3.512329766737885*^9, 3.512329784644944*^9}, {
  3.512406427220812*^9, 3.512406427412525*^9}, {3.512406853011129*^9, 
  3.512406856031934*^9}, {3.512407308843287*^9, 3.51240731162477*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3C ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3C[\[Alpha], \[Beta]][n] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-th recurrence coefficients, ",
 StyleBox["{",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["},",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " of ",
 StyleBox["Alaya ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " monic \nsemi-classical orthogonal polynomials of class 1 ",
 StyleBox["(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "case 3",
 StyleBox[") [5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "; it is a symmetric case.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta]  ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are parameters.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or an integer.\n\n",
 StyleBox["Regularity conditions: ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n ",
 StyleBox["\[Alpha] \[NotEqual] -(n+1), \[Beta] \[NotEqual] -(n+1), \[Alpha]+\
\[Beta] \[NotEqual] -(n+1), n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["otherwise",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- If n>0, ",
 StyleBox["{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n<=0, ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, 
   3.512383072827989*^9, 3.5124054292405577`*^9, {3.5124057075252523`*^9, 
   3.512405724324067*^9}, {3.51240580876766*^9, 3.5124058118938427`*^9}, {
   3.512406010971093*^9, 3.512406026226222*^9}, {3.512406430036735*^9, 
   3.512406430276598*^9}, {3.518028248166874*^9, 3.5180284771411657`*^9}, {
   3.518028520311255*^9, 3.518028655177333*^9}, {3.518028690816325*^9, 
   3.518028763026177*^9}, {3.51802960827759*^9, 3.518029611323441*^9}, {
   3.518033466416016*^9, 3.518033467763632*^9}, {3.5180345594949093`*^9, 
   3.518034567175651*^9}, 3.518034613901154*^9, {3.5180347253310204`*^9, 
   3.5180348336781693`*^9}, {3.51941093393808*^9, 3.519410996350327*^9}, {
   3.5194110338983803`*^9, 3.51941109816108*^9}, 3.5194111459175377`*^9, {
   3.519411375633428*^9, 3.519411403621278*^9}, {3.519412012793817*^9, 
   3.519412020036879*^9}, {3.519412337688258*^9, 3.519412354504672*^9}, {
   3.5194692724836082`*^9, 3.519469282468873*^9}, {3.519471224845841*^9, 
   3.51947127028883*^9}, {3.519471304874926*^9, 3.519471341243886*^9}, {
   3.519493043136072*^9, 3.5194931974380417`*^9}, {3.5194938071265287`*^9, 
   3.519493811525936*^9}, {3.519494813314101*^9, 3.519494813809854*^9}, {
   3.519499621285934*^9, 3.5194996238027067`*^9}, {3.5194999112328377`*^9, 
   3.519499930823393*^9}, {3.519500266943988*^9, 3.519500282576137*^9}, 
   3.519757187737225*^9, {3.520357774231031*^9, 3.520357784955801*^9}, {
   3.520357820121519*^9, 3.520357834577694*^9}, {3.520357866739808*^9, 
   3.5203578764217978`*^9}, {3.520357913906961*^9, 3.5203580240189743`*^9}, {
   3.520443577819564*^9, 3.5204436147828197`*^9}, {3.5204445736266823`*^9, 
   3.520444585967473*^9}, {3.52045060955618*^9, 3.520450609747978*^9}, {
   3.520452975966151*^9, 3.52045299371719*^9}, {3.520453072394391*^9, 
   3.5204530728006287`*^9}, {3.533665853846816*^9, 3.533665854477635*^9}, {
   3.534755951756206*^9, 3.534755990943759*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["SC1AlayaMaroni3C",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3C",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{"n_", "/;", 
      RowBox[{"IntegerQ", "[", "n", "]"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3C",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "n", "]"}], "=", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "n2", "}"}], ",", "\n", "  ", "\n", "  ", 
       RowBox[{"(*", 
        RowBox[{
        "___", "___", "___", "___", "___", "_", " ", "checking", " ", "the", 
         " ", "arguments", " ", "___", "___", "___", "___", "___", "_"}], 
        "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Alpha]", "]"}], ",", 
            RowBox[{"\[Alpha]", " ", "<=", " ", 
             RowBox[{"-", "1"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<warning concerning the parameter \[Alpha]=\>\"", ",", 
            "\[Alpha]", ",", "\[IndentingNewLine]", 
            "\"\<; \[Alpha] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular\>\""}], 
           " ", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "\[Beta]", "]"}], ",", 
            RowBox[{"\[Beta]", " ", "<=", " ", 
             RowBox[{"-", "1"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<warning concerning the parameter \[Beta]=\>\"", ",", 
            "\[Beta]", ",", "\[IndentingNewLine]", 
            "\"\<; \[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular\>\""}], 
           " ", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"IntegerQ", "[", 
             RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"\[Alpha]", "+", "\[Beta]"}], "<=", " ", 
             RowBox[{"-", "1"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{
           "\"\<warning concerning the parameters \[Alpha]=\>\"", ",", 
            "\[Alpha]", ",", "\"\< and \[Beta]=\>\"", ",", "\[Beta]", ",", 
            "\[IndentingNewLine]", 
            "\"\<; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome \
recurrence coefficients are zero or undefined;\n\t\tpolynomials are not \
regular\>\""}], " ", "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\n", "  ", 
        RowBox[{"(*", 
         RowBox[{
         "___", "___", "___", "___", "___", "___", "___", "___", "___", "___",
           "___", "___", "___", "___", "___", "___", "___", "___", "___"}], 
         "*)"}], "\n", "  ", "\n", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"n", "\[LessEqual]", " ", "0"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], " ", "]"}], ";", "\n", 
        "            ", "\n", " ", 
        RowBox[{"n2", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"EvenQ", "[", "n", "]"}], ",", "\[IndentingNewLine]", 
          "     ", "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"n2", "*", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Alpha]", "+", "n2"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n", "+", "1"}], 
                ")"}]}]}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"Return", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"\[Beta]", "+", "n2", "+", "1"}], ")"}], "*", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n2", "+", "1"}], 
                 ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n"}], ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n", "+", "1"}], 
                ")"}]}]}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
         "\[IndentingNewLine]", "    ", "]"}]}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", "If"}], " ", "*)"}], "\n", "    ", "\n",
       "    ", "]"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"end", " ", "of", " ", "Module"}], " ", "*)"}], 
  "   "}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.400452759660624*^9, 3.400452760193726*^9}, {
   3.460618217925473*^9, 3.460618279112927*^9}, {3.460618406882461*^9, 
   3.4606184492486887`*^9}, 3.460618513254024*^9, {3.461263833101872*^9, 
   3.461263849135838*^9}, {3.512329830392654*^9, 3.512329836593623*^9}, {
   3.512329903129181*^9, 3.5123299068879128`*^9}, {3.512329947374423*^9, 
   3.512329997447112*^9}, {3.512330028301688*^9, 3.5123301129978037`*^9}, {
   3.512330152725288*^9, 3.512330276924534*^9}, {3.512330317820643*^9, 
   3.512330444909276*^9}, {3.512330495363944*^9, 3.512330638112714*^9}, {
   3.512330702494276*^9, 3.512330852602721*^9}, {3.512330939725462*^9, 
   3.512331082596624*^9}, {3.512331301779955*^9, 3.512331333243409*^9}, {
   3.512331540606143*^9, 3.512331607014184*^9}, {3.5123316488378477`*^9, 
   3.5123316505573587`*^9}, {3.512331693002837*^9, 3.5123317354794827`*^9}, 
   3.512331785956175*^9, {3.51238015782869*^9, 3.5123801612996387`*^9}, {
   3.512380192018229*^9, 3.512380192928463*^9}, {3.512380333422009*^9, 
   3.5123803413258543`*^9}, {3.51238052769803*^9, 3.512380540439457*^9}, {
   3.5123806028671837`*^9, 3.5123806340331783`*^9}, {3.512382405467901*^9, 
   3.512382406873871*^9}, {3.512382717382518*^9, 3.512382752820456*^9}, {
   3.51238279526624*^9, 3.512382836694922*^9}, {3.512388000087888*^9, 
   3.5123880187935658`*^9}, {3.512388316674268*^9, 3.512388326903895*^9}, {
   3.512388523125185*^9, 3.512388552079053*^9}, 3.512393696962242*^9, {
   3.512393746260998*^9, 3.512393749452236*^9}, {3.5123966167802467`*^9, 
   3.5123966518797493`*^9}, {3.51239690900182*^9, 3.5123969414835*^9}, {
   3.5123970568698072`*^9, 3.512397082869409*^9}, {3.512397524429351*^9, 
   3.512397588029807*^9}, {3.51240437367793*^9, 3.512404386426743*^9}, {
   3.512404657817034*^9, 3.512404783149716*^9}, {3.51240485627293*^9, 
   3.512404893566217*^9}, {3.512404942378972*^9, 3.512405053460487*^9}, {
   3.512405407348139*^9, 3.512405409893429*^9}, {3.512405495156528*^9, 
   3.512405498452251*^9}, 3.512405607463504*^9, {3.512406032651773*^9, 
   3.51240604108302*^9}, 3.512406105157406*^9, {3.518028774969323*^9, 
   3.51802880981861*^9}, {3.518029614498234*^9, 3.518029616106409*^9}, {
   3.518029712805765*^9, 3.518029831967381*^9}, {3.518029881700182*^9, 
   3.518029884339715*^9}, {3.518030373473522*^9, 3.5180304989584093`*^9}, {
   3.518030589972753*^9, 3.518030597291349*^9}, 3.518030634219652*^9, {
   3.518031640752247*^9, 3.518031708071742*^9}, {3.5180318051156063`*^9, 
   3.518031809564804*^9}, {3.518032342234042*^9, 3.5180323429785423`*^9}, {
   3.518033609763501*^9, 3.518033623339281*^9}, {3.518033657310204*^9, 
   3.51803369685161*^9}, {3.518033730769665*^9, 3.518033736887821*^9}, {
   3.518033814156055*^9, 3.518033866895206*^9}, {3.5180339472284946`*^9, 
   3.518033995350499*^9}, {3.518034027925219*^9, 3.51803411461226*^9}, {
   3.5180342357697477`*^9, 3.5180343807144003`*^9}, {3.518110439032362*^9, 
   3.518110571302125*^9}, {3.518110618317313*^9, 3.51811067213057*^9}, {
   3.518110873751232*^9, 3.5181109999817944`*^9}, {3.5181111536810493`*^9, 
   3.518111160150035*^9}, {3.518111194020623*^9, 3.518111202587914*^9}, {
   3.518111260265943*^9, 3.518111272432006*^9}, 3.518111335017764*^9, {
   3.518111409428422*^9, 3.518111412345791*^9}, {3.519469313613496*^9, 
   3.519469455951632*^9}, {3.519469562523449*^9, 3.51946973480604*^9}, {
   3.5194697692248287`*^9, 3.519469857068819*^9}, {3.5194698927896852`*^9, 
   3.5194699903673677`*^9}, {3.5194700224445477`*^9, 3.519470049448662*^9}, {
   3.519470096816676*^9, 3.5194701273641787`*^9}, {3.5194704097233152`*^9, 
   3.5194705729708233`*^9}, {3.5194706055298653`*^9, 3.519470690382963*^9}, {
   3.519470728151087*^9, 3.519470730390251*^9}, {3.519470886059144*^9, 
   3.519470895430389*^9}, {3.519471502792811*^9, 3.519471507551765*^9}, {
   3.5194930152232313`*^9, 3.5194930189246187`*^9}, {3.519493219829631*^9, 
   3.5194933556642447`*^9}, {3.519493393263516*^9, 3.5194934905839443`*^9}, {
   3.519493672949585*^9, 3.519493694176408*^9}, {3.519493796475787*^9, 
   3.519493800113587*^9}, {3.519500286877294*^9, 3.5195003061047983`*^9}, {
   3.520358211087923*^9, 3.52035835516182*^9}, {3.520358459503824*^9, 
   3.520358606114048*^9}, {3.5203586874041023`*^9, 3.5203588463738003`*^9}, {
   3.520358926342474*^9, 3.52035895260843*^9}, {3.5204435779094563`*^9, 
   3.52044357792616*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3C",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3C[\[Alpha], \[Beta]][2n] and \
SC1AlayaMaroni3C[\[Alpha], \[Beta]][2n+1] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the recurrence coefficients of \n",
 StyleBox["Alaya ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " monic semi-classical orthogonal polynomials of class 1 ",
 StyleBox["(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "case 3",
 StyleBox[") [5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", for ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " symbolic, \nin order to be used in calling statements of the ",
 StyleBox["demonstrationSymCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are parameters.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol.\n\n",
 StyleBox["Regularity conditions: ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n ",
 StyleBox["\[Alpha] \[NotEqual] -(n+1), \[Beta] \[NotEqual] -(n+1), \[Alpha]+\
\[Beta] \[NotEqual] -(n+1), n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["otherwise",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- If n>0, ",
 StyleBox["{0, ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "n"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ". If n<=0, ",
 StyleBox["{0,0}",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, 
   3.512383072827989*^9, 3.5124054292405577`*^9, {3.5124057075252523`*^9, 
   3.512405724324067*^9}, {3.51240580876766*^9, 3.5124058118938427`*^9}, {
   3.512406010971093*^9, 3.512406026226222*^9}, {3.512406430036735*^9, 
   3.512406430276598*^9}, {3.518028248166874*^9, 3.5180284771411657`*^9}, {
   3.518028520311255*^9, 3.518028655177333*^9}, {3.518028690816325*^9, 
   3.518028763026177*^9}, {3.51802960827759*^9, 3.518029611323441*^9}, {
   3.518033466416016*^9, 3.518033467763632*^9}, {3.5180345594949093`*^9, 
   3.518034567175651*^9}, 3.518034613901154*^9, {3.5180347253310204`*^9, 
   3.5180348336781693`*^9}, {3.51941093393808*^9, 3.519410996350327*^9}, {
   3.5194110338983803`*^9, 3.51941109816108*^9}, 3.5194111459175377`*^9, {
   3.519411375633428*^9, 3.519411403621278*^9}, {3.519412012793817*^9, 
   3.519412020036879*^9}, {3.519412337688258*^9, 3.519412354504672*^9}, {
   3.5194692724836082`*^9, 3.519469282468873*^9}, {3.519471224845841*^9, 
   3.51947127028883*^9}, {3.519471304874926*^9, 3.519471341243886*^9}, {
   3.519493043136072*^9, 3.5194931974380417`*^9}, {3.5194938071265287`*^9, 
   3.519493811525936*^9}, {3.519494813314101*^9, 3.519494813809854*^9}, {
   3.519499621285934*^9, 3.5194996238027067`*^9}, {3.5194999112328377`*^9, 
   3.519499930823393*^9}, {3.5195799767652483`*^9, 3.51957997763912*^9}, {
   3.519671200626539*^9, 3.519671261733027*^9}, {3.519671367672003*^9, 
   3.5196715564440403`*^9}, 3.5196716830147943`*^9, 3.5196717248450108`*^9, {
   3.519756033117592*^9, 3.51975604776402*^9}, {3.519757151378313*^9, 
   3.519757151459446*^9}, 3.519757186832198*^9, {3.5197572324005337`*^9, 
   3.519757235711545*^9}, 3.519844829875798*^9, {3.520452760576705*^9, 
   3.520452768509879*^9}, {3.520452808669755*^9, 3.520452952056452*^9}, {
   3.533502254697835*^9, 3.533502287595128*^9}, {3.53350233572978*^9, 
   3.533502367129636*^9}, {3.534756012987925*^9, 3.534756022009831*^9}, {
   3.534756699178858*^9, 3.5347566995481567`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3C",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{"2", "*", "n_"}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3C",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
      RowBox[{"2", "*", "n"}], "]"}], "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"n", "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Alpha]", "+", "n"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"\[Alpha]", "+", "\[Beta]", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", 
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}]}]}], "}"}]}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["SC1AlayaMaroni3C",
      FontWeight->"Bold",
      FontSlant->"Italic"], "[", 
     RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n_"}], "+", "1"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3C",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], "=", "\[IndentingNewLine]", 
    
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Beta]", "+", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "n", "+", "1"}], ")"}], 
         "/", 
         RowBox[{"(", 
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", 
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", 
          RowBox[{"2", "*", "n"}], "+", "2"}], ")"}]}]}]}], "}"}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.520452390242795*^9, 3.520452578145555*^9}, {
  3.520452686979124*^9, 3.5204527294372387`*^9}, {3.5205276837553787`*^9, 
  3.5205277598376503`*^9}, {3.520528026297312*^9, 3.5205280312458687`*^9}, {
  3.520622462783502*^9, 3.520622465883739*^9}, {3.533505034311541*^9, 
  3.533505060129847*^9}, {3.5335057207361307`*^9, 3.533505726775403*^9}, {
  3.5335058649099207`*^9, 3.5335058696399384`*^9}, {3.533666719081924*^9, 
  3.533666720103216*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3P[\[Alpha], \[Beta]][n,x] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " is the ",
 StyleBox["Alaya ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " monic semi-classical orthogonal polynomials of",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "class 1",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "(case 3",
 StyleBox[") [5,6] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "of parameters ",
 StyleBox["\[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "of degree ",
 StyleBox["n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "in the variable",
 StyleBox[" x",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SubscriptBox["P", "n"], "(", "x", ")"}],
    FontWeight->"Bold"], TraditionalForm]]],
 " ; it is a symmetric case.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta]  ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are parameters.",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "should be a symbol or an integer.\n\n",
 StyleBox["Regularity conditions: ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n ",
 StyleBox["\[Alpha] \[NotEqual] -(n+1), \[Beta] \[NotEqual] -(n+1), \[Alpha]+\
\[Beta] \[NotEqual] -(n+1), n\[GreaterEqual]0",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["otherwise",
  FontSlant->"Italic"],
 " polynomials are not regular",
 StyleBox[".\n\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "C",
 StyleBox["ommands ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["used:",
  FontWeight->"Bold"],
 "\n-  ",
 StyleBox["SC1AlayaMaroni3C, MOP",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    StyleBox[
     RowBox[{
      SubscriptBox["P", "n"], "(", "x", ")"}],
     FontWeight->"Bold"]}], TraditionalForm]]],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, {
   3.512382910905802*^9, 3.512382999848115*^9}, {3.512383037158457*^9, 
   3.51238305416506*^9}, {3.5124057360673513`*^9, 3.512405742617305*^9}, {
   3.512405773934054*^9, 3.5124057874953403`*^9}, {3.512406167798156*^9, 
   3.512406172734015*^9}, {3.5124064135822077`*^9, 3.512406416173212*^9}, {
   3.518031866146902*^9, 3.518031930450021*^9}, {3.518034689204961*^9, 
   3.518034689793747*^9}, 3.5180348616098146`*^9, {3.518111608449099*^9, 
   3.518111658581373*^9}, {3.519411129093198*^9, 3.519411157824736*^9}, {
   3.5194123784408283`*^9, 3.519412390958762*^9}, {3.519471198544615*^9, 
   3.519471216295969*^9}, {3.519471281432864*^9, 3.51947129066286*^9}, {
   3.5194713637040243`*^9, 3.519471428842478*^9}, {3.519471517152508*^9, 
   3.519471526599386*^9}, {3.519493187154765*^9, 3.519493190943685*^9}, {
   3.519493825229088*^9, 3.51949383068463*^9}, {3.5194947220983887`*^9, 
   3.519494771296136*^9}, {3.51949996898886*^9, 3.519500010211877*^9}, {
   3.5195003173715076`*^9, 3.519500331202306*^9}, 3.5197571878197947`*^9, {
   3.5203580607707148`*^9, 3.520358136985097*^9}, {3.52044357795494*^9, 
   3.520443578127253*^9}, {3.520443626343751*^9, 3.520443643683112*^9}, {
   3.520444501086575*^9, 3.520444565794725*^9}, {3.520450615884384*^9, 
   3.520450616148191*^9}, 3.5204530559044523`*^9, {3.520453087273767*^9, 
   3.520453087694532*^9}, {3.534756713734313*^9, 3.534756731205892*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     StyleBox[
      RowBox[{"SC1AlayaMaroni3", 
       StyleBox["P",
        FontWeight->"Bold",
        FontSlant->"Italic"]}]], 
     StyleBox[" ",
      FontWeight->"Bold",
      FontSlant->"Italic"], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3P",
       FontWeight->"Bold",
       FontSlant->"Italic"], 
      StyleBox[" ",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]_", ",", "\[Beta]_"}], "]"}], "[", 
     RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3P",
        FontWeight->"Bold",
        FontSlant->"Italic"], 
       StyleBox[" ",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", "x"}], "]"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"MOP", "[", 
        StyleBox["SC1AlayaMaroni3C",
         FontWeight->"Bold",
         FontSlant->"Italic"], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", " ", "x"}], "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.392925563841031*^9, 3.392925576529078*^9}, {
   3.442018287322798*^9, 3.442018340937385*^9}, {3.4420185212085667`*^9, 
   3.442018526565257*^9}, {3.4421423285833063`*^9, 3.442142360155676*^9}, {
   3.4560982600803547`*^9, 3.456098264859057*^9}, {3.456098859994157*^9, 
   3.4560988627916603`*^9}, {3.456098932353162*^9, 3.45609894490342*^9}, {
   3.456167980227027*^9, 3.456167987363227*^9}, 3.457348162898199*^9, {
   3.457348206339057*^9, 3.457348231284315*^9}, {3.457348342380673*^9, 
   3.4573483431604033`*^9}, {3.4607030572954206`*^9, 3.460703094013452*^9}, {
   3.512383096788443*^9, 3.512383100228566*^9}, {3.512383132403769*^9, 
   3.512383182277072*^9}, {3.512383289924508*^9, 3.512383290364051*^9}, {
   3.512388257759872*^9, 3.512388304218706*^9}, {3.512406178236154*^9, 
   3.5124061834277163`*^9}, 3.5124062147998466`*^9, {3.5180319600985117`*^9, 
   3.51803197392093*^9}, {3.518032017942237*^9, 3.518032037668724*^9}, {
   3.518111702882885*^9, 3.5181117179619083`*^9}, {3.519471448590616*^9, 
   3.519471481101309*^9}, {3.519471529348703*^9, 3.519471561577835*^9}, {
   3.519493833280472*^9, 3.519493840063748*^9}, {3.519757158032181*^9, 
   3.519757158232161*^9}, {3.520358161625599*^9, 3.520358189036924*^9}, {
   3.520359066572886*^9, 3.520359090496866*^9}, {3.520443578214575*^9, 
   3.520443578414909*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nTests of commands ",
 StyleBox["SC1AlayaMaroni3C",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox["SC1AlayaMaroni3P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " ",
 StyleBox[".\n\
______________________________________________________________________________\
__________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n"
}], "Text",
 CellChangeTimes->{{3.512407390472975*^9, 3.512407390585507*^9}, {
  3.512407531390275*^9, 3.5124075833745413`*^9}, {3.512407670195381*^9, 
  3.5124076935866528`*^9}, {3.518031985268104*^9, 3.518031990625399*^9}, {
  3.518032073991189*^9, 3.518032083221938*^9}, {3.518111731723503*^9, 
  3.518111735059309*^9}, {3.519493851031744*^9, 3.5194938585629883`*^9}, {
  3.519757158314314*^9, 3.51975715838953*^9}, {3.52035907987414*^9, 
  3.520359106629224*^9}, {3.520443578486244*^9, 3.5204435785692387`*^9}, {
  3.520443650713674*^9, 3.520443655822144*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["SC1AlayaMaroni3C",
    FontWeight->"Bold",
    FontSlant->"Italic"], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "n", "]"}]], "Input",
 CellChangeTimes->{{3.512396804922729*^9, 3.5123968052573557`*^9}, {
   3.512396883788857*^9, 3.5123968847709227`*^9}, {3.5123982573437138`*^9, 
   3.512398258301588*^9}, 3.512406114756483*^9, {3.5180321004138403`*^9, 
   3.5180321041634083`*^9}, 3.518111751131372*^9, {3.519471549278028*^9, 
   3.519471577072242*^9}, {3.519493872315482*^9, 3.5194938730751133`*^9}, 
   3.519757158482366*^9, {3.520359131773469*^9, 3.520359136137841*^9}, 
   3.520443578652426*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SC1AlayaMaroni3C", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "n", "]"}]], "Output",
 CellChangeTimes->{
  3.512396114865425*^9, {3.512396636535695*^9, 3.512396661323588*^9}, {
   3.512396798678048*^9, 3.512396805932974*^9}, 3.5123968854607973`*^9, {
   3.512398253299527*^9, 3.512398259003626*^9}, 3.512405541456853*^9, 
   3.5124061330980167`*^9, 3.518032105096051*^9, 3.518111752139269*^9, 
   3.5194715806129*^9, 3.519493873599869*^9, 3.519499555772703*^9, 
   3.51975132294767*^9, 3.520359142301881*^9, 3.520445562597014*^9, 
   3.520528086866043*^9, 3.520529986218395*^9, 3.520530639104064*^9, 
   3.520618840970381*^9, 3.520619743849737*^9, 3.5206216487401333`*^9, 
   3.521353808133664*^9, 3.524397041641446*^9, 3.524397077802251*^9, {
   3.533504770673826*^9, 3.53350477813102*^9}, 3.533505887298211*^9, 
   3.534756766200835*^9, 3.5433160828646507`*^9, 3.543319248024006*^9, 
   3.5435745622892027`*^9, 3.5435765369615183`*^9, 3.543577138241385*^9, 
   3.5436490113514013`*^9, 3.543650365647772*^9, 3.545639700108614*^9, 
   3.5472814076765947`*^9, 3.547283541460555*^9, 3.548401985291622*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["SC1AlayaMaroni3C",
      FontWeight->"Bold",
      FontSlant->"Italic"], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.392925475273508*^9, {3.392925507630931*^9, 3.392925508541072*^9}, {
   3.3929256242649117`*^9, 3.392925625904984*^9}, 3.4573470986049547`*^9, 
   3.460618553569062*^9, {3.512331131405799*^9, 3.512331143723043*^9}, 
   3.512388466990534*^9, 3.512406152194867*^9, 3.518032378548854*^9, 
   3.518112052569334*^9, {3.519471881157172*^9, 3.519471894076879*^9}, 
   3.519757159014406*^9, 3.5203592641725597`*^9, 3.520443579082986*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"1", "+", "\[Beta]"}], 
      RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"1", "+", "\[Alpha]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.392925501680955*^9, 3.3929255091696177`*^9}, {
   3.392925596836184*^9, 3.3929256264701443`*^9}, 3.442018584733432*^9, 
   3.442142552221183*^9, 3.442146235390911*^9, 3.456167511996201*^9, 
   3.45618133116856*^9, {3.456181840546123*^9, 3.456181865569351*^9}, 
   3.456429238566819*^9, 3.457347099643879*^9, 3.457347908897703*^9, 
   3.4574239009258347`*^9, 3.457427395401219*^9, 3.458632500828349*^9, 
   3.458633029535616*^9, 3.458635088267296*^9, 3.459018241472501*^9, 
   3.459494949243528*^9, 3.459500255677944*^9, 3.460618554484255*^9, 
   3.460975685545719*^9, 3.4612638921363277`*^9, 3.4619246429023247`*^9, 
   3.467192306807551*^9, 3.511274323134666*^9, 3.511275391745474*^9, 
   3.511282624174595*^9, {3.512331139486175*^9, 3.512331144406111*^9}, 
   3.512382874383667*^9, {3.512388467782818*^9, 3.51238848624886*^9}, 
   3.512388574799945*^9, 3.512398289692898*^9, 3.512405635297114*^9, 
   3.5124061526801023`*^9, 3.5124065023339252`*^9, 3.5180323812945127`*^9, 
   3.5181120533595448`*^9, {3.519471882562977*^9, 3.519471895079749*^9}, 
   3.519499555929481*^9, 3.5197513231428337`*^9, 3.5203592662276087`*^9, 
   3.520445562791491*^9, 3.5205280870768433`*^9, 3.5205299864518147`*^9, 
   3.520530639346081*^9, 3.520618841176241*^9, 3.5206197440573587`*^9, 
   3.5206216489507008`*^9, 3.521353808373228*^9, 3.5243970418307447`*^9, 
   3.524397077975072*^9, {3.533504770865842*^9, 3.533504778344399*^9}, 
   3.533505887541699*^9, 3.534756776558228*^9, 3.543316083052346*^9, 
   3.543319248176939*^9, 3.54357456242596*^9, 3.5435765371506453`*^9, 
   3.543577138397406*^9, 3.543649011537964*^9, 3.5436503658508472`*^9, 
   3.545639700298533*^9, 3.5472814077285023`*^9, 3.547283541511054*^9, 
   3.5484019853286*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["SC1AlayaMaroni3C",
      FontWeight->"Bold",
      FontSlant->"Italic"], "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520359536001605*^9, 3.5203595368637114`*^9}, 
   3.5204435792857523`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Alpha]=", -1, 
   "; \[Alpha] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.548401985368452*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Beta] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Beta]=", -1, 
   "; \[Beta] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.54840198537109*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm[
  "warning concerning the parameters \[Alpha]=", -1, " and \[Beta]=", -1, 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.5484019855686417`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Alpha]=", -1, 
   "; \[Alpha] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.54840198557283*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Beta] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Beta]=", -1, 
   "; \[Beta] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.54840198557661*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm[
  "warning concerning the parameters \[Alpha]=", -1, " and \[Beta]=", -1, 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.548401985580454*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Infinite expression \[NoBreak]\\!\\(1\\/0\\)\[NoBreak] \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.52035953808565*^9, 3.520445563413804*^9, 3.520528087390966*^9, 
   3.520529986559536*^9, 3.520530639548044*^9, 3.52061884146561*^9, 
   3.5206197441818047`*^9, 3.520621649158972*^9, 3.521353808654669*^9, 
   3.5243970421393967`*^9, 3.524397078098022*^9, {3.533504771122161*^9, 
   3.533504778465905*^9}, 3.5335058877262487`*^9, 3.534756788477243*^9, 
   3.543316083568779*^9, 3.5433192482892113`*^9, 3.543574562559103*^9, 
   3.54357653727809*^9, 3.5435771385232563`*^9, 3.543649011721966*^9, 
   3.543650366001754*^9, 3.545639700554584*^9, 3.547281408081147*^9, 
   3.5472835415681868`*^9, 3.548401985584715*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Indeterminate expression \[NoBreak]\\!\\(0\\\\ \
ComplexInfinity\\)\[NoBreak] encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.52035953808565*^9, 3.520445563413804*^9, 3.520528087390966*^9, 
   3.520529986559536*^9, 3.520530639548044*^9, 3.52061884146561*^9, 
   3.5206197441818047`*^9, 3.520621649158972*^9, 3.521353808654669*^9, 
   3.5243970421393967`*^9, 3.524397078098022*^9, {3.533504771122161*^9, 
   3.533504778465905*^9}, 3.5335058877262487`*^9, 3.534756788477243*^9, 
   3.543316083568779*^9, 3.5433192482892113`*^9, 3.543574562559103*^9, 
   3.54357653727809*^9, 3.5435771385232563`*^9, 3.543649011721966*^9, 
   3.543650366001754*^9, 3.545639700554584*^9, 3.547281408081147*^9, 
   3.5472835415681868`*^9, 3.548401985678886*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Alpha]=", -1, 
   "; \[Alpha] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.54840198568363*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameter \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Beta] is a negative integer; \\n\\t\\tsome \
recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials are not \
regular\"\>"}],
  SequenceForm[
  "warning concerning the parameter \[Beta]=", -1, 
   "; \[Beta] is a negative integer; \n\t\tsome recurrence coefficients are \
zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.548401985686249*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm[
  "warning concerning the parameters \[Alpha]=", -1, " and \[Beta]=", -1, 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359537703888*^9, 3.520445562920763*^9, 3.520528087177232*^9, 
   3.520529986539855*^9, 3.5205306394493313`*^9, 3.520618841319859*^9, 
   3.5206197441608477`*^9, 3.5206216490666037`*^9, 3.521353808493348*^9, 
   3.524397041930317*^9, 3.524397078074689*^9, {3.533504770986545*^9, 
   3.533504778440363*^9}, 3.533505887643396*^9, 3.5347567883494587`*^9, 
   3.543316083173728*^9, 3.543319248263957*^9, 3.543574562532671*^9, 
   3.5435765372530518`*^9, 3.5435771384997272`*^9, 3.543649011646899*^9, 
   3.543650365942144*^9, 3.5456397004007177`*^9, 3.547281407768914*^9, 
   3.547283541545535*^9, 3.548401985690042*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Infinite expression \[NoBreak]\\!\\(1\\/0\\)\[NoBreak] \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.52035953808565*^9, 3.520445563413804*^9, 3.520528087390966*^9, 
   3.520529986559536*^9, 3.520530639548044*^9, 3.52061884146561*^9, 
   3.5206197441818047`*^9, 3.520621649158972*^9, 3.521353808654669*^9, 
   3.5243970421393967`*^9, 3.524397078098022*^9, {3.533504771122161*^9, 
   3.533504778465905*^9}, 3.5335058877262487`*^9, 3.534756788477243*^9, 
   3.543316083568779*^9, 3.5433192482892113`*^9, 3.543574562559103*^9, 
   3.54357653727809*^9, 3.5435771385232563`*^9, 3.543649011721966*^9, 
   3.543650366001754*^9, 3.545639700554584*^9, 3.547281408081147*^9, 
   3.5472835415681868`*^9, 3.548401985693808*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Indeterminate expression \[NoBreak]\\!\\(0\\\\ \
ComplexInfinity\\)\[NoBreak] encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.52035953808565*^9, 3.520445563413804*^9, 3.520528087390966*^9, 
   3.520529986559536*^9, 3.520530639548044*^9, 3.52061884146561*^9, 
   3.5206197441818047`*^9, 3.520621649158972*^9, 3.521353808654669*^9, 
   3.5243970421393967`*^9, 3.524397078098022*^9, {3.533504771122161*^9, 
   3.533504778465905*^9}, 3.5335058877262487`*^9, 3.534756788477243*^9, 
   3.543316083568779*^9, 3.5433192482892113`*^9, 3.543574562559103*^9, 
   3.54357653727809*^9, 3.5435771385232563`*^9, 3.543649011721966*^9, 
   3.543650366001754*^9, 3.545639700554584*^9, 3.547281408081147*^9, 
   3.5472835415681868`*^9, 3.54840198569656*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Indeterminate"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Indeterminate"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.520359538198578*^9, 3.520445563524741*^9, 3.520528087512169*^9, 
   3.520529986577064*^9, 3.520530639714107*^9, 3.520618841622993*^9, 
   3.5206197442001867`*^9, 3.520621649328566*^9, 3.5213538087945433`*^9, 
   3.524397042357757*^9, 3.524397078120277*^9, {3.533504771183442*^9, 
   3.533504778489546*^9}, 3.5335058878816547`*^9, 3.534756788542285*^9, 
   3.5433160836346493`*^9, 3.543319248313229*^9, 3.543574562611082*^9, 
   3.543576537398793*^9, 3.543577138636355*^9, 3.543649011885908*^9, 
   3.543650366047532*^9, 3.545639700648912*^9, 3.5472814082475224`*^9, 
   3.5472835415891237`*^9, 3.548401985699202*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["SC1AlayaMaroni3C",
      FontWeight->"Bold",
      FontSlant->"Italic"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], "]"}], "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5203595597840967`*^9, 3.520359564294113*^9}, 
   3.520443579386242*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm["warning concerning the parameters \[Alpha]=", 
   Rational[-1, 2], " and \[Beta]=", 
   Rational[-1, 2], 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359565323996*^9, 3.520445563664707*^9, 3.52052808755447*^9, 
   3.52052998660995*^9, 3.52053063975077*^9, 3.520618841661364*^9, 
   3.520619744239945*^9, 3.5206216493691063`*^9, 3.521353808840991*^9, 
   3.524397042397172*^9, 3.524397078158085*^9, {3.533504771232809*^9, 
   3.533504778536971*^9}, 3.533505887923664*^9, 3.534756796657558*^9, 
   3.543316083672703*^9, 3.5433192483491917`*^9, 3.5435745626462927`*^9, 
   3.543576537433275*^9, 3.5435771386671047`*^9, 3.543649011922763*^9, 
   3.543650366084578*^9, 3.5456397006839*^9, 3.547281408282009*^9, 
   3.547283541617383*^9, 3.548401985761464*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm["warning concerning the parameters \[Alpha]=", 
   Rational[-1, 2], " and \[Beta]=", 
   Rational[-1, 2], 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359565323996*^9, 3.520445563664707*^9, 3.52052808755447*^9, 
   3.52052998660995*^9, 3.52053063975077*^9, 3.520618841661364*^9, 
   3.520619744239945*^9, 3.5206216493691063`*^9, 3.521353808840991*^9, 
   3.524397042397172*^9, 3.524397078158085*^9, {3.533504771232809*^9, 
   3.533504778536971*^9}, 3.533505887923664*^9, 3.534756796657558*^9, 
   3.543316083672703*^9, 3.5433192483491917`*^9, 3.5435745626462927`*^9, 
   3.543576537433275*^9, 3.5435771386671047`*^9, 3.543649011922763*^9, 
   3.543650366084578*^9, 3.5456397006839*^9, 3.547281408282009*^9, 
   3.547283541617383*^9, 3.548401985765029*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Power", "::", "infy"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Infinite expression \[NoBreak]\\!\\(1\\/0\\)\[NoBreak] \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.520359565329183*^9, 3.520445563671139*^9, 3.52052808756061*^9, 
   3.520529986616317*^9, 3.520530639756926*^9, 3.520618841667942*^9, 
   3.520619744246724*^9, 3.5206216493756847`*^9, 3.521353808847632*^9, 
   3.5243970424054813`*^9, 3.524397078166122*^9, {3.533504771241283*^9, 
   3.533504778546907*^9}, 3.533505887931549*^9, 3.534756796666109*^9, 
   3.54331608368079*^9, 3.5433192483591957`*^9, 3.543574562656125*^9, 
   3.543576537441366*^9, 3.543577138674776*^9, 3.543649011930626*^9, 
   3.543650366092709*^9, 3.545639700693514*^9, 3.547281408289242*^9, 
   3.547283541624878*^9, 3.548401985768978*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Infinity", "::", "indet"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Indeterminate expression \[NoBreak]\\!\\(0\\\\ \
ComplexInfinity\\)\[NoBreak] encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.520359565329183*^9, 3.520445563671139*^9, 3.52052808756061*^9, 
   3.520529986616317*^9, 3.520530639756926*^9, 3.520618841667942*^9, 
   3.520619744246724*^9, 3.5206216493756847`*^9, 3.521353808847632*^9, 
   3.5243970424054813`*^9, 3.524397078166122*^9, {3.533504771241283*^9, 
   3.533504778546907*^9}, 3.533505887931549*^9, 3.534756796666109*^9, 
   3.54331608368079*^9, 3.5433192483591957`*^9, 3.543574562656125*^9, 
   3.543576537441366*^9, 3.543577138674776*^9, 3.543649011930626*^9, 
   3.543650366092709*^9, 3.545639700693514*^9, 3.547281408289242*^9, 
   3.547283541624878*^9, 3.54840198577172*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"warning concerning the parameters \[Alpha]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], "\[InvisibleSpace]", "\<\" and \[Beta]=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], 
   "\[InvisibleSpace]", "\<\"; \[Alpha]+\[Beta] is a negative integer; \\n\\t\
\\tsome recurrence coefficients are zero or undefined;\\n\\t\\tpolynomials \
are not regular\"\>"}],
  SequenceForm["warning concerning the parameters \[Alpha]=", 
   Rational[-1, 2], " and \[Beta]=", 
   Rational[-1, 2], 
   "; \[Alpha]+\[Beta] is a negative integer; \n\t\tsome recurrence \
coefficients are zero or undefined;\n\t\tpolynomials are not regular"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.520359565323996*^9, 3.520445563664707*^9, 3.52052808755447*^9, 
   3.52052998660995*^9, 3.52053063975077*^9, 3.520618841661364*^9, 
   3.520619744239945*^9, 3.5206216493691063`*^9, 3.521353808840991*^9, 
   3.524397042397172*^9, 3.524397078158085*^9, {3.533504771232809*^9, 
   3.533504778536971*^9}, 3.533505887923664*^9, 3.534756796657558*^9, 
   3.543316083672703*^9, 3.5433192483491917`*^9, 3.5435745626462927`*^9, 
   3.543576537433275*^9, 3.5435771386671047`*^9, 3.543649011922763*^9, 
   3.543650366084578*^9, 3.5456397006839*^9, 3.547281408282009*^9, 
   3.547283541617383*^9, 3.548401985774405*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Indeterminate"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["1", "4"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.520359565336628*^9, 3.5204455636783323`*^9, 3.520528087567285*^9, 
   3.520529986622849*^9, 3.520530639763296*^9, 3.5206188416747513`*^9, 
   3.520619744254174*^9, 3.520621649382649*^9, 3.5213538088546133`*^9, 
   3.524397042414507*^9, 3.524397078175156*^9, {3.533504771250181*^9, 
   3.533504778555921*^9}, 3.533505887939987*^9, 3.5347567966765537`*^9, 
   3.5433160836892653`*^9, 3.543319248368517*^9, 3.543574562665332*^9, 
   3.543576537449724*^9, 3.543577138682974*^9, 3.543649011938983*^9, 
   3.543650366101486*^9, 3.545639700702285*^9, 3.547281408297007*^9, 
   3.547283541632885*^9, 3.548401985777088*^9}]
}, Open  ]],

Cell["\<\
______________________________________________________________________________\
____________________\
\>", "Text",
 CellChangeTimes->{{3.520453270969235*^9, 3.520453296378303*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["SC1AlayaMaroni3C",
    FontWeight->"Bold",
    FontSlant->"Italic"], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{"2", "*", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.52045326802293*^9, 3.520453268677186*^9}, {
  3.5204533048593903`*^9, 3.520453337912657*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "n"}], "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.5204532990399427`*^9, 3.520453338537931*^9}, 
   3.520528087629023*^9, 3.520529986672946*^9, 3.520530639798732*^9, 
   3.52061884171277*^9, 3.5206197442930803`*^9, 3.520621649433463*^9, 
   3.521353808888398*^9, 3.524397042451988*^9, 3.524397078212186*^9, {
   3.5335047712983*^9, 3.533504778603456*^9}, 3.533505887976328*^9, 
   3.534756813870718*^9, 3.5433160838124743`*^9, 3.543319248397524*^9, 
   3.5435745626957493`*^9, 3.543576537485676*^9, 3.5435771387155848`*^9, 
   3.543649011975669*^9, 3.543650366137776*^9, 3.545639700733528*^9, 
   3.547281408330093*^9, 3.547283541663316*^9, 3.548401985810122*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["SC1AlayaMaroni3C",
    FontWeight->"Bold",
    FontSlant->"Italic"], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.52045326802293*^9, 3.520453268677186*^9}, {
  3.5204533048593903`*^9, 3.520453313410478*^9}, {3.520453346938196*^9, 
  3.5204533485762053`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "n", "+", "\[Beta]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "n", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "n"}], "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"2", " ", "n"}], "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}],
   "}"}]], "Output",
 CellChangeTimes->{{3.5204532990399427`*^9, 3.5204533140684843`*^9}, 
   3.5204533491804457`*^9, 3.520528087738454*^9, 3.520529986772853*^9, 
   3.520530639977722*^9, 3.520618841823407*^9, 3.520619744387343*^9, 
   3.520621649529928*^9, 3.521353808989458*^9, 3.5243970425520287`*^9, 
   3.524397078312682*^9, {3.533504771398758*^9, 3.5335047787192097`*^9}, 
   3.5335058880734673`*^9, 3.534756813995441*^9, 3.54331608390106*^9, 
   3.543319248459296*^9, 3.5435745627757998`*^9, 3.543576537581283*^9, 
   3.543577138794799*^9, 3.5436490120371447`*^9, 3.54365036621552*^9, 
   3.545639700796287*^9, 3.547281408381081*^9, 3.547283541696046*^9, 
   3.548401985838921*^9}]
}, Open  ]],

Cell[TextData[StyleBox["______________________________________________________\
__________________________________________",
 FontWeight->"Bold",
 FontSlant->"Italic"]], "Text",
 CellChangeTimes->{{3.4606183165070868`*^9, 3.460618323200087*^9}, 
   3.467190225282712*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["SC1AlayaMaroni3P",
    FontWeight->"Bold",
    FontSlant->"Italic"], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.460703178318563*^9, 3.46070318326053*^9}, 
   3.512383219975219*^9, {3.51238859866005*^9, 3.5123885990505953`*^9}, 
   3.512406187128772*^9, {3.5180323966836853`*^9, 3.51803242111191*^9}, {
   3.5181122933137712`*^9, 3.518112299296419*^9}, {3.519471916619033*^9, 
   3.5194719388396597`*^9}, 3.519757159148374*^9, {3.5203593417664824`*^9, 
   3.520359363283004*^9}, {3.520359672761075*^9, 3.520359676440119*^9}, 
   3.52044357948359*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MOP", "[", "SC1AlayaMaroni3C", "]"}], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 CellChangeTimes->{{3.519471924485915*^9, 3.519471939374864*^9}, 
   3.519499555960866*^9, 3.519751323183626*^9, {3.520359342851885*^9, 
   3.52035936426865*^9}, 3.520359419977334*^9, 3.520445563720837*^9, 
   3.520528087770041*^9, 3.52052998682239*^9, 3.520530640026876*^9, 
   3.520618841969659*^9, 3.5206197444428873`*^9, 3.520621649580266*^9, 
   3.521353809039158*^9, 3.524397042692539*^9, 3.5243970783578*^9, 
   3.5243971982125072`*^9, 3.524397597789557*^9, {3.533504771445462*^9, 
   3.533504778769463*^9}, 3.533505888123128*^9, 3.534756817004766*^9, 
   3.543316083932218*^9, 3.543319248510476*^9, 3.543574562808166*^9, 
   3.543576537613706*^9, 3.5435771388451223`*^9, 3.5436490120710506`*^9, 
   3.543650366249119*^9, 3.545639700828865*^9, 3.5472814084129553`*^9, 
   3.547283541729748*^9, 3.548401985872862*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3P",
       FontWeight->"Bold",
       FontSlant->"Italic"], 
      StyleBox["[",
       FontWeight->"Bold",
       FontSlant->"Italic"], 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{"n", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{
  3.392925475533779*^9, {3.392925660271556*^9, 3.392925665282696*^9}, 
   3.457348264098277*^9, {3.4607031916037893`*^9, 3.460703196575037*^9}, {
   3.4671911784058104`*^9, 3.46719117922386*^9}, {3.512383225296369*^9, 
   3.512383253907934*^9}, {3.5123886019251747`*^9, 3.512388602803748*^9}, 
   3.5124062081189137`*^9, {3.518032403971479*^9, 3.51803244836675*^9}, 
   3.5181123044953814`*^9, {3.518112399794433*^9, 3.518112431536294*^9}, {
   3.518112470541895*^9, 3.51811247280376*^9}, {3.51947193263517*^9, 
   3.519471964910121*^9}, {3.51947199846909*^9, 3.519471998884939*^9}, 
   3.519757159280342*^9, {3.520359346911224*^9, 3.520359370067906*^9}, {
   3.5203594262577343`*^9, 3.520359429998901*^9}, 3.520443579618734*^9, {
   3.545734663386991*^9, 3.545734666815591*^9}}],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"0"},
     {"1"},
     {"x"},
     {
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       FractionBox[
        RowBox[{"1", "+", "\[Beta]"}], 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]]}]},
     {
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]]}]},
     {
      RowBox[{
       SuperscriptBox["x", "4"], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]], "+", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}]},
     {
      RowBox[{
       SuperscriptBox["x", "5"], "-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["x", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]], "+", 
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.52035937081037*^9, 3.5203593789140053`*^9}, {
   3.520359422586507*^9, 3.520359430816627*^9}, 3.5204455641741858`*^9, 
   3.52052808836487*^9, 3.520529987286539*^9, 3.520530640557428*^9, 
   3.520618842455307*^9, 3.5206197449077883`*^9, 3.520621650039378*^9, 
   3.5213538096032352`*^9, 3.524397042730315*^9, 3.524397078412559*^9, 
   3.52439720395039*^9, 3.52439760088109*^9, {3.5335047719099894`*^9, 
   3.5335047788205557`*^9}, 3.533505888575848*^9, 3.534756819214116*^9, 
   3.543316084417197*^9, 3.5433192489940166`*^9, 3.5435745632851973`*^9, 
   3.543576538071994*^9, 3.543577139302105*^9, 3.543649012532428*^9, 
   3.5436503667007437`*^9, 3.545639701279801*^9, 3.545734667800259*^9, 
   3.5472814089159527`*^9, 3.5472835421955442`*^9, 3.548401986358425*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Alaya and Maroni polynomials",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["(case 3)\n",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
   3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
   3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
   3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460529160209412*^9, 
   3.460529160850732*^9}, {3.460538651644092*^9, 3.460538676771216*^9}, {
   3.479035782738468*^9, 3.479035797646721*^9}, {3.512329140345154*^9, 
   3.512329145004119*^9}, {3.512329766737885*^9, 3.512329784644944*^9}, {
   3.512406427220812*^9, 3.512406427412525*^9}, {3.512406853011129*^9, 
   3.512406856031934*^9}, 3.518031166223576*^9, {3.5180325559596577`*^9, 
   3.5180325645651217`*^9}, {3.518113399129681*^9, 3.5181134006373663`*^9}, {
   3.519472039692458*^9, 3.519472048918165*^9}, {3.51950013553074*^9, 
   3.519500140929981*^9}, 3.519757187868792*^9, 3.5203595831098013`*^9, {
   3.5204454584077883`*^9, 3.520445458597357*^9}}],

Cell[TextData[{
 StyleBox["\n******************   CHANGE OF THE FIRST PARAMETER  \
***************** \n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta] )\[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta] ) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)10",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where\n",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Alaya ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 StyleBox["Maroni ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "polynomials of class 1 (case 3",
 StyleBox[") ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["*******************************************************************\
******",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.460703558359393*^9, 3.460703582905768*^9}, {
   3.460709308139473*^9, 3.460709310009841*^9}, {3.460709341217023*^9, 
   3.4607093669130898`*^9}, {3.461263959510046*^9, 3.4612639603397837`*^9}, {
   3.461264072541415*^9, 3.461264073679305*^9}, {3.467190233198913*^9, 
   3.467190237595634*^9}, 3.467190533567293*^9, {3.512383428550292*^9, 
   3.5123835155068197`*^9}, {3.512383594183024*^9, 3.5123836009043207`*^9}, {
   3.512388619037654*^9, 3.512388619499806*^9}, {3.51240591835634*^9, 
   3.512405932425798*^9}, {3.512406324948008*^9, 3.5124063250998907`*^9}, {
   3.518031179066057*^9, 3.51803120232371*^9}, {3.518032885659329*^9, 
   3.51803293130197*^9}, 3.518113418443142*^9, {3.51947216275021*^9, 
   3.519472168081785*^9}, 3.519757187957156*^9, {3.520359601948126*^9, 
   3.520359637183074*^9}, {3.5204436632217703`*^9, 3.5204436636298237`*^9}, {
   3.534757041980089*^9, 3.534757042705229*^9}, {3.5456397317689457`*^9, 
   3.545639870027776*^9}, {3.5456401566072206`*^9, 3.545640185683778*^9}, {
   3.545734860546187*^9, 3.5457348610682907`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{"n", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, 3.5203629007869787`*^9, {
   3.520443579769452*^9, 3.520443579835719*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}]}], ",", "0", ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "0", ",", "1"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.392926973081232*^9, 3.393266360763041*^9, {3.456168526255616*^9, 
   3.4561685547367573`*^9}, 3.4561687384832973`*^9, {3.456169202878273*^9, 
   3.456169218687344*^9}, 3.456181337331645*^9, {3.4561818426204367`*^9, 
   3.4561818659610786`*^9}, 3.4573493762621117`*^9, {3.457349561085923*^9, 
   3.45734959017962*^9}, 3.457423902375195*^9, 3.4574273969065104`*^9, 
   3.4586325476312304`*^9, 3.458633071634368*^9, 3.458635149367424*^9, 
   3.4590182447998047`*^9, 3.459494953162136*^9, 3.4595002628562403`*^9, 
   3.460703625625293*^9, 3.4609756896914473`*^9, 3.461924646925459*^9, 
   3.467192315627796*^9, 3.479036132834402*^9, 3.511274324355029*^9, 
   3.5112753923931026`*^9, 3.5112826689999123`*^9, 3.512383687525375*^9, 
   3.5123886239470463`*^9, 3.512388681199531*^9, {3.5123938826901407`*^9, 
   3.51239390830093*^9}, 3.512397202417667*^9, 3.51240627054978*^9, 
   3.512406517479599*^9, 3.51240668309336*^9, 3.518029474793736*^9, 
   3.518030240554325*^9, {3.518030953587761*^9, 3.518030956390827*^9}, 
   3.518030987232251*^9, {3.518031235951988*^9, 3.518031243523738*^9}, 
   3.51803140370433*^9, 3.5180327442359858`*^9, {3.518114858453525*^9, 
   3.518114887411319*^9}, 3.518151069470311*^9, {3.519472239105891*^9, 
   3.519472246590273*^9}, 3.519472375477103*^9, 3.5194995597373753`*^9, 
   3.51975148782162*^9, 3.520359719465959*^9, 3.520362901997054*^9, 
   3.5206238624309177`*^9, 3.5347570494491253`*^9, 3.543316142139161*^9, 
   3.543319250561129*^9, 3.543574541601633*^9, 3.543576558230446*^9, 
   3.54728141043125*^9, 3.5472835437157183`*^9, 3.54840198797093*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n"}], ",", 
     RowBox[{"2", "*", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, {3.52036264513297*^9, 
   3.520362702198772*^9}, {3.5204435801002207`*^9, 3.520443580168537*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}]}], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5203626920729103`*^9, 3.520362703857582*^9}, 
   3.520623862544435*^9, 3.5347570556188*^9, 3.543316142230404*^9, 
   3.5433192506288567`*^9, 3.547281410546588*^9, 3.547283543781672*^9, 
   3.548401988020067*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, {3.52036264513297*^9, 
   3.52036272690165*^9}, {3.5204435802674007`*^9, 3.520443580334021*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "-", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Beta]", "+", 
          OverscriptBox["\[Alpha]", "~"]}], ")"}]}], ")"}]}], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.520362727685348*^9, 3.520623863086372*^9, 
  3.5347570698080873`*^9, 3.5433161427728357`*^9, 3.543319251161961*^9, 
  3.547281411084073*^9, 3.547283544314227*^9, 3.548401988558424*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3DCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3DCC[\[Alpha], \[Beta]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Alpha]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox[", \[Beta]][n,m] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "computes the connection coefficient\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -)  \[LeftArrow] P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta]; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the\n",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomials of class 1 (case 3) ",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nusing the direct closed formulas infered from the above results \
produced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData["P"],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  OverscriptBox["P", "~"]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they must be integers.\n",
 StyleBox["\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, 
   3.512383072827989*^9, 3.5124054292405577`*^9, {3.5124057075252523`*^9, 
   3.512405724324067*^9}, {3.51240580876766*^9, 3.5124058118938427`*^9}, {
   3.512406010971093*^9, 3.512406026226222*^9}, {3.512406430036735*^9, 
   3.512406430276598*^9}, {3.518028248166874*^9, 3.5180284771411657`*^9}, {
   3.518028520311255*^9, 3.518028655177333*^9}, {3.518028690816325*^9, 
   3.518028763026177*^9}, {3.51802960827759*^9, 3.518029611323441*^9}, {
   3.518033466416016*^9, 3.518033467763632*^9}, {3.5180345594949093`*^9, 
   3.518034567175651*^9}, 3.518034613901154*^9, {3.5180347253310204`*^9, 
   3.5180348336781693`*^9}, {3.51941093393808*^9, 3.519410996350327*^9}, {
   3.5194110338983803`*^9, 3.51941109816108*^9}, 3.5194111459175377`*^9, {
   3.519411375633428*^9, 3.519411403621278*^9}, {3.519412012793817*^9, 
   3.519412020036879*^9}, {3.519412337688258*^9, 3.519412354504672*^9}, {
   3.5194692724836082`*^9, 3.519469282468873*^9}, {3.519471224845841*^9, 
   3.51947127028883*^9}, {3.519471304874926*^9, 3.519471341243886*^9}, {
   3.519493043136072*^9, 3.5194931974380417`*^9}, {3.5194938071265287`*^9, 
   3.519493811525936*^9}, {3.519494813314101*^9, 3.519494813809854*^9}, {
   3.519499621285934*^9, 3.5194996238027067`*^9}, {3.5194999112328377`*^9, 
   3.519499930823393*^9}, {3.5195799767652483`*^9, 3.51957997763912*^9}, {
   3.5195803074748497`*^9, 3.5195803126576*^9}, {3.519580411437797*^9, 
   3.519580429594145*^9}, {3.5195806002076693`*^9, 3.519580813241967*^9}, {
   3.5195810724063187`*^9, 3.519581092537472*^9}, {3.519583094536153*^9, 
   3.5195831230328283`*^9}, {3.5197571558097887`*^9, 3.519757155896903*^9}, 
   3.519757384052429*^9, {3.519844754127471*^9, 3.5198447998349257`*^9}, {
   3.520450775580883*^9, 3.520450860010335*^9}, {3.520529626722495*^9, 
   3.5205296787523003`*^9}, {3.520531476411529*^9, 3.5205315790656557`*^9}, {
   3.5347570857864933`*^9, 3.5347570989088793`*^9}, {3.545639898087399*^9, 
   3.54563992737894*^9}, {3.5456399936864*^9, 3.5456399941261463`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]tilde_", ",", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
      RowBox[{"m_", "/;", 
       RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]tilde", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], "=", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n1", ",", "m1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]}], ";", 
        RowBox[{"m1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"m", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", " ", "\[IndentingNewLine]", "\t", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"EvenQ", "[", "n", "]"}], ",", 
              RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"n", "<", "0"}], ",", 
            RowBox[{"m", "<", "0"}], ",", 
            RowBox[{"m", ">", "n"}]}], "]"}], ",", " ", "\[IndentingNewLine]",
           "\t\t", 
          RowBox[{"Return", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"EvenQ", "[", "n", "]"}], ",", 
            RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", 
            RowBox[{"Product", "[", 
             RowBox[{
              RowBox[{"\[Beta]", "+", "k"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", 
                RowBox[{"m1", "+", "1"}], ",", "n1"}], "}"}]}], "]"}], "*", 
            "\[IndentingNewLine]", "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "0", ",", 
                  RowBox[{"n1", "-", "m1", "-", "1"}]}], "}"}]}], "]"}], "/", 
              "\[IndentingNewLine]", 
              "\[NonBreakingSpace]                           ", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", 
                  RowBox[{"n1", "+", "m1", "+", "1"}], ",", "n"}], "}"}]}], 
               "]"}]}], "/", "\[IndentingNewLine]", "\t\t\t\t", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m", "+", "2"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "1"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"OddQ", "[", "n", "]"}], ",", 
            RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", 
            RowBox[{"Product", "[", 
             RowBox[{
              RowBox[{"\[Beta]", "+", "k"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", 
                RowBox[{"m1", "+", "2"}], ",", 
                RowBox[{"n1", "+", "1"}]}], "}"}]}], "]"}], "*", 
            "\[IndentingNewLine]", "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "0", ",", 
                  RowBox[{"n1", "-", "m1", "-", "1"}]}], "}"}]}], "]"}], "/", 
              "\[IndentingNewLine]", 
              "\[NonBreakingSpace]                           ", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", 
                  RowBox[{"n1", "+", "m1", "+", "2"}], ",", "n"}], "}"}]}], 
               "]"}]}], "/", "\[IndentingNewLine]", "\t\t\t\t", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m", "+", "2"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "2"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", "Which"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"end", " ", "of", " ", "Module"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.400452759660624*^9, 3.400452760193726*^9}, {
   3.460618217925473*^9, 3.460618279112927*^9}, {3.460618406882461*^9, 
   3.4606184492486887`*^9}, 3.460618513254024*^9, {3.461263833101872*^9, 
   3.461263849135838*^9}, {3.512329830392654*^9, 3.512329836593623*^9}, {
   3.512329903129181*^9, 3.5123299068879128`*^9}, {3.512329947374423*^9, 
   3.512329997447112*^9}, {3.512330028301688*^9, 3.5123301129978037`*^9}, {
   3.512330152725288*^9, 3.512330276924534*^9}, {3.512330317820643*^9, 
   3.512330444909276*^9}, {3.512330495363944*^9, 3.512330638112714*^9}, {
   3.512330702494276*^9, 3.512330852602721*^9}, {3.512330939725462*^9, 
   3.512331082596624*^9}, {3.512331301779955*^9, 3.512331333243409*^9}, {
   3.512331540606143*^9, 3.512331607014184*^9}, {3.5123316488378477`*^9, 
   3.5123316505573587`*^9}, {3.512331693002837*^9, 3.5123317354794827`*^9}, 
   3.512331785956175*^9, {3.51238015782869*^9, 3.5123801612996387`*^9}, {
   3.512380192018229*^9, 3.512380192928463*^9}, {3.512380333422009*^9, 
   3.5123803413258543`*^9}, {3.51238052769803*^9, 3.512380540439457*^9}, {
   3.5123806028671837`*^9, 3.5123806340331783`*^9}, {3.512382405467901*^9, 
   3.512382406873871*^9}, {3.512382717382518*^9, 3.512382752820456*^9}, {
   3.51238279526624*^9, 3.512382836694922*^9}, {3.512388000087888*^9, 
   3.5123880187935658`*^9}, {3.512388316674268*^9, 3.512388326903895*^9}, {
   3.512388523125185*^9, 3.512388552079053*^9}, 3.512393696962242*^9, {
   3.512393746260998*^9, 3.512393749452236*^9}, {3.5123966167802467`*^9, 
   3.5123966518797493`*^9}, {3.51239690900182*^9, 3.5123969414835*^9}, {
   3.5123970568698072`*^9, 3.512397082869409*^9}, {3.512397524429351*^9, 
   3.512397588029807*^9}, {3.51240437367793*^9, 3.512404386426743*^9}, {
   3.512404657817034*^9, 3.512404783149716*^9}, {3.51240485627293*^9, 
   3.512404893566217*^9}, {3.512404942378972*^9, 3.512405053460487*^9}, {
   3.512405407348139*^9, 3.512405409893429*^9}, {3.512405495156528*^9, 
   3.512405498452251*^9}, 3.512405607463504*^9, {3.512406032651773*^9, 
   3.51240604108302*^9}, 3.512406105157406*^9, {3.518028774969323*^9, 
   3.51802880981861*^9}, {3.518029614498234*^9, 3.518029616106409*^9}, {
   3.518029712805765*^9, 3.518029831967381*^9}, {3.518029881700182*^9, 
   3.518029884339715*^9}, {3.518030373473522*^9, 3.5180304989584093`*^9}, {
   3.518030589972753*^9, 3.518030597291349*^9}, 3.518030634219652*^9, {
   3.518031640752247*^9, 3.518031708071742*^9}, {3.5180318051156063`*^9, 
   3.518031809564804*^9}, {3.518032342234042*^9, 3.5180323429785423`*^9}, {
   3.518033609763501*^9, 3.518033623339281*^9}, {3.518033657310204*^9, 
   3.51803369685161*^9}, {3.518033730769665*^9, 3.518033736887821*^9}, {
   3.518033814156055*^9, 3.518033866895206*^9}, {3.5180339472284946`*^9, 
   3.518033995350499*^9}, {3.518034027925219*^9, 3.51803411461226*^9}, {
   3.5180342357697477`*^9, 3.5180343807144003`*^9}, {3.518110439032362*^9, 
   3.518110571302125*^9}, {3.518110618317313*^9, 3.51811067213057*^9}, {
   3.518110873751232*^9, 3.5181109999817944`*^9}, {3.5181111536810493`*^9, 
   3.518111160150035*^9}, {3.518111194020623*^9, 3.518111202587914*^9}, {
   3.518111260265943*^9, 3.518111272432006*^9}, 3.518111335017764*^9, {
   3.518111409428422*^9, 3.518111412345791*^9}, {3.519469313613496*^9, 
   3.519469455951632*^9}, {3.519469562523449*^9, 3.51946973480604*^9}, {
   3.5194697692248287`*^9, 3.519469857068819*^9}, {3.5194698927896852`*^9, 
   3.5194699903673677`*^9}, {3.5194700224445477`*^9, 3.519470049448662*^9}, {
   3.519470096816676*^9, 3.5194701273641787`*^9}, {3.5194704097233152`*^9, 
   3.5194705729708233`*^9}, {3.5194706055298653`*^9, 3.519470690382963*^9}, {
   3.519470728151087*^9, 3.519470730390251*^9}, {3.519470886059144*^9, 
   3.519470895430389*^9}, {3.519471502792811*^9, 3.519471507551765*^9}, {
   3.5194930152232313`*^9, 3.5194930189246187`*^9}, {3.519493219829631*^9, 
   3.5194933556642447`*^9}, {3.519493393263516*^9, 3.5194934905839443`*^9}, {
   3.519493672949585*^9, 3.519493694176408*^9}, {3.519493796475787*^9, 
   3.519493800113587*^9}, {3.5195808456225367`*^9, 3.5195808822687883`*^9}, {
   3.519581027561227*^9, 3.5195810689344788`*^9}, {3.519581351338389*^9, 
   3.5195813642740097`*^9}, {3.51958148288535*^9, 3.519581512527005*^9}, {
   3.519581617813072*^9, 3.519581736205668*^9}, {3.519581783320011*^9, 
   3.519581789646843*^9}, {3.519581822245473*^9, 3.5195823027098*^9}, {
   3.5195823951946077`*^9, 3.519582395759663*^9}, {3.519582490410535*^9, 
   3.5195824906334267`*^9}, {3.5195825654265137`*^9, 3.519582604917769*^9}, {
   3.519582678714427*^9, 3.519582679289406*^9}, {3.519582714533202*^9, 
   3.519582736825494*^9}, {3.519582835315584*^9, 3.5195828371529913`*^9}, {
   3.519757155988873*^9, 3.519757156124826*^9}, {3.5204509074270687`*^9, 
   3.520450934155868*^9}, {3.520450976037558*^9, 3.520451058851269*^9}, {
   3.52045109709942*^9, 3.5204511558212337`*^9}, {3.520451190460783*^9, 
   3.5204512267528067`*^9}, {3.520454269133164*^9, 3.5204542835728617`*^9}, {
   3.520454451011463*^9, 3.520454461225176*^9}, {3.52052969361096*^9, 
   3.5205297642194643`*^9}, {3.5205298034109163`*^9, 3.520529817120062*^9}, {
   3.5205315942168493`*^9, 3.520531839100397*^9}, {3.520531900878181*^9, 
   3.52053194775983*^9}}],

Cell["\<\
______________________________________________________________________________\
________________\
\>", "Text",
 CellChangeTimes->{{3.520533200151054*^9, 3.520533232945114*^9}, {
   3.520534975977826*^9, 3.520534980271619*^9}, 3.520535049340918*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
       RowBox[{
        OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
   "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.519583152148408*^9, 3.519583198066728*^9}, 
   3.5197571562254353`*^9, 3.5204514065806103`*^9, {3.52052986891962*^9, 
   3.5205298878210487`*^9}, {3.5205308307346497`*^9, 
   3.5205308312602577`*^9}, {3.520532066150874*^9, 3.520532090242239*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", "1", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Beta]", "+", 
         OverscriptBox["\[Alpha]", "~"]}], ")"}]}]], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {(1 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(2 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(3 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (
      2 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(3 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     2 (2 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(4 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(4 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     2 (3 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(5 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(4 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     3 (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(5 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     3 (3 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(6 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(5 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     3 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(6 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     3 (4 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(7 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(5 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     4 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(6 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     6 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (6 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(7 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     4 (4 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(8 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(6 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     4 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (6 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(7 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     6 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (7 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(8 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     4 (5 + $CellContext`\[Beta]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(9 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (4 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (3 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(6 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     5 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (3 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (4 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (5 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (6 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(7 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     10 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (2 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (6 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1) (7 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(8 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     10 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]]) (1 + $CellContext`\[Alpha] - 
      OverTilde[$CellContext`\[Alpha]]) (8 + $CellContext`\[Beta] + 
       OverTilde[$CellContext`\[Alpha]])^(-1)/(9 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 
     5 (5 + $CellContext`\[Beta]) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Alpha] - OverTilde[$CellContext`\[Alpha]])/(10 + $CellContext`\[Beta] + 
     OverTilde[$CellContext`\[Alpha]]), 0, 1}}]]], "Output",
 CellChangeTimes->{{3.519583187864048*^9, 3.519583199635601*^9}, 
   3.519583941893343*^9, 3.519675280938596*^9, 3.519751177385318*^9, 
   3.519837951945984*^9, 3.519849303651927*^9, 3.520451410601124*^9, 
   3.520454309044628*^9, 3.520454469994938*^9, {3.5205298892084846`*^9, 
   3.520529897316255*^9}, 3.520530042388172*^9, {3.520530811190405*^9, 
   3.520530832311303*^9}, 3.520532092468483*^9, 3.5206238632044373`*^9, 
   3.534757143041452*^9, 3.543316142860794*^9, 3.5433192512339373`*^9, 
   3.543576577877034*^9, 3.5472814111939898`*^9, 3.547283544395587*^9, 
   3.5484019886396*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta] ; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command \n",
 StyleBox["SC1AlayaMaroni3DCC[\[Alpha], \[Beta]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta]][n,m] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "up to",
 StyleBox[" n=30",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, 
   3.460704954146987*^9, {3.4671901313567266`*^9, 3.467190135304528*^9}, {
   3.479028670542183*^9, 3.479028675434106*^9}, {3.47910882985538*^9, 
   3.47910888644587*^9}, 3.479109070590269*^9, {3.479109715149744*^9, 
   3.479109716605257*^9}, 3.4791221340671453`*^9, {3.519583238617446*^9, 
   3.5195832739966497`*^9}, {3.51958433109713*^9, 3.519584332830352*^9}, {
   3.519584759238078*^9, 3.51958475997099*^9}, 3.519757156295761*^9, 
   3.519757395776733*^9, {3.520451498304049*^9, 3.520451515671486*^9}, {
   3.520529906398739*^9, 3.520529918790266*^9}, {3.5205321019996233`*^9, 
   3.520532146642042*^9}, {3.520532249503151*^9, 3.520532255974978*^9}, {
   3.545639962522681*^9, 3.545639976583952*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"verificationDCC", "[", 
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], 
        StyleBox["]",
         FontWeight->"Bold",
         FontSlant->"Italic"]}], "[", 
       RowBox[{"SC1AlayaMaroni3C", ",", "SC1AlayaMaroni3C"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", "30", 
    "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, 
   3.458302049606372*^9, {3.479028677507305*^9, 3.479028705649743*^9}, {
   3.47902956954272*^9, 3.479029586922673*^9}, {3.479029644031522*^9, 
   3.479029646605801*^9}, {3.479030939830699*^9, 3.47903094085384*^9}, {
   3.479108773882*^9, 3.479108800926409*^9}, 3.479108912015623*^9, {
   3.479108991075418*^9, 3.479108998865038*^9}, 3.479109740341483*^9, {
   3.479122150184525*^9, 3.47912217491066*^9}, {3.479122331065977*^9, 
   3.4791223321527243`*^9}, {3.479457757667802*^9, 3.479457758785578*^9}, {
   3.519583305750209*^9, 3.519583368506013*^9}, 3.519583644513597*^9, {
   3.519584294197721*^9, 3.519584336304592*^9}, {3.519757156396832*^9, 
   3.519757156463912*^9}, {3.520451427195571*^9, 3.5204514933507338`*^9}, {
   3.520529931026504*^9, 3.520529947552643*^9}, {3.520530846282995*^9, 
   3.520530846666935*^9}, {3.520530918113022*^9, 3.520530928117487*^9}, {
   3.5205321559004917`*^9, 3.5205321804931087`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"155.17440400000004`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{3.5335027902725077`*^9, 3.534757307457596*^9, 
  3.543316297222446*^9, 3.543319405801064*^9, 3.547281564572555*^9, 
  3.547283698803206*^9, 3.548402144056559*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:\nSC1AlayaMaroni3DCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3DCC[\[Alpha],\[Beta]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Alpha]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox[", \[Beta]][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " translates the definitions of the connection coefficients\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -) \[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta]; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " \n monic semi-classical polynomials of class 1 (case 3) ",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", for ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 StyleBox["m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["symbolic",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", in order to be used in calling \n statements of the ",
 StyleBox["demonstrationSymCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command.\n",
 StyleBox["\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Alpha]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", \[Beta]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData["P"],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  OverscriptBox["P", "~"]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they should be symbols.",
 StyleBox["\n\nResults:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206934894661*^9, 
   3.459206935313037*^9}, {3.459207075845229*^9, 3.459207080901113*^9}, {
   3.4592072425801*^9, 3.459207445351715*^9}, 3.4592079216793823`*^9, {
   3.459208083864663*^9, 3.4592080848420362`*^9}, {3.4594940809507113`*^9, 
   3.459494093356348*^9}, {3.459494147042548*^9, 3.459494163725823*^9}, {
   3.46070922863503*^9, 3.460709234659382*^9}, {3.461264927963533*^9, 
   3.461264930287938*^9}, 3.46414189761309*^9, {3.467190375251593*^9, 
   3.467190384412608*^9}, {3.467190444412822*^9, 3.467190465917828*^9}, {
   3.490793108422368*^9, 3.490793126794648*^9}, {3.494242918657694*^9, 
   3.494242935431642*^9}, {3.494567185910108*^9, 3.4945671873633633`*^9}, {
   3.5196721733672943`*^9, 3.519672486895392*^9}, {3.519757156534348*^9, 
   3.519757156614551*^9}, 3.519757187642535*^9, {3.5197574012100697`*^9, 
   3.519757404882127*^9}, {3.520451568327733*^9, 3.520451748970605*^9}, {
   3.520528830094516*^9, 3.52052884222297*^9}, {3.5205288893138943`*^9, 
   3.5205289190815496`*^9}, {3.520529083213235*^9, 3.520529091644556*^9}, {
   3.520529155180623*^9, 3.52052915814589*^9}, {3.520532201170929*^9, 
   3.5205322340341797`*^9}, {3.520532264617004*^9, 3.5205322926953297`*^9}, 
   3.520532331950533*^9, 3.520532363062063*^9, {3.53475717326425*^9, 
   3.534757176614636*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]tilde_", ",", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", "0"}], "]"}], ":=", 
    "\[IndentingNewLine]", "\t       ", 
    RowBox[{
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"\[Beta]", "+", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "/", 
       "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"n", "+", "1"}], ",", 
           RowBox[{"2", "*", "n"}]}], "}"}]}], "]"}]}], "/", " ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "2", ",", 
          RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]tilde_", ",", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", 
      RowBox[{"2", "*", "m_"}]}], "]"}], ":=", "\[IndentingNewLine]", "\t\t", 
    
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "m"}], "]"}], "*", "\[IndentingNewLine]", "\t       ", 
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"\[Beta]", "+", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"m", "+", "1"}], ",", "n"}], "}"}]}], "]"}], "*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}], "/", 
       "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"n", "+", "m", "+", "1"}], ",", 
           RowBox[{"2", "*", "n"}]}], "}"}]}], "]"}]}], "/", " ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{
           RowBox[{"2", "*", "m"}], "+", "2"}], ",", 
          RowBox[{"n", "+", "m", "+", "1"}]}], "}"}]}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]tilde_", ",", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "n_"}], "+", "1"}], ",", "1"}], "]"}], ":=", 
    "\[IndentingNewLine]", "\t       ", 
    RowBox[{
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"\[Beta]", "+", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "2", ",", 
         RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}], "*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "/", 
       "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"n", "+", "2"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}]}], "}"}]}], "]"}]}], "/", " ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "3", ",", 
          RowBox[{"n", "+", "2"}]}], "}"}]}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3DCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{"\[Alpha]tilde_", ",", "\[Beta]_"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n_"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m_"}], "+", "1"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", "\t\t", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "m"}], "]"}], "*", "\[IndentingNewLine]", "\t       ", 
    
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{"\[Beta]", "+", "k"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"m", "+", "2"}], ",", 
        RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}], "*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "-", "\[Alpha]tilde", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "0", ",", 
          RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}], "/", 
      "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"n", "+", "m", "+", "2"}], ",", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}]}], "}"}]}], "]"}]}], "/", " ", 
     
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"\[Alpha]tilde", "+", "\[Beta]", "+", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "3"}], ",", 
         RowBox[{"n", "+", "m", "+", "2"}]}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.519672540790855*^9, 3.519672620606463*^9}, {
   3.519672660659555*^9, 3.519672815676425*^9}, {3.519672867492116*^9, 
   3.519672965851141*^9}, {3.519673025481772*^9, 3.5196730775881853`*^9}, {
   3.519673182247911*^9, 3.5196732629520884`*^9}, {3.519673441886232*^9, 
   3.5196734898119287`*^9}, {3.5196735981626043`*^9, 3.519673613461866*^9}, {
   3.519674803019085*^9, 3.519674810978073*^9}, {3.5197557705668592`*^9, 
   3.519755801099286*^9}, {3.5197558312817373`*^9, 3.519755879030051*^9}, {
   3.519757156695562*^9, 3.519757156894589*^9}, {3.520451780398472*^9, 
   3.520451938634066*^9}, {3.52052895884242*^9, 3.5205289831463423`*^9}, {
   3.520529105478305*^9, 3.5205291363124933`*^9}, {3.5205294250216293`*^9, 
   3.520529463249786*^9}, {3.5205294997855*^9, 3.520529508102705*^9}, {
   3.520532372991482*^9, 3.520532410776679*^9}, {3.520532511250312*^9, 
   3.5205326380260477`*^9}, {3.520532683948147*^9, 3.52053273513548*^9}, {
   3.543576600583494*^9, 3.5435766411971197`*^9}, {3.543577023946484*^9, 
   3.543577028288311*^9}, {3.543577064621839*^9, 3.543577084047529*^9}, {
   3.543649051319075*^9, 3.543649060709771*^9}, {3.543650222047062*^9, 
   3.5436502292966146`*^9}, {3.5436502721358423`*^9, 3.543650318827792*^9}, {
   3.54563910671763*^9, 3.545639121547381*^9}, 3.545646209145295*^9}],

Cell["\<\
______________________________________________________________________________\
___________________\
\>", "Text",
 CellChangeTimes->{{3.520452055448897*^9, 3.5204520793507223`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{
    OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "m"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "m"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "-", 
     OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "m", "+", "\[Beta]"}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "\[Alpha]", "-", 
      OverscriptBox["\[Alpha]", "~"]}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}], 
  RowBox[{
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "m", "+", "n", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
     
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"2", "+", 
      RowBox[{"2", " ", "m"}], "+", "\[Beta]", "+", 
      OverscriptBox["\[Alpha]", "~"]}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}]]], "Output",
 CellChangeTimes->{{3.545646201801162*^9, 3.545646214212047*^9}, 
   3.547281564957055*^9, 3.547283698881075*^9, 3.548402144133944*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{
    OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "n"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520267756443`*^9}, {
   3.520452123443119*^9, 3.520452140208335*^9}, {3.520531151480242*^9, 
   3.5205311553496323`*^9}, 3.520532844346034*^9, {3.545640108106683*^9, 
   3.545640110656795*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452028158291*^9}, {3.520452130337281*^9, 
   3.520452140927631*^9}, 3.520528432450037*^9, 3.520531155954335*^9, 
   3.5205328452604427`*^9, 3.520624018210885*^9, 3.5347573078184834`*^9, 
   3.5433162975315723`*^9, 3.5433194059670362`*^9, 3.545640111610834*^9, 
   3.547281564985546*^9, 3.5472836989170513`*^9, 3.5484021441651373`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{
    OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "m"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "-", 
     OverscriptBox["\[Alpha]", "~"]}], ")"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"2", "+", "m", "+", "\[Beta]"}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "\[Alpha]", "-", 
      OverscriptBox["\[Alpha]", "~"]}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}], 
  RowBox[{
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"2", "+", "m", "+", "n", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
     
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"2", " ", "m"}], "+", "\[Beta]", "+", 
      OverscriptBox["\[Alpha]", "~"]}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}]]], "Output",
 CellChangeTimes->{3.545646239546195*^9, 3.5472815650201902`*^9, 
  3.5472836989511843`*^9, 3.548402144199197*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{
    OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520267756443`*^9}, {
   3.520452123443119*^9, 3.520452140208335*^9}, {3.520531151480242*^9, 
   3.5205311553496323`*^9}, 3.520532844346034*^9}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452028158291*^9}, {3.520452130337281*^9, 
   3.520452140927631*^9}, 3.520528432450037*^9, 3.520531155954335*^9, 
   3.5205328452604427`*^9, 3.520624018210885*^9, 3.5347573078184834`*^9, 
   3.5433162975315723`*^9, 3.5433194059670362`*^9, 3.547281565047956*^9, 
   3.547283698988676*^9, 3.548402144229494*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nDemonstration of the direct closed formulas for  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",\ntranslated by the commands ",
 StyleBox["SC1AlayaMaroni3DCC[\[Alpha], \[Beta]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Alpha]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox[", \[Beta]][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, {3.457351508577216*^9, 3.457351538077633*^9}, 
   3.457423674423217*^9, {3.457425152875874*^9, 3.457425278358103*^9}, {
   3.4612649649532347`*^9, 3.461264988795329*^9}, {3.467190396484603*^9, 
   3.467190433280266*^9}, {3.519673654034919*^9, 3.51967368018394*^9}, {
   3.5196737297416162`*^9, 3.519674067904241*^9}, 3.519757157766913*^9, 
   3.519757418383697*^9, {3.519847994824523*^9, 3.519847995013687*^9}, {
   3.52053101915196*^9, 3.520531062030089*^9}, {3.520531100740471*^9, 
   3.520531103555662*^9}, {3.520531165608007*^9, 3.520531176190943*^9}, {
   3.520532848894144*^9, 3.5205328686230307`*^9}, {3.534757223261773*^9, 
   3.534757246178906*^9}, 3.534767633572173*^9, {3.534844132346714*^9, 
   3.534844133227501*^9}, {3.54564012417424*^9, 3.545640127534017*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationSymDCC", "[", 
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "]"}], "[", 
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["SC1AlayaMaroni3",
          FontWeight->"Bold",
          FontSlant->"Italic"], "C"}]], ",", 
       StyleBox[
        RowBox[{
         StyleBox["SC1AlayaMaroni3",
          FontWeight->"Bold",
          FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{
     OverscriptBox["\[Alpha]", "~"], ",", "\[Beta]"}], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5335029580142603`*^9, 3.533502976128862*^9}, {
  3.5335048672702513`*^9, 3.533504869605476*^9}, {3.534757217326047*^9, 
  3.534757220390539*^9}, {3.5456462679554996`*^9, 3.5456462734891567`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.189959999999985`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.5335031551871147`*^9, 3.533503338191147*^9, 3.533505313903819*^9, {
   3.53350579145932*^9, 3.533505795879208*^9}, 3.533505941151182*^9, 
   3.534757312481266*^9, 3.543316302256798*^9, 3.543319410630844*^9, 
   3.543576665916759*^9, 3.5435769859227057`*^9, 3.543577202312718*^9, 
   3.54357727758444*^9, 3.543649167450539*^9, 3.543649279717617*^9, 
   3.543650339012086*^9, 3.5436503942785063`*^9, {3.545646264547587*^9, 
   3.545646274226324*^9}, 3.545647138190488*^9, 3.547281570478867*^9, 
   3.547283704124712*^9, 3.548402149426161*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["\n******************   CHANGE OF THE SECOND PARAMETER  \
***************** \n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta] )\[LeftArrow]  P(",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["\[Beta]",
     FontSlant->"Plain"], "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)10",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where\n",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the monic ",
 StyleBox["Alaya ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 StyleBox["Maroni ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "polynomials of class 1 (case 3",
 StyleBox[") ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n\n",
 StyleBox["*******************************************************************\
*******",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.460703558359393*^9, 3.460703582905768*^9}, {
   3.460709308139473*^9, 3.460709310009841*^9}, {3.460709341217023*^9, 
   3.4607093669130898`*^9}, {3.461263959510046*^9, 3.4612639603397837`*^9}, {
   3.461264072541415*^9, 3.461264073679305*^9}, {3.467190233198913*^9, 
   3.467190237595634*^9}, 3.467190533567293*^9, {3.512383428550292*^9, 
   3.5123835155068197`*^9}, {3.512383594183024*^9, 3.5123836009043207`*^9}, {
   3.512388619037654*^9, 3.512388619499806*^9}, {3.51240591835634*^9, 
   3.512405932425798*^9}, {3.512406324948008*^9, 3.5124063250998907`*^9}, {
   3.518031179066057*^9, 3.51803120232371*^9}, {3.518032885659329*^9, 
   3.51803293130197*^9}, 3.518113418443142*^9, {3.51947216275021*^9, 
   3.519472168081785*^9}, 3.519757187957156*^9, {3.520359601948126*^9, 
   3.520359637183074*^9}, {3.5204436632217703`*^9, 3.5204436636298237`*^9}, {
   3.534757041980089*^9, 3.534757042705229*^9}, {3.5456397317689457`*^9, 
   3.545639870027776*^9}, {3.5456401566072206`*^9, 3.545640185683778*^9}, {
   3.545640218687352*^9, 3.5456402696919737`*^9}, 3.545640984734024*^9, {
   3.545734873009609*^9, 3.545734873339798*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{
         StyleBox[
          RowBox[{
           StyleBox["SC1AlayaMaroni3",
            FontWeight->"Bold",
            FontSlant->"Italic"], "C"}]], ",", 
         StyleBox[
          RowBox[{
           StyleBox["SC1AlayaMaroni3",
            FontWeight->"Bold",
            FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", 
       OverscriptBox["\[Beta]", "~"]}], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, {3.520359753397807*^9, 
   3.5203597650771227`*^9}, {3.5204435804340687`*^9, 3.520443580501202*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", "1", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {-(1 + $CellContext`\[Alpha]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(2 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, -(1 + $CellContext`\[Alpha]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(3 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {(1 + $CellContext`\[Alpha]) (
      2 + $CellContext`\[Alpha]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(3 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-2) (2 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, (1 + $CellContext`\[Alpha]) (
      2 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-2) (2 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {-(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     3 (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-3) (3 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, -(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     3 (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-3) (3 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     6 (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (4 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, (1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     6 (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (7 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (4 + $CellContext`\[Alpha]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(9 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {-(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     5 (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-10) (3 + $CellContext`\[Alpha]) (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (7 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     10 (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (8 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(9 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-5) (5 + $CellContext`\[Alpha]) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(10 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}}]]], "Output",
 CellChangeTimes->{3.520359768017025*^9, 3.5206244670314837`*^9, 
  3.534757351759794*^9, 3.54331630398501*^9, 3.54331941233985*^9, 
  3.547281572246779*^9, 3.547283705831427*^9, 3.548402151143897*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", 
      OverscriptBox["\[Beta]", "~"]}], "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n"}], ",", 
     RowBox[{"2", "*", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, {3.520359753397807*^9, 
   3.5203597650771227`*^9}, {3.5204435804340687`*^9, 3.520443580501202*^9}, {
   3.5204494028586073`*^9, 3.520449415327054*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}]}]}], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5206244671070843`*^9, 3.53475735534112*^9, 
  3.54331630405415*^9, 3.54331941239067*^9, 3.547281572316221*^9, 
  3.547283705891554*^9, 3.5484021511953897`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", 
      OverscriptBox["\[Beta]", "~"]}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5180312201195517`*^9, 
   3.518031242165126*^9}, {3.518031395644525*^9, 3.518031402922086*^9}, {
   3.518032711170168*^9, 3.5180327365659018`*^9}, {3.518113436777726*^9, 
   3.518113440042554*^9}, {3.518114861980002*^9, 3.518114862411222*^9}, {
   3.519472205923473*^9, 3.5194722452221203`*^9}, {3.519472371229892*^9, 
   3.519472371781962*^9}, {3.5197571594135017`*^9, 3.519757159480413*^9}, {
   3.520359664035915*^9, 3.5203597132053537`*^9}, {3.520359753397807*^9, 
   3.5203597650771227`*^9}, {3.5204435804340687`*^9, 3.520443580501202*^9}, {
   3.5204494028586073`*^9, 3.520449415327054*^9}, {3.520449991859627*^9, 
   3.520449995121407*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Beta]", "-", 
           OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"6", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"7", "+", "\[Alpha]", "+", 
           OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5204499965126743`*^9, 3.52062446769394*^9, 
  3.534757360326807*^9, 3.5433163045013313`*^9, 3.5433194128250837`*^9, 
  3.5472815727478867`*^9, 3.547283706318882*^9, 3.548402151628251*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3DCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3DCC[\[Alpha], \[Beta]][\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["][n,m] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "computes the connection coefficient\n",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -)  \[LeftArrow] P(\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where  ",
 StyleBox["P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the\n",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomials of class 1 (case 3) ",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nusing the direct closed formulas infered from the above results \
produced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 StyleBox["\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 " are the parameters of ",
 Cell[BoxData["P"],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  OverscriptBox["P", "~"]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they must be integers.\n",
 StyleBox["\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, 
   3.512383072827989*^9, 3.5124054292405577`*^9, {3.5124057075252523`*^9, 
   3.512405724324067*^9}, {3.51240580876766*^9, 3.5124058118938427`*^9}, {
   3.512406010971093*^9, 3.512406026226222*^9}, {3.512406430036735*^9, 
   3.512406430276598*^9}, {3.518028248166874*^9, 3.5180284771411657`*^9}, {
   3.518028520311255*^9, 3.518028655177333*^9}, {3.518028690816325*^9, 
   3.518028763026177*^9}, {3.51802960827759*^9, 3.518029611323441*^9}, {
   3.518033466416016*^9, 3.518033467763632*^9}, {3.5180345594949093`*^9, 
   3.518034567175651*^9}, 3.518034613901154*^9, {3.5180347253310204`*^9, 
   3.5180348336781693`*^9}, {3.51941093393808*^9, 3.519410996350327*^9}, {
   3.5194110338983803`*^9, 3.51941109816108*^9}, 3.5194111459175377`*^9, {
   3.519411375633428*^9, 3.519411403621278*^9}, {3.519412012793817*^9, 
   3.519412020036879*^9}, {3.519412337688258*^9, 3.519412354504672*^9}, {
   3.5194692724836082`*^9, 3.519469282468873*^9}, {3.519471224845841*^9, 
   3.51947127028883*^9}, {3.519471304874926*^9, 3.519471341243886*^9}, {
   3.519493043136072*^9, 3.5194931974380417`*^9}, {3.5194938071265287`*^9, 
   3.519493811525936*^9}, {3.519494813314101*^9, 3.519494813809854*^9}, {
   3.519499621285934*^9, 3.5194996238027067`*^9}, {3.5194999112328377`*^9, 
   3.519499930823393*^9}, {3.5195799767652483`*^9, 3.51957997763912*^9}, {
   3.5195803074748497`*^9, 3.5195803126576*^9}, {3.519580411437797*^9, 
   3.519580429594145*^9}, {3.5195806002076693`*^9, 3.519580813241967*^9}, {
   3.5195810724063187`*^9, 3.519581092537472*^9}, {3.519583094536153*^9, 
   3.5195831230328283`*^9}, {3.5197571558097887`*^9, 3.519757155896903*^9}, 
   3.519757384052429*^9, {3.519844754127471*^9, 3.5198447998349257`*^9}, {
   3.520450775580883*^9, 3.520450860010335*^9}, {3.520529626722495*^9, 
   3.5205296787523003`*^9}, {3.520531476411529*^9, 3.5205315790656557`*^9}, {
   3.520533286818511*^9, 3.5205333789015007`*^9}, 3.520533816415559*^9, {
   3.5347573773479156`*^9, 3.534757380801611*^9}, {3.545640297587791*^9, 
   3.5456403072979393`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", "\[Beta]tilde_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
      RowBox[{"m_", "/;", 
       RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], "=", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n1", ",", "m1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]}], ";", 
        RowBox[{"m1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"m", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", " ", "\[IndentingNewLine]", "\t", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"EvenQ", "[", "n", "]"}], ",", 
              RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"n", "<", "0"}], ",", 
            RowBox[{"m", "<", "0"}], ",", 
            RowBox[{"m", ">", "n"}]}], "]"}], ",", " ", "\[IndentingNewLine]",
           "\t\t", 
          RowBox[{"Return", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"EvenQ", "[", "n", "]"}], ",", 
            RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n1", "+", "m1"}], ")"}]}], "*", 
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", 
            RowBox[{"Product", "[", 
             RowBox[{
              RowBox[{"\[Alpha]", "+", "k"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", 
                RowBox[{"m1", "+", "1"}], ",", "n1"}], "}"}]}], "]"}], "*", 
            "\[IndentingNewLine]", "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "0", ",", 
                  RowBox[{"n1", "-", "m1", "-", "1"}]}], "}"}]}], "]"}], "/", 
              "\[IndentingNewLine]", 
              "\[NonBreakingSpace]                           ", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", 
                  RowBox[{"n1", "+", "m1", "+", "1"}], ",", "n"}], "}"}]}], 
               "]"}]}], "/", "\[IndentingNewLine]", "\t\t\t\t", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m", "+", "2"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "1"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"OddQ", "[", "n", "]"}], ",", 
            RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n1", "+", "m1"}], ")"}]}], "*", 
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", 
            RowBox[{"Product", "[", 
             RowBox[{
              RowBox[{"\[Alpha]", "+", "k"}], ",", 
              RowBox[{"{", 
               RowBox[{"k", ",", 
                RowBox[{"m1", "+", "1"}], ",", "n1"}], "}"}]}], "]"}], "*", 
            "\[IndentingNewLine]", "\t\t\t", 
            RowBox[{
             RowBox[{
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", "0", ",", 
                  RowBox[{"n1", "-", "m1", "-", "1"}]}], "}"}]}], "]"}], "/", 
              "\[IndentingNewLine]", 
              "\[NonBreakingSpace]                           ", 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
                RowBox[{"{", 
                 RowBox[{"k", ",", 
                  RowBox[{"n1", "+", "m1", "+", "2"}], ",", "n"}], "}"}]}], 
               "]"}]}], "/", "\[IndentingNewLine]", "\t\t\t\t", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m", "+", "2"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "2"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", "Which"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"end", " ", "of", " ", "Module"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.400452759660624*^9, 3.400452760193726*^9}, {
   3.460618217925473*^9, 3.460618279112927*^9}, {3.460618406882461*^9, 
   3.4606184492486887`*^9}, 3.460618513254024*^9, {3.461263833101872*^9, 
   3.461263849135838*^9}, {3.512329830392654*^9, 3.512329836593623*^9}, {
   3.512329903129181*^9, 3.5123299068879128`*^9}, {3.512329947374423*^9, 
   3.512329997447112*^9}, {3.512330028301688*^9, 3.5123301129978037`*^9}, {
   3.512330152725288*^9, 3.512330276924534*^9}, {3.512330317820643*^9, 
   3.512330444909276*^9}, {3.512330495363944*^9, 3.512330638112714*^9}, {
   3.512330702494276*^9, 3.512330852602721*^9}, {3.512330939725462*^9, 
   3.512331082596624*^9}, {3.512331301779955*^9, 3.512331333243409*^9}, {
   3.512331540606143*^9, 3.512331607014184*^9}, {3.5123316488378477`*^9, 
   3.5123316505573587`*^9}, {3.512331693002837*^9, 3.5123317354794827`*^9}, 
   3.512331785956175*^9, {3.51238015782869*^9, 3.5123801612996387`*^9}, {
   3.512380192018229*^9, 3.512380192928463*^9}, {3.512380333422009*^9, 
   3.5123803413258543`*^9}, {3.51238052769803*^9, 3.512380540439457*^9}, {
   3.5123806028671837`*^9, 3.5123806340331783`*^9}, {3.512382405467901*^9, 
   3.512382406873871*^9}, {3.512382717382518*^9, 3.512382752820456*^9}, {
   3.51238279526624*^9, 3.512382836694922*^9}, {3.512388000087888*^9, 
   3.5123880187935658`*^9}, {3.512388316674268*^9, 3.512388326903895*^9}, {
   3.512388523125185*^9, 3.512388552079053*^9}, 3.512393696962242*^9, {
   3.512393746260998*^9, 3.512393749452236*^9}, {3.5123966167802467`*^9, 
   3.5123966518797493`*^9}, {3.51239690900182*^9, 3.5123969414835*^9}, {
   3.5123970568698072`*^9, 3.512397082869409*^9}, {3.512397524429351*^9, 
   3.512397588029807*^9}, {3.51240437367793*^9, 3.512404386426743*^9}, {
   3.512404657817034*^9, 3.512404783149716*^9}, {3.51240485627293*^9, 
   3.512404893566217*^9}, {3.512404942378972*^9, 3.512405053460487*^9}, {
   3.512405407348139*^9, 3.512405409893429*^9}, {3.512405495156528*^9, 
   3.512405498452251*^9}, 3.512405607463504*^9, {3.512406032651773*^9, 
   3.51240604108302*^9}, 3.512406105157406*^9, {3.518028774969323*^9, 
   3.51802880981861*^9}, {3.518029614498234*^9, 3.518029616106409*^9}, {
   3.518029712805765*^9, 3.518029831967381*^9}, {3.518029881700182*^9, 
   3.518029884339715*^9}, {3.518030373473522*^9, 3.5180304989584093`*^9}, {
   3.518030589972753*^9, 3.518030597291349*^9}, 3.518030634219652*^9, {
   3.518031640752247*^9, 3.518031708071742*^9}, {3.5180318051156063`*^9, 
   3.518031809564804*^9}, {3.518032342234042*^9, 3.5180323429785423`*^9}, {
   3.518033609763501*^9, 3.518033623339281*^9}, {3.518033657310204*^9, 
   3.51803369685161*^9}, {3.518033730769665*^9, 3.518033736887821*^9}, {
   3.518033814156055*^9, 3.518033866895206*^9}, {3.5180339472284946`*^9, 
   3.518033995350499*^9}, {3.518034027925219*^9, 3.51803411461226*^9}, {
   3.5180342357697477`*^9, 3.5180343807144003`*^9}, {3.518110439032362*^9, 
   3.518110571302125*^9}, {3.518110618317313*^9, 3.51811067213057*^9}, {
   3.518110873751232*^9, 3.5181109999817944`*^9}, {3.5181111536810493`*^9, 
   3.518111160150035*^9}, {3.518111194020623*^9, 3.518111202587914*^9}, {
   3.518111260265943*^9, 3.518111272432006*^9}, 3.518111335017764*^9, {
   3.518111409428422*^9, 3.518111412345791*^9}, {3.519469313613496*^9, 
   3.519469455951632*^9}, {3.519469562523449*^9, 3.51946973480604*^9}, {
   3.5194697692248287`*^9, 3.519469857068819*^9}, {3.5194698927896852`*^9, 
   3.5194699903673677`*^9}, {3.5194700224445477`*^9, 3.519470049448662*^9}, {
   3.519470096816676*^9, 3.5194701273641787`*^9}, {3.5194704097233152`*^9, 
   3.5194705729708233`*^9}, {3.5194706055298653`*^9, 3.519470690382963*^9}, {
   3.519470728151087*^9, 3.519470730390251*^9}, {3.519470886059144*^9, 
   3.519470895430389*^9}, {3.519471502792811*^9, 3.519471507551765*^9}, {
   3.5194930152232313`*^9, 3.5194930189246187`*^9}, {3.519493219829631*^9, 
   3.5194933556642447`*^9}, {3.519493393263516*^9, 3.5194934905839443`*^9}, {
   3.519493672949585*^9, 3.519493694176408*^9}, {3.519493796475787*^9, 
   3.519493800113587*^9}, {3.5195808456225367`*^9, 3.5195808822687883`*^9}, {
   3.519581027561227*^9, 3.5195810689344788`*^9}, {3.519581351338389*^9, 
   3.5195813642740097`*^9}, {3.51958148288535*^9, 3.519581512527005*^9}, {
   3.519581617813072*^9, 3.519581736205668*^9}, {3.519581783320011*^9, 
   3.519581789646843*^9}, {3.519581822245473*^9, 3.5195823027098*^9}, {
   3.5195823951946077`*^9, 3.519582395759663*^9}, {3.519582490410535*^9, 
   3.5195824906334267`*^9}, {3.5195825654265137`*^9, 3.519582604917769*^9}, {
   3.519582678714427*^9, 3.519582679289406*^9}, {3.519582714533202*^9, 
   3.519582736825494*^9}, {3.519582835315584*^9, 3.5195828371529913`*^9}, {
   3.519757155988873*^9, 3.519757156124826*^9}, {3.5204509074270687`*^9, 
   3.520450934155868*^9}, {3.520450976037558*^9, 3.520451058851269*^9}, {
   3.52045109709942*^9, 3.5204511558212337`*^9}, {3.520451190460783*^9, 
   3.5204512267528067`*^9}, {3.520454269133164*^9, 3.5204542835728617`*^9}, {
   3.520454451011463*^9, 3.520454461225176*^9}, {3.52052969361096*^9, 
   3.5205297642194643`*^9}, {3.5205298034109163`*^9, 3.520529817120062*^9}, {
   3.5205315942168493`*^9, 3.520531839100397*^9}, {3.520531900878181*^9, 
   3.52053194775983*^9}, {3.5205333825583*^9, 3.52053347261147*^9}, {
   3.5205335350646353`*^9, 3.520533569707287*^9}}],

Cell["\<\
______________________________________________________________________________\
________________
\
\>", "Text",
 CellChangeTimes->{{3.520533200151054*^9, 3.520533232945114*^9}, {
  3.520534975977826*^9, 3.520534980271619*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", 
        OverscriptBox["\[Beta]", "~"]}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
   "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.519583152148408*^9, 3.519583198066728*^9}, 
   3.5197571562254353`*^9, 3.5204514065806103`*^9, {3.52052986891962*^9, 
   3.5205298878210487`*^9}, {3.5205308307346497`*^9, 
   3.5205308312602577`*^9}, {3.5205339372257566`*^9, 3.520533954650741*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", "1", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]", "-", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", 
         OverscriptBox["\[Beta]", "~"]}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"\[Beta]", "-", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", 
          OverscriptBox["\[Beta]", "~"]}], ")"}]}]]}], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {-(1 + $CellContext`\[Alpha]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(2 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, -(1 + $CellContext`\[Alpha]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(3 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {(1 + $CellContext`\[Alpha]) (
      2 + $CellContext`\[Alpha]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(3 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-2) (2 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, (1 + $CellContext`\[Alpha]) (
      2 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-2) (2 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {-(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(4 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     3 (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-3) (3 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, -(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     3 (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-3) (3 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(5 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     6 (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (4 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}, {
    0, (1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     6 (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (7 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-4) (4 + $CellContext`\[Alpha]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(9 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     1}, {-(1 + $CellContext`\[Alpha]) (2 + $CellContext`\[Alpha]) (
      3 + $CellContext`\[Alpha]) (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (3 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(6 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     5 (2 + $CellContext`\[Alpha]) (3 + $CellContext`\[Alpha]) (
      4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (3 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (4 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (5 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(7 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-10) (3 + $CellContext`\[Alpha]) (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (2 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (6 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1) (7 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(8 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 
     10 (4 + $CellContext`\[Alpha]) (
      5 + $CellContext`\[Alpha]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]]) (1 + $CellContext`\[Beta] - 
      OverTilde[$CellContext`\[Beta]]) (8 + $CellContext`\[Alpha] + 
       OverTilde[$CellContext`\[Beta]])^(-1)/(9 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 
     0, (-5) (5 + $CellContext`\[Alpha]) (
       10 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) ($CellContext`\
\[Beta] - OverTilde[$CellContext`\[Beta]])/(10 + $CellContext`\[Alpha] + 
     OverTilde[$CellContext`\[Beta]]), 0, 1}}]]], "Output",
 CellChangeTimes->{{3.519583187864048*^9, 3.519583199635601*^9}, 
   3.519583941893343*^9, 3.519675280938596*^9, 3.519751177385318*^9, 
   3.519837951945984*^9, 3.519849303651927*^9, 3.520451410601124*^9, 
   3.520454309044628*^9, 3.520454469994938*^9, {3.5205298892084846`*^9, 
   3.520529897316255*^9}, 3.520530042388172*^9, {3.520530811190405*^9, 
   3.520530832311303*^9}, 3.520533964269855*^9, 3.520624467806449*^9, 
   3.5347574030825644`*^9, 3.543316304626936*^9, 3.54331941289261*^9, 
   3.547281572844393*^9, 3.547283706395499*^9, 3.548402151719069*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -) \[LeftArrow] P(\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Beta]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command \n",
 StyleBox["SC1AlayaMaroni3DCC[\[Alpha],\[Beta]][\[Alpha],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Beta]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " up to",
 StyleBox[" n=30",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, 
   3.460704954146987*^9, {3.4671901313567266`*^9, 3.467190135304528*^9}, {
   3.479028670542183*^9, 3.479028675434106*^9}, {3.47910882985538*^9, 
   3.47910888644587*^9}, 3.479109070590269*^9, {3.479109715149744*^9, 
   3.479109716605257*^9}, 3.4791221340671453`*^9, {3.519583238617446*^9, 
   3.5195832739966497`*^9}, {3.51958433109713*^9, 3.519584332830352*^9}, {
   3.519584759238078*^9, 3.51958475997099*^9}, 3.519757156295761*^9, 
   3.519757395776733*^9, {3.520451498304049*^9, 3.520451515671486*^9}, {
   3.520529906398739*^9, 3.520529918790266*^9}, {3.5205339720208273`*^9, 
   3.5205340145285597`*^9}, {3.52053412774758*^9, 3.5205341367821827`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"verificationDCC", "[", 
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], 
        StyleBox["]",
         FontWeight->"Bold",
         FontSlant->"Italic"]}], "[", 
       RowBox[{"SC1AlayaMaroni3C", ",", "SC1AlayaMaroni3C"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", 
      OverscriptBox["\[Beta]", "~"]}], "]"}], "[", "30", "]"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, 
   3.458302049606372*^9, {3.479028677507305*^9, 3.479028705649743*^9}, {
   3.47902956954272*^9, 3.479029586922673*^9}, {3.479029644031522*^9, 
   3.479029646605801*^9}, {3.479030939830699*^9, 3.47903094085384*^9}, {
   3.479108773882*^9, 3.479108800926409*^9}, 3.479108912015623*^9, {
   3.479108991075418*^9, 3.479108998865038*^9}, 3.479109740341483*^9, {
   3.479122150184525*^9, 3.47912217491066*^9}, {3.479122331065977*^9, 
   3.4791223321527243`*^9}, {3.479457757667802*^9, 3.479457758785578*^9}, {
   3.519583305750209*^9, 3.519583368506013*^9}, 3.519583644513597*^9, {
   3.519584294197721*^9, 3.519584336304592*^9}, {3.519757156396832*^9, 
   3.519757156463912*^9}, {3.520451427195571*^9, 3.5204514933507338`*^9}, {
   3.520529931026504*^9, 3.520529947552643*^9}, {3.520530846282995*^9, 
   3.520530846666935*^9}, {3.520530918113022*^9, 3.520530928117487*^9}, {
   3.520534079399576*^9, 3.520534111548666*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"148.36587300000002`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.520530057804606*^9, 3.520530847430902*^9, {3.520530921741027*^9, 
   3.520530936928639*^9}, 3.520534269125636*^9, 3.520624615423154*^9, 
   3.53475756282642*^9, 3.543316452211689*^9, 3.543319560981901*^9, 
   3.547281721325489*^9, 3.54728385395251*^9, 3.548402300194502*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:\nSC1AlayaMaroni3DCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3DCC[\[Alpha], \[Beta]][\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " translates the definitions of the connection coefficients\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -)  \[LeftArrow] P(\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " the\n monic semi-classical polynomials of class 1 (case 3) ",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", for ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 StyleBox["m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["symbolic",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", in order to be used in calling \n statements of the ",
 StyleBox["demonstrationSymCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command.\n",
 StyleBox["\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha], \[Beta] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and ",
 StyleBox["\[Alpha], ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    OverscriptBox["\[Beta]", "~"],
    FontWeight->"Bold",
    FontSlant->"Italic"], TraditionalForm]]],
 " are the parameters of ",
 Cell[BoxData["P"],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 Cell[BoxData[
  OverscriptBox["P", "~"]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they should be symbols.",
 StyleBox["\n\nResults:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206934894661*^9, 
   3.459206935313037*^9}, {3.459207075845229*^9, 3.459207080901113*^9}, {
   3.4592072425801*^9, 3.459207445351715*^9}, 3.4592079216793823`*^9, {
   3.459208083864663*^9, 3.4592080848420362`*^9}, {3.4594940809507113`*^9, 
   3.459494093356348*^9}, {3.459494147042548*^9, 3.459494163725823*^9}, {
   3.46070922863503*^9, 3.460709234659382*^9}, {3.461264927963533*^9, 
   3.461264930287938*^9}, 3.46414189761309*^9, {3.467190375251593*^9, 
   3.467190384412608*^9}, {3.467190444412822*^9, 3.467190465917828*^9}, {
   3.490793108422368*^9, 3.490793126794648*^9}, {3.494242918657694*^9, 
   3.494242935431642*^9}, {3.494567185910108*^9, 3.4945671873633633`*^9}, {
   3.5196721733672943`*^9, 3.519672486895392*^9}, {3.519757156534348*^9, 
   3.519757156614551*^9}, 3.519757187642535*^9, {3.5197574012100697`*^9, 
   3.519757404882127*^9}, {3.520451568327733*^9, 3.520451748970605*^9}, {
   3.520528830094516*^9, 3.52052884222297*^9}, {3.5205288893138943`*^9, 
   3.5205289190815496`*^9}, {3.520529083213235*^9, 3.520529091644556*^9}, {
   3.520529155180623*^9, 3.52052915814589*^9}, {3.520532201170929*^9, 
   3.5205322340341797`*^9}, {3.520532264617004*^9, 3.5205322926953297`*^9}, 
   3.520532331950533*^9, 3.520532363062063*^9, {3.520533789673805*^9, 
   3.520533806012972*^9}, 3.520533844485385*^9, {3.534757432310741*^9, 
   3.534757441676713*^9}, {3.545640340192307*^9, 3.54564034535075*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", "\[Beta]tilde_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", "0"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", "0"}], "]"}], "=", "\[IndentingNewLine]",
      "\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", "\[IndentingNewLine]", 
      "\t       ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "/", 
        "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"n", "+", "1"}], ",", 
            RowBox[{"2", "*", "n"}]}], "}"}]}], "]"}]}], "/", " ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "2", ",", 
           RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", "\[Beta]tilde_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", 
      RowBox[{"2", "*", "m_"}]}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", 
       RowBox[{"2", "*", "m"}]}], "]"}], "=", "\[IndentingNewLine]", "\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "m"}], ")"}]}], "*", 
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "m"}], "]"}], "*", "\[IndentingNewLine]", 
      "\t       ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"m", "+", "1"}], ",", "n"}], "}"}]}], "]"}], "*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}], "/", 
        "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"n", "+", "m", "+", "1"}], ",", 
            RowBox[{"2", "*", "n"}]}], "}"}]}], "]"}]}], "/", " ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "2"}], ",", 
           RowBox[{"n", "+", "m", "+", "1"}]}], "}"}]}], "]"}]}]}]}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", "\[Beta]tilde_"}], "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "n_"}], "+", "1"}], ",", "1"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1AlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", 
        RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "*", "n"}], "+", "1"}], ",", "1"}], "]"}], "=", 
     "\[IndentingNewLine]", "\t\t", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", "\[IndentingNewLine]", 
      "\t       ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "/", 
        "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"n", "+", "2"}], ",", 
            RowBox[{
             RowBox[{"2", "*", "n"}], "+", "1"}]}], "}"}]}], "]"}]}], "/", 
       " ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "3", ",", 
           RowBox[{"n", "+", "2"}]}], "}"}]}], "]"}]}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3DCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{"\[Alpha]_", ",", "\[Beta]tilde_"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n_"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m_"}], "+", "1"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", 
       RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
      RowBox[{
       RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "=", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "m"}], ")"}]}], "*", 
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "m"}], "]"}], "*", "\[IndentingNewLine]", "\t       ", 
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"\[Alpha]", "+", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"m", "+", "1"}], ",", "n"}], "}"}]}], "]"}], "*", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Beta]", "-", "\[Beta]tilde", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{"n", "-", "m", "-", "1"}]}], "}"}]}], "]"}], "/", 
       "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"n", "+", "m", "+", "2"}], ",", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}]}], "}"}]}], "]"}]}], "/", " ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "\[Beta]tilde", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{
           RowBox[{"2", "*", "m"}], "+", "3"}], ",", 
          RowBox[{"n", "+", "m", "+", "2"}]}], "}"}]}], "]"}]}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQvd5vprSd5StH1YzJqiBaWHqqFoh2W/rVFkRn7c93
AdE9NrsDQPTaLP0IsPilTXEg+vG749kguqn8XimIZo6x6QHRQb8tJ4FoPpOj
80H07OPrFoLoiDkJZvZAOsEn3hxEb1MO2p8GpKN0lQ+D6H/ML4+BaL1vD86A
aG6naTnpQLpywRww7XGgZ8Yuq1eOrl4ha0C09Ndb7g+A9LV1T7xAtJuffhSI
/vSfMw5EG2xUaALR9v+et4Hoi0qV3SA6xrO5B0Rb7Jr/6SGQ7rsV8R1MM71g
fgSkk64eEAbRFuF1kiD6VugTeRBdxWN+GUS3RYk/BNEeNZdegOhrJ9nfguiC
yYdFrqW9clxm+kAURG9ewrvzaNYrx5cymudBdJRk5j0Q7cXn+hREt7CG2x4D
0i6/toBpAE6FxxU=
  "]],

Cell["\<\
______________________________________________________________________________\
________________
\
\>", "Text",
 CellChangeTimes->{{3.520533200151054*^9, 3.520533232945114*^9}, {
  3.520534975977826*^9, 3.520534980271619*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "m"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520534416999947*^9, 3.520534417454349*^9}, {
  3.520535004578094*^9, 3.520535004920209*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"m", "+", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "-", "\[Beta]tilde"}], ")"}], " ", 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "m"}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"1", "+", "m", "+", "\[Alpha]"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"1", "+", "\[Beta]", "-", "\[Beta]tilde"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"1", "+", "m", "+", "n", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"2", "+", 
       RowBox[{"2", " ", "m"}], "+", "\[Alpha]", "+", "\[Beta]tilde"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.520535005603076*^9, 3.520624615537736*^9, 3.543316452333787*^9, 
   3.543319561065377*^9, 3.545640596932213*^9, {3.545640722300191*^9, 
   3.5456407548088627`*^9}, 3.5472817215693417`*^9, 3.547283854052642*^9, 
   3.5484023002801857`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "n"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520534416999947*^9, 3.520534417454349*^9}}],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}], 
  RowBox[{"2", " ", "n"}]]], "Output",
 CellChangeTimes->{3.5205344181103163`*^9, 3.520624615564239*^9, 
  3.5433164523670597`*^9, 3.543319561105899*^9, 3.545640605726549*^9, 
  3.5456407578431473`*^9, 3.5472817216102133`*^9, 3.547283854088395*^9, 
  3.548402300301375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3DCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n"}], ",", 
     RowBox[{"2", "*", "n"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"And", 
     StyleBox["[", "Code"], 
     RowBox[{
      RowBox[{"Element", "[", 
       RowBox[{"n", ",", "Integers"}], "]"}], ",", 
      RowBox[{"n", "\[GreaterEqual]", " ", "0"}]}], "]"}]}]}], " ", 
  "]"}]], "Input",
 CellChangeTimes->{{3.545641036105526*^9, 3.545641072370854*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.545641037598274*^9, 3.545641074639215*^9, 
  3.5472817216602917`*^9, 3.547283854137925*^9, 3.548402300331975*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520534424351489*^9, 3.520534426333893*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"m", "+", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", "-", "\[Beta]tilde"}], ")"}], " ", 
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "m"}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"1", "+", "m", "+", "\[Alpha]"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"1", "+", "\[Beta]", "-", "\[Beta]tilde"}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "m", "+", "n"}]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"2", "+", "m", "+", "n", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}], " ", 
    RowBox[{"Pochhammer", "[", 
     RowBox[{
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "m"}], "+", "\[Alpha]", "+", "\[Beta]tilde"}], ",", 
      RowBox[{
       RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.520534426785232*^9, 3.520624615594057*^9, 
  3.5433164524076977`*^9, 3.5433195611385307`*^9, 3.545640622255402*^9, 
  3.5456407615311403`*^9, 3.547281721711149*^9, 3.547283854175837*^9, 
  3.548402300370575*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1AlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5205344305110826`*^9, 3.520534433701458*^9}}],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}], 
  RowBox[{"2", " ", "n"}]]], "Output",
 CellChangeTimes->{3.5205344343551607`*^9, 3.5206246156227407`*^9, 
  3.5433164524569407`*^9, 3.54331956116683*^9, 3.54564062469058*^9, 
  3.5456407659492207`*^9, 3.5472817217604322`*^9, 3.547283854204439*^9, 
  3.548402300399304*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1AlayaMaroni3DCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]tilde"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"And", 
     StyleBox["[", "Code"], 
     RowBox[{
      RowBox[{"Element", "[", 
       RowBox[{"n", ",", "Integers"}], "]"}], ",", 
      RowBox[{"n", "\[GreaterEqual]", " ", "0"}]}], "]"}]}]}], " ", 
  "]"}]], "Input",
 CellChangeTimes->{{3.545641036105526*^9, 3.545641072370854*^9}, {
  3.545641110490314*^9, 3.545641113400144*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.545641114168837*^9, 3.547281721807345*^9, 
  3.547283854255603*^9, 3.548402300433185*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nDemonstration of the direct closed formulas for  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",\ntranslated by the commands ",
 StyleBox["SC1AlayaMaroni3DCC[\[Alpha], \[Beta]][",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   OverscriptBox["\[Beta]", "~"], TraditionalForm]],
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, {3.457351508577216*^9, 3.457351538077633*^9}, 
   3.457423674423217*^9, {3.457425152875874*^9, 3.457425278358103*^9}, {
   3.4612649649532347`*^9, 3.461264988795329*^9}, {3.467190396484603*^9, 
   3.467190433280266*^9}, {3.519673654034919*^9, 3.51967368018394*^9}, {
   3.5196737297416162`*^9, 3.519674067904241*^9}, 3.519757157766913*^9, 
   3.519757418383697*^9, {3.519847994824523*^9, 3.519847995013687*^9}, {
   3.52053101915196*^9, 3.520531062030089*^9}, {3.520531100740471*^9, 
   3.520531103555662*^9}, {3.520531165608007*^9, 3.520531176190943*^9}, {
   3.520532848894144*^9, 3.5205328686230307`*^9}, {3.52053448555576*^9, 
   3.5205344952828817`*^9}, {3.5347574849974422`*^9, 3.534757485931456*^9}, {
   3.534767612663451*^9, 3.5347676139685793`*^9}, {3.534844154253694*^9, 
   3.534844154910206*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationSymDCC", "[", 
       StyleBox["SC1AlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "]"}], "[", 
      RowBox[{
       StyleBox[
        RowBox[{
         StyleBox["SC1AlayaMaroni3",
          FontWeight->"Bold",
          FontSlant->"Italic"], "C"}]], ",", 
       StyleBox[
        RowBox[{
         StyleBox["SC1AlayaMaroni3",
          FontWeight->"Bold",
          FontSlant->"Italic"], "C"}]]}], "]"}], "[", 
     RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
    RowBox[{"\[Alpha]", ",", 
     OverscriptBox["\[Beta]", "~"]}], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4219689682529163`*^9, 3.421969026997492*^9}, 
   3.4573515919389563`*^9, 3.458301984477057*^9, {3.4590210893451366`*^9, 
   3.459021095824616*^9}, 3.481873084937743*^9, 3.4818731152814083`*^9, {
   3.519674082970256*^9, 3.5196741201769857`*^9}, {3.519674256127205*^9, 
   3.51967425857292*^9}, {3.519757157863042*^9, 3.519757157932767*^9}, {
   3.52045225333709*^9, 3.5204522823865433`*^9}, {3.5205311842641783`*^9, 
   3.520531204901926*^9}, {3.520532880719212*^9, 3.5205328957176733`*^9}, {
   3.520534505364127*^9, 3.520534512796282*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.07260800000006`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4219690681587677`*^9, 3.42196946705931*^9, 3.42197029629172*^9, 
   3.421970758437779*^9, 3.422140197685143*^9, 3.4221412931574287`*^9, 
   3.4221417047348833`*^9, 3.422142349161212*^9, 3.422142979078932*^9, 
   3.457423992642181*^9, 3.457427490533082*^9, 3.458632865729512*^9, 
   3.458633200087824*^9, 3.458635549426002*^9, 3.4590184328730593`*^9, 
   3.4590187192864017`*^9, 3.4590194952376747`*^9, 3.459019613224717*^9, 
   3.4590199029261913`*^9, 3.459020509059804*^9, 3.459020704766768*^9, 
   3.459021096804945*^9, 3.459495137791923*^9, 3.460976186794701*^9, 
   3.461925143833646*^9, 3.46719351853379*^9, 3.490794034865858*^9, 
   3.494243115644041*^9, 3.49467400041648*^9, 3.519674231525779*^9, 
   3.5196753621433563`*^9, 3.519675646941469*^9, 3.5197513221932087`*^9, 
   3.5197527908495483`*^9, 3.519753101388179*^9, 3.5197539269181423`*^9, 
   3.519754054779262*^9, 3.519754172486393*^9, 3.519754367135702*^9, 
   3.5197544524001207`*^9, 3.519754530256029*^9, 3.5197545979212923`*^9, 
   3.519754713954843*^9, 3.5197550378666983`*^9, 3.51975508523842*^9, 
   3.519755323324548*^9, 3.5197553873733597`*^9, 3.519755525814096*^9, {
   3.5197556148788433`*^9, 3.519755619152976*^9}, {3.5197570989684677`*^9, 
   3.519757117792098*^9}, 3.519837994405672*^9, 3.519849398146454*^9, 
   3.52045230083996*^9, {3.520453118253792*^9, 3.520453141434527*^9}, {
   3.520453443987664*^9, 3.520453447003766*^9}, 3.5205312109750233`*^9, 
   3.520533645948724*^9, 3.520534681553899*^9, 3.520624940752816*^9, 
   3.533505577397909*^9, 3.533506039932952*^9, 3.534757571538732*^9, 
   3.543316460803817*^9, 3.5433195693655663`*^9, 3.5435767711867647`*^9, 
   3.545640641581147*^9, 3.545640769936577*^9, 3.5456463038306828`*^9, 
   3.5456471558084373`*^9, 3.5472817308629017`*^9, 3.547283863228705*^9, 
   3.5484023095252323`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Canonical polynomials in terms of ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["Alaya and Maroni",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" polynomials (case 3)\n",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
   3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
   3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
   3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460529160209412*^9, 
   3.460529160850732*^9}, {3.460538651644092*^9, 3.460538676771216*^9}, {
   3.479035782738468*^9, 3.479035797646721*^9}, {3.512329140345154*^9, 
   3.512329145004119*^9}, {3.512329766737885*^9, 3.512329784644944*^9}, {
   3.512406427220812*^9, 3.512406427412525*^9}, {3.512406853011129*^9, 
   3.512406856031934*^9}, {3.518032577350299*^9, 3.5180325851017647`*^9}, {
   3.5193198498900833`*^9, 3.519319851246088*^9}, {3.519472114886042*^9, 
   3.5194721300893497`*^9}, 3.519757188094317*^9, {3.5203600079204903`*^9, 
   3.5203600193201714`*^9}, {3.5203605508659277`*^9, 3.520360551409883*^9}, {
   3.520443676164715*^9, 3.520443676317663*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X\[LeftArrow]  P(\[Alpha], \[Beta] ) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)10",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials \nand ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomial of class 1 (case 3",
 StyleBox[") [5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.460703558359393*^9, 3.460703582905768*^9}, {
   3.460709308139473*^9, 3.460709310009841*^9}, {3.460709341217023*^9, 
   3.4607093669130898`*^9}, {3.461263959510046*^9, 3.4612639603397837`*^9}, {
   3.461264072541415*^9, 3.461264073679305*^9}, {3.467190233198913*^9, 
   3.467190237595634*^9}, 3.467190533567293*^9, {3.512383428550292*^9, 
   3.5123835155068197`*^9}, {3.512383594183024*^9, 3.5123836009043207`*^9}, {
   3.512388619037654*^9, 3.512388619499806*^9}, {3.51240591835634*^9, 
   3.512405932425798*^9}, {3.512406324948008*^9, 3.5124063250998907`*^9}, {
   3.518032591920138*^9, 3.5180325983148737`*^9}, {3.518033025891184*^9, 
   3.518033050683169*^9}, {3.5193198724238167`*^9, 3.519319874084853*^9}, {
   3.51947271288958*^9, 3.519472721156192*^9}, 3.519757188168783*^9, {
   3.520360091127276*^9, 3.520360137758408*^9}, {3.520443685716442*^9, 
   3.520443686068348*^9}, {3.534757907361191*^9, 3.534757912525978*^9}, {
   3.545641208789134*^9, 3.545641216571069*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{"CanonicalC", ",", 
         StyleBox[
          RowBox[{
           StyleBox["SC1AlayaMaroni3",
            FontWeight->"Bold",
            FontSlant->"Italic"], "C"}]]}], "]"}], "[", "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.518033073178225*^9, 
   3.5180330985259647`*^9}, {3.519319880257361*^9, 3.5193198823356743`*^9}, {
   3.519472729097375*^9, 3.519472755902769*^9}, 3.519757161446986*^9, {
   3.5203601694816628`*^9, 3.520360177165729*^9}, {3.520360215637947*^9, 
   3.520360216387754*^9}, {3.5203605064665127`*^9, 3.520360507648303*^9}, 
   3.5204435812682867`*^9}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{"1", "+", "\[Beta]"}], 
      RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{"2", "+", "\[Beta]"}], 
      RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", "1", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {(1 + $CellContext`\[Beta])/(
     2 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta])/(
     3 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (
      2 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     3 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     2 (2 + $CellContext`\[Beta])/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     2 (3 + $CellContext`\[Beta])/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (3 + $CellContext`\[Beta])/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (4 + $CellContext`\[Beta])/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (4 + $CellContext`\[Beta])/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (5 + $CellContext`\[Beta])/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     5 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     10 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     10 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     5 (5 + $CellContext`\[Beta])/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}}]]], "Output",
 CellChangeTimes->{
  3.518033100294477*^9, 3.5193198956392307`*^9, {3.519472740729369*^9, 
   3.519472757193699*^9}, 3.5194995697705936`*^9, 3.519751499792259*^9, {
   3.520360185109179*^9, 3.52036021687846*^9}, 3.520360316075857*^9, {
   3.520360501669035*^9, 3.520360508512259*^9}, 3.520529168166503*^9, 
   3.520530665747985*^9, 3.5206197227149343`*^9, 3.5206197560508413`*^9, 
   3.53476184697018*^9, 3.543319574936681*^9, 3.543574578442624*^9, 
   3.547281731249457*^9, 3.547283863599163*^9, 3.548402309912353*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{"CanonicalC", ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n"}], ",", 
     RowBox[{"2", "*", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.518033073178225*^9, 
   3.5180330985259647`*^9}, {3.519319880257361*^9, 3.5193198823356743`*^9}, {
   3.519472729097375*^9, 3.519472755902769*^9}, 3.519757161446986*^9, {
   3.5203601694816628`*^9, 3.520360177165729*^9}, {3.520360215637947*^9, 
   3.520360216387754*^9}, {3.5203605064665127`*^9, 3.520360507648303*^9}, 
   3.5204435812682867`*^9, {3.52044700441854*^9, 3.5204470208806343`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "\[Beta]"}], 
      RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.520447016443226*^9, 3.5204470217975388`*^9}, 
   3.5206197561188993`*^9, 3.534761850224503*^9, 3.543319574982155*^9, 
   3.5435745785187407`*^9, 3.54728173128778*^9, 3.547283863635483*^9, 
   3.548402309948001*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{"CanonicalC", ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.518033073178225*^9, 
   3.5180330985259647`*^9}, {3.519319880257361*^9, 3.5193198823356743`*^9}, {
   3.519472729097375*^9, 3.519472755902769*^9}, 3.519757161446986*^9, {
   3.5203601694816628`*^9, 3.520360177165729*^9}, {3.520360215637947*^9, 
   3.520360216387754*^9}, {3.5203605064665127`*^9, 3.520360507648303*^9}, 
   3.5204435812682867`*^9, {3.52044700441854*^9, 3.5204470208806343`*^9}, {
   3.5204476981484013`*^9, 3.520447701486128*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2", "+", "\[Beta]"}], 
      RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}]], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.5204477025561237`*^9, 3.5206197562318983`*^9, 
  3.534761854556356*^9, 3.5433195750842247`*^9, 3.543574578620557*^9, 
  3.547281731390725*^9, 3.547283863735284*^9, 3.548402310053287*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X \[LeftArrow]  ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["P(\[Alpha], \[Beta] )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed recursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command, up to ",
 StyleBox["n=20.",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomial of class 1 (case 3",
 StyleBox[") [5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.456184437961193*^9, 3.4561845022291403`*^9}, {
   3.456184823849684*^9, 3.456184825038542*^9}, {3.456184855520928*^9, 
   3.456184861948104*^9}, {3.456185190476099*^9, 3.456185193970113*^9}, 
   3.457349397471188*^9, 3.4592078813280582`*^9, {3.460703632944169*^9, 
   3.460703657035294*^9}, {3.4671902440556393`*^9, 3.467190247992935*^9}, 
   3.467190529398933*^9, {3.51240630201429*^9, 3.512406302270212*^9}, {
   3.512406444723329*^9, 3.51240645798737*^9}, {3.518033144323909*^9, 
   3.518033161044032*^9}, 3.519319949114842*^9, {3.519472795611246*^9, 
   3.519472807597275*^9}, 3.519757188239194*^9, 3.5203602405730762`*^9, {
   3.520443699758922*^9, 3.520443700139419*^9}, {3.534761863182125*^9, 
   3.534761863524394*^9}, 3.534761894637582*^9, {3.545641233317462*^9, 
   3.5456412487768507`*^9}, 3.545734840469178*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"verificationRCC", "[", 
       RowBox[{"CanonicalC", ",", 
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]]}], "]"}], "[", "]"}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "20", "]"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.457349409694415*^9, 3.457349423527529*^9}, 3.457349545602831*^9, {
   3.460703665295685*^9, 3.460703693285269*^9}, {3.51239397216394*^9, 
   3.5123940019021797`*^9}, {3.5123971803459*^9, 3.5123971839105883`*^9}, {
   3.512397224157185*^9, 3.5123972267644653`*^9}, 3.512406643828631*^9, {
   3.512406710206408*^9, 3.512406717140712*^9}, {3.518033170586432*^9, 
   3.518033183959866*^9}, 3.519319964313765*^9, {3.519320078452696*^9, 
   3.519320079465597*^9}, {3.5194728199787683`*^9, 3.519472823871892*^9}, 
   3.5197571616641493`*^9, {3.5203602512107573`*^9, 3.520360261690131*^9}, 
   3.520443581369652*^9, {3.520529174921893*^9, 3.520529186968923*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"121.47542900000008`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561813422335443`*^9, {3.456181862350334*^9, 
   3.456181875527793*^9}, 3.457349515845791*^9, 3.4574239911194963`*^9, 
   3.457427486142767*^9, 3.458632643325539*^9, 3.458633159648718*^9, 
   3.458635239152103*^9, 3.459018420198572*^9, 3.4594951349756937`*^9, 
   3.459500447950799*^9, 3.460704539761251*^9, 3.460976092350943*^9, 
   3.4619250497740183`*^9, 3.467193299671495*^9, 3.4790362190710382`*^9, 
   3.511274428561335*^9, 3.511275498310877*^9, 3.511282776778036*^9, {
   3.512394010930922*^9, 3.5123940366263323`*^9}, 3.512397247203294*^9, 
   3.512406651851366*^9, 3.51240672381938*^9, 3.5180333889026747`*^9, 
   3.519320109661171*^9, 3.5194728265162573`*^9, 3.5194995718999043`*^9, 
   3.5197515005355177`*^9, 3.520360264589354*^9, 3.520360297745739*^9, 
   3.520360514142334*^9, 3.520529183510223*^9, 3.520529307164609*^9, 
   3.5205307898828573`*^9, 3.520619883958251*^9, 3.5347619916492147`*^9, 
   3.5433196961730328`*^9, 3.543574699943265*^9, 3.547281852799622*^9, 
   3.547283984675272*^9, 3.548402431702512*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1CanonicalAlayaMaroni3DCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1CanonicalAlayaMaroni3DCC[][\[Alpha], \
\[Beta]][n,m] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "computes the connection coefficient\n",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X  \[LeftArrow] P(\[Alpha], \[Beta]; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the\n",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomials of class 1 (case 3) ",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", \nusing the direct closed formulas infered from the above results \
produced by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command.",
 StyleBox["\n\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["\[Beta]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData[
  StyleBox["P",
   FontWeight->"Bold",
   FontSlant->"Italic"]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they must be integers.\n",
 StyleBox["\nResult:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{"n", ",", "m"}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.456096403535576*^9, 3.456096442960013*^9}, {
   3.456096581303585*^9, 3.4560966241370497`*^9}, {3.456096959294372*^9, 
   3.456096964619895*^9}, {3.456097131617483*^9, 3.456097232106226*^9}, {
   3.456097385726853*^9, 3.456097780575531*^9}, {3.456097821173479*^9, 
   3.4560978926713943`*^9}, {3.456098416156371*^9, 3.4560984298819847`*^9}, {
   3.456167890266185*^9, 3.456167909936418*^9}, {3.45617962300206*^9, 
   3.4561796232642317`*^9}, {3.4561838919482327`*^9, 3.4561839083776493`*^9}, 
   3.456183955183276*^9, {3.4564290995662746`*^9, 3.456429143641636*^9}, {
   3.45642939823965*^9, 3.456429446127708*^9}, {3.457346833585137*^9, 
   3.457346890771364*^9}, {3.4573473153253517`*^9, 3.457347425772792*^9}, {
   3.457347462006422*^9, 3.45734746646975*^9}, {3.4573475322062817`*^9, 
   3.4573475512242327`*^9}, {3.457347769880492*^9, 3.4573477727562027`*^9}, {
   3.45734920808046*^9, 3.4573492150973597`*^9}, {3.4574237350349092`*^9, 
   3.457423777988903*^9}, {3.4583016381228857`*^9, 3.45830169535877*^9}, {
   3.459207635137308*^9, 3.459207643204852*^9}, {3.459207810722887*^9, 
   3.459207820128861*^9}, {3.459208006601474*^9, 3.459208007820826*^9}, 
   3.459208049257409*^9, {3.459493593039909*^9, 3.459493629066636*^9}, {
   3.460618669100176*^9, 3.46061879440434*^9}, {3.460618833767291*^9, 
   3.460618834226411*^9}, {3.4606188823463907`*^9, 3.46061890626653*^9}, {
   3.460618936961111*^9, 3.460618940971817*^9}, 3.460702767740107*^9, {
   3.4607028005996313`*^9, 3.4607028420662117`*^9}, {3.460709054102902*^9, 
   3.4607090626562033`*^9}, {3.461263768323636*^9, 3.461263779938589*^9}, 
   3.4641418373424*^9, {3.464291310770895*^9, 3.464291314991865*^9}, {
   3.467190194653721*^9, 3.4671902014266777`*^9}, 3.4671905454051437`*^9, {
   3.512328838134057*^9, 3.512328922760606*^9}, {3.5123289535192127`*^9, 
   3.512329101062057*^9}, {3.512329810065218*^9, 3.512329814667152*^9}, 
   3.512383072827989*^9, 3.5124054292405577`*^9, {3.5124057075252523`*^9, 
   3.512405724324067*^9}, {3.51240580876766*^9, 3.5124058118938427`*^9}, {
   3.512406010971093*^9, 3.512406026226222*^9}, {3.512406430036735*^9, 
   3.512406430276598*^9}, {3.518028248166874*^9, 3.5180284771411657`*^9}, {
   3.518028520311255*^9, 3.518028655177333*^9}, {3.518028690816325*^9, 
   3.518028763026177*^9}, {3.51802960827759*^9, 3.518029611323441*^9}, {
   3.518033466416016*^9, 3.518033467763632*^9}, {3.5180345594949093`*^9, 
   3.518034567175651*^9}, 3.518034613901154*^9, {3.5180347253310204`*^9, 
   3.5180348336781693`*^9}, {3.51941093393808*^9, 3.519410996350327*^9}, {
   3.5194110338983803`*^9, 3.51941109816108*^9}, 3.5194111459175377`*^9, {
   3.519411375633428*^9, 3.519411403621278*^9}, {3.519412012793817*^9, 
   3.519412020036879*^9}, {3.519412337688258*^9, 3.519412354504672*^9}, {
   3.5194692724836082`*^9, 3.519469282468873*^9}, {3.519471224845841*^9, 
   3.51947127028883*^9}, {3.519471304874926*^9, 3.519471341243886*^9}, {
   3.519493043136072*^9, 3.5194931974380417`*^9}, {3.5194938071265287`*^9, 
   3.519493811525936*^9}, {3.519494813314101*^9, 3.519494813809854*^9}, {
   3.519499621285934*^9, 3.5194996238027067`*^9}, {3.5194999112328377`*^9, 
   3.519499930823393*^9}, {3.5195799767652483`*^9, 3.51957997763912*^9}, {
   3.5195803074748497`*^9, 3.5195803126576*^9}, {3.519580411437797*^9, 
   3.519580429594145*^9}, {3.5195806002076693`*^9, 3.519580813241967*^9}, {
   3.5195810724063187`*^9, 3.519581092537472*^9}, {3.519583094536153*^9, 
   3.5195831230328283`*^9}, {3.5197571558097887`*^9, 3.519757155896903*^9}, 
   3.519757384052429*^9, {3.519844754127471*^9, 3.5198447998349257`*^9}, {
   3.520450775580883*^9, 3.520450860010335*^9}, {3.520529626722495*^9, 
   3.5205296787523003`*^9}, {3.5347619016095448`*^9, 3.534761901916387*^9}, {
   3.5456412775065947`*^9, 3.545641294748457*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"n_", "/;", 
       RowBox[{"IntegerQ", "[", "n", "]"}]}], ",", 
      RowBox[{"m_", "/;", 
       RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], "=", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n1", ",", "m1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]}], ";", 
        RowBox[{"m1", "=", 
         RowBox[{"Quotient", "[", 
          RowBox[{"m", ",", "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", " ", "\[IndentingNewLine]", "\t", 
         RowBox[{
          RowBox[{"Or", "[", 
           RowBox[{
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"EvenQ", "[", "n", "]"}], ",", 
              RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"And", "[", 
             RowBox[{
              RowBox[{"OddQ", "[", "n", "]"}], ",", 
              RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
            RowBox[{"n", "<", "0"}], ",", 
            RowBox[{"m", "<", "0"}], ",", 
            RowBox[{"m", ">", "n"}]}], "]"}], ",", " ", "\[IndentingNewLine]",
           "\t\t", 
          RowBox[{"Return", "[", "0", "]"}], ",", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"EvenQ", "[", "n", "]"}], ",", 
            RowBox[{"EvenQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", "\[IndentingNewLine]", 
            "\t\t\t    ", 
            RowBox[{
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m1", "+", "1"}], ",", "n1"}], "}"}]}], "]"}], "/", 
             "\[IndentingNewLine]", 
             "\[NonBreakingSpace]                           ", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{
                  RowBox[{"2", "*", "m1"}], "+", "2"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "1"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}], ",", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "\t", 
          RowBox[{"And", "[", 
           RowBox[{
            RowBox[{"OddQ", "[", "n", "]"}], ",", 
            RowBox[{"OddQ", "[", "m", "]"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\t\t", 
          RowBox[{"Return", "[", "\[NonBreakingSpace]", 
           RowBox[{
            RowBox[{"Binomial", "[", 
             RowBox[{"n1", ",", "m1"}], "]"}], "*", "\[IndentingNewLine]", 
            "\t\t\t    ", 
            RowBox[{
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{"m1", "+", "2"}], ",", 
                 RowBox[{"n1", "+", "1"}]}], "}"}]}], "]"}], "/", 
             "\[IndentingNewLine]", 
             "\[NonBreakingSpace]                           ", 
             RowBox[{"Product", "[", 
              RowBox[{
               RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", 
                 RowBox[{
                  RowBox[{"2", "*", "m1"}], "+", "3"}], ",", 
                 RowBox[{"n1", "+", "m1", "+", "2"}]}], "}"}]}], "]"}]}]}], 
           "\[IndentingNewLine]", "\t\t\t    ", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], 
      RowBox[{"(*", " ", 
       RowBox[{"end", " ", "of", " ", "Which"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"end", " ", "of", " ", "Module"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.400452759660624*^9, 3.400452760193726*^9}, {
   3.460618217925473*^9, 3.460618279112927*^9}, {3.460618406882461*^9, 
   3.4606184492486887`*^9}, 3.460618513254024*^9, {3.461263833101872*^9, 
   3.461263849135838*^9}, {3.512329830392654*^9, 3.512329836593623*^9}, {
   3.512329903129181*^9, 3.5123299068879128`*^9}, {3.512329947374423*^9, 
   3.512329997447112*^9}, {3.512330028301688*^9, 3.5123301129978037`*^9}, {
   3.512330152725288*^9, 3.512330276924534*^9}, {3.512330317820643*^9, 
   3.512330444909276*^9}, {3.512330495363944*^9, 3.512330638112714*^9}, {
   3.512330702494276*^9, 3.512330852602721*^9}, {3.512330939725462*^9, 
   3.512331082596624*^9}, {3.512331301779955*^9, 3.512331333243409*^9}, {
   3.512331540606143*^9, 3.512331607014184*^9}, {3.5123316488378477`*^9, 
   3.5123316505573587`*^9}, {3.512331693002837*^9, 3.5123317354794827`*^9}, 
   3.512331785956175*^9, {3.51238015782869*^9, 3.5123801612996387`*^9}, {
   3.512380192018229*^9, 3.512380192928463*^9}, {3.512380333422009*^9, 
   3.5123803413258543`*^9}, {3.51238052769803*^9, 3.512380540439457*^9}, {
   3.5123806028671837`*^9, 3.5123806340331783`*^9}, {3.512382405467901*^9, 
   3.512382406873871*^9}, {3.512382717382518*^9, 3.512382752820456*^9}, {
   3.51238279526624*^9, 3.512382836694922*^9}, {3.512388000087888*^9, 
   3.5123880187935658`*^9}, {3.512388316674268*^9, 3.512388326903895*^9}, {
   3.512388523125185*^9, 3.512388552079053*^9}, 3.512393696962242*^9, {
   3.512393746260998*^9, 3.512393749452236*^9}, {3.5123966167802467`*^9, 
   3.5123966518797493`*^9}, {3.51239690900182*^9, 3.5123969414835*^9}, {
   3.5123970568698072`*^9, 3.512397082869409*^9}, {3.512397524429351*^9, 
   3.512397588029807*^9}, {3.51240437367793*^9, 3.512404386426743*^9}, {
   3.512404657817034*^9, 3.512404783149716*^9}, {3.51240485627293*^9, 
   3.512404893566217*^9}, {3.512404942378972*^9, 3.512405053460487*^9}, {
   3.512405407348139*^9, 3.512405409893429*^9}, {3.512405495156528*^9, 
   3.512405498452251*^9}, 3.512405607463504*^9, {3.512406032651773*^9, 
   3.51240604108302*^9}, 3.512406105157406*^9, {3.518028774969323*^9, 
   3.51802880981861*^9}, {3.518029614498234*^9, 3.518029616106409*^9}, {
   3.518029712805765*^9, 3.518029831967381*^9}, {3.518029881700182*^9, 
   3.518029884339715*^9}, {3.518030373473522*^9, 3.5180304989584093`*^9}, {
   3.518030589972753*^9, 3.518030597291349*^9}, 3.518030634219652*^9, {
   3.518031640752247*^9, 3.518031708071742*^9}, {3.5180318051156063`*^9, 
   3.518031809564804*^9}, {3.518032342234042*^9, 3.5180323429785423`*^9}, {
   3.518033609763501*^9, 3.518033623339281*^9}, {3.518033657310204*^9, 
   3.51803369685161*^9}, {3.518033730769665*^9, 3.518033736887821*^9}, {
   3.518033814156055*^9, 3.518033866895206*^9}, {3.5180339472284946`*^9, 
   3.518033995350499*^9}, {3.518034027925219*^9, 3.51803411461226*^9}, {
   3.5180342357697477`*^9, 3.5180343807144003`*^9}, {3.518110439032362*^9, 
   3.518110571302125*^9}, {3.518110618317313*^9, 3.51811067213057*^9}, {
   3.518110873751232*^9, 3.5181109999817944`*^9}, {3.5181111536810493`*^9, 
   3.518111160150035*^9}, {3.518111194020623*^9, 3.518111202587914*^9}, {
   3.518111260265943*^9, 3.518111272432006*^9}, 3.518111335017764*^9, {
   3.518111409428422*^9, 3.518111412345791*^9}, {3.519469313613496*^9, 
   3.519469455951632*^9}, {3.519469562523449*^9, 3.51946973480604*^9}, {
   3.5194697692248287`*^9, 3.519469857068819*^9}, {3.5194698927896852`*^9, 
   3.5194699903673677`*^9}, {3.5194700224445477`*^9, 3.519470049448662*^9}, {
   3.519470096816676*^9, 3.5194701273641787`*^9}, {3.5194704097233152`*^9, 
   3.5194705729708233`*^9}, {3.5194706055298653`*^9, 3.519470690382963*^9}, {
   3.519470728151087*^9, 3.519470730390251*^9}, {3.519470886059144*^9, 
   3.519470895430389*^9}, {3.519471502792811*^9, 3.519471507551765*^9}, {
   3.5194930152232313`*^9, 3.5194930189246187`*^9}, {3.519493219829631*^9, 
   3.5194933556642447`*^9}, {3.519493393263516*^9, 3.5194934905839443`*^9}, {
   3.519493672949585*^9, 3.519493694176408*^9}, {3.519493796475787*^9, 
   3.519493800113587*^9}, {3.5195808456225367`*^9, 3.5195808822687883`*^9}, {
   3.519581027561227*^9, 3.5195810689344788`*^9}, {3.519581351338389*^9, 
   3.5195813642740097`*^9}, {3.51958148288535*^9, 3.519581512527005*^9}, {
   3.519581617813072*^9, 3.519581736205668*^9}, {3.519581783320011*^9, 
   3.519581789646843*^9}, {3.519581822245473*^9, 3.5195823027098*^9}, {
   3.5195823951946077`*^9, 3.519582395759663*^9}, {3.519582490410535*^9, 
   3.5195824906334267`*^9}, {3.5195825654265137`*^9, 3.519582604917769*^9}, {
   3.519582678714427*^9, 3.519582679289406*^9}, {3.519582714533202*^9, 
   3.519582736825494*^9}, {3.519582835315584*^9, 3.5195828371529913`*^9}, {
   3.519757155988873*^9, 3.519757156124826*^9}, {3.5204509074270687`*^9, 
   3.520450934155868*^9}, {3.520450976037558*^9, 3.520451058851269*^9}, {
   3.52045109709942*^9, 3.5204511558212337`*^9}, {3.520451190460783*^9, 
   3.5204512267528067`*^9}, {3.520454269133164*^9, 3.5204542835728617`*^9}, {
   3.520454451011463*^9, 3.520454461225176*^9}, {3.52052969361096*^9, 
   3.5205297642194643`*^9}, {3.5205298034109163`*^9, 3.520529817120062*^9}}],

Cell["\<\
______________________________________________________________________________\
________________\
\>", "Text",
 CellChangeTimes->{{3.520533200151054*^9, 3.520533232945114*^9}, {
   3.520534975977826*^9, 3.520534980271619*^9}, 3.520535070979505*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", 
      RowBox[{"n", ",", "m"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
   "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.519583152148408*^9, 3.519583198066728*^9}, 
   3.5197571562254353`*^9, 3.5204514065806103`*^9, {3.52052986891962*^9, 
   3.5205298878210487`*^9}, {3.5205308307346497`*^9, 3.5205308312602577`*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{"1", "+", "\[Beta]"}], 
      RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{"2", "+", "\[Beta]"}], 
      RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", "1", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}]], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {(1 + $CellContext`\[Beta])/(
     2 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta])/(
     3 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (
      2 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     3 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     2 (2 + $CellContext`\[Beta])/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     2 (3 + $CellContext`\[Beta])/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (3 + $CellContext`\[Beta])/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (4 + $CellContext`\[Beta])/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (4 + $CellContext`\[Beta])/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     4 (5 + $CellContext`\[Beta])/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       2 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     5 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     10 (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     10 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     5 (5 + $CellContext`\[Beta])/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}}]]], "Output",
 CellChangeTimes->{{3.519583187864048*^9, 3.519583199635601*^9}, 
   3.519583941893343*^9, 3.519675280938596*^9, 3.519751177385318*^9, 
   3.519837951945984*^9, 3.519849303651927*^9, 3.520451410601124*^9, 
   3.520454309044628*^9, 3.520454469994938*^9, {3.5205298892084846`*^9, 
   3.520529897316255*^9}, 3.520530042388172*^9, {3.520530811190405*^9, 
   3.520530832311303*^9}, 3.52061988404386*^9, 3.534761991803434*^9, 
   3.543319696272674*^9, 3.543574700047657*^9, 3.547281852899432*^9, 
   3.547283984755458*^9, 3.548402431782851*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta] ; -) \[LeftArrow]  X )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " produced by the command \n",
 StyleBox["SC1CanonicalAlayaMaroni3DCC[][\[Alpha],\[Beta]][n,m],",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " up to",
 StyleBox[" n=30",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.456183497787829*^9, 
   3.4561835281771593`*^9}, {3.456185123836526*^9, 3.4561851627212553`*^9}, 
   3.460704954146987*^9, {3.4671901313567266`*^9, 3.467190135304528*^9}, {
   3.479028670542183*^9, 3.479028675434106*^9}, {3.47910882985538*^9, 
   3.47910888644587*^9}, 3.479109070590269*^9, {3.479109715149744*^9, 
   3.479109716605257*^9}, 3.4791221340671453`*^9, {3.519583238617446*^9, 
   3.5195832739966497`*^9}, {3.51958433109713*^9, 3.519584332830352*^9}, {
   3.519584759238078*^9, 3.51958475997099*^9}, 3.519757156295761*^9, 
   3.519757395776733*^9, {3.520451498304049*^9, 3.520451515671486*^9}, {
   3.520529906398739*^9, 3.520529918790266*^9}, {3.5456413144416523`*^9, 
   3.5456413253522873`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"verificationDCC", "[", 
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], 
        StyleBox["]",
         FontWeight->"Bold",
         FontSlant->"Italic"]}], "[", 
       RowBox[{"CanonicalC", ",", "SC1AlayaMaroni3C"}], "]"}], 
      StyleBox["[",
       FontWeight->"Bold",
       FontSlant->"Italic"], 
      StyleBox["]",
       FontWeight->"Bold",
       FontSlant->"Italic"]}], "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "30", "]"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.456180748433251*^9, 3.456180767313106*^9}, {3.456180917263891*^9, 
   3.45618091829984*^9}, {3.4561832954033203`*^9, 3.456183300773457*^9}, 
   3.458302049606372*^9, {3.479028677507305*^9, 3.479028705649743*^9}, {
   3.47902956954272*^9, 3.479029586922673*^9}, {3.479029644031522*^9, 
   3.479029646605801*^9}, {3.479030939830699*^9, 3.47903094085384*^9}, {
   3.479108773882*^9, 3.479108800926409*^9}, 3.479108912015623*^9, {
   3.479108991075418*^9, 3.479108998865038*^9}, 3.479109740341483*^9, {
   3.479122150184525*^9, 3.47912217491066*^9}, {3.479122331065977*^9, 
   3.4791223321527243`*^9}, {3.479457757667802*^9, 3.479457758785578*^9}, {
   3.519583305750209*^9, 3.519583368506013*^9}, 3.519583644513597*^9, {
   3.519584294197721*^9, 3.519584336304592*^9}, {3.519757156396832*^9, 
   3.519757156463912*^9}, {3.520451427195571*^9, 3.5204514933507338`*^9}, {
   3.520529931026504*^9, 3.520529947552643*^9}, {3.520530846282995*^9, 
   3.520530846666935*^9}, {3.520530918113022*^9, 3.520530928117487*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.9466169999999465`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.520530057804606*^9, 3.520530847430902*^9, {3.520530921741027*^9, 
   3.520530936928639*^9}, 3.5206198912105503`*^9, 3.534762001619129*^9, 
   3.5433197031779757`*^9, 3.54357470697269*^9, 3.54728185983609*^9, 
   3.547283991676749*^9, 3.548402438735017*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Command:\nSC1CanonicalAlayaMaroni3DCC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1CanonicalAlayaMaroni3DCC[][\[Alpha],\[Beta]][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " translates the definitions of the connection coefficients\n ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( X \[LeftArrow]  P(\[Alpha], \[Beta] ; -) )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 Cell[BoxData[
  RowBox[{"P", " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " \n monic semi-classical polynomials of class 1 (case 3)",
 StyleBox["[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", for ",
 StyleBox["n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and ",
 StyleBox["m",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 StyleBox["symbolic",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", in order to be used in calling \n statements of the ",
 StyleBox["demonstrationSymCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command.\n",
 StyleBox["\nArguments:\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" \[Alpha] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "and",
 StyleBox[" ",
  FontWeight->"Bold"],
 StyleBox["\[Beta]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " are the parameters of ",
 Cell[BoxData["P"],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".",
 StyleBox["\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "-",
 StyleBox[" n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " and",
 StyleBox[" m ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "are the indexes, they should be symbols.",
 StyleBox["\n\nResults:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n- ",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.456180542628393*^9}, {3.456180602783188*^9, 
   3.456180604649598*^9}, {3.4561822019635983`*^9, 3.456182212633822*^9}, {
   3.456182246475658*^9, 3.456182324389946*^9}, {3.456182362729306*^9, 
   3.456182397689868*^9}, {3.4561825177026854`*^9, 3.4561828017076187`*^9}, {
   3.456183069933147*^9, 3.456183163670642*^9}, 3.456183780902816*^9, {
   3.456184556036704*^9, 3.456184580913746*^9}, {3.456184634967795*^9, 
   3.456184652137188*^9}, {3.45734969246879*^9, 3.457349804757008*^9}, {
   3.45735140713972*^9, 3.457351407528389*^9}, {3.457424015433811*^9, 
   3.457424019897767*^9}, 3.4574248506658497`*^9, {3.4574249110866747`*^9, 
   3.457424941812604*^9}, {3.45742532604984*^9, 3.457425328718508*^9}, {
   3.458301846429578*^9, 3.458301848803665*^9}, {3.459206934894661*^9, 
   3.459206935313037*^9}, {3.459207075845229*^9, 3.459207080901113*^9}, {
   3.4592072425801*^9, 3.459207445351715*^9}, 3.4592079216793823`*^9, {
   3.459208083864663*^9, 3.4592080848420362`*^9}, {3.4594940809507113`*^9, 
   3.459494093356348*^9}, {3.459494147042548*^9, 3.459494163725823*^9}, {
   3.46070922863503*^9, 3.460709234659382*^9}, {3.461264927963533*^9, 
   3.461264930287938*^9}, 3.46414189761309*^9, {3.467190375251593*^9, 
   3.467190384412608*^9}, {3.467190444412822*^9, 3.467190465917828*^9}, {
   3.490793108422368*^9, 3.490793126794648*^9}, {3.494242918657694*^9, 
   3.494242935431642*^9}, {3.494567185910108*^9, 3.4945671873633633`*^9}, {
   3.5196721733672943`*^9, 3.519672486895392*^9}, {3.519757156534348*^9, 
   3.519757156614551*^9}, 3.519757187642535*^9, {3.5197574012100697`*^9, 
   3.519757404882127*^9}, {3.520451568327733*^9, 3.520451748970605*^9}, {
   3.520528830094516*^9, 3.52052884222297*^9}, {3.5205288893138943`*^9, 
   3.5205289190815496`*^9}, {3.520529083213235*^9, 3.520529091644556*^9}, {
   3.520529155180623*^9, 3.52052915814589*^9}, 3.534761936260748*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", "0"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", "]"}], "[", 
       RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", "0"}], "]"}], "=", 
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], "/", 
      "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "2", ",", 
          RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"2", "*", "n_"}], ",", 
      RowBox[{"2", "*", "m_"}]}], "]"}], ":=", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", "]"}], "[", 
       RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
      RowBox[{
       RowBox[{"2", "*", "n"}], ",", 
       RowBox[{"2", "*", "m"}]}], "]"}], "=", "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"n", ",", "m"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"m", "+", "1"}], ",", "n"}], "}"}]}], "]"}], "/", 
       "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "2"}], ",", 
           RowBox[{"n", "+", "m", "+", "1"}]}], "}"}]}], "]"}]}]}]}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"2", "*", "n_"}]}], ",", "1"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["SC1CanonicalAlayaMaroni3DCC",
         FontWeight->"Bold",
         FontSlant->"Italic"], "[", "]"}], "[", 
       RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "n"}]}], ",", "1"}], "]"}], "=", 
     "\[IndentingNewLine]", "\t       ", 
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "2", ",", 
          RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}], "/", 
      "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "3", ",", 
          RowBox[{"n", "+", "2"}]}], "}"}]}], "]"}]}]}]}], ";"}], "  ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["SC1CanonicalAlayaMaroni3DCC",
       FontWeight->"Bold",
       FontSlant->"Italic"], "[", "]"}], "[", 
     RowBox[{"\[Alpha]_", ",", " ", "\[Beta]_"}], "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n_"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m_"}], "+", "1"}]}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "[", "]"}], "[", 
      RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
      RowBox[{
       RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], "=", 
    "\[IndentingNewLine]", "\t\t", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "m"}], "]"}], "*", "\[IndentingNewLine]", "\t       ", 
     RowBox[{
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{"m", "+", "2"}], ",", 
          RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}], "/", 
      "\[IndentingNewLine]", "\[NonBreakingSpace]            ", 
      RowBox[{"Product", "[", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", "\[Beta]", "+", "k"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", 
          RowBox[{
           RowBox[{"2", "*", "m"}], "+", "3"}], ",", 
          RowBox[{"n", "+", "m", "+", "2"}]}], "}"}]}], "]"}]}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.519672540790855*^9, 3.519672620606463*^9}, {
   3.519672660659555*^9, 3.519672815676425*^9}, {3.519672867492116*^9, 
   3.519672965851141*^9}, {3.519673025481772*^9, 3.5196730775881853`*^9}, {
   3.519673182247911*^9, 3.5196732629520884`*^9}, {3.519673441886232*^9, 
   3.5196734898119287`*^9}, {3.5196735981626043`*^9, 3.519673613461866*^9}, {
   3.519674803019085*^9, 3.519674810978073*^9}, {3.5197557705668592`*^9, 
   3.519755801099286*^9}, {3.5197558312817373`*^9, 3.519755879030051*^9}, {
   3.519757156695562*^9, 3.519757156894589*^9}, {3.520451780398472*^9, 
   3.520451938634066*^9}, {3.52052895884242*^9, 3.5205289831463423`*^9}, {
   3.520529105478305*^9, 3.5205291363124933`*^9}, {3.5205294250216293`*^9, 
   3.520529463249786*^9}, {3.5205294997855*^9, 3.520529508102705*^9}, {
   3.5206185714655733`*^9, 3.520618754374702*^9}, {3.520620147216316*^9, 
   3.520620337470804*^9}, {3.520620773022258*^9, 3.520620780196747*^9}, {
   3.520621833380093*^9, 3.520621861527856*^9}, {3.520622690316893*^9, 
   3.5206226907656612`*^9}, {3.534844185829397*^9, 3.534844188395969*^9}, {
   3.54357443292342*^9, 3.543574442770433*^9}, {3.543575073761653*^9, 
   3.5435751768689547`*^9}, {3.5435753266677217`*^9, 
   3.5435753551497583`*^9}, {3.5435754017602158`*^9, 
   3.5435754064557943`*^9}, {3.5435761412148*^9, 3.5435761701875257`*^9}, {
   3.543576200807249*^9, 3.543576293724966*^9}, {3.5435768226517963`*^9, 
   3.543576834266862*^9}, {3.545641386732252*^9, 3.545641411534972*^9}, {
   3.545644397357586*^9, 3.545644446182384*^9}, {3.545644726819037*^9, 
   3.54564473776856*^9}, 3.545644970914572*^9, {3.545645014508773*^9, 
   3.545645016962175*^9}}],

Cell["\<\
______________________________________________________________________________\
___________________\
\>", "Text",
 CellChangeTimes->{{3.520452055448897*^9, 3.5204520793507223`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "m"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520267756443`*^9}, {
  3.5205311161944637`*^9, 3.520531123114295*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "m"}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "m", "+", "\[Beta]"}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}], 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "m"}], "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
    RowBox[{
     RowBox[{"-", "m"}], "+", "n"}]}], "]"}]]], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452028158291*^9}, 3.5205284210309*^9, 
   3.520531124086391*^9, 3.52061989133014*^9, 3.5206204651250677`*^9, 
   3.534762001918827*^9, 3.543319703342038*^9, 3.543574707400421*^9, 
   3.5435752154584846`*^9, 3.5435753594026117`*^9, 3.5456443844954987`*^9, 
   3.545644453432651*^9, 3.545644770628034*^9, 3.547281859993371*^9, 
   3.5472839917755537`*^9, 3.548402438796262*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{3.545644782139599*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "\[Beta]"}], ",", "n"}], "]"}]}], 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
    RowBox[{"1", "+", "n"}]}], "]"}]]], "Output",
 CellChangeTimes->{3.545644782820334*^9, 3.547281860030369*^9, 
  3.5472839918105927`*^9, 3.548402438826634*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{"2", "*", "n"}], ",", 
   RowBox[{"2", "*", "n"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520364790487`*^9}, {
  3.52053113170539*^9, 3.52053113448694*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452038348626*^9}, 3.520531135170835*^9, 
   3.520619891365136*^9, 3.520620469027083*^9, 3.534762001969016*^9, 
   3.543319703377585*^9, 3.543574707440733*^9, 3.54357521922768*^9, 
   3.545644461988583*^9, 3.547281860081204*^9, 3.547283991848342*^9, 
   3.548402438853676*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520267756443`*^9}, {
  3.520452123443119*^9, 3.520452129792938*^9}, {3.5205311395352707`*^9, 
  3.5205311446223383`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "m"}], "]"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"2", "+", "m", "+", "\[Beta]"}], ",", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "n"}]}], "]"}]}], 
  RowBox[{"Pochhammer", "[", 
   RowBox[{
    RowBox[{"3", "+", 
     RowBox[{"2", " ", "m"}], "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
    RowBox[{
     RowBox[{"-", "m"}], "+", "n"}]}], "]"}]]], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452028158291*^9}, 3.520452130337281*^9, 
   3.5205311451790667`*^9, 3.52061989141328*^9, 3.53476200522644*^9, 
   3.543319703512381*^9, 3.543574707520898*^9, 3.54564447384941*^9, 
   3.5456447727963247`*^9, 3.547281860132884*^9, 3.547283991894821*^9, 
   3.548402438894903*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{3.5457349533659286`*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "\[Beta]"}], ",", 
     RowBox[{"1", "+", "n"}]}], "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], ",", 
     RowBox[{"2", "+", "n"}]}], "]"}]}]]], "Output",
 CellChangeTimes->{3.545734953980012*^9, 3.5472818601826973`*^9, 
  3.547283991927549*^9, 3.548402438922847*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    StyleBox["SC1CanonicalAlayaMaroni3DCC",
     FontWeight->"Bold",
     FontSlant->"Italic"], "[", "]"}], 
   StyleBox["[",
    FontWeight->"Bold",
    FontSlant->"Italic"], 
   RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"2", "*", "n"}], "+", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.520452007802772*^9, 3.5204520267756443`*^9}, {
  3.520452123443119*^9, 3.520452140208335*^9}, {3.520531151480242*^9, 
  3.5205311553496323`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{
  3.5197522033118267`*^9, 3.519837978753191*^9, 3.519849329625605*^9, {
   3.52045201278032*^9, 3.520452028158291*^9}, {3.520452130337281*^9, 
   3.520452140927631*^9}, 3.520528432450037*^9, 3.520531155954335*^9, 
   3.520619891467745*^9, 3.534762005286047*^9, 3.543319703550606*^9, 
   3.543574707570724*^9, 3.545644482437769*^9, 3.547281860232777*^9, 
   3.547283991965662*^9, 3.548402438955935*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nDemonstration of the direct closed formulas for  ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{
     RowBox[{"2", "n"}], ",", 
     RowBox[{"2", "m"}]}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",  ",
 Cell[BoxData[
  SubscriptBox["\[Lambda]", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ",", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}]}]]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ",\ntranslated by the commands ",
 StyleBox["SC1CanonicalAlayaMaroni3DCC[][\[Alpha], \[Beta]][n,m]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.45618072285388*^9, 3.4561807432466307`*^9}, {
   3.456182837555313*^9, 3.456182875129499*^9}, {3.45618348411018*^9, 
   3.456183488189213*^9}, {3.456183542192712*^9, 3.4561835644352503`*^9}, {
   3.456183614671237*^9, 3.456183630415698*^9}, {3.456184740424855*^9, 
   3.4561847439156218`*^9}, {3.456184774460842*^9, 3.456184777695949*^9}, 
   3.456185170092537*^9, {3.457351508577216*^9, 3.457351538077633*^9}, 
   3.457423674423217*^9, {3.457425152875874*^9, 3.457425278358103*^9}, {
   3.4612649649532347`*^9, 3.461264988795329*^9}, {3.467190396484603*^9, 
   3.467190433280266*^9}, {3.519673654034919*^9, 3.51967368018394*^9}, {
   3.5196737297416162`*^9, 3.519674067904241*^9}, 3.519757157766913*^9, 
   3.519757418383697*^9, {3.519847994824523*^9, 3.519847995013687*^9}, {
   3.52053101915196*^9, 3.520531062030089*^9}, {3.520531100740471*^9, 
   3.520531103555662*^9}, {3.520531165608007*^9, 3.520531176190943*^9}, {
   3.534762021253291*^9, 3.53476202210752*^9}, 3.534767655137802*^9, {
   3.534844196402863*^9, 3.534844196907048*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"demonstrationSymDCC", "[", 
       StyleBox["SC1CanonicalAlayaMaroni3DCC",
        FontWeight->"Bold",
        FontSlant->"Italic"], "]"}], "[", 
      RowBox[{"CanonicalC", ",", 
       StyleBox[
        RowBox[{
         StyleBox["SC1AlayaMaroni3",
          FontWeight->"Bold",
          FontSlant->"Italic"], "C"}]]}], "]"}], "[", "]"}], "[", 
    RowBox[{"\[Alpha]", ",", " ", "\[Beta]"}], "]"}], "[", 
   RowBox[{"n", ",", "m"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.4219689682529163`*^9, 3.421969026997492*^9}, 
   3.4573515919389563`*^9, 3.458301984477057*^9, {3.4590210893451366`*^9, 
   3.459021095824616*^9}, 3.481873084937743*^9, 3.4818731152814083`*^9, {
   3.519674082970256*^9, 3.5196741201769857`*^9}, {3.519674256127205*^9, 
   3.51967425857292*^9}, {3.519757157863042*^9, 3.519757157932767*^9}, {
   3.52045225333709*^9, 3.5204522823865433`*^9}, {3.5205311842641783`*^9, 
   3.520531204901926*^9}, {3.520621316480495*^9, 3.520621341340343*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.5203679999999622`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4219690681587677`*^9, 3.42196946705931*^9, 3.42197029629172*^9, 
   3.421970758437779*^9, 3.422140197685143*^9, 3.4221412931574287`*^9, 
   3.4221417047348833`*^9, 3.422142349161212*^9, 3.422142979078932*^9, 
   3.457423992642181*^9, 3.457427490533082*^9, 3.458632865729512*^9, 
   3.458633200087824*^9, 3.458635549426002*^9, 3.4590184328730593`*^9, 
   3.4590187192864017`*^9, 3.4590194952376747`*^9, 3.459019613224717*^9, 
   3.4590199029261913`*^9, 3.459020509059804*^9, 3.459020704766768*^9, 
   3.459021096804945*^9, 3.459495137791923*^9, 3.460976186794701*^9, 
   3.461925143833646*^9, 3.46719351853379*^9, 3.490794034865858*^9, 
   3.494243115644041*^9, 3.49467400041648*^9, 3.519674231525779*^9, 
   3.5196753621433563`*^9, 3.519675646941469*^9, 3.5197513221932087`*^9, 
   3.5197527908495483`*^9, 3.519753101388179*^9, 3.5197539269181423`*^9, 
   3.519754054779262*^9, 3.519754172486393*^9, 3.519754367135702*^9, 
   3.5197544524001207`*^9, 3.519754530256029*^9, 3.5197545979212923`*^9, 
   3.519754713954843*^9, 3.5197550378666983`*^9, 3.51975508523842*^9, 
   3.519755323324548*^9, 3.5197553873733597`*^9, 3.519755525814096*^9, {
   3.5197556148788433`*^9, 3.519755619152976*^9}, {3.5197570989684677`*^9, 
   3.519757117792098*^9}, 3.519837994405672*^9, 3.519849398146454*^9, 
   3.52045230083996*^9, {3.520453118253792*^9, 3.520453141434527*^9}, {
   3.520453443987664*^9, 3.520453447003766*^9}, 3.5205312109750233`*^9, 
   3.5206198992242537`*^9, 3.520620998322904*^9, {3.520621053079232*^9, 
   3.5206210742141523`*^9}, 3.5206212034747334`*^9, 3.5206212428332644`*^9, 
   3.520621328665353*^9, {3.520621900639575*^9, 3.5206219360339947`*^9}, 
   3.533506084147787*^9, 3.534762030292944*^9, 3.54331970522402*^9, 
   3.543574712746706*^9, 3.543574757671523*^9, 3.54357493809422*^9, 
   3.543575268234129*^9, 3.543575602527577*^9, 3.543576846810988*^9, 
   3.545644588237627*^9, 3.545644931492899*^9, 3.545644976589592*^9, 
   3.545646425222938*^9, 3.5456471712647543`*^9, 3.547281861758546*^9, 
   3.5472839934590473`*^9, 3.548402440494985*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Alaya and Maroni",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox[" polynomials (case 3) in terms of canonical polynomials\n",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsubsection",
 CellChangeTimes->{{3.455999406140938*^9, 3.4559994171377087`*^9}, {
   3.456099245982315*^9, 3.456099250448112*^9}, {3.4573468227181997`*^9, 
   3.457346828264802*^9}, {3.459023380434758*^9, 3.4590233923629837`*^9}, {
   3.4592068440110207`*^9, 3.459206844531361*^9}, {3.460529160209412*^9, 
   3.460529160850732*^9}, {3.460538651644092*^9, 3.460538676771216*^9}, {
   3.479035782738468*^9, 3.479035797646721*^9}, {3.512329140345154*^9, 
   3.512329145004119*^9}, {3.512329766737885*^9, 3.512329784644944*^9}, {
   3.512406427220812*^9, 3.512406427412525*^9}, {3.512406789470221*^9, 
   3.512406789956813*^9}, {3.512406913063662*^9, 3.512406933114687*^9}, 
   3.519319987102524*^9, {3.519472135529723*^9, 3.5194721421926517`*^9}, 
   3.5195001494434147`*^9, 3.5197571882867327`*^9, {3.520360541629219*^9, 
   3.5203605421389027`*^9}, {3.520443678364436*^9, 3.520443678508419*^9}}],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["P(\[Alpha], \[Beta] )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["\[LeftArrow] X  )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ,  ",
  FontWeight->"Bold"],
 StyleBox["n=0(1)7",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed by the ",
 StyleBox["CC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "command",
 StyleBox[", ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "where ",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials \nand ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomial of class 1 (case 3",
 StyleBox[") [5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561838087435207`*^9, 
   3.456183813952264*^9}, {3.45618424450836*^9, 3.456184381623825*^9}, {
   3.456533139597863*^9, 3.456533152366724*^9}, {3.457349185152617*^9, 
   3.457349191013109*^9}, {3.457350134576707*^9, 3.45735013519596*^9}, {
   3.4592078680917997`*^9, 3.459207868881755*^9}, 3.459207967845901*^9, {
   3.4592080635876102`*^9, 3.459208064026883*^9}, {3.459493745744158*^9, 
   3.459493747691848*^9}, {3.460703558359393*^9, 3.460703582905768*^9}, {
   3.460709308139473*^9, 3.460709310009841*^9}, {3.460709341217023*^9, 
   3.4607093669130898`*^9}, {3.461263959510046*^9, 3.4612639603397837`*^9}, {
   3.461264072541415*^9, 3.461264073679305*^9}, {3.467190233198913*^9, 
   3.467190237595634*^9}, 3.467190533567293*^9, {3.512383428550292*^9, 
   3.5123835155068197`*^9}, {3.512383594183024*^9, 3.5123836009043207`*^9}, {
   3.512388619037654*^9, 3.512388619499806*^9}, {3.51240591835634*^9, 
   3.512405932425798*^9}, {3.512406324948008*^9, 3.5124063250998907`*^9}, {
   3.512407729313406*^9, 3.5124077359739313`*^9}, {3.5180331917046556`*^9, 
   3.518033201752944*^9}, 3.519319998455806*^9, {3.519472840314834*^9, 
   3.5194728473100653`*^9}, 3.519757188366353*^9, 3.520360407625703*^9, {
   3.5204437132611322`*^9, 3.52044371341849*^9}, {3.534762064513421*^9, 
   3.534762068590219*^9}, 3.545645058381584*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CC", "[", 
        RowBox[{
         StyleBox[
          RowBox[{
           StyleBox["SC1AlayaMaroni3",
            FontWeight->"Bold",
            FontSlant->"Italic"], "C"}]], ",", "CanonicalC"}], "]"}], "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "]"}], "[", 
     RowBox[{"n", ",", "m"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}], "//", 
  "\[IndentingNewLine]", "TableForm"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5124077410732822`*^9, 
   3.512407757743208*^9}, {3.51803321283259*^9, 3.518033229797803*^9}, {
   3.518033286531896*^9, 3.518033289473917*^9}, 3.519320010951548*^9, {
   3.5193200848248777`*^9, 3.519320088464459*^9}, {3.51947285813732*^9, 
   3.519472872957786*^9}, 3.5197571618641768`*^9, {3.520360359024139*^9, 
   3.520360368763872*^9}, 3.5204435814698257`*^9, 3.520445572890256*^9}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[Beta]"}], 
       RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", "+", "\[Beta]"}], 
       RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>", "\<\"\"\>"},
    {"0", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", 
     "1", "\<\"\"\>"},
    {
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], "0", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], "0", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}]]}], "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{1}, {0, 
    1}, {-(1 + $CellContext`\[Beta])/(
     2 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, -(2 + $CellContext`\[Beta])/(
     3 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (
      2 + $CellContext`\[Beta]) (
       3 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-2) (2 + $CellContext`\[Beta])/(
     4 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-2) (3 + $CellContext`\[Beta])/(
     5 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {-(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       4 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-3) (3 + $CellContext`\[Beta])/(
     6 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, -(2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     3 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-3) (4 + $CellContext`\[Beta])/(
     7 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       5 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-4) (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-4) (4 + $CellContext`\[Beta])/(
     8 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}, {
    0, (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-4) (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     6 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-4) (5 + $CellContext`\[Beta])/(
     9 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     1}, {-(1 + $CellContext`\[Beta]) (2 + $CellContext`\[Beta]) (
      3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       6 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     5 (2 + $CellContext`\[Beta]) (3 + $CellContext`\[Beta]) (
      4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       7 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-10) (3 + $CellContext`\[Beta]) (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       8 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 
     10 (4 + $CellContext`\[Beta]) (
      5 + $CellContext`\[Beta]) (
       9 + $CellContext`\[Alpha] + $CellContext`\[Beta])^(-1)/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 
     0, (-5) (5 + $CellContext`\[Beta])/(
     10 + $CellContext`\[Alpha] + $CellContext`\[Beta]), 0, 1}}]]], "Output",
 CellChangeTimes->{
  3.518033291976727*^9, 3.519320276401919*^9, {3.51947286899758*^9, 
   3.5194728745582933`*^9}, 3.519499572948694*^9, 3.5197515352179317`*^9, 
   3.520360369962575*^9, 3.520445574010001*^9, 3.520528118621462*^9, 
   3.5206234948476057`*^9, 3.534762077511722*^9, 3.543319705598301*^9, 
   3.5472818621236353`*^9, 3.547283993809043*^9, 3.5484024408813877`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", "CanonicalC"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "]"}], "[", 
    RowBox[{
     RowBox[{"2", "*", "n"}], ",", 
     RowBox[{"2", "*", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5124077410732822`*^9, 
   3.512407757743208*^9}, {3.51803321283259*^9, 3.518033229797803*^9}, {
   3.518033286531896*^9, 3.518033289473917*^9}, 3.519320010951548*^9, {
   3.5193200848248777`*^9, 3.519320088464459*^9}, {3.51947285813732*^9, 
   3.519472872957786*^9}, 3.5197571618641768`*^9, {3.520360359024139*^9, 
   3.520360368763872*^9}, 3.5204435814698257`*^9, {3.520445572890256*^9, 
   3.520445606373966*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[Beta]"}], 
       RowBox[{"2", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.520445601718092*^9, 3.520445607188712*^9}, 
   3.520623494944751*^9, 3.5347620799698353`*^9, 3.543319705635872*^9, 
   3.547281862173564*^9, 3.547283993847721*^9, 3.548402440916863*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", "CanonicalC"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "]"}], "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "*", "m"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.39292547748246*^9, 3.3929254774896297`*^9}, 
   3.3929346698865128`*^9, {3.456168523515086*^9, 3.456168524344268*^9}, {
   3.456169209537615*^9, 3.456169218058262*^9}, {3.4573492680366793`*^9, 
   3.457349301769301*^9}, {3.457349356895598*^9, 3.457349373320958*^9}, {
   3.457349557665288*^9, 3.4573495895816936`*^9}, {3.4607035944697647`*^9, 
   3.460703621267891*^9}, {3.467191330666403*^9, 3.467191331197106*^9}, {
   3.512383532044886*^9, 3.5123835471285467`*^9}, {3.51238360784724*^9, 
   3.5123836833753242`*^9}, {3.512388622484539*^9, 3.512388622899124*^9}, {
   3.512388673833817*^9, 3.512388676321733*^9}, 3.512397201241786*^9, 
   3.5124062693316593`*^9, 3.512406675418613*^9, {3.5124077410732822`*^9, 
   3.512407757743208*^9}, {3.51803321283259*^9, 3.518033229797803*^9}, {
   3.518033286531896*^9, 3.518033289473917*^9}, 3.519320010951548*^9, {
   3.5193200848248777`*^9, 3.519320088464459*^9}, {3.51947285813732*^9, 
   3.519472872957786*^9}, 3.5197571618641768`*^9, {3.520360359024139*^9, 
   3.520360368763872*^9}, 3.5204435814698257`*^9, {3.520445572890256*^9, 
   3.520445606373966*^9}, {3.5204465957026577`*^9, 3.5204466098034163`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", "+", "\[Beta]"}], 
       RowBox[{"3", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"7", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"5", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"4", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{"10", " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"10", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}], ")"}]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", "\[Beta]"}], ")"}]}], 
       RowBox[{"11", "+", "\[Alpha]", "+", "\[Beta]"}]]}], ",", "1"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5206234950465517`*^9, 3.534762099803236*^9, 
  3.543319705739567*^9, 3.547281862275483*^9, 3.547283993945594*^9, 
  3.548402441020159*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\nVerification of the",
 StyleBox[" ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["P(\[Alpha], \[Beta] )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" \[LeftArrow]  X )",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "computed recursively by the ",
 StyleBox["CC",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " command, up to ",
 StyleBox["n=20.",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " \n",
 StyleBox["X",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the canonical polynomials and ",
 StyleBox["P",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 " notes the ",
 StyleBox["Alaya",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["and",
  FontColor->GrayLevel[0]],
 StyleBox[" ",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 StyleBox["Maroni",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],
 " monic semi-classical polynomial of class 1 (case 3",
 StyleBox[")[5,6]",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 ".\n",
 StyleBox["___________________________________________________________________\
_____________________________",
  FontWeight->"Bold",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.4561673158844347`*^9, {3.456167767058833*^9, 3.4561677710484858`*^9}, {
   3.456168036284203*^9, 3.4561680412021713`*^9}, {3.456168134821238*^9, 
   3.456168164236377*^9}, {3.4561682718739843`*^9, 3.456168304123795*^9}, {
   3.456168362368804*^9, 3.456168407333006*^9}, {3.456168439968919*^9, 
   3.45616850055614*^9}, {3.456177917370041*^9, 3.4561779664397*^9}, {
   3.456178304162936*^9, 3.456178319425927*^9}, {3.4561801264978247`*^9, 
   3.456180210156637*^9}, {3.456180257452335*^9, 3.4561802872372923`*^9}, {
   3.456180445957172*^9, 3.4561804463594017`*^9}, {3.456180491510071*^9, 
   3.456180493690312*^9}, {3.456184437961193*^9, 3.4561845022291403`*^9}, {
   3.456184823849684*^9, 3.456184825038542*^9}, {3.456184855520928*^9, 
   3.456184861948104*^9}, {3.456185190476099*^9, 3.456185193970113*^9}, 
   3.457349397471188*^9, 3.4592078813280582`*^9, {3.460703632944169*^9, 
   3.460703657035294*^9}, {3.4671902440556393`*^9, 3.467190247992935*^9}, 
   3.467190529398933*^9, {3.51240630201429*^9, 3.512406302270212*^9}, {
   3.512406444723329*^9, 3.51240645798737*^9}, {3.5124078400322638`*^9, 
   3.512407847366231*^9}, {3.518033260908326*^9, 3.51803327066861*^9}, {
   3.519320039428406*^9, 3.519320044622868*^9}, {3.519472889569997*^9, 
   3.5194728949452677`*^9}, 3.519757188440897*^9, {3.520360415968734*^9, 
   3.520360427050939*^9}, {3.5204437180026007`*^9, 3.52044371825839*^9}, {
   3.5347621094817867`*^9, 3.534762113707695*^9}, 3.545645072818429*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Timing", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"verificationRCC", "[", 
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["SC1AlayaMaroni3",
           FontWeight->"Bold",
           FontSlant->"Italic"], "C"}]], ",", "CanonicalC"}], "]"}], "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "[", "]"}], "[", "20", 
    "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.392925893995387*^9, 3.392925918603496*^9}, {
   3.392926467932302*^9, 3.392926569375394*^9}, 3.392935894773592*^9, 
   3.442142393452833*^9, 3.445044236890649*^9, {3.456180092108357*^9, 
   3.456180098051878*^9}, {3.456180298647736*^9, 3.456180301430152*^9}, 
   3.4561803542827044`*^9, {3.456180387366889*^9, 3.456180411755897*^9}, {
   3.457349409694415*^9, 3.457349423527529*^9}, 3.457349545602831*^9, {
   3.460703665295685*^9, 3.460703693285269*^9}, {3.51239397216394*^9, 
   3.5123940019021797`*^9}, {3.5123971803459*^9, 3.5123971839105883`*^9}, {
   3.512397224157185*^9, 3.5123972267644653`*^9}, 3.512406643828631*^9, {
   3.512406710206408*^9, 3.512406717140712*^9}, {3.512407826331936*^9, 
   3.512407836538419*^9}, {3.518033311513459*^9, 3.518033323886902*^9}, 
   3.51932005275004*^9, {3.5194729040855923`*^9, 3.519472923961451*^9}, 
   3.519757162115798*^9, {3.520360378834139*^9, 3.520360391897276*^9}, 
   3.520443581569558*^9, {3.520453667014344*^9, 3.52045366773131*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"119.54374799999994`", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{
  3.456167436959506*^9, 3.456180104249721*^9, 3.456180356800641*^9, 
   3.456180398573226*^9, 3.4561813422335443`*^9, {3.456181862350334*^9, 
   3.456181875527793*^9}, 3.457349515845791*^9, 3.4574239911194963`*^9, 
   3.457427486142767*^9, 3.458632643325539*^9, 3.458633159648718*^9, 
   3.458635239152103*^9, 3.459018420198572*^9, 3.4594951349756937`*^9, 
   3.459500447950799*^9, 3.460704539761251*^9, 3.460976092350943*^9, 
   3.4619250497740183`*^9, 3.467193299671495*^9, 3.4790362190710382`*^9, 
   3.511274428561335*^9, 3.511275498310877*^9, 3.511282776778036*^9, {
   3.512394010930922*^9, 3.5123940366263323`*^9}, 3.512397247203294*^9, 
   3.512406651851366*^9, 3.51240672381938*^9, 3.51240785715903*^9, 
   3.518033379078639*^9, 3.5193203623674297`*^9, 3.5194729171402607`*^9, 
   3.51947295249105*^9, 3.519499600920061*^9, 3.5197516200863*^9, 
   3.520360437540958*^9, 3.520453784645501*^9, 3.5205282695516233`*^9, 
   3.520623614077857*^9, 3.5347622391489058`*^9, 3.543319824958852*^9, 
   3.547281982398597*^9, 3.547284113418269*^9, 3.5484025605880947`*^9}]
}, Open  ]],

Cell[TextData[{
 StyleBox["___________________________________________________________________\
_____________________________\n",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["Command:",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n",
 StyleBox["SC1AlayaMaroni3CanonicalDCC ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "\n\n",
 StyleBox["Description:\nSC1AlayaMaroni3CanonicalDCC [\[Alpha], \
\[Beta]][][n,m] ",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 "computes the connection coefficient",
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]], " "}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[":=",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{" ", 
   SubscriptBox["\[Lambda]", 
    RowBox[{"n", ",", "m"}]]}]],
  CellChangeTimes->{{3.4559265110117083`*^9, 3.455926666238552*^9}, {
   3.455926740816263*^9, 3.4559267589890757`*^9}},
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox["( P(\[Alpha], \[Beta]; -) \[LeftArrow]  X )",
  Fon