!
!  Rename the specific names in interface blocks and modules for
!  LAPACK 3E.
!  E. Anderson, 07-22-02
!
      program rename
      integer, parameter :: nlen=80
      character*1 c1
      character*1 getmod
      character*80 aline, bline
      character*80 rtname
      integer rtlen, n, n2, pcount
      logical blank
      logical usetyp(4)
!
!  Read the rename.opts input file to determine which names to keep
!
      open(3,file='rename.opts')
      do i = 1, 4
         read(3,'(a1)') c1
         if( c1.eq.'t' .or. c1.eq.'T' .or. c1.eq.'y' .or. c1.eq.'Y' )
     &   then
            usetyp(i) = .true.
         else
            usetyp(i) = .false.
         end if
      end do
      istate = 0
      close(3)
!
!  Start of main loop
!
      blank = .false.
   10 continue
      read(*,'(a)',end=99) aline
!
!  Find the last non-blank
!
      do n = nlen, 1, -1
         if( aline(n:n).ne.' ' ) go to 20
      end do
      if( istate.lt.5 .and. .not.blank ) then
         blank = .true.
         write(*,*)
      end if
      go to 10
   20 continue
!
!  Find the first non-blank
!
      do i = 1, n-1
         if( aline(i:i).ne.' ' ) go to 30
      end do
   30 continue
      i1 = i
!
!  Print and return if the first non-blank is a comment or
!  continuation character
!
      c1 = aline(i1:i1)
      if( c1.eq.'!' .or. (i1.eq.1 .and.
     &   (c1.eq.'*' .or. c1.eq.'c' .or. c1.eq.'C'))  .or. i1.eq.6 ) then
         if( istate.lt.5 ) then
            write(*,'(a)') aline(1:n)
            blank = .false.
         end if
         go to 10
      end if
!
!  Otherwise find the extent of the first word on the line
!
   32 continue
      call getxts( aline, i, n, i1, i2 )
!
!  State 0:  top level
!  Look for the start of a SUBROUTINE or FUNCTION block or a PRIVATE
!  statement
!
      if( istate.eq.0 ) then
         if( aline(i1:i2).eq.'SUBROUTINE' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            call getsta( aline, i1, i2, usetyp, istate )
            istate = istate + 1
            call cvtnam( aline, i1, i2 )
         else if( aline(i1:i2).eq.'FUNCTION' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            if( i1.le.i2 ) then
!
!  Get stem of function name (to the first underscore)
!
               do i = i1, i2
                  if (aline(i:i).eq.'_') go to 35
               end do
   35          continue
               i2 = i-1
               rtname = aline(i1:i2)
               rtlen = i2-i1+1
            end if
            call getsta( aline, i1, i2, usetyp, istate )
            istate = istate + 2
            call cvtnam( aline, i1, i2 )
         else if( aline(i1:i2).eq.'PRIVATE' ) then
            bline = aline
            aline = ' '
            aline(1:i2) = bline(1:i2)
            pcount = 0
            n2 = i2+1
            i = i2+1
   40       continue
            call getxts( bline, i, n, i1, i2 )
            call getsta( bline, i1, i2, usetyp, istate )
            if( istate.eq.0 ) then
               call cvtnam( bline, i1, i2 )
               if( pcount.gt.0 ) then
                  aline(n2+1:n2+1) = ','
                  n2 = n2 + 2
               end if
               aline(n2+1:n2+1+i2-i1) = bline(i1:i2)
               pcount = pcount + 1
               n2 = n2 + 1 + i2 - i1
            end if
            do i = i2+1, n
               if( bline(i:i).ne.' ' .and. bline(i:i).ne.',')
     &            go to 40
            end do
            istate = 0
            n = n2
            if( pcount.eq.0 ) go to 10
         else if( aline(i1:i2).eq.'MODULE' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            if( aline(i1:i2).eq.'PROCEDURE' ) then
               call getxts( aline, i2+1, n, i1, i2 )
               call getsta( aline, i1, i2, usetyp, istate )
               call cvtnam( aline, i1, i2 )
               if( istate.gt.0 ) then
                  istate = 0
                  go to 10
               end if
            end if
         else if( aline(i1:i2).eq.'INTEGER' .OR.
     &            aline(i1:i2).eq.'LOGICAL' ) then
!
!           Could be a function, advance i1 and try again
!
            i = i2+1
            go to 32
         end if
      else if( istate.eq.1 .or. istate.eq.6 ) then
!
!  Inside a subroutine interface, look for CALL or END SUBROUTINE
!
         if( aline(i1:i2).eq.'CALL' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            call cvtnam( aline, i1, i2 )
         else if( aline(i1:i2).eq.'END' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            if( aline(i1:i2).eq.'SUBROUTINE' ) then
               call getxts( aline, i2+1, n, i1, i2 )
               call cvtnam( aline, i1, i2 )
               if( istate.eq.1 ) then
                  write(*,'(a)') aline(1:n)
                  blank = .false.
               else
                  blank = .true.
               end if
               istate = 0
               go to 10
            end if
         end if
      else if( istate.eq.2 .or. istate.eq.7 ) then
!
!  Inside a function interface, look for the function name or
!  END FUNCTION
!
         if( aline(i1:i2).eq.'END' ) then
            call getxts( aline, i2+1, n, i1, i2 )
            if( aline(i1:i2).eq.'FUNCTION' ) then
               call getxts( aline, i2+1, n, i1, i2 )
               call cvtnam( aline, i1, i2 )
               if( istate.eq.2 ) then
                  write(*,'(a)') aline(1:n)
                  blank = .false.
               else
                  blank = .true.
               end if
               istate = 0
               go to 10
            end if
         else
            c1 = rtname(1:1)
            i = i1
            if( i.gt.n-rtlen+1 ) go to 60
   50       continue
            if( aline(i:i).eq.c1 ) then
               if( aline(i:i+rtlen-1).eq.rtname(1:rtlen) ) then
                   call cvtnam( aline, i, i+rtlen-1 )
                   i = i + rtlen - 1
               end if
            end if
            i = i + 1
            if( i.le.n-rtlen+1 ) go to 50
   60       continue
         end if
      end if
      if( istate.lt.5 ) then
         write(*,'(a)') aline(1:n)
         blank = .false.
      end if
      go to 10
   99 continue
      end
      subroutine getxts( aline, i, n, i1, i2 )
      character*80 aline
      integer i, n, i1, i2
!
!  getxts gets the extents of the next word in aline(i:n)
!
      i2 = n
      do i1 = i, n
         if( aline(i1:i1).ne.' ' ) go to 10
      end do
   10 continue
      if( i1.le.n ) then
         do i2 = i1, n
            if( aline(i2:i2).eq.' ' .or. aline(i2:i2).eq.',' .or.
     &          aline(i2:i2).eq.'(' ) go to 20
         end do
   20    continue
         i2 = i2 - 1
      end if
      return
      end
      subroutine cvtnam( aline, i1, i2 )
      character*(*) aline
      integer i1, i2
      character*1 c1
      character, parameter :: s32='H'
      character, parameter :: s64='S'
      character, parameter :: c32='G'
      character, parameter :: c64='C'
!
!  Convert the leading character if S, D, C, or Z
!
      if( i1.gt.i2 ) return
      c1 = aline(i1:i1)
      if( c1.eq.'S' ) then
         aline(i1:i1) = s32
      else if( c1.eq.'D' ) then
         aline(i1:i1) = s64
      else if( c1.eq.'C' ) then
         aline(i1:i1) = c32
      else if( c1.eq.'Z' ) then
         aline(i1:i1) = c64
      end if
!
!  Special cases:  AMAX, ASUM, NRM2, ROT, SCAL, SUM1
!  Convert the second character too.
!
      if( aline(i1+2:i1+5).eq.'AMAX' .or.
     &    aline(i1+2:i1+5).eq.'ASUM' .or.
     &    aline(i1+2:i1+5).eq.'MAX1' .or.
     &    aline(i1+2:i1+5).eq.'NRM2' .or.
     &    aline(i1+2:i1+4).eq.'ROT'  .or.
     &    aline(i1+2:i1+5).eq.'RSCL' .or.
     &    aline(i1+2:i1+5).eq.'SCAL' .or.
     &    aline(i1+2:i1+5).eq.'SUM1' ) then
         c1 = aline(i1+1:i1+1)
         if( c1.eq.'S' ) then
            aline(i1+1:i1+1) = s32
         else if( c1.eq.'D' ) then
            aline(i1+1:i1+1) = s64
         else if( c1.eq.'C' ) then
            aline(i1+1:i1+1) = c32
         else if( c1.eq.'Z' ) then
            aline(i1+1:i1+1) = c64
         end if
      end if
      return
      end
      subroutine getsta( aline, i1, i2, usetyp, istate )
      character*(*) aline
      logical usetyp(*)
      integer istate
      character*1 c1
      character*2 c2
      istate = 5
      if( i1.gt.i2 ) return
      c1 = aline(i1:i1)
      if( c1.eq.'S' ) then
         if( usetyp(1) ) istate = 0
      else if( c1.eq.'D' ) then
         if( usetyp(2) ) istate = 0
      else if( c1.eq.'C' ) then
         if( usetyp(3) ) istate = 0
      else if( c1.eq.'Z' ) then
         if( usetyp(4) ) istate = 0
      else if( c1.eq.'I' .and. aline(i1+2:i1+5).eq.'AMAX' ) then
         c1 = aline(i1+1:i1+1)
         if( c1.eq.'S' .and. usetyp(1) ) then
            istate = 0
         else if( c1.eq.'D' .and. usetyp(2) ) then
            istate = 0
         else if( c1.eq.'C' .and. usetyp(3) ) then
            istate = 0
         else if( c1.eq.'Z' .and. usetyp(4) ) then
            istate = 0
         end if
      else if( c1.eq.'I' .and. aline(i1+2:i1+5).eq.'MAX1' ) then
         c1 = aline(i1+1:i1+1)
         if( c1.eq.'C' .and. usetyp(3) ) then
            istate = 0
         else if( c1.eq.'Z' .and. usetyp(4) ) then
            istate = 0
         end if
      else
!
!        If not a standard name, print it by default.
!
         istate = 0
      end if
!
!  Special cases ASUM, NRM2, SUM1 require that we look at 2nd character
!
      if( aline(i1+2:i1+5).eq.'ASUM' .or.
     &    aline(i1+2:i1+5).eq.'NRM2' .or.
     &    aline(i1+2:i1+5).eq.'SUM1' ) then
         istate = 5
         c2 = aline(i1:i1+1)
         if( c2.eq.'SC' .and. usetyp(3) ) then
            istate = 0
         else if( c2.eq.'DZ' .and. usetyp(4) ) then
            istate = 0
         end if
      end if
!
!  Special cases ROT, RSCL, SCAL require that we look at 2nd character
!
      if( aline(i1+2:i1+4).eq.'ROT' .or.
     &    aline(i1+2:i1+5).eq.'RSCL' .or.
     &    aline(i1+2:i1+5).eq.'SCAL' ) then
         istate = 5
         c2 = aline(i1:i1+1)
         if( c2.eq.'CS' .and. usetyp(3) ) then
            istate = 0
         else if( c2.eq.'ZD' .and. usetyp(4) ) then
            istate = 0
         end if
      end if
      return
      end
