      SUBROUTINE ZTRDT1( UPLO, N, A, LDA, Q, LDQ, D, E, T, LDT, WORK,
     $                   LWORK, RWORK, RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            LDA, LDQ, LDT, LWORK, N
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   D( * ), E( * ), RESULT( * ), RWORK( * )
      COMPLEX*16         A( LDA, * ), Q( LDQ, * ), T( LDT, * ),
     $                   WORK( LWORK )
*     ..
*
*  Purpose
*  =======
*
*  ZTRDT1 tests the reduction to tridiagonal form of an n-by-n symmetric
*  matrix A as computed by CHETRD, and the generation of the orthogonal
*  matrix from the reduction as computed by CUNGTR.
*
*  Given A, the diagonal D and offdiagonal E from the tridiagonal form,
*  and the orthogonal matrix Q, ZTRDT1 compares the tridiagonal matrix
*  with Q'*A*Q, and checks that the columns of Q are orthonormal.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          = 'U':  Upper triangle of A is stored;
*          = 'L':  Lower triangle of A is stored.
*
*  N       (input) INTEGER
*          The number of rows and columns of the original matrix A.
*          N >= 0.
*
*  A       (input) COMPLEX*16 array, dimension (LDA,N)
*          The initial n-by-n matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*
*  Q       (input) COMPLEX*16 array, dimension (LDQ,N)
*          The n-by-n orthogonal matrix Q, as returned by CUNGTR.
*
*  LDQ     (input) INTEGER
*          The leading dimension of the array Q.
*
*  D       (output) DOUBLE PRECISION array, dimension (N)
*          The diagonal elements of the tridiagonal matrix T, as
*          returned by CHETRD.
*
*  E       (output) DOUBLE PRECISION array, dimension (N-1)
*          The off-diagonal elements of the tridiagonal matrix T, as
*          returned by CHETRD.  If UPLO = 'U', E(i) = A(i,i+1) of the
*          reduced matrix, and if UPLO = 'L', E(i) = A(i+1,i).
*
*  T       (workspace) COMPLEX*16 array, dimension (LDT,N)
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T.
*
*  WORK    (workspace) COMPLEX*16 array, dimension (LWORK)
*
*  LWORK   (input) INTEGER
*          The length of WORK.  Assumed to be at least N*N.
*
*  RWORK   (workspace) DOUBLE PRECISION array, dimension (N)
*
*  RESULT  (output) DOUBLE PRECISION array, dimension (2)
*          The test ratios:
*          RESULT(1) = norm( H - Q'*A*Q ) / ( N * norm(A) * EPS )
*          RESULT(2) = norm( I - Q'*Q ) / ( N * EPS )
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX*16         ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, LDWORK
      DOUBLE PRECISION   ANORM, EPS, RESID
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMCH, ZLANGE, ZLANHE
      EXTERNAL           DLAMCH, ZLANGE, ZLANHE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZGEMM, ZUNT01, ZHEMM
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, DBLE
*     ..
*     .. Executable Statements ..
*
*     Compute A * Q
*
      LDWORK = MAX( 1, N )
      CALL ZHEMM( 'Left', UPLO, N, N, ONE, A, LDA, Q, LDQ, ZERO, WORK,
     $            LDWORK )
*
*     Compute Q' * (A * Q)
*
      CALL ZGEMM( 'Conjugate transpose', 'No transpose', N, N, N, ONE,
     $            Q, LDQ, WORK, LDWORK, ZERO, T, LDT )
*
*     Subtract the tridiagonal matrix.
*
      T( 1, 1 ) = T( 1, 1 ) - D( 1 )
      IF( N.GT.1 ) THEN
         T( 2, 1 ) = T( 2, 1 ) - E( 1 )
         T( N-1, N ) = T( N-1, N ) - E( N-1 )
         T( N, N ) = T( N, N ) - D( N )
      END IF
      DO 10 I = 2, N - 1
         T( I-1, I ) = T( I-1, I ) - E( I-1 )
         T( I, I ) = T( I, I ) - D( I )
         T( I+1, I ) = T( I+1, I ) - E( I )
   10 CONTINUE
*
*     Compute norm( T - Q'*A*Q ) / ( N * norm(A) * EPS ) .
*
      EPS = DLAMCH( 'Epsilon' )
      ANORM = ZLANHE( '1', UPLO, N, A, LDA, RWORK )
      RESID = ZLANGE( '1', N, N, T, LDT, RWORK )
      IF( ANORM.GT.0.0 ) THEN
         RESULT( 1 ) = ( ( RESID / DBLE( MAX( 1, N ) ) ) / ANORM ) / EPS
      ELSE
         RESULT( 1 ) = 0.0D0
      END IF
*
*     Compute norm( I - Q'*Q ) / ( N * EPS ) .
*
      CALL ZUNT01( 'Columns', N, N, Q, LDQ, WORK, LWORK, RWORK,
     $             RESULT( 2 ) )
      RETURN
*
*     End of ZTRDT1
*
      END
