      SUBROUTINE ZERRRD( PATH, NUNIT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  ZERRRD tests the error exits for the COMPLEX*16 reduction routines.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = ( NMAX+2 )*( NMAX+2 )+NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, IHI, ILO, INFO, J, NT
*     ..
*     .. Local Arrays ..
      DOUBLE PRECISION   D( NMAX ), E( NMAX ), S( NMAX )
      COMPLEX*16         A( NMAX, NMAX ), C( NMAX, NMAX ), TAU( NMAX ),
     $                   TP( NMAX ), TQ( NMAX ), W( NMAX ),
     $                   Z( NMAX, NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      EXTERNAL           LSAMEN
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, ZGEBAK, ZGEBAL, ZGEBRD, ZGEHRD,
     $                   ZHETRD, ZHPTRD, ZUNGBR, ZUNGHR, ZUNGTR, ZUNMBR,
     $                   ZUNMHR, ZUNMTR, ZUPGTR, ZUPMTR
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      ILO = 1
      IHI = 1
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / DBLE( I+J )
            C( I, J ) = 0.
   10    CONTINUE
   20 CONTINUE
      DO 30 J = 1, NMAX
         TAU( J ) = 1.
         TP( J ) = 1.
         TQ( J ) = 1.
   30 CONTINUE
      OK = .TRUE.
      NT = 0
*
      IF( LSAMEN( 3, PATH, 'HRD' ) ) THEN
*
*        Test error exits for the reduction to Hessenberg form for
*        the nonsymmetric eigenvalue problem.
*
*        ZGEBAL
*
         SRNAMT = 'ZGEBAL'
         INFOT = 1
         CALL ZGEBAL( '/', 0, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'ZGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGEBAL( 'N', -1, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'ZGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGEBAL( 'N', 2, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'ZGEBAL', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        ZGEBAK
*
         SRNAMT = 'ZGEBAK'
         INFOT = 1
         CALL ZGEBAK( '/', 'R', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGEBAK( 'N', '/', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGEBAK( 'N', 'R', -1, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGEBAK( 'N', 'R', 0, 0, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGEBAK( 'N', 'R', 0, 2, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZGEBAK( 'N', 'R', 2, 2, 1, S, 0, A, 2, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZGEBAK( 'N', 'R', 0, 1, 1, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZGEBAK( 'N', 'R', 0, 1, 0, S, -1, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ZGEBAK( 'N', 'R', 2, 1, 2, S, 0, A, 1, INFO )
         CALL CHKXER( 'ZGEBAK', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        ZGEHRD
*
         SRNAMT = 'ZGEHRD'
         INFOT = 1
         CALL ZGEHRD( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGEHRD( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGEHRD( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGEHRD( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZGEHRD( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZGEHRD( 2, 1, 1, A, 1, TAU, W, 2, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZGEHRD( 2, 1, 2, A, 2, TAU, W, 1, INFO )
         CALL CHKXER( 'ZGEHRD', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        ZUNGHR
*
         SRNAMT = 'ZUNGHR'
         INFOT = 1
         CALL ZUNGHR( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNGHR( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNGHR( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGHR( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGHR( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNGHR( 2, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNGHR( 3, 1, 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGHR', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        ZUNMHR
*
         SRNAMT = 'ZUNMHR'
         INFOT = 1
         CALL ZUNMHR( '/', 'N', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNMHR( 'L', '/', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNMHR( 'L', 'N', -1, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUNMHR( 'L', 'N', 0, -1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMHR( 'L', 'N', 0, 0, 0, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMHR( 'L', 'N', 0, 0, 2, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMHR( 'L', 'N', 1, 2, 2, 1, A, 1, TAU, C, 1, W, 2,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMHR( 'R', 'N', 2, 1, 2, 1, A, 1, TAU, C, 2, W, 2,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUNMHR( 'L', 'N', 1, 1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUNMHR( 'L', 'N', 0, 1, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUNMHR( 'R', 'N', 1, 0, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMHR( 'L', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMHR( 'R', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ZUNMHR( 'L', 'N', 2, 1, 1, 1, A, 2, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ZUNMHR( 'L', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ZUNMHR( 'R', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMHR', INFOT, NOUT, LERR, OK )
         NT = NT + 16
*
      ELSE IF( LSAMEN( 3, PATH, 'TRD' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        for the symmetric eigenvalue problem.
*
*        ZHETRD
*
         SRNAMT = 'ZHETRD'
         INFOT = 1
         CALL ZHETRD( '/', 0, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'ZHETRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZHETRD( 'U', -1, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'ZHETRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZHETRD( 'U', 2, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'ZHETRD', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        ZUNGTR
*
         SRNAMT = 'ZUNGTR'
         INFOT = 1
         CALL ZUNGTR( '/', 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNGTR( 'U', -1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUNGTR( 'U', 2, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZUNGTR( 'U', 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'ZUNGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        ZUNMTR
*
         SRNAMT = 'ZUNMTR'
         INFOT = 1
         CALL ZUNMTR( '/', 'U', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNMTR( 'L', '/', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNMTR( 'L', 'U', '/', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUNMTR( 'L', 'U', 'N', -1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMTR( 'L', 'U', 'N', 0, -1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZUNMTR( 'L', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ZUNMTR( 'R', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ZUNMTR( 'L', 'U', 'N', 2, 0, A, 2, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ZUNMTR( 'L', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ZUNMTR( 'R', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'ZUNMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
      ELSE IF( LSAMEN( 2, C2, 'UP' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        of a symmetric packed matrix.
*
*        ZHPTRD
*
         SRNAMT = 'ZHPTRD'
         INFOT = 1
         CALL ZHPTRD( '/', 0, A, D, E, TAU, INFO )
         CALL CHKXER( 'ZHPTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZHPTRD( 'U', -1, A, D, E, TAU, INFO )
         CALL CHKXER( 'ZHPTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 2
*
*        ZUPGTR
*
         SRNAMT = 'ZUPGTR'
         INFOT = 1
         CALL ZUPGTR( '/', 0, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'ZUPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUPGTR( 'U', -1, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'ZUPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUPGTR( 'U', 2, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'ZUPGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        ZUPMTR
*
         SRNAMT = 'ZUPMTR'
         INFOT = 1
         CALL ZUPMTR( '/', 'U', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUPMTR( 'L', '/', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUPMTR( 'L', 'U', '/', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUPMTR( 'L', 'U', 'N', -1, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUPMTR( 'L', 'U', 'N', 0, -1, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ZUPMTR( 'L', 'U', 'N', 2, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'ZUPMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
      ELSE IF( LSAMEN( 3, PATH, 'BRD' ) ) THEN
*
*        ZGEBRD
*
         SRNAMT = 'ZGEBRD'
         INFOT = 1
         CALL ZGEBRD( -1, 0, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'ZGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZGEBRD( 0, -1, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'ZGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZGEBRD( 2, 1, A, 1, D, E, TQ, TP, W, 2, INFO )
         CALL CHKXER( 'ZGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ZGEBRD( 2, 1, A, 2, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'ZGEBRD', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        ZUNGBR
*
         SRNAMT = 'ZUNGBR'
         INFOT = 1
         CALL ZUNGBR( '/', 0, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNGBR( 'Q', -1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGBR( 'Q', 0, -1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGBR( 'Q', 0, 1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGBR( 'Q', 1, 0, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGBR( 'P', 1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNGBR( 'P', 0, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUNGBR( 'Q', 0, 0, -1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUNGBR( 'Q', 2, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ZUNGBR( 'Q', 2, 2, 1, A, 2, TQ, W, 1, INFO )
         CALL CHKXER( 'ZUNGBR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        ZUNMBR
*
         SRNAMT = 'ZUNMBR'
         INFOT = 1
         CALL ZUNMBR( '/', 'L', 'C', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ZUNMBR( 'Q', '/', 'C', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ZUNMBR( 'Q', 'L', '/', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ZUNMBR( 'Q', 'L', 'C', -1, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ZUNMBR( 'Q', 'L', 'C', 0, -1, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ZUNMBR( 'Q', 'L', 'C', 0, 0, -1, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMBR( 'Q', 'L', 'C', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMBR( 'Q', 'R', 'C', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMBR( 'P', 'L', 'C', 2, 0, 2, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ZUNMBR( 'P', 'R', 'C', 0, 2, 2, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ZUNMBR( 'Q', 'R', 'C', 2, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ZUNMBR( 'Q', 'L', 'C', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ZUNMBR( 'Q', 'R', 'C', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'ZUNMBR', INFOT, NOUT, LERR, OK )
         NT = NT + 13
      END IF
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of ZERRRD
*
      END
