      SUBROUTINE ZERRLQ( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  ZERRLQ tests the error exits for the COMPLEX*16 routines
*  that use the LQ decomposition of a general matrix.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX
      PARAMETER          ( NMAX = 2 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, INFO, J
*     ..
*     .. Local Arrays ..
      COMPLEX*16         A( NMAX, NMAX ), AF( NMAX, NMAX ), B( NMAX ),
     $                   W( NMAX ), X( NMAX )
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, ZGELQF, ZGELQS, ZUNGLQ, ZUNMLQ
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, DCMPLX
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = DCMPLX( 1.D0 / DBLE( I+J ),
     $                  -1.D0 / DBLE( I+J ) )
            AF( I, J ) = DCMPLX( 1.D0 / DBLE( I+J ),
     $                   -1.D0 / DBLE( I+J ) )
   10    CONTINUE
         B( J ) = 0.D0
         W( J ) = 0.D0
         X( J ) = 0.D0
   20 CONTINUE
      OK = .TRUE.
*
*     Error exits for LQ factorization
*
*     ZGELQF
*
      SRNAMT = 'ZGELQF'
      INFOT = 1
      CALL ZGELQF( -1, 0, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'ZGELQF', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZGELQF( 0, -1, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'ZGELQF', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL ZGELQF( 2, 1, A, 1, B, W, 2, INFO )
      CALL CHKXER( 'ZGELQF', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL ZGELQF( 2, 1, A, 2, B, W, 1, INFO )
      CALL CHKXER( 'ZGELQF', INFOT, NOUT, LERR, OK )
*
*     ZGELQ2
*
!eca  SRNAMT = 'ZGELQ2'
!eca  INFOT = 1
!eca  CALL ZGELQ2( -1, 0, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'ZGELQ2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL ZGELQ2( 0, -1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'ZGELQ2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL ZGELQ2( 2, 1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'ZGELQ2', INFOT, NOUT, LERR, OK )
*
*     ZGELQS
*
      SRNAMT = 'ZGELQS'
      INFOT = 1
      CALL ZGELQS( -1, 0, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZGELQS( 0, -1, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZGELQS( 2, 1, 0, A, 2, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL ZGELQS( 0, 0, -1, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL ZGELQS( 2, 2, 0, A, 1, X, B, 2, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL ZGELQS( 1, 2, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL ZGELQS( 1, 1, 2, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'ZGELQS', INFOT, NOUT, LERR, OK )
*
*     ZUNGLQ
*
      SRNAMT = 'ZUNGLQ'
      INFOT = 1
      CALL ZUNGLQ( -1, 0, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZUNGLQ( 0, -1, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZUNGLQ( 2, 1, 0, A, 2, X, W, 2, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL ZUNGLQ( 0, 0, -1, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL ZUNGLQ( 1, 1, 2, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL ZUNGLQ( 2, 2, 0, A, 1, X, W, 2, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL ZUNGLQ( 2, 2, 0, A, 2, X, W, 1, INFO )
      CALL CHKXER( 'ZUNGLQ', INFOT, NOUT, LERR, OK )
*
*     ZUNGL2
*
!eca  SRNAMT = 'ZUNGL2'
!eca  INFOT = 1
!eca  CALL ZUNGL2( -1, 0, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL ZUNGL2( 0, -1, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL ZUNGL2( 2, 1, 0, A, 2, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL ZUNGL2( 0, 0, -1, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL ZUNGL2( 1, 1, 2, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL ZUNGL2( 2, 2, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'ZUNGL2', INFOT, NOUT, LERR, OK )
*
*     ZUNMLQ
*
      SRNAMT = 'ZUNMLQ'
      INFOT = 1
      CALL ZUNMLQ( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL ZUNMLQ( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL ZUNMLQ( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL ZUNMLQ( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL ZUNMLQ( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL ZUNMLQ( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL ZUNMLQ( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL ZUNMLQ( 'L', 'N', 2, 0, 2, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL ZUNMLQ( 'R', 'N', 0, 2, 2, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL ZUNMLQ( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL ZUNMLQ( 'L', 'N', 1, 2, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL ZUNMLQ( 'R', 'N', 2, 1, 0, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'ZUNMLQ', INFOT, NOUT, LERR, OK )
*
*     ZUNML2
*
!eca  SRNAMT = 'ZUNML2'
!eca  INFOT = 1
!eca  CALL ZUNML2( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL ZUNML2( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL ZUNML2( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL ZUNML2( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL ZUNML2( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL ZUNML2( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL ZUNML2( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL ZUNML2( 'L', 'N', 2, 1, 2, A, 1, X, AF, 2, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL ZUNML2( 'R', 'N', 1, 2, 2, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 10
!eca  CALL ZUNML2( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'ZUNML2', INFOT, NOUT, LERR, OK )
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of ZERRLQ
*
      END
