      SUBROUTINE STRDT1( UPLO, N, A, LDA, Q, LDQ, D, E, T, LDT, WORK,
     $                   LWORK, RWORK, RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*     12-1-99:  Change calls to SORT01 to SORGT1  (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            LDA, LDQ, LDT, LWORK, N
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * ), D( * ), E( * ), Q( LDQ, * ),
     $                   RESULT( * ), RWORK( * ), T( LDT, * ),
     $                   WORK( LWORK )
*     ..
*
*  Purpose
*  =======
*
*  STRDT1 tests the reduction to tridiagonal form of an n-by-n symmetric
*  matrix A as computed by SSYTRD, and the generation of the orthogonal
*  matrix from the reduction as computed by SORGTR.
*
*  Given A, the diagonal D and offdiagonal E from the tridiagonal form,
*  and the orthogonal matrix Q, STRDT1 compares the tridiagonal matrix
*  with Q'*A*Q, and checks that the columns of Q are orthonormal.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          = 'U':  Upper triangle of A is stored;
*          = 'L':  Lower triangle of A is stored.
*
*  N       (input) INTEGER
*          The number of rows and columns of the original matrix A.
*          N >= 0.
*
*  A       (input) REAL array, dimension (LDA,N)
*          The initial n-by-n matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*
*  Q       (input) REAL array, dimension (LDQ,N)
*          The n-by-n orthogonal matrix Q, as returned by SORGTR.
*
*  LDQ     (input) INTEGER
*          The leading dimension of the array Q.
*
*  D       (output) REAL array, dimension (N)
*          The diagonal elements of the tridiagonal matrix T, as
*          returned by SSYTRD.
*
*  E       (output) REAL array, dimension (N-1)
*          The off-diagonal elements of the tridiagonal matrix T, as
*          returned by SSYTRD.  If UPLO = 'U', E(i) = A(i,i+1) of the
*          reduced matrix, and if UPLO = 'L', E(i) = A(i+1,i).
*
*  T       (workspace) REAL array, dimension (LDT,N)
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T.
*
*  WORK    (workspace) REAL array, dimension (LWORK)
*
*  LWORK   (input) INTEGER
*          The length of WORK.  Assumed to be at least N*N.
*
*  RWORK   (workspace) REAL array, dimension (N)
*
*  RESULT  (output) REAL array, dimension (2)
*          The test ratios:
*          RESULT(1) = norm( H - Q'*A*Q ) / ( N * norm(A) * EPS )
*          RESULT(2) = norm( I - Q'*Q ) / ( N * EPS )
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ZERO, ONE
      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, LDWORK
      REAL               ANORM, EPS, RESID
*     ..
*     .. External Functions ..
      REAL               SLAMCH, SLANGE, SLANSY
      EXTERNAL           SLAMCH, SLANGE, SLANSY
*     ..
*     .. External Subroutines ..
      EXTERNAL           SGEMM, SORGT1, SSYMM
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, REAL
*     ..
*     .. Executable Statements ..
*
*     Compute A * Q
*
      LDWORK = MAX( 1, N )
      CALL SSYMM( 'Left', UPLO, N, N, ONE, A, LDA, Q, LDQ, ZERO, WORK,
     $            LDWORK )
*
*     Compute Q' * (A * Q)
*
      CALL SGEMM( 'Transpose', 'No transpose', N, N, N, ONE, Q, LDQ,
     $            WORK, LDWORK, ZERO, T, LDT )
*
*     Subtract the tridiagonal matrix.
*
      T( 1, 1 ) = T( 1, 1 ) - D( 1 )
      IF( N.GT.1 ) THEN
         T( 2, 1 ) = T( 2, 1 ) - E( 1 )
         T( N-1, N ) = T( N-1, N ) - E( N-1 )
         T( N, N ) = T( N, N ) - D( N )
      END IF
      DO 10 I = 2, N - 1
         T( I-1, I ) = T( I-1, I ) - E( I-1 )
         T( I, I ) = T( I, I ) - D( I )
         T( I+1, I ) = T( I+1, I ) - E( I )
   10 CONTINUE
*
*     Compute norm( T - Q'*A*Q ) / ( N * norm(A) * EPS ) .
*
      EPS = SLAMCH( 'Epsilon' )
      ANORM = SLANSY( '1', UPLO, N, A, LDA, RWORK )
      RESID = SLANGE( '1', N, N, T, LDT, RWORK )
      IF( ANORM.GT.ZERO ) THEN
         RESULT( 1 ) = ( ( RESID / REAL( MAX( 1, N ) ) ) / ANORM ) / EPS
      ELSE
         RESULT( 1 ) = ZERO
      END IF
*
*     Compute norm( I - Q'*Q ) / ( N * EPS ) .
*
      CALL SORGT1( 'Columns', N, N, Q, LDQ, WORK, LWORK, RWORK,
     $             RESULT( 2 ) )
      RETURN
*
*     End of STRDT1
*
      END
