      SUBROUTINE SERRRD( PATH, NUNIT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  SERRRD tests the error exits for the REAL reduction routines.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = ( NMAX+2 )*( NMAX+2 )+NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, IHI, ILO, INFO, J, NT
*     ..
*     .. Local Arrays ..
      REAL               A( NMAX, NMAX ), C( NMAX, NMAX ), D( NMAX ),
     $                   E( NMAX ), S( NMAX ), TAU( NMAX ), TP( NMAX ),
     $                   TQ( NMAX ), W( NMAX ), Z( NMAX, NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      EXTERNAL           LSAMEN
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, SGEBAK, SGEBAL, SGEBRD, SGEHRD,
     $                   SOPGTR, SOPMTR, SORGBR, SORGHR, SORGTR, SORMBR,
     $                   SORMHR, SORMTR, SSPTRD, SSYTRD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      ILO = 1
      IHI = 1
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / REAL( I+J )
            C( I, J ) = 0.
   10    CONTINUE
   20 CONTINUE
      DO 30 J = 1, NMAX
         TAU( J ) = 1.
         TP( J ) = 1.
         TQ( J ) = 1.
   30 CONTINUE
      OK = .TRUE.
      NT = 0
*
      IF( LSAMEN( 3, PATH, 'HRD' ) ) THEN
*
*        Test error exits for the reduction to Hessenberg form for
*        the nonsymmetric eigenvalue problem.
*
*        SGEBAL
*
         SRNAMT = 'SGEBAL'
         INFOT = 1
         CALL SGEBAL( '/', 0, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'SGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SGEBAL( 'N', -1, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'SGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SGEBAL( 'N', 2, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'SGEBAL', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        SGEBAK
*
         SRNAMT = 'SGEBAK'
         INFOT = 1
         CALL SGEBAK( '/', 'R', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SGEBAK( 'N', '/', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SGEBAK( 'N', 'R', -1, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SGEBAK( 'N', 'R', 0, 0, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SGEBAK( 'N', 'R', 0, 2, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SGEBAK( 'N', 'R', 2, 2, 1, S, 0, A, 2, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SGEBAK( 'N', 'R', 0, 1, 1, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL SGEBAK( 'N', 'R', 0, 1, 0, S, -1, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL SGEBAK( 'N', 'R', 2, 1, 2, S, 0, A, 1, INFO )
         CALL CHKXER( 'SGEBAK', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        SGEHRD
*
         SRNAMT = 'SGEHRD'
         INFOT = 1
         CALL SGEHRD( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SGEHRD( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SGEHRD( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SGEHRD( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SGEHRD( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SGEHRD( 2, 1, 1, A, 1, TAU, W, 2, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SGEHRD( 2, 1, 2, A, 2, TAU, W, 1, INFO )
         CALL CHKXER( 'SGEHRD', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        SORGHR
*
         SRNAMT = 'SORGHR'
         INFOT = 1
         CALL SORGHR( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORGHR( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORGHR( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGHR( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGHR( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORGHR( 2, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORGHR( 3, 1, 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGHR', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        SORMHR
*
         SRNAMT = 'SORMHR'
         INFOT = 1
         CALL SORMHR( '/', 'N', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORMHR( 'L', '/', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORMHR( 'L', 'N', -1, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SORMHR( 'L', 'N', 0, -1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMHR( 'L', 'N', 0, 0, 0, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMHR( 'L', 'N', 0, 0, 2, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMHR( 'L', 'N', 1, 2, 2, 1, A, 1, TAU, C, 1, W, 2,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMHR( 'R', 'N', 2, 1, 2, 1, A, 1, TAU, C, 2, W, 2,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SORMHR( 'L', 'N', 1, 1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SORMHR( 'L', 'N', 0, 1, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SORMHR( 'R', 'N', 1, 0, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMHR( 'L', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMHR( 'R', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL SORMHR( 'L', 'N', 2, 1, 1, 1, A, 2, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL SORMHR( 'L', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL SORMHR( 'R', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMHR', INFOT, NOUT, LERR, OK )
         NT = NT + 16
*
      ELSE IF( LSAMEN( 3, PATH, 'TRD' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        for the symmetric eigenvalue problem.
*
*        SSYTRD
*
         SRNAMT = 'SSYTRD'
         INFOT = 1
         CALL SSYTRD( '/', 0, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'SSYTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SSYTRD( 'U', -1, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'SSYTRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SSYTRD( 'U', 2, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'SSYTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        SORGTR
*
         SRNAMT = 'SORGTR'
         INFOT = 1
         CALL SORGTR( '/', 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORGTR( 'U', -1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SORGTR( 'U', 2, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL SORGTR( 'U', 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'SORGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        SORMTR
*
         SRNAMT = 'SORMTR'
         INFOT = 1
         CALL SORMTR( '/', 'U', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORMTR( 'L', '/', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORMTR( 'L', 'U', '/', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SORMTR( 'L', 'U', 'N', -1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMTR( 'L', 'U', 'N', 0, -1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL SORMTR( 'L', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL SORMTR( 'R', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL SORMTR( 'L', 'U', 'N', 2, 0, A, 2, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL SORMTR( 'L', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL SORMTR( 'R', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'SORMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
      ELSE IF( LSAMEN( 2, C2, 'OP' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        of a symmetric packed matrix.
*
*        SSPTRD
*
         SRNAMT = 'SSPTRD'
         INFOT = 1
         CALL SSPTRD( '/', 0, A, D, E, TAU, INFO )
         CALL CHKXER( 'SSPTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SSPTRD( 'U', -1, A, D, E, TAU, INFO )
         CALL CHKXER( 'SSPTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 2
*
*        SOPGTR
*
         SRNAMT = 'SOPGTR'
         INFOT = 1
         CALL SOPGTR( '/', 0, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'SOPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SOPGTR( 'U', -1, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'SOPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SOPGTR( 'U', 2, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'SOPGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        SOPMTR
*
         SRNAMT = 'SOPMTR'
         INFOT = 1
         CALL SOPMTR( '/', 'U', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SOPMTR( 'L', '/', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SOPMTR( 'L', 'U', '/', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SOPMTR( 'L', 'U', 'N', -1, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SOPMTR( 'L', 'U', 'N', 0, -1, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL SOPMTR( 'L', 'U', 'N', 2, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'SOPMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
      ELSE IF( LSAMEN( 3, PATH, 'BRD' ) ) THEN
*
*        SGEBRD
*
         SRNAMT = 'SGEBRD'
         INFOT = 1
         CALL SGEBRD( -1, 0, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'SGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SGEBRD( 0, -1, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'SGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SGEBRD( 2, 1, A, 1, D, E, TQ, TP, W, 2, INFO )
         CALL CHKXER( 'SGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL SGEBRD( 2, 1, A, 2, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'SGEBRD', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        SORGBR
*
         SRNAMT = 'SORGBR'
         INFOT = 1
         CALL SORGBR( '/', 0, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORGBR( 'Q', -1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGBR( 'Q', 0, -1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGBR( 'Q', 0, 1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGBR( 'Q', 1, 0, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGBR( 'P', 1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORGBR( 'P', 0, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SORGBR( 'Q', 0, 0, -1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SORGBR( 'Q', 2, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL SORGBR( 'Q', 2, 2, 1, A, 2, TQ, W, 1, INFO )
         CALL CHKXER( 'SORGBR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        SORMBR
*
         SRNAMT = 'SORMBR'
         INFOT = 1
         CALL SORMBR( '/', 'L', 'T', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL SORMBR( 'Q', '/', 'T', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL SORMBR( 'Q', 'L', '/', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL SORMBR( 'Q', 'L', 'T', -1, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL SORMBR( 'Q', 'L', 'T', 0, -1, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL SORMBR( 'Q', 'L', 'T', 0, 0, -1, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMBR( 'Q', 'L', 'T', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMBR( 'Q', 'R', 'T', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMBR( 'P', 'L', 'T', 2, 0, 2, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL SORMBR( 'P', 'R', 'T', 0, 2, 2, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL SORMBR( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL SORMBR( 'Q', 'L', 'T', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL SORMBR( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'SORMBR', INFOT, NOUT, LERR, OK )
         NT = NT + 13
      END IF
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of SERRRD
*
      END
