      SUBROUTINE SERRQR( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  SERRQR tests the error exits for the REAL routines
*  that use the QR decomposition of a general matrix.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX
      PARAMETER          ( NMAX = 2 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, INFO, J
*     ..
*     .. Local Arrays ..
      REAL               A( NMAX, NMAX ), AF( NMAX, NMAX ), B( NMAX ),
     $                   W( NMAX ), X( NMAX )
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, SGEQRF, SGEQRS, SORGQR, SORMQR
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / REAL( I+J )
            AF( I, J ) = 1. / REAL( I+J )
   10    CONTINUE
         B( J ) = 0.
         W( J ) = 0.
         X( J ) = 0.
   20 CONTINUE
      OK = .TRUE.
*
*     Error exits for QR factorization
*
*     SGEQRF
*
      SRNAMT = 'SGEQRF'
      INFOT = 1
      CALL SGEQRF( -1, 0, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'SGEQRF', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SGEQRF( 0, -1, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'SGEQRF', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL SGEQRF( 2, 1, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'SGEQRF', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL SGEQRF( 1, 2, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'SGEQRF', INFOT, NOUT, LERR, OK )
*
*     SGEQR2
*
!eca  SRNAMT = 'SGEQR2'
!eca  INFOT = 1
!eca  CALL SGEQR2( -1, 0, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'SGEQR2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL SGEQR2( 0, -1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'SGEQR2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL SGEQR2( 2, 1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'SGEQR2', INFOT, NOUT, LERR, OK )
*
*     SGEQRS
*
      SRNAMT = 'SGEQRS'
      INFOT = 1
      CALL SGEQRS( -1, 0, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SGEQRS( 0, -1, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SGEQRS( 1, 2, 0, A, 2, X, B, 2, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL SGEQRS( 0, 0, -1, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL SGEQRS( 2, 1, 0, A, 1, X, B, 2, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL SGEQRS( 2, 1, 0, A, 2, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL SGEQRS( 1, 1, 2, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'SGEQRS', INFOT, NOUT, LERR, OK )
*
*     SORGQR
*
      SRNAMT = 'SORGQR'
      INFOT = 1
      CALL SORGQR( -1, 0, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SORGQR( 0, -1, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SORGQR( 1, 2, 0, A, 1, X, W, 2, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL SORGQR( 0, 0, -1, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL SORGQR( 1, 1, 2, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL SORGQR( 2, 2, 0, A, 1, X, W, 2, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL SORGQR( 2, 2, 0, A, 2, X, W, 1, INFO )
      CALL CHKXER( 'SORGQR', INFOT, NOUT, LERR, OK )
*
*     SORG2R
*
!eca  SRNAMT = 'SORG2R'
!eca  INFOT = 1
!eca  CALL SORG2R( -1, 0, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL SORG2R( 0, -1, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL SORG2R( 1, 2, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL SORG2R( 0, 0, -1, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL SORG2R( 2, 1, 2, A, 2, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL SORG2R( 2, 1, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'SORG2R', INFOT, NOUT, LERR, OK )
*
*     SORMQR
*
      SRNAMT = 'SORMQR'
      INFOT = 1
      CALL SORMQR( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL SORMQR( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL SORMQR( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL SORMQR( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL SORMQR( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL SORMQR( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL SORMQR( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL SORMQR( 'L', 'N', 2, 1, 0, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL SORMQR( 'R', 'N', 1, 2, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL SORMQR( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL SORMQR( 'L', 'N', 1, 2, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL SORMQR( 'R', 'N', 2, 1, 0, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'SORMQR', INFOT, NOUT, LERR, OK )
*
*     SORM2R
*
!eca  SRNAMT = 'SORM2R'
!eca  INFOT = 1
!eca  CALL SORM2R( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL SORM2R( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL SORM2R( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL SORM2R( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL SORM2R( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL SORM2R( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL SORM2R( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL SORM2R( 'L', 'N', 2, 1, 0, A, 1, X, AF, 2, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL SORM2R( 'R', 'N', 1, 2, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
!eca  INFOT = 10
!eca  CALL SORM2R( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'SORM2R', INFOT, NOUT, LERR, OK )
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of SERRQR
*
      END
