      SUBROUTINE DCKHRD( DOTYPE, NM, MVAL, NN, NVAL, NNB, NBVAL, NXVAL,
     $                   THRESH, TSTERR, NMAX, A, AF, AQ, AH, C, TAU, X,
     $                   WORK, RWORK, NOUT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      LOGICAL            TSTERR
      INTEGER            NM, NMAX, NN, NNB, NOUT
      DOUBLE PRECISION   THRESH
*     ..
*     .. Array Arguments ..
      LOGICAL            DOTYPE( * )
      INTEGER            MVAL( * ), NBVAL( * ), NVAL( * ), NXVAL( * )
      DOUBLE PRECISION   A( NMAX, * ), AF( * ), AH( * ), AQ( * ),
     $                   C( * ), RWORK( * ), TAU( * ), WORK( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  DCKHRD tests DGEHRD, DORGHR and DORMHR.
*
*  Arguments
*  =========
*
*  DOTYPE  (input) LOGICAL array, dimension (NTYPES)
*          The matrix types to be used for testing.  Matrices of type j
*          (for 1 <= j <= NTYPES) are used for testing if DOTYPE(j) =
*          .TRUE.; if DOTYPE(j) = .FALSE., then type j is not used.
*
*  NM      (input) INTEGER
*          The number of values of M contained in the vector MVAL.
*
*  MVAL    (input) INTEGER array, dimension (NM)
*          The values of the matrix dimension M, used as the size of the
*          nonsymmetric square matrix to be reduced by DGEHRD.
*
*  NN      (input) INTEGER
*          The number of values of N contained in the vector NVAL.
*
*  NVAL    (input) INTEGER array, dimension (NN)
*          The values of the matrix dimension N, used as the other
*          dimension of the matrix C multiplied on the left or right by
*          Q or Q**T.
*
*  NNB     (input) INTEGER
*          The number of values of NB and NX contained in the
*          vectors NBVAL and NXVAL.  The blocking parameters are used
*          in pairs (NB,NX).
*
*  NBVAL   (input) INTEGER array, dimension (NNB)
*          The values of the blocksize NB.
*
*  NXVAL   (input) INTEGER array, dimension (NNB)
*          The values of the crossover point NX.
*
*  THRESH  (input) DOUBLE PRECISION
*          The threshold value for the test ratios.  A result is
*          included in the output file if RESULT >= THRESH.  To have
*          every test ratio printed, use THRESH = 0.
*
*  TSTERR  (input) LOGICAL
*          Flag that indicates whether error exits are to be tested.
*
*  NMAX    (input) INTEGER
*          The maximum value permitted for M or N, used in dimensioning
*          the work arrays.
*
*  A       (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  AF      (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  AQ      (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  AH      (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  C       (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  TAU     (workspace) DOUBLE PRECISION array, dimension (NMAX)
*
*  X       (workspace) DOUBLE PRECISION array, dimension (NMAX)
*
*  WORK    (workspace) DOUBLE PRECISION array, dimension (NMAX*NMAX)
*
*  RWORK   (workspace) DOUBLE PRECISION array, dimension (NMAX)
*
*  NOUT    (input) INTEGER
*          The unit number for output.
*
*     .. Parameters ..
      INTEGER            NTESTS, NTYPES
      PARAMETER          ( NTESTS = 6, NTYPES = 1 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
      DOUBLE PRECISION   ROGUE
      PARAMETER          ( ROGUE = -1.0D+10 )
*     ..
*     .. Local Scalars ..
      CHARACTER          SIDE, TRANS
      CHARACTER*3        PATH
      INTEGER            I, IHI, IK, ILO, IM, IMAT, IN, INB, INFO,
     $                   ISIDE, ITRANS, J, K, LDA, LWORK, M, MC, MODE,
     $                   N, NB, NC, NERRS, NFAIL, NK, NR, NRUN, NT, NX
      DOUBLE PRECISION   CNORM, COND, EPS, RESID
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 ), ISEEDY( 4 )
      DOUBLE PRECISION   RESULT( NTESTS )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      DOUBLE PRECISION   DLAMCH, DLANGE
      EXTERNAL           LSAME, DLAMCH, DLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAHD, ALASUM, DCOPY, DERRRD, DGEHRD, DGEMM,
     $                   DHRDT1, DLACPY, DLARF, DLARFG, DLARNV, DLASET,
     $                   DLATM1, DORGHR, DORMHR, XLAENV
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, DBLE
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NUNIT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NUNIT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 0, 0, 0, 1 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      PATH( 1: 3 ) = 'HRD'
      NRUN = 0
      NFAIL = 0
      NERRS = 0
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Test the error exits
*
      IF( TSTERR )
     $   CALL DERRRD( PATH, NOUT )
*
*     Print the header if NM = 0 and THRESH = 0.
*
      IF( NM.EQ.0 .AND. THRESH.EQ.ZERO )
     $   CALL ALAHD( NOUT, PATH )
      INFOT = 0
      CALL XLAENV( 2, 2 )
*
      EPS = DLAMCH( 'Epsilon' )
      LDA = NMAX
      LWORK = NMAX*NMAX
*
*     Do for each value of M in MVAL.
*
      DO 140 IM = 1, NM
         M = MVAL( IM )
         DO 130 IMAT = 1, NTYPES
*
*           Do the tests only if DOTYPE( IMAT ) is true.
*
            IF( .NOT.DOTYPE( IMAT ) )
     $         GO TO 130
*
            IF( M.LE.1 ) THEN
               NK = 1
            ELSE IF( M.EQ.2 ) THEN
               NK = 3
            ELSE IF( M.LE.4 ) THEN
               NK = 5
            ELSE
               NK = 6
            END IF
*
*           Do for each combination of ILO and IHI.
*
            DO 120 IK = 1, NK
               K = ( M+1 ) / 2
               IF( IK.EQ.1 ) THEN
                  ILO = 1
                  IHI = M
               ELSE IF( IK.EQ.2 ) THEN
                  ILO = 1
                  IHI = K
               ELSE IF( IK.EQ.3 ) THEN
                  ILO = K + 1
                  IHI = M
               ELSE IF( IK.EQ.4 ) THEN
                  ILO = K
                  IHI = K
               ELSE IF( IK.EQ.5 ) THEN
                  ILO = K
                  IHI = K + 1
               ELSE
                  ILO = 2
                  IHI = M - 1
               END IF
*
*              Generate a Schur matrix of the desired type.
*
               MODE = 3
               COND = 2.0
               CALL DLATM1( MODE, COND, 0, 2, ISEED, X, M, INFO )
               CALL DLASET( 'Full', M, M, ZERO, ZERO, A, LDA )
               CALL DCOPY( M, X, 1, A, LDA+1 )
*
*              Set up complex conjugate pairs
*
               IF( ILO.LT.IHI ) THEN
                  A( ILO, ILO+1 ) = A( ILO+1, ILO+1 )
                  A( ILO+1, ILO ) = -A( ILO+1, ILO+1 )
                  A( ILO+1, ILO+1 ) = A( ILO, ILO )
               END IF
               IF( IHI.GT.ILO+2 ) THEN
                  A( IHI-1, IHI ) = A( IHI, IHI )
                  A( IHI, IHI-1 ) = -A( IHI, IHI )
                  A( IHI, IHI ) = A( IHI-1, IHI-1 )
               END IF
               CALL DLARNV( 1, ISEED, ( IHI-ILO ) / 2, X )
               DO 20 I = ILO + 2, IHI - 3, 2
                  IF( X( ( I-ILO ) / 2 ).GT.0.5 ) THEN
                     A( I, I+1 ) = A( I+1, I+1 )
                     A( I+1, I ) = -A( I+1, I+1 )
                     A( I+1, I+1 ) = A( I, I )
                  END IF
   20          CONTINUE
*
*              Fill the rest of the upper triangle with random elements
*
               DO 30 J = 2, M
                  NR = J - 1
                  IF( A( J-1, J ).NE.ZERO )
     $               NR = J - 2
                  CALL DLARNV( 2, ISEED, NR, A( 1, J ) )
   30          CONTINUE
*
*              Pre- and post-multiply by random orthogonal matrices.
*
               DO 40 I = IHI - 1, ILO, -1
*
*                 Generate random reflection
*
                  CALL DLARNV( 2, ISEED, IHI-I+1, X )
                  CALL DLARFG( IHI-I+1, X( 1 ), X( 2 ), 1, TAU )
                  X( 1 ) = ONE
                  K = I
                  IF( I.GT.1 ) THEN
                     IF( A( I, I-1 ).NE.ZERO )
     $                  K = I - 1
                  END IF
*
*                 Multiply A(i:ihi,i:m) by random reflection from the
*                 left
*
                  CALL DLARF( 'Left', IHI-I+1, M-K+1, X, 1, TAU,
     $                        A( I, K ), LDA, WORK )
                  K = I
                  IF( I.GT.1 ) THEN
                     IF( A( I-1, I ).NE.ZERO )
     $                  K = I - 1
                  END IF
*
*                 Multiply A(1:ihi,i:ihi) by the same reflection from
*                 the right
*
                  CALL DLARF( 'Right', IHI, IHI-I+1, X, 1, TAU,
     $                        A( 1, I ), LDA, WORK )
   40          CONTINUE
*
*              Do for each pair of values (NB,NX) in NBVAL and NXVAL.
*
               DO 110 INB = 1, NNB
                  NB = NBVAL( INB )
                  CALL XLAENV( 1, NB )
                  NX = NXVAL( INB )
                  CALL XLAENV( 3, NX )
*
*                 Copy the matrix A to the array AF.
*
                  CALL DLACPY( 'Full', M, M, A, LDA, AF, LDA )
*
*                 Compute the reduction to Hessenberg form in AF.
*
                  SRNAMT = 'DGEHRD'
                  CALL DGEHRD( M, ILO, IHI, AF, LDA, TAU, WORK, LWORK,
     $                         INFO )
*
*                 Copy details of Q
*
                  CALL DLASET( 'Full', M, M, ROGUE, ROGUE, AQ, LDA )
                  CALL DLACPY( 'Lower', IHI-ILO-1, IHI-ILO-1,
     $                         AF( ( ILO-1 )*LDA+ILO+2 ), LDA,
     $                         AQ( ( ILO-1 )*LDA+ILO+2 ), LDA )
*
*                 Generate the m-by-m matrix Q
*
                  SRNAMT = 'DORGHR'
                  CALL DORGHR( M, ILO, IHI, AQ, LDA, TAU, WORK, LWORK,
     $                         INFO )
*
*                 Check the factorization and orthogonality of Q.
*
                  CALL DHRDT1( M, ILO, IHI, A, LDA, AF, LDA, AQ, LDA,
     $                         AH, LDA, WORK, LWORK, RWORK, RESULT )
*
*                 Print information about the tests that did not
*                 pass the threshold.
*
                  DO 50 I = 1, 2
                     IF( RESULT( I ).GE.THRESH ) THEN
                        IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                     CALL ALAHD( NOUT, PATH )
                        WRITE( NOUT, FMT = 9999 )M, ILO, IHI, NB, NX,
     $                     IMAT, I, RESULT( I )
                        NFAIL = NFAIL + 1
                     END IF
   50             CONTINUE
                  NRUN = NRUN + 2
*
*                 Do for each value of N in NVAL.
*
                  DO 100 IN = 1, NN
                     N = NVAL( IN )
                     NT = 0
*
*                    Test DORMHR
*
                     DO 80 ISIDE = 1, 2
                        IF( ISIDE.EQ.1 ) THEN
                           SIDE = 'Left'
                           MC = M
                           NC = N
                        ELSE
                           SIDE = 'Right'
                           MC = N
                           NC = M
                        END IF
*
*                       Generate MC by NC matrix C
*
                        DO 60 J = 1, NC
                           CALL DLARNV( 2, ISEED, MC,
     $                                  C( 1+( J-1 )*LDA ) )
   60                   CONTINUE
                        CNORM = DLANGE( '1', MC, NC, C, LDA, RWORK )
                        IF( CNORM.EQ.0.0 )
     $                     CNORM = ONE
                        DO 70 ITRANS = 1, 2
                           IF( ITRANS.EQ.1 ) THEN
                              TRANS = 'No transpose'
                           ELSE
                              TRANS = 'Transpose'
                           END IF
*
*                          Copy C
*
                           CALL DLACPY( 'Full', MC, NC, C, LDA, AH,
     $                                  LDA )
*
*                          Apply Q or Q' to C
*
                           SRNAMT = 'DORMHR'
                           CALL DORMHR( SIDE, TRANS, MC, NC, ILO, IHI,
     $                                  AF, LDA, TAU, AH, LDA, WORK,
     $                                  LWORK, INFO )
*
*                          Form explicit product and subtract
*
                           IF( LSAME( SIDE, 'L' ) ) THEN
                              CALL DGEMM( TRANS, 'No transpose', MC, NC,
     $                                    MC, -ONE, AQ, LDA, C, LDA,
     $                                    ONE, AH, LDA )
                           ELSE
                              CALL DGEMM( 'No transpose', TRANS, MC, NC,
     $                                    NC, -ONE, C, LDA, AQ, LDA,
     $                                    ONE, AH, LDA )
                           END IF
*
*                          Compute error in the difference
*
                           RESID = DLANGE( '1', MC, NC, AH, LDA, RWORK )
                           NT = NT + 1
                           RESULT( NT ) = RESID /
     $                                    ( DBLE( MAX( 1, MC ) )*CNORM*
     $                                    EPS )
   70                   CONTINUE
   80                CONTINUE
*
*                    Print information about the tests that did not
*                    pass the threshold.
*
                     DO 90 I = 1, NT
                        IF( RESULT( I ).GE.THRESH ) THEN
                           IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                        CALL ALAHD( NOUT, PATH )
                           IF( I.LE.2 ) THEN
                              MC = M
                              NC = N
                           ELSE
                              MC = N
                              NC = M
                           END IF
                           IF( MAX( MC, NC ).LT.1000 ) THEN
                              WRITE( NOUT, FMT = 9998 )MC, NC, ILO,
     $                           IHI, NB, NX, IMAT, I+2, RESULT( I )
                           ELSE
                              WRITE( NOUT, FMT = 9997 )MC, NC, ILO,
     $                           IHI, NB, NX, IMAT, I+2, RESULT( I )
                           END IF
                           NFAIL = NFAIL + 1
                        END IF
   90                CONTINUE
                     NRUN = NRUN + NT
  100             CONTINUE
  110          CONTINUE
  120       CONTINUE
  130    CONTINUE
  140 CONTINUE
*
*     Print a summary of the results.
*
      CALL ALASUM( PATH, NOUT, NFAIL, NRUN, NERRS )
*
 9999 FORMAT( ' N=', I6, ', ILO=', I5, ', IHI=', I5, ', NB=', I4,
     $      ',NX=', I4, ', type ', I2, ', test(', I1, ')=', G12.5 )
 9998 FORMAT( ' M=', I3, ', N=', I3, ', ILO=', I3, ', IHI=', I3,
     $      ', NB=', I4, ',NX=', I4, ', type ', I2, ', test(', I1, ')=',
     $      G12.5 )
 9997 FORMAT( ' M=', I4, ',N=', I4, ',ILO=', I4, ',IHI=', I4, ',NB=',
     $      I4, ',NX=', I4, ', type ', I2, ', test(', I1, ')=', G12.5 )
      RETURN
*
*     End of DCKHRD
*
      END
