      SUBROUTINE CHRDT1( N, ILO, IHI, A, LDA, AF, LDAF, Q, LDQ, H, LDH,
     $                   WORK, LWORK, RWORK, RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IHI, ILO, LDA, LDAF, LDH, LDQ, LWORK, N
*     ..
*     .. Array Arguments ..
      REAL               RESULT( * ), RWORK( * )
      COMPLEX            A( LDA, * ), AF( LDAF, * ), H( LDH, * ),
     $                   Q( LDQ, * ), WORK( LWORK )
*     ..
*
*  Purpose
*  =======
*
*  CHRDT1 tests the reduction to Hessenberg form of an n-by-n matrix A
*  as computed by CGEHRD, and the generation of the orthogonal matrix
*  from the reduction as computed by CUNGHR.
*
*  Given A, its factored form AF, and the orthogonal matrix Q, CHRDT1
*  compares the upper Hessenberg part of A with Q'*A*Q, and checks that
*  the columns of Q are orthonormal.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of rows and columns of the original matrix A.
*          N >= 0.
*
*  ILO     (input) INTEGER
*  IHI     (input) INTEGER
*          It is assumed that A is already upper triangular in rows
*          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
*          set by a previous call to CGEBAL; otherwise they should be
*          set to 1 and N respectively.  See CGEHRD for further details.
*          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
*
*  A       (input) COMPLEX array, dimension (LDA,N)
*          The initial n-by-n matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*
*  AF      (input) COMPLEX array, dimension (LDAF,N)
*          Details of the reduction to Hessenberg form of the matrix A,
*          as returned by CGEHRD.
*
*  LDAF    (input) INTEGER
*          The leading dimension of the array AF.
*
*  Q       (input) COMPLEX array, dimension (LDQ,N)
*          The n-by-n orthogonal matrix Q, as returned by CUNGHR.
*
*  LDQ     (input) INTEGER
*          The leading dimension of the array Q.
*
*  H       (workspace) COMPLEX array, dimension (LDH,N)
*
*  LDH     (input) INTEGER
*          The leading dimension of the array H.
*
*  WORK    (workspace) COMPLEX array, dimension (LWORK)
*
*  LWORK   (input) INTEGER
*          The length of WORK.  Assumed to be at least N*N.
*
*  RWORK   (workspace) REAL array, dimension (N)
*
*  RESULT  (output) REAL array, dimension (2)
*          The test ratios:
*          RESULT(1) = norm( H - Q'*A*Q ) / ( N * norm(A) * EPS )
*          RESULT(2) = norm( I - Q'*Q ) / ( N * EPS )
*
*  =====================================================================
*
*     .. Parameters ..
      COMPLEX            ZERO, ONE
      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            LDWORK
      REAL               ANORM, EPS, RESID
*     ..
*     .. External Functions ..
      REAL               SLAMCH, CLANGE
      EXTERNAL           SLAMCH, CLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           CCOPY, CGEMM, CLACPY, CLASET, CUNT01
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, REAL
*     ..
*     .. Executable Statements ..
*
*     Copy the Hessenberg matrix to H.
*
      CALL CLACPY( 'Upper', N, N, AF, LDAF, H, LDH )
      CALL CLASET( 'Lower', N-1, N, ZERO, ZERO, H( 2, 1 ), LDH )
      IF( ILO.LT.IHI )
     $   CALL CCOPY( IHI-ILO, AF( ILO+1, ILO ), LDAF+1, H( ILO+1, ILO ),
     $               LDH+1 )
*
*     Compute Q' * A
*
      LDWORK = MAX( 1, N )
      CALL CGEMM( 'Conjugate transpose', 'No transpose', N, N, N, ONE,
     $            Q, LDQ, A, LDA, ZERO, WORK, LDWORK )
*
*     Compute H - (Q' * A) * Q
*
      CALL CGEMM( 'No transpose', 'No transpose', N, N, N, -ONE, WORK,
     $            LDWORK, Q, LDQ, ONE, H, LDH )
*
*     Compute norm( H - Q'*A*Q ) / ( N * norm(A) * EPS ) .
*
      EPS = SLAMCH( 'Epsilon' )
      ANORM = CLANGE( '1', N, N, A, LDA, RWORK )
      RESID = CLANGE( '1', N, N, H, LDH, RWORK )
      IF( ANORM.GT.0.0 ) THEN
         RESULT( 1 ) = ( ( RESID / REAL( MAX( 1, N ) ) ) / ANORM ) / EPS
      ELSE
         RESULT( 1 ) = 0.0
      END IF
*
*     Compute norm( I - Q'*Q ) / ( N * EPS ) .
*
      CALL CUNT01( 'Columns', N, N, Q, LDQ, WORK, LWORK, RWORK,
     $             RESULT( 2 ) )
      RETURN
*
*     End of CHRDT1
*
      END
