      SUBROUTINE CERRRD( PATH, NUNIT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  CERRRD tests the error exits for the COMPLEX reduction routines.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = ( NMAX+2 )*( NMAX+2 )+NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, IHI, ILO, INFO, J, NT
*     ..
*     .. Local Arrays ..
      REAL               D( NMAX ), E( NMAX ), S( NMAX )
      COMPLEX            A( NMAX, NMAX ), C( NMAX, NMAX ), TAU( NMAX ),
     $                   TP( NMAX ), TQ( NMAX ), W( NMAX ),
     $                   Z( NMAX, NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      EXTERNAL           LSAMEN
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, CGEBAK, CGEBAL, CGEBRD, CGEHRD,
     $                   CHETRD, CHPTRD, CUNGBR, CUNGHR, CUNGTR, CUNMBR,
     $                   CUNMHR, CUNMTR, CUPGTR, CUPMTR
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      ILO = 1
      IHI = 1
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / REAL( I+J )
            C( I, J ) = 0.
   10    CONTINUE
   20 CONTINUE
      DO 30 J = 1, NMAX
         TAU( J ) = 1.
         TP( J ) = 1.
         TQ( J ) = 1.
   30 CONTINUE
      OK = .TRUE.
      NT = 0
*
      IF( LSAMEN( 3, PATH, 'HRD' ) ) THEN
*
*        Test error exits for the reduction to Hessenberg form for
*        the nonsymmetric eigenvalue problem.
*
*        CGEBAL
*
         SRNAMT = 'CGEBAL'
         INFOT = 1
         CALL CGEBAL( '/', 0, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'CGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CGEBAL( 'N', -1, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'CGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CGEBAL( 'N', 2, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'CGEBAL', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        CGEBAK
*
         SRNAMT = 'CGEBAK'
         INFOT = 1
         CALL CGEBAK( '/', 'R', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CGEBAK( 'N', '/', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CGEBAK( 'N', 'R', -1, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CGEBAK( 'N', 'R', 0, 0, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CGEBAK( 'N', 'R', 0, 2, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CGEBAK( 'N', 'R', 2, 2, 1, S, 0, A, 2, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CGEBAK( 'N', 'R', 0, 1, 1, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL CGEBAK( 'N', 'R', 0, 1, 0, S, -1, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL CGEBAK( 'N', 'R', 2, 1, 2, S, 0, A, 1, INFO )
         CALL CHKXER( 'CGEBAK', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        CGEHRD
*
         SRNAMT = 'CGEHRD'
         INFOT = 1
         CALL CGEHRD( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CGEHRD( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CGEHRD( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CGEHRD( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CGEHRD( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CGEHRD( 2, 1, 1, A, 1, TAU, W, 2, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CGEHRD( 2, 1, 2, A, 2, TAU, W, 1, INFO )
         CALL CHKXER( 'CGEHRD', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        CUNGHR
*
         SRNAMT = 'CUNGHR'
         INFOT = 1
         CALL CUNGHR( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNGHR( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNGHR( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGHR( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGHR( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNGHR( 2, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNGHR( 3, 1, 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGHR', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        CUNMHR
*
         SRNAMT = 'CUNMHR'
         INFOT = 1
         CALL CUNMHR( '/', 'N', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNMHR( 'L', '/', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNMHR( 'L', 'N', -1, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUNMHR( 'L', 'N', 0, -1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMHR( 'L', 'N', 0, 0, 0, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMHR( 'L', 'N', 0, 0, 2, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMHR( 'L', 'N', 1, 2, 2, 1, A, 1, TAU, C, 1, W, 2,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMHR( 'R', 'N', 2, 1, 2, 1, A, 1, TAU, C, 2, W, 2,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUNMHR( 'L', 'N', 1, 1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUNMHR( 'L', 'N', 0, 1, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUNMHR( 'R', 'N', 1, 0, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMHR( 'L', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMHR( 'R', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL CUNMHR( 'L', 'N', 2, 1, 1, 1, A, 2, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL CUNMHR( 'L', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL CUNMHR( 'R', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMHR', INFOT, NOUT, LERR, OK )
         NT = NT + 16
*
      ELSE IF( LSAMEN( 3, PATH, 'TRD' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        for the symmetric eigenvalue problem.
*
*        CHETRD
*
         SRNAMT = 'CHETRD'
         INFOT = 1
         CALL CHETRD( '/', 0, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'CHETRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CHETRD( 'U', -1, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'CHETRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CHETRD( 'U', 2, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'CHETRD', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        CUNGTR
*
         SRNAMT = 'CUNGTR'
         INFOT = 1
         CALL CUNGTR( '/', 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNGTR( 'U', -1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUNGTR( 'U', 2, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL CUNGTR( 'U', 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'CUNGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        CUNMTR
*
         SRNAMT = 'CUNMTR'
         INFOT = 1
         CALL CUNMTR( '/', 'U', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNMTR( 'L', '/', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNMTR( 'L', 'U', '/', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUNMTR( 'L', 'U', 'N', -1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMTR( 'L', 'U', 'N', 0, -1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL CUNMTR( 'L', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL CUNMTR( 'R', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL CUNMTR( 'L', 'U', 'N', 2, 0, A, 2, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL CUNMTR( 'L', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL CUNMTR( 'R', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'CUNMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
      ELSE IF( LSAMEN( 2, C2, 'UP' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        of a symmetric packed matrix.
*
*        CHPTRD
*
         SRNAMT = 'CHPTRD'
         INFOT = 1
         CALL CHPTRD( '/', 0, A, D, E, TAU, INFO )
         CALL CHKXER( 'CHPTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CHPTRD( 'U', -1, A, D, E, TAU, INFO )
         CALL CHKXER( 'CHPTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 2
*
*        CUPGTR
*
         SRNAMT = 'CUPGTR'
         INFOT = 1
         CALL CUPGTR( '/', 0, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'CUPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUPGTR( 'U', -1, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'CUPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUPGTR( 'U', 2, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'CUPGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        CUPMTR
*
         SRNAMT = 'CUPMTR'
         INFOT = 1
         CALL CUPMTR( '/', 'U', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUPMTR( 'L', '/', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUPMTR( 'L', 'U', '/', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUPMTR( 'L', 'U', 'N', -1, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUPMTR( 'L', 'U', 'N', 0, -1, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL CUPMTR( 'L', 'U', 'N', 2, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'CUPMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
      ELSE IF( LSAMEN( 3, PATH, 'BRD' ) ) THEN
*
*        CGEBRD
*
         SRNAMT = 'CGEBRD'
         INFOT = 1
         CALL CGEBRD( -1, 0, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'CGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CGEBRD( 0, -1, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'CGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CGEBRD( 2, 1, A, 1, D, E, TQ, TP, W, 2, INFO )
         CALL CHKXER( 'CGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL CGEBRD( 2, 1, A, 2, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'CGEBRD', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        CUNGBR
*
         SRNAMT = 'CUNGBR'
         INFOT = 1
         CALL CUNGBR( '/', 0, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNGBR( 'Q', -1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGBR( 'Q', 0, -1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGBR( 'Q', 0, 1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGBR( 'Q', 1, 0, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGBR( 'P', 1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNGBR( 'P', 0, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUNGBR( 'Q', 0, 0, -1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUNGBR( 'Q', 2, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL CUNGBR( 'Q', 2, 2, 1, A, 2, TQ, W, 1, INFO )
         CALL CHKXER( 'CUNGBR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        CUNMBR
*
         SRNAMT = 'CUNMBR'
         INFOT = 1
         CALL CUNMBR( '/', 'L', 'C', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL CUNMBR( 'Q', '/', 'C', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL CUNMBR( 'Q', 'L', '/', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL CUNMBR( 'Q', 'L', 'C', -1, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL CUNMBR( 'Q', 'L', 'C', 0, -1, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL CUNMBR( 'Q', 'L', 'C', 0, 0, -1, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMBR( 'Q', 'L', 'C', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMBR( 'Q', 'R', 'C', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMBR( 'P', 'L', 'C', 2, 0, 2, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL CUNMBR( 'P', 'R', 'C', 0, 2, 2, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL CUNMBR( 'Q', 'R', 'C', 2, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL CUNMBR( 'Q', 'L', 'C', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL CUNMBR( 'Q', 'R', 'C', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'CUNMBR', INFOT, NOUT, LERR, OK )
         NT = NT + 13
      END IF
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of CERRRD
*
      END
