      SUBROUTINE CERRQL( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  CERRQL tests the error exits for the COMPLEX routines
*  that use the QL decomposition of a general matrix.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX
      PARAMETER          ( NMAX = 2 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, INFO, J
*     ..
*     .. Local Arrays ..
      COMPLEX            A( NMAX, NMAX ), AF( NMAX, NMAX ), B( NMAX ),
     $                   W( NMAX ), X( NMAX )
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CGEQLF, CGEQLS, CHKXER, CUNGQL, CUNMQL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CMPLX, REAL
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = CMPLX( 1. / REAL( I+J ), -1. / REAL( I+J ) )
            AF( I, J ) = CMPLX( 1. / REAL( I+J ), -1. / REAL( I+J ) )
   10    CONTINUE
         B( J ) = 0.
         W( J ) = 0.
         X( J ) = 0.
   20 CONTINUE
      OK = .TRUE.
*
*     Error exits for QL factorization
*
*     CGEQLF
*
      SRNAMT = 'CGEQLF'
      INFOT = 1
      CALL CGEQLF( -1, 0, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'CGEQLF', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CGEQLF( 0, -1, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'CGEQLF', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL CGEQLF( 2, 1, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'CGEQLF', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL CGEQLF( 1, 2, A, 1, B, W, 1, INFO )
      CALL CHKXER( 'CGEQLF', INFOT, NOUT, LERR, OK )
*
*     CGEQL2
*
!eca  SRNAMT = 'CGEQL2'
!eca  INFOT = 1
!eca  CALL CGEQL2( -1, 0, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'CGEQL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL CGEQL2( 0, -1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'CGEQL2', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL CGEQL2( 2, 1, A, 1, B, W, INFO )
!eca  CALL CHKXER( 'CGEQL2', INFOT, NOUT, LERR, OK )
*
*     CGEQLS
*
      SRNAMT = 'CGEQLS'
      INFOT = 1
      CALL CGEQLS( -1, 0, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CGEQLS( 0, -1, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CGEQLS( 1, 2, 0, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL CGEQLS( 0, 0, -1, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL CGEQLS( 2, 1, 0, A, 1, X, B, 2, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL CGEQLS( 2, 1, 0, A, 2, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL CGEQLS( 1, 1, 2, A, 1, X, B, 1, W, 1, INFO )
      CALL CHKXER( 'CGEQLS', INFOT, NOUT, LERR, OK )
*
*     CUNGQL
*
      SRNAMT = 'CUNGQL'
      INFOT = 1
      CALL CUNGQL( -1, 0, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CUNGQL( 0, -1, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CUNGQL( 1, 2, 0, A, 1, X, W, 2, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL CUNGQL( 0, 0, -1, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL CUNGQL( 1, 1, 2, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL CUNGQL( 2, 1, 0, A, 1, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
      INFOT = 8
      CALL CUNGQL( 2, 2, 0, A, 2, X, W, 1, INFO )
      CALL CHKXER( 'CUNGQL', INFOT, NOUT, LERR, OK )
*
*     CUNG2L
*
!eca  SRNAMT = 'CUNG2L'
!eca  INFOT = 1
!eca  CALL CUNG2L( -1, 0, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL CUNG2L( 0, -1, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL CUNG2L( 1, 2, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL CUNG2L( 0, 0, -1, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL CUNG2L( 2, 1, 2, A, 2, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL CUNG2L( 2, 1, 0, A, 1, X, W, INFO )
!eca  CALL CHKXER( 'CUNG2L', INFOT, NOUT, LERR, OK )
*
*     CUNMQL
*
      SRNAMT = 'CUNMQL'
      INFOT = 1
      CALL CUNMQL( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 2
      CALL CUNMQL( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 3
      CALL CUNMQL( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 4
      CALL CUNMQL( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL CUNMQL( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL CUNMQL( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 5
      CALL CUNMQL( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL CUNMQL( 'L', 'N', 2, 1, 0, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 7
      CALL CUNMQL( 'R', 'N', 1, 2, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 10
      CALL CUNMQL( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL CUNMQL( 'L', 'N', 1, 2, 0, A, 1, X, AF, 1, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
      INFOT = 12
      CALL CUNMQL( 'R', 'N', 2, 1, 0, A, 1, X, AF, 2, W, 1, INFO )
      CALL CHKXER( 'CUNMQL', INFOT, NOUT, LERR, OK )
*
*     CUNM2L
*
!eca  SRNAMT = 'CUNM2L'
!eca  INFOT = 1
!eca  CALL CUNM2L( '/', 'N', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 2
!eca  CALL CUNM2L( 'L', '/', 0, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 3
!eca  CALL CUNM2L( 'L', 'N', -1, 0, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 4
!eca  CALL CUNM2L( 'L', 'N', 0, -1, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL CUNM2L( 'L', 'N', 0, 0, -1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL CUNM2L( 'L', 'N', 0, 1, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 5
!eca  CALL CUNM2L( 'R', 'N', 1, 0, 1, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL CUNM2L( 'L', 'N', 2, 1, 0, A, 1, X, AF, 2, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 7
!eca  CALL CUNM2L( 'R', 'N', 1, 2, 0, A, 1, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
!eca  INFOT = 10
!eca  CALL CUNM2L( 'L', 'N', 2, 1, 0, A, 2, X, AF, 1, W, INFO )
!eca  CALL CHKXER( 'CUNM2L', INFOT, NOUT, LERR, OK )
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of CERRQL
*
      END
