      SUBROUTINE CBLT02( ISIDE, N, NRHS, X, LDX, Y, LDY, S, IPERM,
     &                   RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson
*     April 14, 2001
*
*     .. Scalar Arguments ..
      INTEGER            ISIDE, LDX, LDY, N, NRHS
      REAL               RESULT
*     ..
*     .. Array Arguments ..
      INTEGER            IPERM( * )
      REAL               S( * )
      COMPLEX            X( LDX, * ), Y( LDY, * )
*     ..
*
*  Purpose
*  =======
*
*  CBLT02 tests the permutations and scaling of an N-by-NRHS matrix X
*  as computed by CGEBAK.
*
*  Arguments
*  =========
*
*  ISIDE   (input) INTEGER
*          An integer code representing the value of the SIDE argument
*          = 1:  SIDE = 'L' in CGEBAK
*          = 2:  SIDE = 'R' in CGEBAK
*
*  N       (input) INTEGER
*          The number of rows of the arrays X and Y.
*
*  NRHS    (input) INTEGER
*          The number of columns of the arrays X and Y.
*
*  X       (input) COMPLEX array, dimension (N,NRHS)
*          The original matrix X before balancing.
*
*  LDX     (input) INTEGER
*          The leading dimension of the array X.  LDX >= max(1,N).
*
*  Y       (input) COMPLEX array, dimension (N,NRHS)
*          The matrix X (of eigenvectors) after application of the
*          permutations and scalings from CGEBAL as computed by CGEBAK.
*
*  LDY     (input) INTEGER
*          The leading dimension of the array Y.  LDY >= max(1,N).
*
*  S       (input) REAL array, dimension (N)
*          Details of the permutations and scaling factors applied to A.
*          If P(j) is the index of the row and column interchanged with
*          row and column j and D(j) is the scaling factor applied to
*          row and column j, then
*          S(j) = P(j)    for j = 1,...,ILO-1
*               = D(j)    for j = ILO,...,IHI
*               = P(j)    for j = IHI+1,...,N.
*          The order in which the interchanges are made is N to IHI+1,
*          then 1 to ILO-1.
*
*  IPERM   (input) INTEGER array, dimension (N)
*          The indices of the columns or rows of A after application of
*          the pivots returned by CGEBAL.
*
*  RESULT  (output) REAL
*          One of the test ratios computed for CGEBAK:
*          if ISIDE = 1, maximum relative error in y^T = x^T *inv(D)*P
*          if ISIDE = 2, maximum relative error in y = P^T *D*x
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E0, ZERO = 0.0E0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IP, J
      REAL               AERR, DENO, SFMIN
      COMPLEX            AEXP
*     ..
*     .. External Functions ..
      REAL               SLAMCH
      EXTERNAL           SLAMCH
*     ..
      AERR = ZERO
      SFMIN = SLAMCH( 'Safe minimum' )
      IF( ISIDE.EQ.1 ) THEN
         DO J = 1, NRHS
            DO I = 1, N
               IP = IPERM(I)
               AEXP = S(I)*X(I,J)
               DENO = MAX( ABS(AEXP), ABS(Y(IP,J)), SFMIN )
               AERR = MAX( AERR, ABS(AEXP-Y(IP,J)) / DENO )
            END DO
         END DO
      ELSE
         DO J = 1, NRHS
            DO I = 1, N
               IP = IPERM(I)
               AEXP = (ONE/S(I))*X(I,J)
               DENO = MAX( ABS(AEXP), ABS(Y(IP,J)), SFMIN )
               AERR = MAX( AERR, ABS(AEXP-Y(IP,J)) / DENO )
            END DO
         END DO
      END IF
      RESULT = AERR
      RETURN
      END
