#include "lapacknames.inc"
      SUBROUTINE SPTTS2( N, NRHS, D, E, B, LDB )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_SCAL
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      REAL(WP)           B( LDB, * ), D( * ), E( * )
*     ..
*
*  Purpose
*  =======
*
*  SPTTS2 solves a tridiagonal system of the form
*     A * X = B
*  using the L*D*L' factorization of A computed by SPTTRF.  D is a
*  diagonal matrix specified in the vector D, L is a unit bidiagonal
*  matrix whose subdiagonal is specified in the vector E, and X and B
*  are N by NRHS matrices.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the tridiagonal matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  D       (input) REAL array, dimension (N)
*          The n diagonal elements of the diagonal matrix D from the
*          L*D*L' factorization of A.
*
*  E       (input) REAL array, dimension (N-1)
*          The (n-1) subdiagonal elements of the unit bidiagonal factor
*          L from the L*D*L' factorization of A.  E can also be regarded
*          as the superdiagonal of the unit bidiagonal factor U from the
*          factorization A = U'*D*U.
*
*  B       (input/output) REAL array, dimension (LDB,NRHS)
*          On entry, the right hand side vectors B for the system of
*          linear equations.
*          On exit, the solution vectors, X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.1 ) THEN
         IF( N.EQ.1 )
     $      CALL LA_SCAL( NRHS, ONE / D( 1 ), B( 1, 1 ), LDB )
         RETURN
      END IF
*
*     Solve A * X = B using the factorization A = L*D*L',
*     overwriting each right hand side vector with its solution.
*
      DO 40 J = 1, NRHS
*
*        Solve L * x = b.
*
         DO 20 I = 2, N
            B( I, J ) = B( I, J ) - B( I-1, J )*E( I-1 )
   20    CONTINUE
*
*        Solve D * L' * x = b.
*
         B( N, J ) = B( N, J ) / D( N )
         DO 30 I = N - 1, 1, -1
            B( I, J ) = B( I, J ) / D( I ) - B( I+1, J )*E( I )
   30    CONTINUE
   40 CONTINUE
*
      RETURN
*
*     End of SPTTS2
*
      END
