#include "lapacknames.inc"
      SUBROUTINE SLATZM( SIDE, M, N, V, INCV, TAU, C1, C2, LDC, WORK )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME
      USE LA_BLAS1, ONLY: LA_AXPY, LA_COPY
      USE LA_BLAS2, ONLY: LA_GEMV, LA_GER
*
*  -- LAPACK routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     February 29, 1992
*     05-08-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          SIDE
      INTEGER            INCV, LDC, M, N
      REAL(WP)           TAU
*     ..
*     .. Array Arguments ..
      REAL(WP)           C1( LDC, * ), C2( LDC, * ), V( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  This routine is deprecated and has been replaced by routine SORMRZ.
*
*  SLATZM applies a Householder matrix generated by STZRQF to a matrix.
*
*  Let P = I - tau*u*u',   u = ( 1 ),
*                              ( v )
*  where v is an (m-1) vector if SIDE = 'L', or a (n-1) vector if
*  SIDE = 'R'.
*
*  If SIDE equals 'L', let
*         C = [ C1 ] 1
*             [ C2 ] m-1
*               n
*  Then C is overwritten by P*C.
*
*  If SIDE equals 'R', let
*         C = [ C1, C2 ] m
*                1  n-1
*  Then C is overwritten by C*P.
*
*  Arguments
*  =========
*
*  SIDE    (input) CHARACTER*1
*          = 'L': form P * C
*          = 'R': form C * P
*
*  M       (input) INTEGER
*          The number of rows of the matrix C.
*
*  N       (input) INTEGER
*          The number of columns of the matrix C.
*
*  V       (input) REAL array, dimension
*                  (1 + (M-1)*abs(INCV)) if SIDE = 'L'
*                  (1 + (N-1)*abs(INCV)) if SIDE = 'R'
*          The vector v in the representation of P. V is not used
*          if TAU = 0.
*
*  INCV    (input) INTEGER
*          The increment between elements of v. INCV <> 0
*
*  TAU     (input) REAL
*          The value tau in the representation of P.
*
*  C1      (input/output) REAL array, dimension
*                         (LDC,N) if SIDE = 'L'
*                         (M,1)   if SIDE = 'R'
*          On entry, the n-vector C1 if SIDE = 'L', or the m-vector C1
*          if SIDE = 'R'.
*
*          On exit, the first row of P*C if SIDE = 'L', or the first
*          column of C*P if SIDE = 'R'.
*
*  C2      (input/output) REAL array, dimension
*                         (LDC, N)   if SIDE = 'L'
*                         (LDC, N-1) if SIDE = 'R'
*          On entry, the (m - 1) x n matrix C2 if SIDE = 'L', or the
*          m x (n - 1) matrix C2 if SIDE = 'R'.
*
*          On exit, rows 2:m of P*C if SIDE = 'L', or columns 2:m of C*P
*          if SIDE = 'R'.
*
*  LDC     (input) INTEGER
*          The leading dimension of the arrays C1 and C2.
*          LDC >= max(1,M).
*
*  WORK    (workspace) REAL array, dimension
*                      (N) if SIDE = 'L'
*                      (M) if SIDE = 'R'
*
*  =====================================================================
*
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      IF( ( MIN( M, N ).EQ.0 ) .OR. ( TAU.EQ.ZERO ) )
     $   RETURN
*
      IF( LSAME( SIDE, 'L' ) ) THEN
*
*        w := C1 + v' * C2
*
         CALL LA_COPY( N, C1(1,1), LDC, WORK(1), 1 )
         CALL LA_GEMV( 'Transpose', M-1, N, ONE, C2(1,1), LDC, V(1),
     $                 INCV, ONE, WORK(1), 1 )
*
*        [ C1 ] := [ C1 ] - tau* [ 1 ] * w'
*        [ C2 ]    [ C2 ]        [ v ]
*
         CALL LA_AXPY( N, -TAU, WORK(1), 1, C1(1,1), LDC )
         CALL LA_GER( M-1, N, -TAU, V(1), INCV, WORK(1), 1, C2(1,1),
     $                LDC )
*
      ELSE IF( LSAME( SIDE, 'R' ) ) THEN
*
*        w := C1 + C2 * v
*
         CALL LA_COPY( M, C1(1,1), 1, WORK(1), 1 )
         CALL LA_GEMV( 'No transpose', M, N-1, ONE, C2(1,1), LDC, V(1),
     $                 INCV, ONE, WORK(1), 1 )
*
*        [ C1, C2 ] := [ C1, C2 ] - tau* w * [ 1 , v']
*
         CALL LA_AXPY( M, -TAU, WORK(1), 1, C1(1,1), 1 )
         CALL LA_GER( M, N-1, -TAU, WORK(1), 1, V(1), INCV, C2(1,1),
     $                LDC )
      END IF
*
      RETURN
*
*     End of SLATZM
*
      END
