#include "lapacknames.inc"
      SUBROUTINE SLASSQ( N, X, INCX, SCL, SUMSQ )
      USE LA_CONSTANTS
!
!  -- LAPACK auxiliary routine (version 2.0) --
!     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
!     Courant Institute, Argonne National Lab, and Rice University
!     October 31, 1992
!     10-15-99:  New version based on LAWN 126 (eca)
!     08-31-01:  Use smaller constants for 32-bit IEEE (eca)
!     09-25-01:  Don't scale by < SAFMIN or more than SAFMAX (eca)
!     04-19-02:  LAPACK 3E version (eca)
!
!     .. Scalar Arguments ..
      INTEGER            INCX, N
      REAL(WP)           SCL, SUMSQ
!     ..
!     .. Array Arguments ..
      REAL(WP)           X( * )
!     ..
!
!  Purpose
!  =======
!
!  SLASSQ  returns the values  scl  and  smsq  such that
!
!     ( scl**2 )*smsq = x( 1 )**2 +...+ x( n )**2 + ( scale**2 )*sumsq,
!
!  where  x( i ) = X( 1 + ( i - 1 )*INCX ). The value of  sumsq  is
!  assumed to be non-negative and  scl  returns the value
!
!     scl = max( scale, abs( x( i ) ) ).
!
!  scale and sumsq must be supplied in SCL and SUMSQ and
!  scl and smsq are overwritten on SCL and SUMSQ respectively.
!
!  Arguments
!  =========
!
!  N       (input) INTEGER
!          The number of elements to be used from the vector X.
!
!  X       (input) REAL array, dimension (N)
!          The vector for which a scaled sum of squares is computed.
!             x( i )  = X( 1 + ( i - 1 )*INCX ), 1 <= i <= n.
!
!  INCX    (input) INTEGER
!          The increment between successive values of the vector X.
!          INCX > 0.
!
!  SCL     (input/output) REAL
!          On entry, the value  scale  in the equation above.
!          On exit, SCL is overwritten with  scl , the scaling factor
!          for the sum of squares.
!
!  SUMSQ   (input/output) REAL
!          On entry, the value  sumsq  in the equation above.
!          On exit, SUMSQ is overwritten with  smsq , the basic sum of
!          squares from which  scl  has been factored out.
!
! =====================================================================
!
!     .. Local Scalars ..
      INTEGER            I, IX
      REAL(WP)           HITEST, SMAX, SQMAX
!     ..
!     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, REAL
!     ..
!     .. Executable Statements ..
!
      IF( N.LE.0 ) RETURN
      HITEST = RTMAX / REAL( N+1, WP )
      IF( SUMSQ.EQ.ZERO ) SCL = ONE
!
      IF( INCX.EQ.1 ) THEN
!
!        Pass through once to find the maximum value in X.
!
         SMAX = ZERO
         DO I = 1, N
            SMAX = MAX( SMAX, ABS(X(I)) )
         END DO
         SQMAX = MAX( SCL*SQRT( SUMSQ ), SMAX )
!
         IF( SCL.EQ.ONE .AND. SQMAX.GT.RTMIN .AND. SQMAX.LT.HITEST )
     &      THEN
!
!           If SCL = ONE and SQMAX is greater than RTMIN and less than
!           HITEST, no scaling should be needed.
!
            DO I = 1, N
               SUMSQ = SUMSQ + X(I)**2
            END DO
         ELSE IF( SMAX.GT.ZERO ) THEN
!
!           Scale by SQMAX if SCL = ONE, otherwise scale by
!           max( SQMAX, SCL ).
!
            SQMAX = MIN( MAX( SQMAX, SAFMIN ), SAFMAX )
            IF( SCL.EQ.ONE .OR. SCL.LT.SQMAX ) THEN
               SUMSQ = ( SUMSQ*( SCL / SQMAX ) )*( SCL / SQMAX )
               SCL = SQMAX
            END IF
!
!           Add the sum of squares of values of X scaled by SCL.
!
            DO I = 1, N
               SUMSQ = SUMSQ + ( X(I) / SCL )**2
            END DO
         END IF
      ELSE
!
!        Pass through once to find the maximum value in X.
!
         SMAX = ZERO
         IX = 1
         IF( INCX.LT.0 ) IX = 1 - (N-1)*INCX
         DO I = 1, N
            SMAX = MAX( SMAX, ABS(X(IX)) )
            IX = IX + INCX
         END DO
         SQMAX = MAX( SCL*SQRT( SUMSQ ), SMAX )
!
         IF( SCL.EQ.ONE .AND. SQMAX.GT.RTMIN .AND. SQMAX.LT.HITEST )
     &      THEN
!
!           If SCL = ONE and SQMAX is greater than RTMIN and less than
!           HITEST, no scaling should be needed.
!
            IX = 1
            IF( INCX.LT.0 ) IX = 1 - (N-1)*INCX
            DO I = 1, N
               SUMSQ = SUMSQ + X(IX)**2
               IX = IX + INCX
            END DO
         ELSE IF( SMAX.GT.ZERO ) THEN
!
!           Scale by SQMAX if SCL = ONE, otherwise scale by
!           max( SQMAX, SCL ).
!
            SQMAX = MIN( MAX( SQMAX, SAFMIN ), SAFMAX )
            IF( SCL.EQ.ONE .OR. SCL.LT.SQMAX ) THEN
               SUMSQ = ( SUMSQ*( SCL / SQMAX ) )*( SCL / SQMAX )
               SCL = SQMAX
            END IF
!
!           Add the sum of squares of values of X scaled by SCL.
!
            IX = 1
            IF( INCX.LT.0 ) IX = 1 - (N-1)*INCX
            DO I = 1, N
               SUMSQ = SUMSQ + ( X(IX) / SCL )**2
               IX = IX + INCX
            END DO
         END IF
      END IF
      RETURN
      END
