#include "lapacknames.inc"
      SUBROUTINE SLARRF( N, D, L, LD, LLD, IFIRST, ILAST, W, SIGMA,
     $                   DPLUS, LPLUS, WORK, INFO )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_COPY
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     03-29-02:  Inderjit's latest version
*     08-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IFIRST, ILAST, INFO, N
      REAL(WP)           SIGMA
*     ..
*     .. Array Arguments ..
      REAL(WP)           D( * ), DPLUS( * ), L( * ), LD( * ), LLD( * ),
     $                   LPLUS( * ), W( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  Given the initial representation L D L^T and its cluster of close
*  eigenvalues (in a relative measure), W( IFIRST ), W( IFIRST+1 ), ...
*  W( ILAST ), SLARRF finds a new relatively robust representation
*  L D L^T - SIGMA I = L(+) D(+) L(+)^T such that at least one of the
*  eigenvalues of L(+) D(+) L(+)^T is relatively isolated.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix.
*
*  D       (input) REAL array, dimension (N)
*          The N diagonal elements of the diagonal matrix D.
*
*  L       (input) REAL array, dimension (N-1)
*          The (N-1) subdiagonal elements of the unit bidiagonal
*          matrix L.
*
*  LD      (input) REAL array, dimension (N-1)
*          The (N-1) elements L(i)*D(i).
*
*  LLD     (input) REAL array, dimension (N-1)
*          The (N-1) elements L(i)*L(i)*D(i).
*
*  IFIRST  (input) INTEGER
*          The index of the first eigenvalue in the cluster.
*
*  ILAST   (input) INTEGER
*          The index of the last eigenvalue in the cluster.
*
*  W       (input) REAL array, dimension (N)
*          The eigenvalues of L D L^T in ascending order.
*          W( IFIRST ) through W( ILAST ) form the cluster of relatively
*          close eigenalues.
*
*  SIGMA   (output) REAL
*          The shift used to form L(+) D(+) L(+)^T.
*
*  DPLUS   (output) REAL array, dimension (N)
*          The N diagonal elements of the diagonal matrix D(+).
*
*  LPLUS   (output) REAL array, dimension (N-1)
*          The first (N-1) elements of LPLUS contain the subdiagonal
*          elements of the unit bidiagonal matrix L(+).
*
*  WORK    (workspace) REAL array, dimension (2*N)
*
*  INFO    (output) INTEGER
*          Always returns 0 in this version.
*
*  Further Details
*  ===============
*
*  Based on contributions by
*     Inderjit Dhillon, University of Texas, Austin, USA
*     Osni Marques, LBNL/NERSC, USA
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I
      REAL(WP)           DELTA, DMAX1, DMAX2, S, TMP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS
*     ..
*     .. Executable Statements ..
*
      INFO = 0
      SIGMA = W( IFIRST )
      DELTA = TWO * ULP
*
*     Compute the new relatively robust representation (RRR)
*
   10 CONTINUE
      S = -SIGMA
      DPLUS( 1 ) = D( 1 ) + S
      DMAX1 = ABS( DPLUS( 1 ) )
      DO 20 I = 1, N - 1
         LPLUS( I ) = LD( I ) / DPLUS( I )
         S = S*LPLUS( I )*L( I ) - SIGMA
         DPLUS( I+1 ) = D( I+1 ) + S
         DMAX1 = MAX( DMAX1, ABS( DPLUS( I+1 ) ) )
   20 CONTINUE
      IF( .NOT.( DMAX1.GT.ZERO .OR. DMAX1.LT.ONE ) ) THEN
         SIGMA = SIGMA - ABS( SIGMA )*DELTA
         DELTA = TWO*DELTA
         GO TO 10
      END IF
*
      TMP = W( ILAST )
      DELTA = TWO * ULP
   30 CONTINUE
      S = -TMP
      WORK( 1 ) = D( 1 ) + S
      DMAX2 = ABS( WORK( 1 ) )
      DO 40 I = 1, N - 1
         WORK( N+I ) = LD( I ) / WORK( I )
         S = S*WORK( N+I )*L( I ) - TMP
         WORK( I+1 ) = D( I+1 ) + S
         DMAX2 = MAX( DMAX2, ABS( WORK( I+1 ) ) )
   40 CONTINUE
      IF( .NOT.( DMAX2.GT.ZERO .OR. DMAX2.LT.ONE ) ) THEN
         TMP = TMP + ABS( TMP )*DELTA
         DELTA = TWO*DELTA
         GO TO 30
      END IF
      IF( DMAX2.LT.DMAX1 ) THEN
         SIGMA = TMP
         CALL LA_COPY( N, WORK(1), 1, DPLUS(1), 1 )
         CALL LA_COPY( N-1, WORK(N+1), 1, LPLUS(1), 1 )
      END IF
*
      RETURN
*
*     End of SLARRF
*
      END
