#include "lapacknames.inc"
      SUBROUTINE SLARRE( RANGE, N, VL, VU, IL, IU, D, E, TOL,
     $                   NSPLIT, ISPLIT, M, W, IBLOCK, INDEXW,
     $                   GERSCH, WORK, IWORK, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, LA_LASRT
      USE LA_BLAS1, ONLY: LA_COPY
      USE LA_XLASQX, ONLY: LA_LADQ2
      USE LA_XLARRX, ONLY: LA_LARRB
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     03-29-02:  Inderjit's latest version
*     08-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          RANGE
      INTEGER            IL, INFO, IU, M, N, NSPLIT
      REAL(WP)           TOL, VL, VU
*     ..
*     .. Array Arguments ..
      INTEGER            IBLOCK( * ), ISPLIT( * ), IWORK( * ),
     $                   INDEXW( * )
      REAL(WP)           D( * ), E( * ), GERSCH( * ), W( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  Given the tridiagonal matrix T, SLARRE sets "small" off-diagonal
*  elements to zero, and for each unreduced block T_i, it finds
*  (a) the numbers sigma_i
*  (b) the base, T_i - sigma_i I = L_i D_i L_i^T, representations and
*  (c) eigenvalues of each L_i D_i L_i^T.
*  The representations and eigenvalues found are then used by
*  SSTEGR to compute the eigenvectors of a symmetric tridiagonal
*  matrix. Currently, the base representations are limited to being
*  positive or negative definite, and the eigenvalues of the definite
*  matrices are found by the dqds algorithm (subroutine DLADQ2) to
*  high relative accuracy, with respect to the non-trivial entries of
*  L_i and D_i. As an added benefit, SLARRE also outputs the n
*  Gerschgorin intervals for the matrices L_i D_i L_i^T.
*  NOTE: Even if RANGE='V' or RANGE='I', currently ALL eigenvalues
*  are computed using DLADQ2, and then the unwanted eigenvalues
*  are discarded. When the number of desired eigenvalues is small, a
*  better solution would be to use bisection.
*
*  Arguments
*  =========
*
*  RANGE   (input) CHARACTER
*          = 'A': ("All")   all eigenvalues will be found.
*          = 'V': ("Value") all eigenvalues in the half-open interval
*                           (VL, VU] will be found.
*          = 'I': ("Index") the IL-th through IU-th eigenvalues (of the
*                           entire matrix) will be found.
*
*  N       (input) INTEGER
*          The order of the matrix. N > 0.
*
*  VL      (input) REAL
*  VU      (input) REAL
*          If RANGE='V', the lower and upper bounds for the eigenvalues.
*          Eigenvalues less than or equal to VL, or greater than VU,
*          will not be returned.  VL < VU.
*          Not referenced if RANGE = 'A' or 'I'.
*
*  IL      (input) INTEGER
*  IU      (input) INTEGER
*          If RANGE='I', the indices (in ascending order) of the
*          smallest and largest eigenvalues to be returned.
*          1 <= IL <= IU <= N.
*          Not referenced if RANGE = 'A' or 'V'.
*
*  D       (input/output) REAL array, dimension (N)
*          On entry, the N diagonal elements of the tridiagonal
*          matrix T.
*          On exit, the N diagonal elements of the diagonal
*          matrices D_i.
*
*  E       (input/output) REAL array, dimension (N)
*          On entry, the first (N-1) entries contain the subdiagonal
*          elements of the tridiagonal matrix T; E(N) need not be set.
*          On exit, E contains the subdiagonal elements of the unit
*          bidiagonal matrices L_i. The entries E( ISPLIT( I ) ),
*          1 <= I <= NSPLIT, contain the base points sigma_i on output.
*
*  TOL     (input) REAL
*          The threshold for splitting. If on input |E(i)| < TOL, then
*          the matrix T is split into smaller block diagonal matrices.
*
*  NSPLIT  (output) INTEGER
*          The number of blocks T splits into. 1 <= NSPLIT <= N.
*
*  ISPLIT  (output) INTEGER array, dimension (2*N)
*          The splitting points, at which T breaks up into blocks.
*          The first block consists of rows/columns 1 to ISPLIT(1),
*          the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),
*          etc., and the NSPLIT-th consists of rows/columns
*          ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N.
*
*  M       (output) INTEGER
*          The total number of eigenvalues (of all L_i D_i L_i^T)
*          found.
*
*  W       (output) REAL array, dimension (N)
*          The first M elements contain the eigenvalues. The
*          eigenvalues of each of the blocks, L_i D_i L_i^T, are
*          sorted in ascending order ( SLARRE may use the
*          remaining N-M elements as workspace).
*
*  IBLOCK  (output) INTEGER array, dimension (N)
*          The indices of the blocks (submatrices) associated with the
*          corresponding eigenvalues in W; IBLOCK(i)=1 if eigenvalue
*          W(i) belongs to the first block from the top, =2 if W(i)
*          belongs to the second block, etc.
*
*  INDEXW  (output) INTEGER array, dimension (N)
*          The indices of the eigenvalues within each block (submatrix);
*          for example, INDEXW(i)= 10 and IBLOCK(i)=2 imply that the
*          i-th eigenvalue W(i) is the 10-th eigenvalue in the second
*          block.
*
*  GERSCH  (output) REAL array, dimension (2*N)
*          The N Gerschgorin intervals (the i-th Gerschgorin interval
*          is (GERSCH(2*i-1), GERSCH(2*i)).
*
*  WORK    (workspace) REAL array, dimension (7*N)
*
*  IWORK   (workspace) INTEGER array, dimension (2*N)
*
*  INFO    (output) INTEGER
*          Output error code from DLADQ2
*
*  Further Details
*  ===============
*
*  Based on contributions by
*     Inderjit Dhillon, University of Texas, Austin, USA
*     Osni Marques, LBNL/NERSC, USA
*
*  =====================================================================
*
*     .. Parameters ..
      REAL(WP)           FOURTH
      PARAMETER          ( FOURTH = 0.25_WP )
*     ..
*     .. Local Scalars ..
      INTEGER            CNT, I, IBEGIN, IEND, IINFO, IN, IRANGE, ITMP,
     $                   J, JBLK, K, MAXCNT, TILL
      REAL(WP)           DELTA, GL, GU, NRM, OFFD, RTOL, S, SGNDEF,
     $                   SIGMA, T1, T2, TAU, TMP, VVL, VVU, WIDTH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN
*     ..
*     .. Executable Statements ..
*
      INFO = 0
*
*     Decode RANGE
*
      IF( LSAME( RANGE, 'A' ) ) THEN
         IRANGE = 1
      ELSE IF( LSAME( RANGE, 'V' ) ) THEN
         IRANGE = 2
      ELSE IF( LSAME( RANGE, 'I' ) ) THEN
         IRANGE = 3
      END IF
*
*     Simplifications:
*
*     IF( IRANGE.EQ.3 .AND. IL.EQ.1 .AND. IU.EQ.N )
*    $   IRANGE = 1
*
      M = 0
*
*     Compute Splitting Points
*
      NSPLIT = 1
      DO 10 I = 1, N - 1
         IF( ABS( E( I ) ).LE.TOL ) THEN
            ISPLIT( NSPLIT ) = I
            NSPLIT = NSPLIT + 1
         END IF
   10 CONTINUE
      ISPLIT( NSPLIT ) = N
*
      IBEGIN = 1
      DO 170 JBLK = 1, NSPLIT
         IEND = ISPLIT( JBLK )
         IF( IBEGIN.EQ.IEND ) THEN
            M = M + 1
            W( M ) = D( IBEGIN )
            IBLOCK( M ) = JBLK
            INDEXW( M ) = 1
            E( IEND ) = ZERO
            IBEGIN = IEND + 1
            GO TO 170
         END IF
         IN = IEND - IBEGIN + 1
*
*        Form the IN Gerschgorin intervals
*
         GL = D( IBEGIN ) - ABS( E( IBEGIN ) )
         GU = D( IBEGIN ) + ABS( E( IBEGIN ) )
         GERSCH( 2*IBEGIN-1 ) = GL
         GERSCH( 2*IBEGIN ) = GU
         GERSCH( 2*IEND-1 ) = D( IEND ) - ABS( E( IEND-1 ) )
         GERSCH( 2*IEND ) = D( IEND ) + ABS( E( IEND-1 ) )
         GL = MIN( GERSCH( 2*IEND-1 ), GL )
         GU = MAX( GERSCH( 2*IEND ), GU )
         DO 20 I = IBEGIN + 1, IEND - 1
            OFFD = ABS( E( I-1 ) ) + ABS( E( I ) )
            GERSCH( 2*I-1 ) = D( I ) - OFFD
            GL = MIN( GERSCH( 2*I-1 ), GL )
            GERSCH( 2*I ) = D( I ) + OFFD
            GU = MAX( GERSCH( 2*I ), GU )
   20    CONTINUE
         NRM = MAX( ABS( GL ), ABS( GU ) )
*
*        Set SIGMA to either GL or GU and then form
*        T - SIGMA I = L D L^T.
*
         WIDTH = GU - GL
         DO 30 I = IBEGIN, IEND - 1
            WORK( I ) = E( I )*E( I )
   30    CONTINUE
         DO 50 J = 1, 2
            IF( J.EQ.1 ) THEN
               TAU = GL + FOURTH*WIDTH
            ELSE
               TAU = GU - FOURTH*WIDTH
            END IF
            TMP = D( IBEGIN ) - TAU
            IF( TMP.LT.ZERO ) THEN
               CNT = 1
            ELSE
               CNT = 0
            END IF
            DO 40 I = IBEGIN + 1, IEND
               TMP = D( I ) - TAU - WORK( I-1 ) / TMP
               IF( TMP.LT.ZERO )
     $            CNT = CNT + 1
   40       CONTINUE
            IF( CNT.EQ.0 ) THEN
               GL = TAU
            ELSE IF( CNT.EQ.IN ) THEN
               GU = TAU
            END IF
            IF( J.EQ.1 ) THEN
               MAXCNT = CNT
               SIGMA = GL
               SGNDEF = ONE
            ELSE
               IF( IN-CNT.GT.MAXCNT ) THEN
                  SIGMA = GU
                  SGNDEF = -ONE
               END IF
            END IF
   50    CONTINUE
*
*        Compute T - SIGMA I = L D L^T.
*
         WORK( 3*IN ) = ONE
         DELTA = EPS
         TAU = SGNDEF*NRM
   60    CONTINUE
         SIGMA = SIGMA - DELTA*TAU
         WORK( 1 ) = D( IBEGIN ) - SIGMA
         J = IBEGIN
         DO 70 I = 1, IN - 1
            WORK( 2*IN+I ) = ONE / WORK( I )
            TMP = E( J )*WORK( 2*IN+I )
            WORK( I+1 ) = ( D( J+1 )-SIGMA ) - TMP*E( J )
            WORK( IN+I ) = TMP
            J = J + 1
   70    CONTINUE
         DO 80 I = IN, 1, -1
            TMP = SGNDEF*WORK( I )
            IF( TMP.LT.ZERO .OR. WORK( 2*IN+I ).EQ.ZERO .OR. .NOT.
     $          ( TMP.GT.ZERO .OR. TMP.LT.ONE ) ) THEN
               DELTA = TWO*DELTA
               GO TO 60
            END IF
   80    CONTINUE
*
*        Compute the leftmost or rightmost eigenvalue (depending
*        upon SGNDEF) of L D L^T.
*
         CALL LA_COPY( IN, WORK( 1 ), 1, D( IBEGIN ), 1 )
         CALL LA_COPY( IN-1, WORK( IN+1 ), 1, E( IBEGIN ), 1 )
         DO 85 I = 1, IN-1
            WORK( 3*IN+I ) = WORK( I ) * WORK( IN+I )
            WORK( 4*IN+I ) = WORK( 3*IN+I ) * WORK( IN+I )
   85    CONTINUE
         IF( SGNDEF.GT.ZERO ) THEN
            CNT = 1
            WORK( 1 ) = ( GL + GU ) / TWO - SIGMA
            WORK( IN+1 ) = ZERO
            WORK( 2*IN+1 ) = ( GU - GL ) / TWO
         ELSE
            CNT = IN
            WORK( IN ) = ( GL + GU ) / TWO - SIGMA
            WORK( 2*IN ) = ZERO
            WORK( 3*IN ) = ( GU - GL ) / TWO
         END IF
         RTOL = FOUR * EPS
         CALL LA_LARRB( IN, D( IBEGIN ), E( IBEGIN ), WORK( 3*IN+1 ),
     $                  WORK( 4*IN+1 ), CNT, CNT, RTOL, RTOL, 0,
     $                  WORK( 1 ), WORK( IN+1 ), WORK( 2*IN+1 ),
     $                  WORK( 5*IN+1 ), IWORK( 1 ), IINFO )
         IF( SGNDEF.GT.ZERO ) THEN
            TAU = WORK( 1 ) - WORK( 2*IN+1 )
         ELSE
            TAU = WORK( IN ) + WORK( 3*IN )
         END IF
*
         WORK( 3*IN ) = ONE
         DELTA = TWO*EPS
  100    CONTINUE
         TAU = TAU*( ONE-DELTA )
*
*        Shift by TAU to get the base L D L^T representation (using
*        the differential stationary qd transform).
*
         S = -TAU
         J = IBEGIN
         DO 110 I = 1, IN - 1
            WORK( I ) = D( J ) + S
            WORK( 2*IN+I ) = ONE / WORK( I )
            WORK( IN+I ) = ( E( J )*D( J ) )*WORK( 2*IN+I )
            S = S*WORK( IN+I )*E( J ) - TAU
            J = J + 1
  110    CONTINUE
         WORK( IN ) = D( IEND ) + S
*
*        Check to ensure that all diagonal elements of the new
*        L D L^T representation have the same sign
*
         DO 120 I = IN, 1, -1
            TMP = SGNDEF*WORK( I )
            IF( TMP.LT.ZERO .OR. WORK( 2*IN+I ).EQ.ZERO .OR. .NOT.
     $          ( TMP.GT.ZERO .OR. TMP.LT.ONE ) ) THEN
               DELTA = TWO*DELTA
               GO TO 100
            END IF
  120    CONTINUE
*
         SIGMA = SIGMA + TAU
         CALL LA_COPY( IN, WORK( 1 ), 1, D( IBEGIN ), 1 )
         CALL LA_COPY( IN-1, WORK( IN+1 ), 1, E( IBEGIN ), 1 )
         E( IEND ) = SIGMA
*
*        Update the Gerschgorin intervals
*
         TMP = FOUR*REAL( IN, WP )*EPS * ( ABS( SIGMA ) + ABS( TAU ) )
         DO 130 I = IBEGIN, IEND
            GERSCH( 2*I-1 ) = GERSCH( 2*I-1 ) - SIGMA - TMP
            GERSCH( 2*I ) = GERSCH( 2*I ) - SIGMA + TMP
  130    CONTINUE
*
*        Compute the eigenvalues of L D L^T.
*
         J = IBEGIN
         DO 140 I = 1, IN - 1
            WORK( 2*I-1 ) = ABS( D( J ) )
            WORK( 2*I ) = E( J )*E( J )*WORK( 2*I-1 )
            J = J + 1
  140    CONTINUE
         WORK( 2*IN-1 ) = ABS( D( IEND ) )
*
         CALL LA_LADQ2( IN, WORK, INFO )
         IF( INFO.NE.0 ) RETURN
*
         IF( SGNDEF.GT.ZERO ) THEN
            DO 150 I = 1, IN
               M = M + 1
               W( M ) = WORK( IN-I+1 )
               IBLOCK( M ) = JBLK
               INDEXW( M ) = I
  150       CONTINUE
         ELSE
            DO 160 I = 1, IN
               M = M + 1
               W( M ) = -WORK( I )
               IBLOCK( M ) = JBLK
               INDEXW( M ) = I
  160       CONTINUE
         END IF
         IBEGIN = IEND + 1
  170 CONTINUE
      IF( IRANGE.EQ.2 ) THEN
         M = 0
         IBEGIN = 1
         DO 200 I = 1, NSPLIT
            IEND = ISPLIT ( I )
            VVL = VL - E( IEND )
            VVU = VU - E( IEND )
            DO 210 J = IBEGIN, IEND
               IF( VVL.LE.W( J ) .AND. W( J ).LE.VVU ) THEN
                  M = M + 1
                  W( M ) = W( J )
                  IBLOCK( M ) = I
                  INDEXW( M ) = J-IBEGIN+1
               END IF
  210       CONTINUE
            IBEGIN = IEND + 1
  200    CONTINUE
      ELSE IF( IRANGE.EQ.3 ) THEN
         M = IU - IL + 1
         IF( NSPLIT.EQ.1 ) THEN
            DO 171 I = 1, M
               W( I ) = W( IL+I-1 )
               INDEXW( I ) = IL+I-1
  171       CONTINUE
         ELSE
            IBEGIN = 1
            DO 180 I = 1, NSPLIT
               IEND = ISPLIT ( I )
               DO 190 J = IBEGIN, IEND
                  WORK( J ) = W( J ) + E( IEND )
  190          CONTINUE
               IBEGIN = IEND + 1
  180       CONTINUE
            DO 175 I = 1, N
               IWORK( I ) = I
               IWORK( N+I ) = IBLOCK( I )
 175        CONTINUE
            CALL LA_LASRT( 'I', N, WORK, IWORK, IINFO )
            DO 185 I = 1, M
               ITMP = IWORK( IL+I-1 )
               WORK( I ) = W( ITMP )
               IBLOCK( I ) = IWORK( N+ITMP )
  185       CONTINUE
            DO 186 I = 1, M
               IWORK( N+I ) = IWORK( IL+I-1 )
               IWORK( I ) = I
 186        CONTINUE
            CALL LA_LASRT( 'I', M, IBLOCK, IWORK, IINFO )
            J = 1
            ITMP = IBLOCK( J )
            CNT = IWORK( N+IWORK( J ) )
            IF( ITMP.EQ.1 ) THEN
               IBEGIN = 1
            ELSE
               IBEGIN = ISPLIT( ITMP-1 ) + 1
            END IF
            DO 187 I = 1, M
               W( I ) = WORK( IWORK( I ) )
               IF( IBLOCK( I ).NE.ITMP .OR. I.EQ.M ) THEN
                  IF( IBLOCK( I ).EQ.ITMP ) THEN
                     TILL = M
                  ELSE
                     TILL = I-1
                  END IF
                  CALL LA_LASRT( 'I', TILL-J+1, W( J ), IINFO )
                  CNT = CNT - IBEGIN + 1
                  DO 188 K = J, TILL
                     INDEXW( K ) = CNT+K-J
  188             CONTINUE
                  J = I
                  ITMP = IBLOCK( J )
                  CNT = IWORK( N+IWORK( J ) )
                  IBEGIN = ISPLIT( ITMP-1 ) + 1
                  IF( I.EQ.M .AND. TILL.LT.M ) THEN
                     INDEXW( M ) = CNT-IBEGIN+1
                  END IF
               ELSE
                  CNT = MIN( CNT, IWORK( N+IWORK( I ) ) )
               END IF
  187       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of SLARRE
*
      END
