#include "lapacknames.inc"
      SUBROUTINE SLARRB( N, D, L, LD, LLD, IFIRST, ILAST, RTOL1,
     $                   RTOL2, OFFSET, W, WGAP, WERR, WORK, IWORK,
     $                   INFO )
      USE LA_CONSTANTS
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     03-29-02:  Inderjit's latest version
*     08-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IFIRST, ILAST, INFO, N, OFFSET
      REAL(WP)           RTOL1, RTOL2
*     ..
*     .. Array Arguments ..
      INTEGER            IWORK( * )
      REAL(WP)           D( * ), L( * ), LD( * ), LLD( * ), W( * ),
     $                   WERR( * ), WGAP( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  Given the relatively robust representation(RRR) L D L^T, SLARRB
*  does "limited" bisection to refine the eigenvalues of L D L^T,
*  W( IFIRST-OFFSET ) through W( ILAST-OFFSET ), to more accuracy.
*  Initial guesses for these eigenvalues are input in W, the
*  corresponding estimate of the error in these guesses and their gaps
*  are input in WERR and WGAP, respectively. During bisection, intervals
*  [left, right] are maintained by storing their mid-points and
*  semi-widths in the arrays W and WERR respectively.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix.
*
*  D       (input) REAL array, dimension (N)
*          The N diagonal elements of the diagonal matrix D.
*
*  L       (input) REAL array, dimension (N-1)
*          The (N-1) subdiagonal elements of the unit bidiagonal matrix
*          L.
*
*  LD      (input) REAL array, dimension (N-1)
*          The (N-1) elements L(i)*D(i).
*
*  LLD     (input) REAL array, dimension (N-1)
*          The (N-1) elements L(i)*L(i)*D(i).
*
*  IFIRST  (input) INTEGER
*          The index of the first eigenvalue to be computed.
*
*  ILAST   (input) INTEGER
*          The index of the last eigenvalue to be computed.
*
*  RTOL1   (input) REAL
*          Tolerance for the convergence of the bisection intervals.
*          An interval [LEFT,RIGHT] has converged if
*          RIGHT-LEFT.LT.MAX( RTOL1*GAP, RTOL2*ABS((LEFT+RIGHT)/2) ),
*          where GAP is the (estimated) distance to the nearest
*          eigenvalue.
*
*  RTOL2   (input) REAL
*          Tolerance for the convergence of the bisection intervals.
*          An interval [LEFT,RIGHT] has converged if
*          RIGHT-LEFT.LT.MAX( RTOL1*GAP, RTOL2*ABS((LEFT+RIGHT)/2) ),
*          where GAP is the (estimated) distance to the nearest
*          eigenvalue.
*
*  OFFSET  (input) INTEGER
*          Offset for the arrays W, WGAP and WERR, i.e., the
*          IFIRST-OFFSET through ILAST-OFFSET elements of these arrays
*          are to be used.
*
*  W       (input/output) REAL array, dimension (N)
*          On input, W( IFIRST-OFFSET ) through W( ILAST-OFFSET ) are
*          estimates of the eigenvalues of L D L^T indexed IFIRST
*          through ILAST.
*          On output, these estimates are refined.
*
*  WGAP    (input/output) REAL array, dimension (N-1)
*          On input, the (estimated) gaps between consecutive
*          eigenvalues of L D L^T, i.e., WGAP(I-OFFSET) is the gap
*          between eigenvalues I and I+1. Note that if IFIRST.EQ.ILAST
*          then WGAP(IFIRST-OFFSET) must be set to ZERO.
*          On output, these gaps are refined.
*
*  WERR    (input/output) REAL array, dimension (N)
*          On input, WERR( IFIRST-OFFSET ) through WERR( ILAST-OFFSET )
*          are the errors in the estimates of the corresponding elements
*          in W.
*          On output, these errors are refined.
*
*  WORK    (workspace) REAL array, dimension (2*N)
*
*  IWORK   (workspace) INTEGER array, dimension (2*N)
*
*  INFO    (output) INTEGER
*          INFO always returns 0 in this version.
*
*  Further Details
*  ===============
*
*  Based on contributions by
*     Inderjit Dhillon, University of Texas, Austin, USA
*     Osni Marques, LBNL/NERSC, USA
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            CNT, I, II, I1, I2, J, K, KK, NEXT, NLEFT,
     $                   NINT, NRIGHT, OLNINT, P, PREV
      REAL(WP)           DPLUS, ERROR, FAC, GAP, LEFT, MID, RIGHT,
     $                   S, TMP, WIDTH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Check to see if any of the initial eigenvalue
*     estimates is acceptable.
*
      INFO = 0
      DO 5 I = 1, 2*N
         IWORK( I ) = 0
   5  CONTINUE
      I1 = IFIRST
      I2 = IFIRST
      PREV = 0
      DO 10 I = IFIRST, ILAST
         II = I - OFFSET
         IF( I.EQ.IFIRST ) THEN
            GAP = WGAP( II )
         ELSE IF( I.EQ.ILAST ) THEN
            GAP = WGAP( II-1 )
         ELSE
            GAP = MIN( WGAP( II-1 ), WGAP( II ) )
         END IF
         ERROR = WERR( II )
         K = 2*I
         IF( ERROR.LT.RTOL1*GAP ) THEN
            WORK( K-1 ) = W( II ) - ERROR
            WORK( K ) = W( II ) + ERROR
            IWORK( K-1 ) = -1
            IF( I1.EQ.I ) THEN
               I1 = I1 + 1
               PREV = I
            END IF
         ELSE
            IWORK( K-1 ) = 1
            I2 = I
         END IF
   10 CONTINUE
*
*     Initialize unconverged intervals in [ WORK(2*I-1), WORK(2*I) ].
*     The Sturm Count, Count( WORK(2*I-1) ) is arranged to be I-1, while
*     Count( WORK(2*I) ) is stored in IWORK( 2*I ). The integer
*     IWORK( 2*I-1 ) for an unconverged interval is set to the index of
*     the next unconverged interval, and is -1 or 0 for a converged
*     interval. Thus a linked list of unconverged intervals is set up.
*
      I = I1
      NINT = 0
   30 CONTINUE
      IF( I.LE.I2 ) THEN
         II = I - OFFSET
         IF( IWORK( 2*I-1 ).EQ.1 ) THEN
            FAC = ONE
            LEFT = W( II ) - WERR( II )
*
*           Do while( CNT(LEFT).GT.I-1 )
*
   40       CONTINUE
            IF( I.GT.I1 .AND. LEFT.LE.RIGHT ) THEN
               LEFT = RIGHT
               CNT = I - 1
            ELSE
               S = -LEFT
               CNT = 0
               DO 50 J = 1, N - 1
                  DPLUS = D( J ) + S
                  S = S*LLD( J ) / DPLUS - LEFT
                  IF( DPLUS.LT.ZERO )
     $               CNT = CNT + 1
   50          CONTINUE
               DPLUS = D( N ) + S
               IF( DPLUS.LT.ZERO )
     $            CNT = CNT + 1
               IF( .NOT.( S.GT.ZERO .OR. S.LT.ONE ) ) THEN
*
*                Run a slower version of the above loop if a NaN is
*                detected
*
                 CNT = 0
                 S = -LEFT
                 DO 55 J = 1, N - 1
                    DPLUS = D( J ) + S
                    IF( DPLUS.LT.ZERO )
     $                 CNT = CNT + 1
                    TMP = LLD( J ) / DPLUS
                    IF( TMP.EQ.ZERO ) THEN
                       S = LLD( J ) - LEFT
                    ELSE
                       S = S*TMP - LEFT
                    END IF
   55            CONTINUE
                 DPLUS = D( N ) + S
                 IF( DPLUS.LT.ZERO )
     $             CNT = CNT + 1
               END IF
               IF( CNT.GT.I-1 ) THEN
                  LEFT = LEFT - WERR( II )*FAC
                  FAC = TWO*FAC
                  GO TO 40
               END IF
            END IF
            NLEFT = CNT + 1
            I1 = MIN( I1, NLEFT )
            FAC = ONE
            RIGHT = W( II ) + WERR( II )
*
*           Do while( CNT(RIGHT).LT.I )
*
   60       CONTINUE
            S = -RIGHT
            CNT = 0
            DO 70 J = 1, N - 1
               DPLUS = D( J ) + S
               S = S*LLD( J ) / DPLUS - RIGHT
               IF( DPLUS.LT.ZERO )
     $            CNT = CNT + 1
   70       CONTINUE
            DPLUS = D( N ) + S
            IF( DPLUS.LT.ZERO )
     $         CNT = CNT + 1
               IF( .NOT.( S.GT.ZERO .OR. S.LT.ONE ) ) THEN
*
*                Run a slower version of the above loop if a NaN is
*                detected.
*
                 CNT = 0
                 S = -RIGHT
                 DO 75 J = 1, N - 1
                    DPLUS = D( J ) + S
                    IF( DPLUS.LT.ZERO )
     $                 CNT = CNT + 1
                    TMP = LLD( J ) / DPLUS
                    IF( TMP.EQ.ZERO ) THEN
                       S = LLD( J ) - RIGHT
                    ELSE
                       S = S*TMP - RIGHT
                    END IF
   75            CONTINUE
                 DPLUS = D( N ) + S
                 IF( DPLUS.LT.ZERO )
     $             CNT = CNT + 1
               END IF
            IF( CNT.LT.I ) THEN
               RIGHT = RIGHT + WERR( II )*FAC
               FAC = TWO*FAC
               GO TO 60
            END IF
            CNT = MIN( CNT, I2 )
            NINT = NINT + 1
            K = 2*NLEFT
            WORK( K-1 ) = LEFT
            WORK( K ) = RIGHT
            I = CNT + 1
            IWORK( K-1 ) = I
            IWORK( K ) = CNT
            IF( PREV.NE.NLEFT-1 ) THEN
               WORK( K-2 ) = LEFT
            END IF
            PREV = NLEFT
         ELSE
            RIGHT = WORK( 2*I )
*
*           Remove converged interval from linked list
*
            IWORK( K-1 ) = IWORK( K-1 ) + 1
            PREV = I
            I = I + 1
         END IF
         GO TO 30
      END IF
      IF( I.LE.N .AND. IWORK( 2*I-1 ).NE.-1 )
     $   WORK( 2*I-1 ) = WORK( 2*PREV )
*
*     Do while( NINT.GT.0 )
*
   80 CONTINUE
      PREV = I1 - 1
      OLNINT = NINT
      I = I1
      DO 100 P = 1, OLNINT
         K = 2*I
         LEFT = WORK( K-1 )
         RIGHT = WORK( K )
         NEXT = IWORK( K-1 )
         NRIGHT = IWORK( K )
         MID = HALF*( LEFT + RIGHT )
         WIDTH = RIGHT - MID
         TMP = MAX( ABS( LEFT ), ABS( RIGHT ) )
*
*        Check for convergence of interval if there is only one
*        eigenvalue in the interval.
*
         GAP = ZERO
         IF( I.EQ.NRIGHT ) THEN
            IF( PREV.GT.0 .AND. NEXT.LE.N ) THEN
               GAP = MIN( LEFT-WORK( K-2 ), WORK( K+1 )-RIGHT )
            ELSE IF( PREV.GT.0 ) THEN
               GAP = LEFT - WORK( K-2 )
            ELSE IF( NEXT.LE.N ) THEN
               GAP = WORK( K+1 ) - RIGHT
            END IF
         END IF
         IF( WIDTH.LT.MAX( RTOL1*GAP, RTOL2*TMP ) ) THEN
            NINT = NINT - 1
            IWORK( K-1 ) = 0
            KK = K
            DO J = I+1, NRIGHT
               KK = KK+2
               IWORK( KK-1 ) = 0
               WORK( KK-1 ) = LEFT
               WORK( KK ) = RIGHT
               WGAP( J-1-OFFSET ) = ZERO
            END DO
            IF( I1.EQ.I ) THEN
               I1 = NEXT
            ELSE
               IWORK( 2*PREV-1 ) = NEXT
            END IF
            I = NEXT
            GO TO 100
         END IF
         PREV = I
*
*        Perform one bisection step
*
         S = -MID
         CNT = 0
         DO 90 J = 1, N - 1
            DPLUS = D( J ) + S
            S = S*LLD( J ) / DPLUS - MID
            IF( DPLUS.LT.ZERO )
     $         CNT = CNT + 1
   90    CONTINUE
         DPLUS = D( N ) + S
         IF( DPLUS.LT.ZERO )
     $      CNT = CNT + 1
         IF( .NOT.( S.GT.ZERO .OR. S.LT.ONE ) ) THEN
*
*          Run a slower version of the above loop if a NaN is detected
*
           CNT = 0
           S = -MID
           DO 95 J = 1, N - 1
              DPLUS = D( J ) + S
              IF( DPLUS.LT.ZERO )
     $           CNT = CNT + 1
              TMP = LLD( J ) / DPLUS
              IF( TMP.EQ.ZERO ) THEN
                 S = LLD( J ) - MID
              ELSE
                 S = S*TMP - MID
              END IF
   95      CONTINUE
           DPLUS = D( N ) + S
           IF( DPLUS.LT.ZERO )
     $       CNT = CNT + 1
         END IF
         CNT = MAX( I-1, MIN( NRIGHT, CNT ) )
         IF( CNT.EQ.I-1 ) THEN
            WORK( K-1 ) = MID
         ELSE IF( CNT.EQ.NRIGHT ) THEN
            WORK( K ) = MID
         ELSE
            IWORK( K ) = CNT
            CNT = CNT + 1
            IWORK( K-1 ) = CNT
            KK = 2*CNT
            IWORK( KK-1 ) = NEXT
            IWORK( KK ) = NRIGHT
            WORK( K ) = MID
            WORK( KK-1 ) = MID
            WORK( KK ) = RIGHT
            PREV = CNT
            IF( CNT-1.GT.I ) THEN
               WORK( KK-2 ) = MID
            END IF
            IF( CNT.GT.IFIRST .AND. CNT.LE.ILAST ) THEN
               NINT = NINT + 1
            ELSE IF( CNT.LE.IFIRST ) THEN
               I1 = CNT
            END IF
         END IF
         I = NEXT
  100 CONTINUE
      IF( NINT.GT.0 )
     $   GO TO 80
      DO 110 I = IFIRST, ILAST
         K = 2*I
         II = I - OFFSET
         IF( IWORK( K-1 ).NE.-1 ) THEN
            W( II ) = HALF*( WORK( K-1 )+WORK( K ) )
            WERR( II ) = WORK( K ) - W( II )
         END IF
  110 CONTINUE
*
      RETURN
*
*     End of SLARRB
*
      END
