#include "lapacknames.inc"
      SUBROUTINE SLARNV( IDIST, ISEED, N, X )
      USE LA_CONSTANTS
      USE LA_XLARUV
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     05-31-02:  LAPACK 3E version, avoid recopying for types 1&2 (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IDIST, N
*     ..
*     .. Array Arguments ..
      INTEGER            ISEED( 4 )
      REAL(WP)           X( * )
*     ..
*
*  Purpose
*  =======
*
*  SLARNV returns a vector of n random real numbers from a uniform or
*  normal distribution.
*
*  Arguments
*  =========
*
*  IDIST   (input) INTEGER
*          Specifies the distribution of the random numbers:
*          = 1:  uniform (0,1)
*          = 2:  uniform (-1,1)
*          = 3:  normal (0,1)
*
*  ISEED   (input/output) INTEGER array, dimension (4)
*          On entry, the seed of the random number generator; the array
*          elements must be between 0 and 4095, and ISEED(4) must be
*          odd.
*          On exit, the seed is updated.
*
*  N       (input) INTEGER
*          The number of random numbers to be generated.
*
*  X       (output) REAL array, dimension (N)
*          The generated random numbers.
*
*  Further Details
*  ===============
*
*  This routine calls the auxiliary routine SLARUV to generate random
*  real numbers from a uniform (0,1) distribution, in batches of up to
*  128 using vectorisable code. The Box-Muller method is used to
*  transform numbers from a uniform to a normal distribution.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            LV
      PARAMETER          ( LV = 128 )
      REAL(WP)           TWOPI
      PARAMETER          ( TWOPI = 6.2831853071795864769252867663_WP )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IL, IV
*     ..
*     .. Local Arrays ..
      REAL(WP)           U( LV )
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          COS, LOG, MIN, SQRT
*     ..
*     .. Executable Statements ..
*
      IF( IDIST.EQ.1 ) THEN
         DO IV = 1, N, LV
            IL = MIN( LV, N-IV+1 )
*
*           Generate IL numbers from a uniform (0,1) distribution
*
            CALL LA_LARUV( ISEED, IL, X( IV ) )
         END DO
      ELSE IF( IDIST.EQ.2 ) THEN
         DO IV = 1, N, LV
            IL = MIN( LV, N-IV+1 )
*
*           Generate IL numbers from a uniform (0,1) distribution
*
            CALL LA_LARUV( ISEED, IL, X( IV ) )
*
*           Convert generated numbers to uniform (-1,1) distribution
*
            DO 20 I = 1, IL
               X( IV+I-1 ) = TWO*X( IV+I-1 ) - ONE
   20       CONTINUE
         END DO
      ELSE IF( IDIST.EQ.3 ) THEN
         DO IV = 1, N, LV / 2
            IL = MIN( LV / 2, N-IV+1 )
*
*           Generate 2*IL numbers from a uniform (0,1) distribution
*
            CALL LA_LARUV( ISEED, 2*IL, U(1) )
*
*           Convert generated numbers to normal (0,1) distribution
*
            DO 30 I = 1, IL
               X( IV+I-1 ) = SQRT( -TWO*LOG( U( 2*I-1 ) ) )*
     $                       COS( TWOPI*U( 2*I ) )
   30       CONTINUE
         END DO
      END IF
      RETURN
*
*     End of SLARNV
*
      END
