#include "lapacknames.inc"
      FUNCTION SLAPY2( X, Y )
      USE LA_CONSTANTS
      REAL(WP) :: SLAPY2
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     October 31, 1992
*     04-25-02:  LAPACK 3E version, modified for consistency with
*                xLASSQ (eca)
*
*     .. Scalar Arguments ..
      REAL(WP)           X, Y
*     ..
*
*  Purpose
*  =======
*
*  SLAPY2 returns sqrt(x**2+y**2), taking care not to cause unnecessary
*  overflow.
*
*  Arguments
*  =========
*
*  X       (input) REAL
*  Y       (input) REAL
*          X and Y specify the values x and y.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           W, XABS, YABS, Z
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, SQRT
*     ..
*     .. Executable Statements ..
*
      XABS = ABS( X )
      YABS = ABS( Y )
      W = MAX( XABS, YABS )
      Z = MIN( XABS, YABS )
      IF( Z.EQ.ZERO ) THEN
         SLAPY2 = W
      ELSE IF( W.GT.SAFMIN .AND. W.LT.SAFMAX ) THEN
         SLAPY2 = W*SQRT( ONE+( Z / W )**2 )
      ELSE
         W = MIN( MAX( SAFMIN, W ), SAFMAX )
         SLAPY2 = W*SQRT( ( XABS / W )**2 + ( YABS / W )**2 )
      END IF
      RETURN
*
*     End of SLAPY2
*
      END
