#include "lapacknames.inc"
      SUBROUTINE SLAEIU( JOB, N, D, DU, DU2, X, TOL )
      USE LA_CONSTANTS
*
*  -- LAPACK routine --
*     Based on LAPACK version 2.0, 9-30-94
*     E. Anderson, Cray Research Inc.
*     September 15, 1995
*     06-05-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            JOB, N
      REAL(WP)           TOL
*     ..
*     .. Array Arguments ..
      REAL(WP)           D( * ), DU( * ), DU2( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  SLAEIU solves a linear system with the upper triangular factor
*  U from the LU factorization of the symmetric tridiagonal matrix
*  (T - lambda*I), as computed by SLAEIF.
*
*  Arguments
*  =========
*
*  JOB     (input) INTEGER
*          =  1:  The equation  Ux = y  is to be solved without
*                 perturbing small diagonal elements of U.
*          = -1:  The equation  Ux = y  is to be solved and small
*                 diagonal elements of U are to be perturbed to prevent
*                 overflow.  See the argument TOL.
*
*  N       (input) INTEGER
*          The order of the matrix U.
*
*  D       (input) REAL array, dimension (N-1)
*          The n diagonal elements of U.
*
*  DU      (input) REAL array, dimension (N-1)
*          The (n-1) super-diagonal elements of U.
*
*  DU2     (input) REAL array, dimension (N-2)
*          The (n-2) second super-diagonal elements of U.
*
*  X       (input/output) REAL array, dimension (N)
*          On entry, the right hand side vector y.
*          On exit, X is overwritten by the solution vector x.
*
*  TOL     (input/output) REAL
*          On entry, if JOB = -1, TOL should be the minimum perturbation
*          to be made to very small diagonal elements of U.  TOL should
*          normally be chosen as about eps*norm(U), where eps is the
*          relative machine precision, but if TOL is supplied as
*          non-positive, then it is reset to eps*max( abs( U(i,j) ) ).
*          Not referenced if JOB = 1.
*
*          On exit, if JOB = -1 and TOL = 0. on entry, TOL is reset to
*          eps*max( abs( U(i,j) ) ); otherwise, TOL is not modified.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            K
      REAL(WP)           AK, PERT, TEMP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, SIGN
*     ..
*     .. Executable Statements ..
*
*     Quick return for N = 0
*
      IF( N.LE.0 )
     $   RETURN
*
      IF( JOB.EQ.1 ) THEN
*
*        Solve Ux = y without perturbing U.
*
         X( N ) = X( N ) / D( N )
         IF( N.EQ.1 )
     $      RETURN
*
         X( N-1 ) = ( X( N-1 )-DU( N-1 )*X( N ) ) / D( N-1 )
         DO 10 K = N - 2, 1, -1
            X( K ) = ( X( K )-DU( K )*X( K+1 )-DU2( K )*X( K+2 ) ) /
     $               D( K )
   10    CONTINUE
      ELSE
*
*        Solve Ux = y, perturbing small diagonal elements of U by TOL.
*
         IF( TOL.LE.ZERO ) THEN
            TOL = ABS( D( 1 ) )
            IF( N.GT.1 )
     $         TOL = MAX( TOL, ABS( D( 2 ) ), ABS( DU( 1 ) ) )
            DO 20 K = 3, N
               TOL = MAX( TOL, ABS( D( K ) ), ABS( DU( K-1 ) ),
     $               ABS( DU2( K-2 ) ) )
   20       CONTINUE
            TOL = TOL*EPS
            IF( TOL.EQ.ZERO )
     $         TOL = EPS
         END IF
*
         TEMP = X( N )
         AK = D( N )
         IF( MAX( ABS( TEMP )*SAFMIN, SAFMIN ).GT.ABS( AK ) ) THEN
            PERT = SIGN( TOL, AK )
   30       CONTINUE
            AK = AK + PERT
            PERT = 2*PERT
            IF( ABS( TEMP )*SAFMIN.GT.ABS( AK ) )
     $         GO TO 30
         END IF
         X( N ) = TEMP / AK
         IF( N.EQ.1 )
     $      RETURN
         TEMP = X( N-1 ) - DU( N-1 )*X( N )
         AK = D( N-1 )
         IF( MAX( ABS( TEMP )*SAFMIN, SAFMIN ).GT.ABS( AK ) ) THEN
            PERT = SIGN( TOL, AK )
   40       CONTINUE
            AK = AK + PERT
            PERT = 2*PERT
            IF( ABS( TEMP )*SAFMIN.GT.ABS( AK ) )
     $         GO TO 40
         END IF
         X( N-1 ) = TEMP / AK
         DO 60 K = N - 2, 1, -1
            TEMP = X( K ) - DU( K )*X( K+1 ) - DU2( K )*X( K+2 )
            AK = D( K )
            IF( MAX( ABS( TEMP )*SAFMIN, SAFMIN ).GT.ABS( AK ) ) THEN
               PERT = SIGN( TOL, AK )
   50          CONTINUE
               AK = AK + PERT
               PERT = 2*PERT
               IF( ABS( TEMP )*SAFMIN.GT.ABS( AK ) )
     $            GO TO 50
            END IF
            X( K ) = TEMP / AK
   60    CONTINUE
      END IF
*
      RETURN
*
*     End of SLAEIU
*
      END
