#include "lapacknames.inc"
      SUBROUTINE SGESUM( TRANS, M, N, ALPHA, A, LDA, BETA, B, LDB )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA
*
* --  LAPACK auxiliary routine --
*     Adapted from Cray libsci routine of the same name
*     E. Anderson
*     May 8, 2002
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS
      INTEGER            LDA, LDB, M, N
      REAL(WP)           ALPHA, BETA
*     ..
*     .. Array Arguments ..
      REAL(WP)           A(LDA,*), B(LDB,*)
*     ..
*
*  Purpose
*  =======
*
*  SGESUM adds two real matrices with optional scaling and
*  transposition.
*
*     B <-- alpha op(A) + beta B
*
*  where
*                                     T                              H
*  op(A) represents A, its transpose A , or its conjugate transpose A
*  op(A) and B are m-by-n matrices, and alpha and beta are scalars.
*  beta = 0 is a special case, used to copy alpha*op(A) to B.
*  alpha = 0 is also a special case, used to scale B.
*
*  Arguments
*  =========
*
*  TRANS   (input) CHARACTER*1
*          Specifies whether the matrix A is transposed.
*          = 'N':  No Transpose, op(A) = A
*          = 'T':  Transpose, op(A) = A**T
*          = 'C':  Conjugate transpose = Transpose, op(A) = A**H
*
*  M       (input) INTEGER
*          Specifies the number of rows of the matrices op(A) and B.
*
*  N       (input) INTEGER
*          Specifies the number of columns of the matrices op(A) and B.
*
*  ALPHA   (input) REAL
*          The scalar factor alpha.
*
*  A       (input) REAL array, dimension (LDA,k)
*          When TRANS = 'N', k = N; otherwise, k = M.  When TRANS = 'N',
*          the leading M-by-N part of the array A contains the matrix A.
*          When TRANS = 'T' or 'C', the leading N-by-M part or the array
*          A contains the matrix A, whose transpose or conjugate
*          transpose will be used in the matrix sum.  If ALPHA = 0,
*          A need not be specified on entry.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  When TRANS = 'N',
*          LDA >= max(1,M); otherwise, LDA >= max(1,N).
*
*  BETA    (input) REAL
*          The scalar factor beta.
*
*  B       (input/output) REAL array, dimension (LDB,N)
*          On entry, if beta is not equal to 0, the M-by-N matrix B.
*          If beta = 0, B need not be specified on entry.
*
*          On exit, B is overwritten with the matrix sum
*          alpha*op(A) + beta*B.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,M).
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            NOTRAN, TRANSC, TRANST
      INTEGER            I, INFO, J
*     ..
*     .. Executable Statements ..
*
*     Do some error checking.  As with the BLAS, XERBLA is called, but
*     no error code is returned.
*
      INFO = 0
      NOTRAN = LSAME( TRANS, 'N' )
      TRANST = LSAME( TRANS, 'T' )
      TRANSC = LSAME( TRANS, 'C' )
      IF( .NOT.NOTRAN .AND. .NOT.TRANST .AND. .NOT.TRANSC ) THEN
         INFO = -1
      ELSE IF( ( NOTRAN .AND. LDA.LT.MAX(1,M) ) .OR. 
     $   ( ( TRANST.OR.TRANSC ) .AND. LDA.LT.MAX(1,N) ) ) THEN
         INFO = -6
      ELSE IF( LDB.LT.MAX(1,M) ) THEN
         INFO = -9
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( SPREFIX // 'GESUM', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.LE.0 .OR. N.LE.0 )
     $   RETURN
*
      IF( ALPHA.EQ.ZERO ) THEN
*
*        alpha = 0:  A is not referenced, just scale B
*
         IF( BETA.NE.ONE ) THEN
            DO J = 1, N
               DO I = 1, M
                  B(I,J) = BETA*B(I,J)
               END DO
            END DO
         END IF
*
      ELSE IF( NOTRAN ) THEN
*
*        A is not transposed
*
         IF( BETA.EQ.ZERO ) THEN
*
*           beta = 0:  Initial value of B is not referenced
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(I,J)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(I,J)
                  END DO
               END DO
            END IF
         ELSE IF( BETA.EQ.ONE ) THEN
*
*           beta = 1
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(I,J) + B(I,J)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(I,J) + B(I,J)
                  END DO
               END DO
            END IF
         ELSE
*
*           beta != 1
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(I,J) + BETA*B(I,J)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(I,J) + BETA*B(I,J)
                  END DO
               END DO
            END IF
         END IF
*
      ELSE
*
*        A is transposed
*
         IF( BETA.EQ.ZERO ) THEN
*
*           beta = 0:  Initial value of B is not referenced
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(J,I)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(J,I)
                  END DO
               END DO
            END IF
         ELSE IF( BETA.EQ.ONE ) THEN
*
*           beta = 1
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(J,I) + B(I,J)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(J,I) + B(I,J)
                  END DO
               END DO
            END IF
         ELSE
*
*           beta != 1
*
            IF( ALPHA.EQ.ONE ) THEN
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = A(J,I) + BETA*B(I,J)
                  END DO
               END DO
            ELSE
               DO J = 1, N
                  DO I = 1, M
                     B(I,J) = ALPHA*A(J,I) + BETA*B(I,J)
                  END DO
               END DO
            END IF
         END IF
      END IF
      RETURN
*
*     End of SGESUM
*
      END
