#include "lapacknames.inc"
      SUBROUTINE SGELSD( M, N, NRHS, A, LDA, B, LDB, S, RCOND,
     $                   RANK, WORK, LWORK, IWORK, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILAENV, XERBLA, LA_LACPY, LA_LANGE,
     $                        LA_LASCL, LA_LASET
      USE LA_LAPACK, ONLY: LA_GEBRD, LA_GELQF, LA_GEQRF, LA_ORMBR,
     $                     LA_ORMLQ, LA_ORMQR
      USE LA_XLALSD
*
*  -- LAPACK driver routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     8-15-00:  Improve consistency of WS calculations (eca)
*     06-26-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INFO, LDA, LDB, LWORK, M, N, NRHS, RANK
      REAL(WP)           RCOND
*     ..
*     .. Array Arguments ..
      INTEGER            IWORK( * )
      REAL(WP)           A( LDA, * ), B( LDB, * ), S( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  SGELSD computes the minimum-norm solution to a real linear least
*  squares problem:
*      minimize 2-norm(| b - A*x |)
*  using the singular value decomposition (SVD) of A. A is an M-by-N
*  matrix which may be rank-deficient.
*
*  Several right hand side vectors b and solution vectors x can be
*  handled in a single call; they are stored as the columns of the
*  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
*  matrix X.
*
*  The problem is solved in three steps:
*  (1) Reduce the coefficient matrix A to bidiagonal form with
*      Householder transformations, reducing the original problem
*      into a "bidiagonal least squares problem" (BLS)
*  (2) Solve the BLS using a divide and conquer approach.
*  (3) Apply back all the Householder tranformations to solve
*      the original least squares problem.
*
*  The effective rank of A is determined by treating as zero those
*  singular values which are less than RCOND times the largest singular
*  value.
*
*  The divide and conquer algorithm makes very mild assumptions about
*  floating point arithmetic. It will work on machines with a guard
*  digit in add/subtract, or on those binary machines without guard
*  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
*  Cray-2. It could conceivably fail on hexadecimal or decimal machines
*  without guard digits, but we know of none.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of A. M >= 0.
*
*  N       (input) INTEGER
*          The number of columns of A. N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrices B and X. NRHS >= 0.
*
*  A       (input/output) REAL array, dimension (LDA,N)
*          On entry, the M-by-N matrix A.
*          On exit, the first min(m,n) rows of A are overwritten with
*          its right singular vectors, stored rowwise.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,M).
*
*  B       (input/output) REAL array, dimension (LDB,NRHS)
*          On entry, the M-by-NRHS right hand side matrix B.
*          On exit, B is overwritten by the N-by-NRHS solution
*          matrix X.  If m >= n and RANK = n, the residual
*          sum-of-squares for the solution in the i-th column is given
*          by the sum of squares of elements n+1:m in that column.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B. LDB >= max(1,max(M,N)).
*
*  S       (output) REAL array, dimension (min(M,N))
*          The singular values of A in decreasing order.
*          The condition number of A in the 2-norm = S(1)/S(min(m,n)).
*
*  RCOND   (input) REAL
*          RCOND is used to determine the effective rank of A.
*          Singular values S(i) <= RCOND*S(1) are treated as zero.
*          If RCOND < 0, machine precision is used instead.
*
*  RANK    (output) INTEGER
*          The effective rank of A, i.e., the number of singular values
*          which are greater than RCOND*S(1).
*
*  WORK    (workspace/output) REAL array, dimension (LWORK)
*          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
*
*  LWORK   (input) INTEGER
*          The dimension of the array WORK. LWORK >= 1.
*          The exact minimum amount of workspace needed depends on M,
*          N and NRHS.
*          If M >= N, LWORK >=  11*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS.
*          If M < N, LWORK >=  11*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS.
*          SMLSIZ is returned by ILAENV and is equal to the maximum
*          size of the subproblems at the bottom of the computation
*          tree (usually about 25), and
*              NLVL = INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1
*          For good performance, LWORK should generally be larger.
*
*          If LWORK = -1, a workspace query is assumed.  The optimal
*          size for the WORK array is calculated and stored in WORK(1),
*          and no other work except argument checking is performed.
*
*  IWORK   (workspace) INTEGER array, dimension (LIWORK)
*          LIWORK >= 3 * MINMN * NLVL + 11 * MINMN,
*          where MINMN = MIN( M,N ).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value.
*          > 0:  the algorithm for computing the SVD failed to converge;
*                if INFO = i, i off-diagonal elements of an intermediate
*                bidiagonal form did not converge to zero.
*
*  Further Details
*  ===============
*
*  Based on contributions by
*     Ming Gu and Ren-Cang Li, Computer Science Division, University of
*       California at Berkeley, USA
*     Osni Marques, LBNL/NERSC, USA
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            LQUERY
      INTEGER            IASCL, IBSCL, IE, IL, ITAU, ITAUP, ITAUQ,
     $                   LDWORK, MAXMN, MAXWRK, MINMN, MINWRK, MM,
     $                   MNTHR, NLVL, NWORK, SMLSIZ
      REAL(WP)           ANRM, BNRM
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL, INT, LOG, MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments.
*
      INFO = 0
      MINMN = MIN( M, N )
      MAXMN = MAX( M, N )
      LQUERY = ( LWORK.EQ.-1 )
      MNTHR = ILAENV( 6, SPREFIX // 'GELSD', ' ', M, N, NRHS, -1 )
      IF( M.LT.0 ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, M ) ) THEN
         INFO = -5
      ELSE IF( LDB.LT.MAX( 1, MAXMN ) ) THEN
         INFO = -7
      END IF
*
      SMLSIZ = ILAENV( 9, SPREFIX // 'GELSD', ' ', 0, 0, 0, 0 )
*
*     Compute workspace.
*     (Note: Comments in the code beginning "Workspace:" describe the
*     minimal amount of workspace needed at that point in the code,
*     as well as the preferred amount for good performance.
*     NB refers to the optimal block size for the immediately
*     following subroutine, as returned by ILAENV.)
*
      MINWRK = 1
      MINMN = MAX( 1, MINMN )
      NLVL = INT( LOG( REAL( MINMN, WP ) / REAL( SMLSIZ+1, WP ) ) / 
     $       LOG( TWO ) ) + 1
*
      IF( INFO.EQ.0 ) THEN
         MAXWRK = 0
         MM = M
         IF( M.GE.N .AND. M.GE.MNTHR ) THEN
*
*           Path 1a - overdetermined, with many more rows than columns.
*
            MM = N
            MAXWRK = MAX( MAXWRK, N+N*ILAENV( 1, SPREFIX // 'GEQRF',
     $               ' ', M, N, -1, -1 ) )
            MAXWRK = MAX( MAXWRK, N+NRHS*ILAENV( 1, SPREFIX // 'ORMQR',
     $               'LT', M, NRHS, N, -1 ) )
         END IF
         IF( M.GE.N ) THEN
*
*           Path 1 - overdetermined or exactly determined.
*
            MAXWRK = MAX( MAXWRK, 3*N+( MM+N )*ILAENV( 1,
     $               SPREFIX // 'GEBRD', ' ', MM, N, -1, -1 ) )
            MAXWRK = MAX( MAXWRK, 3*N+NRHS*ILAENV( 1,
     $               SPREFIX // 'ORMBR', 'QLT', MM, NRHS, N, -1 ) )
            MAXWRK = MAX( MAXWRK, 3*N+( N-1 )*ILAENV( 1,
     $               SPREFIX // 'ORMBR', 'PLN', N, NRHS, N, -1 ) )
            MAXWRK = MAX( MAXWRK, 3*N+8*N+2*N*SMLSIZ+8*N*NLVL+N*NRHS )
            MINWRK = MAX( 3*N+MM, 3*N+NRHS,
     $               3*N+8*N+2*N*SMLSIZ+8*N*NLVL+N*NRHS )
         END IF
         IF( N.GT.M ) THEN
            IF( N.GE.MNTHR ) THEN
*
*              Path 2a - underdetermined, with many more columns
*              than rows.
*
               MAXWRK = M + M*ILAENV( 1, SPREFIX // 'GELQF', ' ', M, N,
     $                  -1, -1 )
               MAXWRK = MAX( MAXWRK, M*M+4*M+2*M*ILAENV( 1,
     $                  SPREFIX // 'GEBRD', ' ', M, M, -1, -1 ) )
               MAXWRK = MAX( MAXWRK, M*M+4*M+NRHS*ILAENV( 1,
     $                  SPREFIX // 'ORMBR', 'QLT', M, NRHS, M, -1 ) )
               MAXWRK = MAX( MAXWRK, M*M+4*M+( M-1 )*ILAENV( 1,
     $                  SPREFIX // 'ORMBR', 'PLN', M, NRHS, M, -1 ) )
               IF( NRHS.GT.1 ) THEN
                  MAXWRK = MAX( MAXWRK, M*M+M+M*NRHS )
               ELSE
                  MAXWRK = MAX( MAXWRK, M*M+2*M )
               END IF
               MAXWRK = MAX( MAXWRK, M+NRHS*ILAENV( 1,
     $                  SPREFIX // 'ORMLQ', 'LT', N, NRHS, M, -1 ) )
               MAXWRK = MAX( MAXWRK, M*M+4*M+8*M+2*M*SMLSIZ+8*M*NLVL+M*
     $                  NRHS )
            ELSE
*
*              Path 2 - remaining underdetermined cases.
*
               MAXWRK = 3*M + ( N+M )*ILAENV( 1, SPREFIX // 'GEBRD',
     $                  ' ', M, N, -1, -1 )
               MAXWRK = MAX( MAXWRK, 3*M+NRHS*ILAENV( 1,
     $                  SPREFIX // 'ORMBR', 'QLT', M, NRHS, N, -1 ) )
               MAXWRK = MAX( MAXWRK, 3*M+M*ILAENV( 1,
     $                  SPREFIX // 'ORMBR', 'PLN', N, NRHS, M, -1 ) )
               MAXWRK = MAX( MAXWRK, 3*M+8*M+2*M*SMLSIZ+8*M*NLVL+M*
     $                  NRHS )
            END IF
            MINWRK = MAX( 3*M+NRHS, 3*M+M,
     $               3*M+8*M+2*M*SMLSIZ+8*M*NLVL+M*NRHS )
         END IF
         MINWRK = MIN( MINWRK, MAXWRK )
         WORK( 1 ) = MAXWRK
         IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY )
     $      INFO = -12
      END IF
*
*     Quick returns
*
      IF( LQUERY .OR. INFO.NE.0 ) THEN
         IF( INFO.NE.0 ) CALL XERBLA( SPREFIX // 'GELSD', -INFO )
         RETURN
      END IF
      IF( M.EQ.0 .OR. N.EQ.0 ) THEN
         RANK = 0
         RETURN
      END IF
*
*     Scale A if max entry outside range [SMLNUM,BIGNUM].
*
      ANRM = LA_LANGE( 'M', M, N, A, LDA, WORK )
      IASCL = 0
      IF( ANRM.GT.ZERO .AND. ANRM.LT.SMLNUM ) THEN
*
*        Scale matrix norm up to SMLNUM.
*
         CALL LA_LASCL( 'G', 0, 0, ANRM, SMLNUM, M, N, A, LDA, INFO )
         IASCL = 1
      ELSE IF( ANRM.GT.BIGNUM ) THEN
*
*        Scale matrix norm down to BIGNUM.
*
         CALL LA_LASCL( 'G', 0, 0, ANRM, BIGNUM, M, N, A, LDA, INFO )
         IASCL = 2
      ELSE IF( ANRM.EQ.ZERO ) THEN
*
*        Matrix all zero. Return zero solution.
*
         CALL LA_LASET( 'F', MAX( M, N ), NRHS, ZERO, ZERO, B, LDB )
         CALL LA_LASET( 'F', MINMN, 1, ZERO, ZERO, S(1), 1 )
         RANK = 0
         GO TO 10
      END IF
*
*     Scale B if max entry outside range [SMLNUM,BIGNUM].
*
      BNRM = LA_LANGE( 'M', M, NRHS, B, LDB, WORK )
      IBSCL = 0
      IF( BNRM.GT.ZERO .AND. BNRM.LT.SMLNUM ) THEN
*
*        Scale matrix norm up to SMLNUM.
*
         CALL LA_LASCL( 'G', 0, 0, BNRM, SMLNUM, M, NRHS, B, LDB, INFO )
         IBSCL = 1
      ELSE IF( BNRM.GT.BIGNUM ) THEN
*
*        Scale matrix norm down to BIGNUM.
*
         CALL LA_LASCL( 'G', 0, 0, BNRM, BIGNUM, M, NRHS, B, LDB, INFO )
         IBSCL = 2
      END IF
*
*     If M < N make sure certain entries of B are zero.
*
      IF( M.LT.N )
     $   CALL LA_LASET( 'F', N-M, NRHS, ZERO, ZERO, B( M+1, 1 ), LDB )
*
*     Overdetermined case.
*
      IF( M.GE.N ) THEN
*
*        Path 1 - overdetermined or exactly determined.
*
         MM = M
         IF( M.GE.MNTHR ) THEN
*
*           Path 1a - overdetermined, with many more rows than columns.
*
            MM = N
            ITAU = 1
            NWORK = ITAU + N
*
*           Compute A=Q*R.
*           (Workspace: need 2*N, prefer N+N*NB)
*
            CALL LA_GEQRF( M, N, A(1,1), LDA, WORK( ITAU ),
     $                     WORK( NWORK ), LWORK-NWORK+1, INFO )
*
*           Multiply B by transpose(Q).
*           (Workspace: need N+NRHS, prefer N+NRHS*NB)
*
            CALL LA_ORMQR( 'L', 'T', M, NRHS, N, A(1,1), LDA,
     $                     WORK( ITAU ), B(1,1), LDB, WORK( NWORK ),
     $                     LWORK-NWORK+1, INFO )
*
*           Zero out below R.
*
            IF( N.GT.1 ) THEN
               CALL LA_LASET( 'L', N-1, N-1, ZERO, ZERO, A( 2, 1 ), LDA)
            END IF
         END IF
*
         IE = 1
         ITAUQ = IE + N
         ITAUP = ITAUQ + N
         NWORK = ITAUP + N
*
*        Bidiagonalize R in A.
*        (Workspace: need 3*N+MM, prefer 3*N+(MM+N)*NB)
*
         CALL LA_GEBRD( MM, N, A(1,1), LDA, S(1), WORK( IE ),
     $                  WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Multiply B by transpose of left bidiagonalizing vectors of R.
*        (Workspace: need 3*N+NRHS, prefer 3*N+NRHS*NB)
*
         CALL LA_ORMBR( 'Q', 'L', 'T', MM, NRHS, N, A(1,1), LDA,
     $                  WORK( ITAUQ ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Solve the bidiagonal least squares problem.
*
         CALL LA_LALSD( 'U', SMLSIZ, N, NRHS, S(1), WORK( IE ), B(1,1),
     $                  LDB, RCOND, RANK, WORK( NWORK ), IWORK(1), INFO)
         IF( INFO.NE.0 ) THEN
            GO TO 10
         END IF
*
*        Multiply B by right bidiagonalizing vectors of R.
*
         CALL LA_ORMBR( 'P', 'L', 'N', N, NRHS, N, A(1,1), LDA,
     $                  WORK( ITAUP ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
      ELSE IF( N.GE.MNTHR .AND. LWORK.GE.4*M+M*M+
     $         MAX( M, 2*M-4, NRHS, N-3*M ) ) THEN
*
*        Path 2a - underdetermined, with many more columns than rows
*        and sufficient workspace for an efficient algorithm.
*
         LDWORK = M
         IF( LWORK.GE.MAX( 4*M+M*LDA+MAX( M, 2*M-4, NRHS, N-3*M ),
     $       M*LDA+M+M*NRHS ) )LDWORK = LDA
         ITAU = 1
         NWORK = M + 1
*
*        Compute A=L*Q.
*        (Workspace: need 2*M, prefer M+M*NB)
*
         CALL LA_GELQF( M, N, A(1,1), LDA, WORK( ITAU ), WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
         IL = NWORK
*
*        Copy L to WORK(IL), zeroing out above its diagonal.
*
         CALL LA_LACPY( 'L', M, M, A(1,1), LDA, WORK( IL ), LDWORK )
         CALL LA_LASET( 'U', M-1, M-1, ZERO, ZERO, WORK( IL+LDWORK ),
     $                  LDWORK )
         IE = IL + LDWORK*M
         ITAUQ = IE + M
         ITAUP = ITAUQ + M
         NWORK = ITAUP + M
*
*        Bidiagonalize L in WORK(IL).
*        (Workspace: need M*M+5*M, prefer M*M+4*M+2*M*NB)
*
         CALL LA_GEBRD( M, M, WORK( IL ), LDWORK, S(1), WORK( IE ),
     $                  WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Multiply B by transpose of left bidiagonalizing vectors of L.
*        (Workspace: need M*M+4*M+NRHS, prefer M*M+4*M+NRHS*NB)
*
         CALL LA_ORMBR( 'Q', 'L', 'T', M, NRHS, M, WORK( IL ), LDWORK,
     $                  WORK( ITAUQ ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Solve the bidiagonal least squares problem.
*
         CALL LA_LALSD( 'U', SMLSIZ, M, NRHS, S(1), WORK( IE ), B(1,1),
     $                  LDB, RCOND, RANK, WORK( NWORK ), IWORK(1), INFO)
         IF( INFO.NE.0 ) THEN
            GO TO 10
         END IF
*
*        Multiply B by right bidiagonalizing vectors of L.
*
         CALL LA_ORMBR( 'P', 'L', 'N', M, NRHS, M, WORK( IL ), LDWORK,
     $                  WORK( ITAUP ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Zero out below first M rows of B.
*
         CALL LA_LASET( 'F', N-M, NRHS, ZERO, ZERO, B( M+1, 1 ), LDB )
         NWORK = ITAU + M
*
*        Multiply transpose(Q) by B.
*        (Workspace: need M+NRHS, prefer M+NRHS*NB)
*
         CALL LA_ORMLQ( 'L', 'T', N, NRHS, M, A(1,1), LDA, WORK( ITAU ),
     $                  B(1,1), LDB, WORK( NWORK ), LWORK-NWORK+1, INFO)
*
      ELSE
*
*        Path 2 - remaining underdetermined cases.
*
         IE = 1
         ITAUQ = IE + M
         ITAUP = ITAUQ + M
         NWORK = ITAUP + M
*
*        Bidiagonalize A.
*        (Workspace: need 3*M+N, prefer 3*M+(M+N)*NB)
*
         CALL LA_GEBRD( M, N, A(1,1), LDA, S(1), WORK( IE ),
     $                  WORK( ITAUQ ), WORK( ITAUP ), WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Multiply B by transpose of left bidiagonalizing vectors.
*        (Workspace: need 3*M+NRHS, prefer 3*M+NRHS*NB)
*
         CALL LA_ORMBR( 'Q', 'L', 'T', M, NRHS, N, A(1,1), LDA,
     $                  WORK( ITAUQ ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
*        Solve the bidiagonal least squares problem.
*
         CALL LA_LALSD( 'L', SMLSIZ, M, NRHS, S(1), WORK( IE ), B(1,1),
     $                  LDB, RCOND, RANK, WORK( NWORK ), IWORK(1), INFO)
         IF( INFO.NE.0 ) THEN
            GO TO 10
         END IF
*
*        Multiply B by right bidiagonalizing vectors of A.
*
         CALL LA_ORMBR( 'P', 'L', 'N', N, NRHS, M, A(1,1), LDA,
     $                  WORK( ITAUP ), B(1,1), LDB, WORK( NWORK ),
     $                  LWORK-NWORK+1, INFO )
*
      END IF
*
*     Undo scaling.
*
      IF( IASCL.EQ.1 ) THEN
         CALL LA_LASCL( 'G', 0, 0, ANRM, SMLNUM, N, NRHS, B, LDB, INFO )
         CALL LA_LASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
     $                  INFO )
      ELSE IF( IASCL.EQ.2 ) THEN
         CALL LA_LASCL( 'G', 0, 0, ANRM, BIGNUM, N, NRHS, B, LDB, INFO )
         CALL LA_LASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
     $                  INFO )
      END IF
      IF( IBSCL.EQ.1 ) THEN
         CALL LA_LASCL( 'G', 0, 0, SMLNUM, BNRM, N, NRHS, B, LDB, INFO )
      ELSE IF( IBSCL.EQ.2 ) THEN
         CALL LA_LASCL( 'G', 0, 0, BIGNUM, BNRM, N, NRHS, B, LDB, INFO )
      END IF
*
   10 CONTINUE
      WORK( 1 ) = MAXWRK
      RETURN
*
*     End of SGELSD
*
      END
