      MODULE LA_XTPTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 19, 2002
!
!  Purpose
!  =======
!
!  LA_XTPTS2 defines a generic interface for xTPTS2.
!
      INTERFACE LA_TPTS2
 
      SUBROUTINE STPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIAG, ITRANS, IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE STPTS2
 
      SUBROUTINE CTPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIAG, ITRANS, IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CTPTS2
 
      MODULE PROCEDURE STPTS2_A1B2
      MODULE PROCEDURE CTPTS2_A1B2
 
      END INTERFACE ! LA_TPTS2
      PRIVATE STPTS2_A1B2, CTPTS2_A1B2
 
      CONTAINS
 
      SUBROUTINE STPTS2_A1B2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB)
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIAG, ITRANS, IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL STPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP(1), B(1,1), LDB)
      END SUBROUTINE STPTS2_A1B2
 
      SUBROUTINE CTPTS2_A1B2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB)
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIAG, ITRANS, IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CTPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP(1), B(1,1), LDB)
      END SUBROUTINE CTPTS2_A1B2
 
      END MODULE LA_XTPTS2
