      MODULE LA_XSYTF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 22, 2002
!
!  Purpose
!  =======
!
!  LA_XSYTF2 defines generic interfaces for xSYTF2 and xLASYF.
!
      INTERFACE LA_LASYF
 
      SUBROUTINE SLASYF( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A, W
      END SUBROUTINE SLASYF
 
      SUBROUTINE CLASYF( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A, W
      END SUBROUTINE CLASYF
 
      MODULE PROCEDURE SLASYF_A2I1W2
      MODULE PROCEDURE CLASYF_A2I1W2
 
      END INTERFACE ! LA_LASYF
      PRIVATE SLASYF_A2I1W2, CLASYF_A2I1W2
 
      INTERFACE LA_SYTF2
 
      SUBROUTINE SSYTF2( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SSYTF2
 
      SUBROUTINE CSYTF2( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CSYTF2
 
      MODULE PROCEDURE SSYTF2_A2I1
      MODULE PROCEDURE CSYTF2_A2I1
 
      END INTERFACE ! LA_SYTF2
      PRIVATE SSYTF2_A2I1, CSYTF2_A2I1
 
      CONTAINS
 
      SUBROUTINE SLASYF_A2I1W2( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW,
     $                          INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), W(LDW,*)
         CALL SLASYF( UPLO, N, NB, KB, A(1,1), LDA, IPIV(1), W(1,1),
     $                LDW, INFO )
      END SUBROUTINE SLASYF_A2I1W2
 
      SUBROUTINE CLASYF_A2I1W2( UPLO, N, NB, KB, A, LDA, IPIV, W, LDW,
     $                          INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         INTEGER, INTENT(OUT) :: INFO, KB
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), W(LDW,*)
         CALL CLASYF( UPLO, N, NB, KB, A(1,1), LDA, IPIV(1), W(1,1),
     $                LDW, INFO )
      END SUBROUTINE CLASYF_A2I1W2
 
      SUBROUTINE SSYTF2_A2I1( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SSYTF2( UPLO, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE SSYTF2_A2I1
 
      SUBROUTINE CSYTF2_A2I1( UPLO, N, A, LDA, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CSYTF2( UPLO, N, A(1,1), LDA, IPIV(1), INFO )
      END SUBROUTINE CSYTF2_A2I1
 
      END MODULE LA_XSYTF2
