      MODULE LA_XPOTF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 15, 2002
!
!  Purpose
!  =======
!
!  LA_XPOTF2 defines a generic interface for xPOTF2.
!
      INTERFACE LA_POTF2
 
      SUBROUTINE SPOTF2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SPOTF2
 
      SUBROUTINE CPOTF2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CPOTF2
 
      MODULE PROCEDURE SPOTF2_A2
      MODULE PROCEDURE CPOTF2_A2
 
      END INTERFACE ! LA_POTF2
      PRIVATE SPOTF2_A2, CPOTF2_A2
 
      CONTAINS
 
      SUBROUTINE SPOTF2_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SPOTF2( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE SPOTF2_A2
 
      SUBROUTINE CPOTF2_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CPOTF2( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE CPOTF2_A2
 
      END MODULE LA_XPOTF2
