      MODULE LA_XLAEIF
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 05, 2002
!
!  Purpose
!  =======
!
!  LA_XLAEIF defines generic interfaces for xLAEIF, xLAEIL, and xLAEIU.
!
      INTERFACE LA_LAEIF
 
      SUBROUTINE SLAEIF( N, D, E, LAMBDA, DLF, DF, DUF, DU2, IN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: LAMBDA
         INTEGER, INTENT(OUT) :: IN
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(OUT) :: DF, DLF, DU2, DUF
      END SUBROUTINE SLAEIF
 
      MODULE PROCEDURE SLAEIF_D1E1
 
      END INTERFACE ! LA_LAEIF
      PRIVATE SLAEIF_D1E1
 
      INTERFACE LA_LAEIL
 
      SUBROUTINE SLAEIL( N, DL, IN, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(IN) :: IN
         REAL(WP), INTENT(IN) :: DL
         REAL(WP), INTENT(INOUT) :: X
      END SUBROUTINE SLAEIL
 
      MODULE PROCEDURE SLAEIL_D1I1X1
 
      END INTERFACE ! LA_LAEIL
      PRIVATE SLAEIL_D1I1X1
 
      INTERFACE LA_LAEIU
 
      SUBROUTINE SLAEIU( JOB, N, D, DU, DU2, X, TOL )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: JOB, N
         REAL(WP), INTENT(INOUT) :: TOL
         REAL(WP), INTENT(IN) :: D, DU, DU2
         REAL(WP), INTENT(INOUT) :: X
      END SUBROUTINE SLAEIU
 
      MODULE PROCEDURE SLAEIU_D1X1
 
      END INTERFACE ! LA_LAEIU
      PRIVATE SLAEIU_D1X1
 
      CONTAINS
!
!-----Natural interface for xLAEIF
!
      SUBROUTINE SLAEIF_D1E1( N, D, E, LAMBDA, DLF, DF, DUF, DU2, IN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: LAMBDA
         INTEGER, INTENT(OUT) :: IN(*)
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: DF(*), DLF(*), DU2(*), DUF(*)
         CALL SLAEIF( N, D(1), E(1), LAMBDA, DLF(1), DF(1), DUF(1),
     $                DU2(1), IN(1) )
      END SUBROUTINE SLAEIF_D1E1
!
!-----Natural interface for xLAEIL
!
      SUBROUTINE SLAEIL_D1I1X1( N, DL, IN, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(IN) :: IN(*)
         REAL(WP), INTENT(IN) :: DL(*)
         REAL(WP), INTENT(INOUT) :: X(*)
         CALL SLAEIL( N, DL(1), IN(1), X(1) )
      END SUBROUTINE SLAEIL_D1I1X1
!
!-----Natural interface for xLAEIU
!
      SUBROUTINE SLAEIU_D1X1( JOB, N, D, DU, DU2, X, TOL )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: JOB, N
         REAL(WP), INTENT(INOUT) :: TOL
         REAL(WP), INTENT(IN) :: D(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: X(*)
         CALL SLAEIU( JOB, N, D(1), DU(1), DU2(1), X(1), TOL )
      END SUBROUTINE SLAEIU_D1X1
 
      END MODULE LA_XLAEIF
