      MODULE LA_XHETS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 23, 2002
!
!  Purpose
!  =======
!
!  LA_XHETS2 defines a generic interface for xHETS2.
!
      INTERFACE LA_HETS2
 
      SUBROUTINE CHETS2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CHETS2
 
      MODULE PROCEDURE CHETS2_A2I1B2
 
      MODULE PROCEDURE CHETS2_A2I1B1
 
      END INTERFACE ! LA_HETS2
      PRIVATE CHETS2_A2I1B2, CHETS2_A2I1B1
 
      CONTAINS
 
      SUBROUTINE CHETS2_A2I1B2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CHETS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB)
      END SUBROUTINE CHETS2_A2I1B2
 
      SUBROUTINE CHETS2_A2I1B1( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CHETS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB )
      END SUBROUTINE CHETS2_A2I1B1
 
      END MODULE LA_XHETS2
