      MODULE LA_XGTTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 17, 2002
!
!  Purpose
!  =======
!
!  LA_XGTTS2 defines a generic interface for xGTTS2.
!
      INTERFACE LA_GTTS2
 
      SUBROUTINE SGTTS2( ITRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: ITRANS, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: D, DL, DU, DU2
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SGTTS2
 
      SUBROUTINE CGTTS2( ITRANS, N, NRHS, DL, D, DU, DU2, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: ITRANS, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: D, DL, DU, DU2
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CGTTS2
 
      MODULE PROCEDURE SGTTS2_D1I1B2
      MODULE PROCEDURE CGTTS2_D1I1B2
 
      END INTERFACE ! LA_GTTS2
      PRIVATE SGTTS2_D1I1B2, CGTTS2_D1I1B2
 
      CONTAINS
 
      SUBROUTINE SGTTS2_D1I1B2( ITRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     $                          B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: ITRANS, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SGTTS2( ITRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     $                IPIV(1), B(1,1), LDB )
      END SUBROUTINE SGTTS2_D1I1B2
 
      SUBROUTINE CGTTS2_D1I1B2( ITRANS, N, NRHS, DL, D, DU, DU2, IPIV,
     $                          B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: ITRANS, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), DU2(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CGTTS2( ITRANS, N, NRHS, DL(1), D(1), DU(1), DU2(1),
     $                IPIV(1), B(1,1), LDB )
      END SUBROUTINE CGTTS2_D1I1B2
 
      END MODULE LA_XGTTS2
