      MODULE LA_BLASO
!
!  -- LAPACK 3E module --
!     E. Anderson
!     July 29, 2002
!
!  Purpose
!  =======
!
!  LA_BLASO defines interfaces to alternate versions of the Level 1 BLAS
!  that use a true one-norm of a complex number, rather than the
!  pseduo-norm CABS1.
!
      INTERFACE LA_IMAX1
 
      INTEGER FUNCTION ICMAX1( N, CX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(IN) :: CX(*)
      END FUNCTION ICMAX1
 
      END INTERFACE ! LA_IMAX1
 
      INTERFACE LA_SUM1
 
      FUNCTION SCSUM1( N, CX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SCSUM1
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(IN) :: CX(*)
      END FUNCTION SCSUM1
 
      END INTERFACE ! LA_SUM1
 
      END MODULE LA_BLASO
