      MODULE LA_AUXILIARY
!
!  -- LAPACK 3E module --
!     E. Anderson
!     March 27, 2002
!
!  Purpose
!  =======
!
!  LA_AUXILIARY defines interfaces for public LAPACK auxiliary routines.
!  For routines that are called with indexed array arguments, both the
!  point interface and the natural interface are defined.
!
!!!!! ==================== !!!!!
!!!!! Non-generic routines !!!!!
!!!!! ==================== !!!!!
!
      INTERFACE
      FUNCTION ILAENV( ISPEC, NAME, OPTS, N1, N2, N3, N4 )
         INTEGER :: ILAENV
         CHARACTER*(*), INTENT(IN) :: NAME, OPTS
         INTEGER, INTENT(IN) :: ISPEC, N1, N2, N3, N4
      END FUNCTION ILAENV
      END INTERFACE
 
      INTERFACE
      FUNCTION ILATRS( ISPEC, NAME, OPTS, N1, N2, N3, N4 )
         INTEGER :: ILATRS
         CHARACTER*(*), INTENT(IN) :: NAME, OPTS
         INTEGER, INTENT(IN) :: ISPEC, N1, N2, N3, N4
      END FUNCTION ILATRS
      END INTERFACE
 
      INTERFACE
      FUNCTION LSAME( CA, CB )
         LOGICAL :: LSAME
         CHARACTER, INTENT(IN) :: CA, CB
      END FUNCTION LSAME
      END INTERFACE
 
      INTERFACE
      SUBROUTINE XERBLA( SRNAME, INFO )
         CHARACTER*(*), INTENT(IN) :: SRNAME
         INTEGER, INTENT(IN) :: INFO
      END SUBROUTINE XERBLA
      END INTERFACE
!
!!!!! ================ !!!!!
!!!!! Generic routines !!!!!
!!!!! ================ !!!!!
!
!-----Interface for xCLCPY
!
      INTERFACE LA_CLCPY
 
      SUBROUTINE SCLCPY( N, ALPHA, X, INCX, Y, INCY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(IN) :: ALPHA
         REAL(WP), INTENT(IN) :: X
         REAL(WP), INTENT(OUT) :: Y
      END SUBROUTINE SCLCPY
 
      MODULE PROCEDURE SCLCPY_X1Y1
 
      END INTERFACE ! LA_CLCPY
      PRIVATE SCLCPY_X1Y1
!
!-----Interface for xGESUM (an LAPACK 3E extension)
!
      INTERFACE LA_GESUM
 
      SUBROUTINE SGESUM( TRANS, M, N, ALPHA, A, LDA, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SGESUM
 
      SUBROUTINE CGESUM( TRANS, M, N, ALPHA, A, LDA, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CGESUM
 
      MODULE PROCEDURE SGESUM_A2B2
      MODULE PROCEDURE CGESUM_A2B2
 
      END INTERFACE ! LA_GESUM
      PRIVATE SGESUM_A2B2, CGESUM_A2B2
!
!-----Interface for xLACGV
!
      INTERFACE LA_LACGV
 
      SUBROUTINE CLACGV( N, X, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N, INCX
         COMPLEX(WP), INTENT(INOUT) :: X
      END SUBROUTINE CLACGV
 
      MODULE PROCEDURE CLACGV_X1
 
      END INTERFACE ! LA_LACGV
      PRIVATE CLACGV_X1
!
!-----Interface for xLACN2, the LAPACK 3E replacement for xLACON
!
      INTERFACE LA_LACN2
 
      SUBROUTINE SLACN2( N, V, X, ISGN, EST, KASE, ITER, JMAX, JUMP )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(INOUT) :: ITER, JMAX, JUMP, KASE
         REAL(WP), INTENT(OUT) :: EST
         INTEGER, INTENT(INOUT) :: ISGN(*)
         REAL(WP), INTENT(INOUT) :: V, X
      END SUBROUTINE SLACN2
 
      SUBROUTINE CLACN2( N, V, X, EST, KASE, ITER, JMAX, JUMP )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(INOUT) :: ITER, JMAX, JUMP, KASE
         REAL(WP), INTENT(OUT) :: EST
         COMPLEX(WP), INTENT(INOUT) :: V, X
      END SUBROUTINE CLACN2
 
      MODULE PROCEDURE SLACN2_V1X1
      MODULE PROCEDURE CLACN2_V1X1
 
      END INTERFACE ! LA_LACN2
      PRIVATE SLACN2_V1X1, CLACN2_V1X1
!
!-----Interface for xLACPY
!
      INTERFACE LA_LACPY
 
      SUBROUTINE SLACPY( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: B
      END SUBROUTINE SLACPY
 
      SUBROUTINE CLACPY( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(OUT) :: B
      END SUBROUTINE CLACPY
 
      SUBROUTINE CLACP2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(OUT) :: B
      END SUBROUTINE CLACP2
 
      MODULE PROCEDURE SLACPY_A2B2
      MODULE PROCEDURE CLACPY_A2B2
 
      MODULE PROCEDURE SLACPY_A0B2
      MODULE PROCEDURE CLACPY_A0B2
 
      MODULE PROCEDURE SLACPY_A2B0
      MODULE PROCEDURE CLACPY_A2B0
 
      MODULE PROCEDURE CLACP2_A2B2
      MODULE PROCEDURE CLACP2_A0B2
      MODULE PROCEDURE CLACP2_A2B0
 
      END INTERFACE ! LA_LACPY
      PRIVATE SLACPY_A2B2, CLACPY_A2B2
      PRIVATE SLACPY_A0B2, CLACPY_A0B2
      PRIVATE SLACPY_A2B0, CLACPY_A2B0
      PRIVATE CLACP2_A2B2
      PRIVATE CLACP2_A0B2
      PRIVATE CLACP2_A2B0
!
!-----Interface for xLACRM
!
      INTERFACE LA_LACRM
 
      SUBROUTINE CLACRM( M, N, A, LDA, B, LDB, C, LDC, RWORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LDC, M, N
         REAL(WP), INTENT(IN) :: B
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(OUT) :: C
      END SUBROUTINE CLACRM
 
      MODULE PROCEDURE CLACRM_A2C2R1
 
      END INTERFACE ! LA_LACRM
      PRIVATE CLACRM_A2C2R1
!
!-----Interface for the subroutine form of real xLADIV
!
      INTERFACE LA_LADV2
 
      SUBROUTINE SLADIV( A, B, C, D, P, Q )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: A, B, C, D
         REAL(WP), INTENT(OUT) :: P, Q
      END SUBROUTINE SLADIV
 
      END INTERFACE ! LA_LADV2
!
!-----Interface for the function form of complex xLADIV
!
      INTERFACE LA_LADIV
 
      FUNCTION CLADIV( X, Y )
         USE LA_CONSTANTS, ONLY: WP
         COMPLEX(WP) :: CLADIV
         COMPLEX(WP), INTENT(IN) :: X, Y
      END FUNCTION CLADIV
 
      END INTERFACE ! LA_LADIV
!
!-----Interface for xLAE2
!
      INTERFACE LA_LAE2
 
      SUBROUTINE SLAE2( A, B, C, RT1, RT2 )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: A, B, C
         REAL(WP), INTENT(OUT) :: RT1, RT2
      END SUBROUTINE SLAE2
 
      END INTERFACE ! LA_LAE2
!
!-----Interface for xLAEV2
!
      INTERFACE LA_LAEV2
 
      SUBROUTINE SLAEV2( A, B, C, RT1, RT2, CS1, SN1 )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: A, B, C
         REAL(WP), INTENT(OUT) :: CS1, RT1, RT2, SN1
      END SUBROUTINE SLAEV2
 
      SUBROUTINE CLAEV2( A, B, C, RT1, RT2, CS1, SN1 )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(OUT) :: CS1, RT1, RT2
         COMPLEX(WP), INTENT(IN) :: A, B, C
         COMPLEX(WP), INTENT(OUT) :: SN1
      END SUBROUTINE CLAEV2
 
      END INTERFACE ! LA_LAEV2
!
!-----Interface for xLAG2
!
      INTERFACE LA_LAG2
 
      SUBROUTINE SLAG2( A, LDA, B, LDB, SAFDUM, SCALE1, SCALE2, WR1,
     &                  WR2, WI )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: SAFDUM
         REAL(WP), INTENT(OUT) :: SCALE1, SCALE2, WI, WR1, WR2
         REAL(WP), INTENT(IN) :: A, B
      END SUBROUTINE SLAG2
 
      MODULE PROCEDURE SLAG2_A2B2
 
      END INTERFACE ! LA_LAG2
      PRIVATE SLAG2_A2B2
!
!-----Interface for xLALN2
!
      INTERFACE LA_LALN2
 
      SUBROUTINE SLALN2( LTRANS, NA, NW, SMIN, CA, A, LDA, D1, D2, B,
     &                   LDB, WR, WI, X, LDX, SCALE, XNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, NA, NW
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CA, D1, D2, SMIN, WI, WR
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: A, B
         REAL(WP), INTENT(OUT) :: X
      END SUBROUTINE SLALN2
 
      MODULE PROCEDURE SLALN2_A2B2X2
 
      MODULE PROCEDURE SLALN2_A0B2X2
 
      END INTERFACE ! LA_LALN2
      PRIVATE SLALN2_A2B2X2
      PRIVATE SLALN2_A0B2X2
!
!-----Interface for xLAMC3
!
      INTERFACE LA_LAMC3
 
      FUNCTION SLAMC3( A, B )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLAMC3
         REAL(WP), INTENT(IN) :: A, B
      END FUNCTION SLAMC3
 
      END INTERFACE ! LA_LAMC3
!
!-----Interface for xLAMRG
!
      INTERFACE LA_LAMRG
 
      SUBROUTINE SLAMRG( N1, N2, A, STRD1, STRD2, INDEX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N1, N2, STRD1, STRD2
         INTEGER, INTENT(OUT) :: INDEX
         REAL(WP), INTENT(IN) :: A
      END SUBROUTINE SLAMRG
 
      MODULE PROCEDURE SLAMRG_A1I1
 
      END INTERFACE ! LA_LAMRG
      PRIVATE SLAMRG_A1I1
!
!-----Interface for xLANGB
!
      INTERFACE LA_LANGB
 
      FUNCTION SLANGB( NORM, N, KL, KU, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANGB
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDAB, N, KL, KU
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION SLANGB
 
      FUNCTION CLANGB( NORM, N, KL, KU, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANGB
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDAB, N, KL, KU
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION CLANGB
 
      END INTERFACE ! LA_LANGB
!
!-----Interface for xLANGE
!
      INTERFACE LA_LANGE
 
      FUNCTION SLANGE( NORM, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANGE
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END FUNCTION SLANGE
 
      FUNCTION CLANGE( NORM, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANGE
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, M, N
         COMPLEX(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END FUNCTION CLANGE
 
      MODULE PROCEDURE SLANGE_A2W1
      MODULE PROCEDURE CLANGE_A2W1
 
      END INTERFACE ! LA_LANGE
      PRIVATE SLANGE_A2W1, CLANGE_A2W1
!
!-----Interface for xLANGT
!
      INTERFACE LA_LANGT
 
      FUNCTION SLANGT( NORM, N, DL, D, DU )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANGT
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*)
      END FUNCTION SLANGT
 
      FUNCTION CLANGT( NORM, N, DL, D, DU )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANGT
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*)
      END FUNCTION CLANGT
 
      END INTERFACE ! LA_LANGT
!
!-----Interface for xLANHS
!
      INTERFACE LA_LANHS
 
      FUNCTION SLANHS( NORM, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANHS
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END FUNCTION SLANHS
 
      FUNCTION CLANHS( NORM, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHS
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         COMPLEX(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END FUNCTION CLANHS
 
      MODULE PROCEDURE SLANHS_A2W1
      MODULE PROCEDURE CLANHS_A2W1
 
      END INTERFACE ! LA_LANHS
      PRIVATE SLANHS_A2W1, CLANHS_A2W1
!
!-----Interface for xLANSB and xLANHB
!
      INTERFACE LA_LANSB
 
      FUNCTION SLANSB( NORM, UPLO, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANSB
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION SLANSB
 
      FUNCTION CLANSB( NORM, UPLO, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANSB
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION CLANSB
 
      END INTERFACE ! LA_LANSB
 
      INTERFACE LA_LANHB
 
      FUNCTION CLANHB( NORM, UPLO, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHB
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION CLANHB
 
      END INTERFACE ! LA_LANHB
!
!-----Interface for xLANSP and xLANHP
!
      INTERFACE LA_LANSP
 
      FUNCTION SLANSP( NORM, UPLO, N, AP, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANSP
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) ::  WORK(*)
      END FUNCTION SLANSP
 
      FUNCTION CLANSP( NORM, UPLO, N, AP, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANSP
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: N
         COMPLEX(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) ::  WORK(*)
      END FUNCTION CLANSP
 
      END INTERFACE ! LA_LANSP
 
      INTERFACE LA_LANHP
 
      FUNCTION CLANHP( NORM, UPLO, N, AP, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHP
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: N
         COMPLEX(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(OUT) ::  WORK(*)
      END FUNCTION CLANHP
 
      END INTERFACE ! LA_LANHP
!
!-----Interface for xLANST and xLANHT
!
      INTERFACE LA_LANST
 
      FUNCTION SLANST( NORM, N, D, E )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANST
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: D, E
      END FUNCTION SLANST
 
      MODULE PROCEDURE SLANST_D1E1
 
      END INTERFACE ! LA_LANST
      PRIVATE SLANST_D1E1
 
      INTERFACE LA_LANHT
 
      FUNCTION CLANHT( NORM, N, D, E )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHT
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: D
         COMPLEX(WP), INTENT(IN) :: E
      END FUNCTION CLANHT
 
      MODULE PROCEDURE CLANHT_D1E1
 
      END INTERFACE ! LA_LANHT
      PRIVATE CLANHT_D1E1
!
!-----Interface for xLANSY and xLANHE
!
      INTERFACE LA_LANSY
 
      FUNCTION SLANSY( NORM, UPLO, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANSY
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION SLANSY
 
      FUNCTION CLANSY( NORM, UPLO, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANSY
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION CLANSY
 
      END INTERFACE ! LA_LANSY
 
      INTERFACE LA_LANHE
 
      FUNCTION CLANHE( NORM, UPLO, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHE
         CHARACTER, INTENT(IN) :: NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
      END FUNCTION CLANHE
 
      END INTERFACE ! LA_LANHE
!
!-----Interface for xLANTB
!
      INTERFACE LA_LANTB
 
      FUNCTION SLANTB( NORM, UPLO, DIAG, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANTB
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: WORK
      END FUNCTION SLANTB
 
      FUNCTION CLANTB( NORM, UPLO, DIAG, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANTB
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         COMPLEX(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: WORK
      END FUNCTION CLANTB
 
      MODULE PROCEDURE SLANTB_A2W1
      MODULE PROCEDURE CLANTB_A2W1
 
      END INTERFACE ! LA_LANTB
      PRIVATE SLANTB_A2W1, CLANTB_A2W1
!
!-----Interface for xLANTP
!
      INTERFACE LA_LANTP
 
      FUNCTION SLANTP( NORM, UPLO, DIAG, N, AP, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANTP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
      END FUNCTION SLANTP
 
      FUNCTION CLANTP( NORM, UPLO, DIAG, N, AP, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANTP
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: N
         COMPLEX(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
      END FUNCTION CLANTP
 
      END INTERFACE ! LA_LANTP
!
!-----Interface for xLANTR
!
      INTERFACE LA_LANTR
 
      FUNCTION SLANTR( NORM, UPLO, DIAG, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANTR
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
      END FUNCTION SLANTR
 
      FUNCTION CLANTR( NORM, UPLO, DIAG, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANTR
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
      END FUNCTION CLANTR
 
      END INTERFACE ! LA_LANTR
!
!-----Interface for xLANV2
!
      INTERFACE LA_LANV2
 
      SUBROUTINE SLANV2( A, B, C, D, RT1R, RT1I, RT2R, RT2I, CS, SN )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(INOUT) :: A, B, C, D
         REAL(WP), INTENT(OUT) :: CS, RT1I, RT1R, RT2I, RT2R, SN
      END SUBROUTINE SLANV2
 
      END INTERFACE ! LA_LANV2
!
!-----Interface for xLAPY2 and xLAPY3
!
      INTERFACE LA_LAPY2
 
      FUNCTION SLAPY2( X, Y )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLAPY2
         REAL(WP), INTENT(IN) :: X, Y
      END FUNCTION SLAPY2
 
      END INTERFACE ! LA_LAPY2
 
      INTERFACE LA_LAPY3
 
      FUNCTION SLAPY3( X, Y, Z )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLAPY3
         REAL(WP), INTENT(IN) :: X, Y, Z
      END FUNCTION SLAPY3
 
      END INTERFACE ! LA_LAPY3
!
!-----Interface for xLAR2V
!
      INTERFACE LA_LAR2V
 
      SUBROUTINE SLAR2V( N, X, Y, Z, INCX, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, N
         REAL(WP), INTENT(IN) :: C, S
         REAL(WP), INTENT(INOUT) :: X, Y, Z
      END SUBROUTINE SLAR2V
 
      SUBROUTINE CLAR2V( N, X, Y, Z, INCX, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, N
         REAL(WP), INTENT(IN) :: C
         COMPLEX(WP), INTENT(IN) :: S
         COMPLEX(WP), INTENT(INOUT) :: X, Y, Z
      END SUBROUTINE CLAR2V
 
      MODULE PROCEDURE SLAR2V_X1C1
      MODULE PROCEDURE CLAR2V_X1C1
 
      END INTERFACE ! LA_LAR2V
      PRIVATE SLAR2V_X1C1, CLAR2V_X1C1
!
!-----Interface for xLARCM
!
      INTERFACE LA_LARCM
 
      SUBROUTINE CLARCM( M, N, A, LDA, B, LDB, C, LDC, RWORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LDC, M, N
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(IN) :: B, C
      END SUBROUTINE CLARCM
 
      MODULE PROCEDURE CLARCM_A2C2R1
 
      END INTERFACE ! LA_LARCM
      PRIVATE CLARCM_A2C2R1
!
!-----Interface for xLARF
!
      INTERFACE LA_LARF
 
      SUBROUTINE SLARF( SIDE, M, N, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARF
 
      SUBROUTINE CLARF( SIDE, M, N, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLARF
 
      MODULE PROCEDURE SLARF_V1C2W1
      MODULE PROCEDURE CLARF_V1C2W1
 
      END INTERFACE ! LA_LARF
      PRIVATE SLARF_V1C2W1, CLARF_V1C2W1
!
!-----Interface for xLARFB
!
      INTERFACE LA_LARFB
 
      SUBROUTINE SLARFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, V, LDV,
     &                   T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, LDC, LDT, LDV, LDWORK, M, N
         REAL(WP), INTENT(IN) :: T, V
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARFB
 
      SUBROUTINE CLARFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, V, LDV,
     &                   T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, LDC, LDT, LDV, LDWORK, M, N
         COMPLEX(WP), INTENT(IN) :: T, V
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLARFB
 
      MODULE PROCEDURE SLARFB_V2C2W2
      MODULE PROCEDURE CLARFB_V2C2W2
 
      END INTERFACE ! LA_LARFB
      PRIVATE SLARFB_V2C2W2, CLARFB_V2C2W2
!
!-----Interface for xLARFG
!
      INTERFACE LA_LARFG
 
      SUBROUTINE SLARFG( N, ALPHA, X, INCX, TAU )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: ALPHA
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(INOUT) :: X
      END SUBROUTINE SLARFG
 
      SUBROUTINE CLARFG( N, ALPHA, X, INCX, TAU )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(INOUT) :: ALPHA
         COMPLEX(WP), INTENT(OUT) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: X
      END SUBROUTINE CLARFG
 
      MODULE PROCEDURE SLARFG_X1
      MODULE PROCEDURE CLARFG_X1
 
      END INTERFACE ! LA_LARFG
      PRIVATE SLARFG_X1, CLARFG_X1
!
!-----Interface for xLARFT
!
      INTERFACE LA_LARFT
 
      SUBROUTINE SLARFT( DIRECT, STOREV, N, K, V, LDV, TAU, T, LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: V
         REAL(WP), INTENT(OUT) :: T
      END SUBROUTINE SLARFT
 
      SUBROUTINE CLARFT( DIRECT, STOREV, N, K, V, LDV, TAU, T, LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: V
         COMPLEX(WP), INTENT(OUT) :: T
      END SUBROUTINE CLARFT
 
      MODULE PROCEDURE SLARFT_V2U1T2
      MODULE PROCEDURE CLARFT_V2U1T2
 
      END INTERFACE ! LA_LARFT
      PRIVATE SLARFT_V2U1T2, CLARFT_V2U1T2
!
!-----Interface for xLARGV
!
      INTERFACE LA_LARGV
 
      SUBROUTINE SLARGV( N, X, INCX, Y, INCY, C, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(INOUT) :: X, Y
         REAL(WP), INTENT(OUT) :: C
      END SUBROUTINE SLARGV
 
      SUBROUTINE CLARGV( N, X, INCX, Y, INCY, C, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(OUT) :: C
         COMPLEX(WP), INTENT(INOUT) :: X, Y
      END SUBROUTINE CLARGV
 
      MODULE PROCEDURE SLARGV_X1Y1C1
      MODULE PROCEDURE CLARGV_X1Y1C1
 
      END INTERFACE ! LA_LARGV
      PRIVATE SLARGV_X1Y1C1, CLARGV_X1Y1C1
!
!-----Interface for xLARNV
!
      INTERFACE LA_LARNV
 
      SUBROUTINE SLARNV( IDIST, ISEED, N, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIST, N
         INTEGER, INTENT(INOUT) :: ISEED(4)
         REAL(WP), INTENT(OUT) :: X
      END SUBROUTINE SLARNV
 
      SUBROUTINE CLARNV( IDIST, ISEED, N, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIST, N
         INTEGER, INTENT(INOUT) :: ISEED(4)
         COMPLEX(WP), INTENT(OUT) :: X
      END SUBROUTINE CLARNV
 
      END INTERFACE ! LA_LARNV
      PRIVATE SLARNV_X1, CLARNV_X1
!
!-----Interface for xLARTG
!
      INTERFACE LA_LARTG
 
      SUBROUTINE SLARTG( F, G, CS, SN, R )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: F, G
         REAL(WP), INTENT(OUT) :: CS, R, SN
      END SUBROUTINE SLARTG
 
      SUBROUTINE CLARTG( F, G, CS, SN, R )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(OUT) :: CS
         COMPLEX(WP), INTENT(IN) :: F, G
         COMPLEX(WP), INTENT(OUT) :: R, SN
      END SUBROUTINE CLARTG
 
      END INTERFACE ! LA_LARTG
!
!-----Interface for xLARTV
!
      INTERFACE LA_LARTV
 
      SUBROUTINE SLARTV( N, X, INCX, Y, INCY, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(IN) :: C, S
         REAL(WP), INTENT(INOUT) :: X, Y
      END SUBROUTINE SLARTV
 
      SUBROUTINE CLARTV( N, X, INCX, Y, INCY, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(IN) :: C
         COMPLEX(WP), INTENT(IN) :: S
         COMPLEX(WP), INTENT(INOUT) :: X, Y
      END SUBROUTINE CLARTV
 
      MODULE PROCEDURE SLARTV_X1Y1C1
      MODULE PROCEDURE CLARTV_X1Y1C1
 
      END INTERFACE ! LA_LARTV
      PRIVATE SLARTV_X1Y1C1, CLARTV_X1Y1C1
!
!-----Interface for xLARZ
!
      INTERFACE LA_LARZ
 
      SUBROUTINE SLARZ( SIDE, M, N, L, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, L, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARZ
 
      SUBROUTINE CLARZ( SIDE, M, N, L, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, L, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLARZ
 
      MODULE PROCEDURE SLARZ_V1C2W1
      MODULE PROCEDURE CLARZ_V1C2W1
 
      END INTERFACE ! LA_LARZ
      PRIVATE SLARZ_V1C2W1, CLARZ_V1C2W1
!
!-----Interface for xLARZB
!
      INTERFACE LA_LARZB
 
      SUBROUTINE SLARZB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V,
     &                   LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, L, LDC, LDT, LDV, LDWORK, M, N
         REAL(WP), INTENT(IN) :: T, V
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARZB
 
      SUBROUTINE CLARZB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V,
     &                   LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, L, LDC, LDT, LDV, LDWORK, M, N
         COMPLEX(WP), INTENT(IN) :: T, V
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLARZB
 
      MODULE PROCEDURE SLARZB_V2T2W2
      MODULE PROCEDURE CLARZB_V2T2W2
 
      END INTERFACE ! LA_LARZB
      PRIVATE SLARZB_V2T2W2, CLARZB_V2T2W2
!
!-----Interface for xLARZT
!
      INTERFACE LA_LARZT
 
      SUBROUTINE SLARZT( DIRECT, STOREV, N, K, V, LDV, TAU, T, LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: V
         REAL(WP), INTENT(OUT) :: T
      END SUBROUTINE SLARZT
 
      SUBROUTINE CLARZT( DIRECT, STOREV, N, K, V, LDV, TAU, T, LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: V
         COMPLEX(WP), INTENT(OUT) :: T
      END SUBROUTINE CLARZT
 
      MODULE PROCEDURE SLARZT_V2U1T2
      MODULE PROCEDURE CLARZT_V2U1T2
 
      END INTERFACE ! LA_LARZT
      PRIVATE SLARZT_V2U1T2, CLARZT_V2U1T2
!
!-----Interface for xLAS2
!
      INTERFACE LA_LAS2
 
      SUBROUTINE SLAS2( F, G, H, SSMIN, SSMAX )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: F, G, H
         REAL(WP), INTENT(OUT) :: SSMAX, SSMIN
      END SUBROUTINE SLAS2
 
      END INTERFACE ! LA_LAS2
!
!-----Interface for xLASCL
!
      INTERFACE LA_LASCL
 
      SUBROUTINE SLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SLASCL
 
      SUBROUTINE CLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CLASCL
 
      MODULE PROCEDURE SLASCL_A2
      MODULE PROCEDURE CLASCL_A2
 
      MODULE PROCEDURE SLASCL_A1
      MODULE PROCEDURE CLASCL_A1
 
      END INTERFACE LA_LASCL
      PRIVATE SLASCL_A2, CLASCL_A2
      PRIVATE SLASCL_A1, CLASCL_A1
!
!-----Interface for xLASET
!
      INTERFACE LA_LASET
 
      SUBROUTINE SLASET( UPLO, M, N, ALPHA, BETA, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SLASET
 
      SUBROUTINE CLASET( UPLO, M, N, ALPHA, BETA, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CLASET
 
      MODULE PROCEDURE SLASET_A2
      MODULE PROCEDURE CLASET_A2
 
      END INTERFACE ! LA_LASET
      PRIVATE SLASET_A2, CLASET_A2
!
!-----Interface for xLASGN
!
      INTERFACE LA_LASGN
 
      FUNCTION CLASGN( Z )
         USE LA_CONSTANTS, ONLY: WP
         COMPLEX(WP) CLASGN
         COMPLEX(WP), INTENT(IN) :: Z
      END FUNCTION CLASGN
 
      END INTERFACE ! LA_LASGN
!
!-----Interface for xLASR
!
      INTERFACE LA_LASR
 
      SUBROUTINE SLASR( SIDE, PIVOT, DIRECT, M, N, C, S, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, PIVOT, SIDE
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: C, S
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SLASR
 
      SUBROUTINE CLASR( SIDE, PIVOT, DIRECT, M, N, C, S, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, PIVOT, SIDE
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: C, S
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CLASR
 
      MODULE PROCEDURE SLASR_C1S1A2
      MODULE PROCEDURE CLASR_C1S1A2
 
      END INTERFACE ! LA_LASR
      PRIVATE SLASR_C1S1A2, CLASR_C1S1A2
!
!-----Interface for xLASRT
!
      INTERFACE LA_LASRT
 
      SUBROUTINE ILASRT( ID, N, D, INFO )
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: D
      END SUBROUTINE ILASRT
 
      SUBROUTINE ILASRT2( ID, N, D, KEY, INFO )
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: D, KEY
      END SUBROUTINE ILASRT2
 
      SUBROUTINE SLASRT( ID, N, D, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         REAL(WP), INTENT(INOUT) :: D
      END SUBROUTINE SLASRT
 
      SUBROUTINE SLASRT2( ID, N, D, KEY, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: KEY
         REAL(WP), INTENT(INOUT) :: D
      END SUBROUTINE SLASRT2
 
      MODULE PROCEDURE ILASRT_D1
      MODULE PROCEDURE ILASRT2_D1K1
      MODULE PROCEDURE SLASRT_D1
      MODULE PROCEDURE SLASRT2_D1K1
 
      END INTERFACE ! LA_LASRT
      PRIVATE ILASRT_D1, ILASRT2_D1K1
      PRIVATE SLASRT_D1, SLASRT2_D1K1
!
!-----Interface for xLASSQ
!
      INTERFACE LA_LASSQ
 
      SUBROUTINE SLASSQ( N, X, INCX, SCL, SUMSQ )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: SCL, SUMSQ
         REAL(WP), INTENT(IN) :: X
      END SUBROUTINE SLASSQ
 
      SUBROUTINE CLASSQ( N, X, INCX, SCL, SUMSQ )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: SCL, SUMSQ
         COMPLEX(WP), INTENT(IN) :: X
      END SUBROUTINE CLASSQ
 
      MODULE PROCEDURE SLASSQ_X1
      MODULE PROCEDURE CLASSQ_X1
 
      END INTERFACE ! LA_LASSQ
      PRIVATE SLASSQ_X1, CLASSQ_X1
!
!-----Interface for xLASV2
!
      INTERFACE LA_LASV2
 
      SUBROUTINE SLASV2( F, G, H, SSMIN, SSMAX, SNR, CSR, SNL, CSL )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP), INTENT(IN) :: F, G, H
         REAL(WP), INTENT(OUT) :: CSL, CSR, SNL, SNR, SSMAX, SSMIN
      END SUBROUTINE SLASV2
 
      END INTERFACE ! LA_LASV2
!
!-----Interface for xLASWP
!
      INTERFACE LA_LASWP
 
      SUBROUTINE SLASWP( N, A, LDA, K1, K2, IPIV, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, K1, K2, LDA, N
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SLASWP
 
      SUBROUTINE CLASWP( N, A, LDA, K1, K2, IPIV, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, K1, K2, LDA, N
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CLASWP
 
      MODULE PROCEDURE SLASWP_A2I1
      MODULE PROCEDURE CLASWP_A2I1
 
      END INTERFACE ! LA_LASWP
      PRIVATE SLASWP_A2I1, CLASWP_A2I1
!
!-----Interface for xLATBS
!
      INTERFACE LA_LATBS
 
      SUBROUTINE SLATBS( UPLO, TRANS, DIAG, NORMIN, N, KD, AB, LDAB, X,
     &                   SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: AB
         REAL(WP), INTENT(INOUT) :: CNORM, X
      END SUBROUTINE SLATBS
 
      SUBROUTINE CLATBS( UPLO, TRANS, DIAG, NORMIN, N, KD, AB, LDAB, X,
     &                   SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM
         COMPLEX(WP), INTENT(IN) :: AB
         COMPLEX(WP), INTENT(INOUT) :: X
      END SUBROUTINE CLATBS
 
      MODULE PROCEDURE SLATBS_A2X1C1
      MODULE PROCEDURE CLATBS_A2X1C1
 
      END INTERFACE ! LA_LATBS
      PRIVATE SLATBS_A2X1C1, CLATBS_A2X1C1
!
!-----Interface for xLATPS
!
      INTERFACE LA_LATPS
 
      SUBROUTINE SLATPS( UPLO, TRANS, DIAG, NORMIN, N, AP, X, SCALE,
     &                   CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: CNORM, X
      END SUBROUTINE SLATPS
 
      SUBROUTINE CLATPS( UPLO, TRANS, DIAG, NORMIN, N, AP, X, SCALE,
     &                   CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: X
      END SUBROUTINE CLATPS
 
      MODULE PROCEDURE SLATPS_A1X1C1
      MODULE PROCEDURE CLATPS_A1X1C1
 
      END INTERFACE ! LA_LATPS
      PRIVATE SLATPS_A1X1C1, CLATPS_A1X1C1
!
!-----Interface for xLATRS
!
      INTERFACE LA_LATRS
 
      SUBROUTINE SLATRS( UPLO, TRANS, DIAG, NORMIN, N, A, LDA, X, SCALE,
     &                   CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: CNORM, X
      END SUBROUTINE SLATRS
 
      SUBROUTINE CLATRS( UPLO, TRANS, DIAG, NORMIN, N, A, LDA, X, SCALE,
     &                   CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: X
      END SUBROUTINE CLATRS
 
      MODULE PROCEDURE SLATRS_A2X1C1
      MODULE PROCEDURE CLATRS_A2X1C1
 
      END INTERFACE ! LA_LATRS
      PRIVATE SLATRS_A2X1C1, CLATRS_A2X1C1
!
!-----Interface for xRSCL
!
      INTERFACE LA_RSCL
 
      SUBROUTINE SRSCL( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(IN) :: SA
         REAL(WP), INTENT(INOUT) :: SX
      END SUBROUTINE SRSCL
 
      SUBROUTINE CRSCL( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(IN) :: SA
         COMPLEX(WP), INTENT(INOUT) :: SX
      END SUBROUTINE CRSCL
 
      SUBROUTINE CSRSCL( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(IN) :: SA
         COMPLEX(WP), INTENT(INOUT) :: SX
      END SUBROUTINE CSRSCL
 
      MODULE PROCEDURE SRSCL_X1
      MODULE PROCEDURE CRSCL_X1
      MODULE PROCEDURE CSRSCL_X1
 
      END INTERFACE ! LA_RSCL
      PRIVATE SRSCL_X1, CRSCL_X1
      PRIVATE CSRSCL_X1
 
      CONTAINS
 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!! Natural interfaces !!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!-----Natural interface for xCLCPY
!
      SUBROUTINE SCLCPY_X1Y1( N, ALPHA, X, INCX, Y, INCY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(IN) :: ALPHA
         REAL(WP), INTENT(IN) :: X(*)
         REAL(WP), INTENT(OUT) :: Y(*)
         CALL SCLCPY( N, ALPHA, X(1), INCX, Y(1), INCY )
      END SUBROUTINE SCLCPY_X1Y1
!
!-----Natural interface for xGESUM
!
      SUBROUTINE SGESUM_A2B2( TRANS, M, N, ALPHA, A, LDA, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SGESUM( TRANS, M, N, ALPHA, A(1,1), LDA, BETA, B(1,1),
     &                LDB )
      END SUBROUTINE SGESUM_A2B2
 
      SUBROUTINE CGESUM_A2B2( TRANS, M, N, ALPHA, A, LDA, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CGESUM( TRANS, M, N, ALPHA, A(1,1), LDA, BETA, B(1,1),
     &                LDB )
      END SUBROUTINE CGESUM_A2B2
!
!-----Natural interface for xLACGV
!
      SUBROUTINE CLACGV_X1( N, X, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N, INCX
         COMPLEX(WP), INTENT(INOUT) :: X(*)
         CALL CLACGV( N, X(1), INCX )
      END SUBROUTINE CLACGV_X1
!
!-----Natural interface for xLACN2
!
      SUBROUTINE SLACN2_V1X1( N, V, X, ISGN, EST, KASE, ITER, JMAX,
     &                        JUMP )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(INOUT) :: ITER, JMAX, JUMP, KASE
         REAL(WP), INTENT(OUT) :: EST
         INTEGER, INTENT(INOUT) :: ISGN(*)
         REAL(WP), INTENT(INOUT) :: V(*), X(*)
         CALL SLACN2( N, V(1), X(1), ISGN, EST, KASE, ITER, JMAX, JUMP )
      END SUBROUTINE SLACN2_V1X1
 
      SUBROUTINE CLACN2_V1X1( N, V, X, EST, KASE, ITER, JMAX, JUMP )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(INOUT) :: ITER, JMAX, JUMP, KASE
         REAL(WP), INTENT(OUT) :: EST
         COMPLEX(WP), INTENT(INOUT) :: V(*), X(*)
         CALL CLACN2( N, V(1), X(1), EST, KASE, ITER, JMAX, JUMP )
      END SUBROUTINE CLACN2_V1X1
!
!-----Natural interface for xLACP2
!
      SUBROUTINE CLACP2_A2B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL CLACP2( UPLO, M, N, A(1,1), LDA, B(1,1), LDB )
      END SUBROUTINE CLACP2_A2B2
!
!-----Interface for xLACP2 using point interface for A
!
      SUBROUTINE CLACP2_A0B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL CLACP2( UPLO, M, N, A, LDA, B(1,1), LDB )
      END SUBROUTINE CLACP2_A0B2
!
!-----Interface for xLACPY using point interface for B
!
      SUBROUTINE CLACP2_A2B0( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: B
         CALL CLACP2( UPLO, M, N, A(1,1), LDA, B, LDB )
      END SUBROUTINE CLACP2_A2B0
!
!-----Natural interface for xLACPY
!
      SUBROUTINE SLACPY_A2B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: B(LDB,*)
         CALL SLACPY( UPLO, M, N, A(1,1), LDA, B(1,1), LDB )
      END SUBROUTINE SLACPY_A2B2
 
      SUBROUTINE CLACPY_A2B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL CLACPY( UPLO, M, N, A(1,1), LDA, B(1,1), LDB )
      END SUBROUTINE CLACPY_A2B2
!
!-----Interface for xLACPY using point interface for A
!
      SUBROUTINE SLACPY_A0B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(OUT) :: B(LDB,*)
         CALL SLACPY( UPLO, M, N, A, LDA, B(1,1), LDB )
      END SUBROUTINE SLACPY_A0B2
 
      SUBROUTINE CLACPY_A0B2( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(OUT) :: B(LDB,*)
         CALL CLACPY( UPLO, M, N, A, LDA, B(1,1), LDB )
      END SUBROUTINE CLACPY_A0B2
!
!-----Interface for xLACPY using point interface for B
!
      SUBROUTINE SLACPY_A2B0( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: B
         CALL SLACPY( UPLO, M, N, A(1,1), LDA, B, LDB )
      END SUBROUTINE SLACPY_A2B0
 
      SUBROUTINE CLACPY_A2B0( UPLO, M, N, A, LDA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDB, M, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: B
         CALL CLACPY( UPLO, M, N, A(1,1), LDA, B, LDB )
      END SUBROUTINE CLACPY_A2B0
!
!-----Natural interface for xLACRM
!
      SUBROUTINE CLACRM_A2C2R1( M, N, A, LDA, B, LDB, C, LDC, RWORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LDC, M, N
         REAL(WP), INTENT(IN) :: B(LDB,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: C(LDC,*)
         CALL CLACRM( M, N, A(1,1), LDA, B(1,1), LDB, C(1,1), LDC,
     &                RWORK(1) )
      END SUBROUTINE CLACRM_A2C2R1
!
!-----Natural interface for xLAG2
!
      SUBROUTINE SLAG2_A2B2( A, LDA, B, LDB, SAFDUM, SCALE1, SCALE2,
     &                       WR1, WR2, WI )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: SAFDUM
         REAL(WP), INTENT(OUT) :: SCALE1, SCALE2, WI, WR1, WR2
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         CALL SLAG2( A(1,1), LDA, B(1,1), LDB, SAFDUM, SCALE1, SCALE2,
     &               WR1, WR2, WI )
      END SUBROUTINE SLAG2_A2B2
!
!-----Natural interface for xLALN2
!
      SUBROUTINE SLALN2_A2B2X2( LTRANS, NA, NW, SMIN, CA, A, LDA, D1,
     &                          D2, B, LDB, WR, WI, X, LDX, SCALE,
     &                          XNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, NA, NW
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CA, D1, D2, SMIN, WI, WR
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: X(LDX,*)
         CALL SLALN2( LTRANS, NA, NW, SMIN, CA, A(1,1), LDA, D1, D2,
     &                B(1,1), LDB, WR, WI, X(1,1), LDX, SCALE, XNORM,
     &                INFO )
      END SUBROUTINE SLALN2_A2B2X2
 
      SUBROUTINE SLALN2_A0B2X2( LTRANS, NA, NW, SMIN, CA, A, LDA, D1,
     &                          D2, B, LDB, WR, WI, X, LDX, SCALE,
     &                          XNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANS
         INTEGER, INTENT(IN) :: LDA, LDB, LDX, NA, NW
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CA, D1, D2, SMIN, WI, WR
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: A, B(LDB,*)
         REAL(WP), INTENT(OUT) :: X(LDX,*)
         CALL SLALN2( LTRANS, NA, NW, SMIN, CA, A, LDA, D1, D2,
     &                B(1,1), LDB, WR, WI, X(1,1), LDX, SCALE, XNORM,
     &                INFO )
      END SUBROUTINE SLALN2_A0B2X2
!
!-----Natural interface for xLAMRG
!
      SUBROUTINE SLAMRG_A1I1( N1, N2, A, STRD1, STRD2, INDEX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: N1, N2, STRD1, STRD2
         INTEGER, INTENT(OUT) :: INDEX(*)
         REAL(WP), INTENT(IN) :: A(*)
         CALL SLAMRG( N1, N2, A(1), STRD1, STRD2, INDEX(1) )
      END SUBROUTINE SLAMRG_A1I1
!
!-----Natural interface for xLANGE
!
      FUNCTION SLANGE_A2W1( NORM, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANGE_A2W1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         SLANGE_A2W1 = SLANGE( NORM, M, N, A(1,1), LDA, WORK(1) )
      END FUNCTION SLANGE_A2W1
 
      FUNCTION CLANGE_A2W1( NORM, M, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANGE_A2W1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, M, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CLANGE_A2W1 = CLANGE( NORM, M, N, A(1,1), LDA, WORK(1) )
      END FUNCTION CLANGE_A2W1
!
!-----Natural interface for xLANHS
!
      FUNCTION SLANHS_A2W1( NORM, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANHS_A2W1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         SLANHS_A2W1 = SLANHS( NORM, N, A(1,1), LDA, WORK(1) )
      END FUNCTION SLANHS_A2W1
 
      FUNCTION CLANHS_A2W1( NORM, N, A, LDA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHS_A2W1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: LDA, N
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CLANHS_A2W1 = CLANHS( NORM, N, A(1,1), LDA, WORK(1) )
      END FUNCTION CLANHS_A2W1
!
!-----Natural interface for xLANST and xLANHT
!
      FUNCTION SLANST_D1E1( NORM, N, D, E )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANST_D1E1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: D(*), E(*)
         SLANST_D1E1 = SLANST( NORM, N, D(1), E(1) )
      END FUNCTION SLANST_D1E1
 
      FUNCTION CLANHT_D1E1( NORM, N, D, E )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANHT_D1E1
         CHARACTER, INTENT(IN) :: NORM
         INTEGER, INTENT(IN) :: N
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         CLANHT_D1E1 = CLANHT( NORM, N, D(1), E(1) )
      END FUNCTION CLANHT_D1E1
!
!-----Natural interface for xLANTB
!
      FUNCTION SLANTB_A2W1( NORM, UPLO, DIAG, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: SLANTB_A2W1
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
         SLANTB_A2W1 = SLANTB( NORM, UPLO, DIAG, N, K, AB(1,1), LDAB,
     &                 WORK(1) )
      END FUNCTION SLANTB_A2W1
 
      FUNCTION CLANTB_A2W1( NORM, UPLO, DIAG, N, K, AB, LDAB, WORK )
         USE LA_CONSTANTS, ONLY: WP
         REAL(WP) :: CLANTB_A2W1
         CHARACTER, INTENT(IN) :: DIAG, NORM, UPLO
         INTEGER, INTENT(IN) :: K, LDAB, N
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: WORK(*)
         CLANTB_A2W1 = CLANTB( NORM, UPLO, DIAG, N, K, AB(1,1), LDAB,
     &                 WORK(1) )
      END FUNCTION CLANTB_A2W1
!
!-----Natural interface for xLAR2V
!
      SUBROUTINE SLAR2V_X1C1( N, X, Y, Z, INCX, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, N
         REAL(WP), INTENT(IN) :: C(*), S(*)
         REAL(WP), INTENT(INOUT) :: X(*), Y(*), Z(*)
         CALL SLAR2V( N, X(1), Y(1), Z(1), INCX, C(1), S(1), INCC )
      END SUBROUTINE SLAR2V_X1C1
 
      SUBROUTINE CLAR2V_X1C1( N, X, Y, Z, INCX, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, N
         REAL(WP), INTENT(IN) :: C(*)
         COMPLEX(WP), INTENT(IN) :: S(*)
         COMPLEX(WP), INTENT(INOUT) :: X(*), Y(*), Z(*)
         CALL CLAR2V( N, X(1), Y(1), Z(1), INCX, C(1), S(1), INCC )
      END SUBROUTINE CLAR2V_X1C1
!
!-----Natural interface for xLARCM
!
      SUBROUTINE CLARCM_A2C2R1( M, N, A, LDA, B, LDB, C, LDC, RWORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB, LDC, M, N
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(IN) :: B(LDB,*), C(LDC,*)
         CALL CLARCM( M, N, A(1,1), LDA, B(1,1), LDB, C(1,1), LDC,
     &                RWORK(1) )
      END SUBROUTINE CLARCM_A2C2R1
!
!-----Natural interface for xLARF
!
      SUBROUTINE SLARF_V1C2W1( SIDE, M, N, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLARF( SIDE, M, N, V(1), INCV, TAU, C(1,1), LDC, WORK(1) )
      END SUBROUTINE SLARF_V1C2W1
 
      SUBROUTINE CLARF_V1C2W1( SIDE, M, N, V, INCV, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLARF( SIDE, M, N, V(1), INCV, TAU, C(1,1), LDC, WORK(1) )
      END SUBROUTINE CLARF_V1C2W1
!
!-----Natural interface for xLARFB
!
      SUBROUTINE SLARFB_V2C2W2( SIDE, TRANS, DIRECT, STOREV, M, N, K, V,
     &                          LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, LDC, LDT, LDV, LDWORK, M, N
         REAL(WP), INTENT(IN) :: T(LDT,*), V(LDV,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL SLARFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, V(1,1), LDV,
     &                T(1,1), LDT, C(1,1), LDC, WORK(1,1), LDWORK )
      END SUBROUTINE SLARFB_V2C2W2
 
      SUBROUTINE CLARFB_V2C2W2( SIDE, TRANS, DIRECT, STOREV, M, N, K, V,
     &                          LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, LDC, LDT, LDV, LDWORK, M, N
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), V(LDV,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL CLARFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, V(1,1), LDV,
     &                T(1,1), LDT, C(1,1), LDC, WORK(1,1), LDWORK )
      END SUBROUTINE CLARFB_V2C2W2
!
!-----Natural interface for xLARFG
!
      SUBROUTINE SLARFG_X1( N, ALPHA, X, INCX, TAU )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: ALPHA
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(INOUT) :: X(*)
         CALL SLARFG( N, ALPHA, X(1), INCX, TAU )
      END SUBROUTINE SLARFG_X1
 
      SUBROUTINE CLARFG_X1( N, ALPHA, X, INCX, TAU )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(INOUT) :: ALPHA
         COMPLEX(WP), INTENT(OUT) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: X(*)
         CALL CLARFG( N, ALPHA, X(1), INCX, TAU )
      END SUBROUTINE CLARFG_X1
!
!-----Natural interface for xLARFT
!
      SUBROUTINE SLARFT_V2U1T2( DIRECT, STOREV, N, K, V, LDV, TAU, T,
     &                          LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         REAL(WP), INTENT(OUT) :: T(LDT,*)
         CALL SLARFT( DIRECT, STOREV, N, K, V(1,1), LDV, TAU(1), T(1,1),
     &                LDT )
      END SUBROUTINE SLARFT_V2U1T2
 
      SUBROUTINE CLARFT_V2U1T2( DIRECT, STOREV, N, K, V, LDV, TAU, T,
     &                          LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         COMPLEX(WP), INTENT(OUT) :: T(LDT,*)
         CALL CLARFT( DIRECT, STOREV, N, K, V(1,1), LDV, TAU(1), T(1,1),
     &                LDT )
      END SUBROUTINE CLARFT_V2U1T2
!
!-----Natural interface for xLARGV
!
      SUBROUTINE SLARGV_X1Y1C1( N, X, INCX, Y, INCY, C, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(INOUT) :: X(*), Y(*)
         REAL(WP), INTENT(OUT) :: C(*)
         CALL SLARGV( N, X(1), INCX, Y(1), INCY, C(1), INCC )
      END SUBROUTINE SLARGV_X1Y1C1
 
      SUBROUTINE CLARGV_X1Y1C1( N, X, INCX, Y, INCY, C, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(OUT) :: C(*)
         COMPLEX(WP), INTENT(INOUT) :: X(*), Y(*)
         CALL CLARGV( N, X(1), INCX, Y(1), INCY, C(1), INCC )
      END SUBROUTINE CLARGV_X1Y1C1
!
!-----Natural interface for xLARNV
!
      SUBROUTINE SLARNV_X1( IDIST, ISEED, N, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIST, N
         INTEGER, INTENT(INOUT) :: ISEED(4)
         REAL(WP), INTENT(OUT) :: X(*)
         CALL SLARNV( IDIST, ISEED, N, X(1) )
      END SUBROUTINE SLARNV_X1
 
      SUBROUTINE CLARNV_X1( IDIST, ISEED, N, X )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IDIST, N
         INTEGER, INTENT(INOUT) :: ISEED(4)
         COMPLEX(WP), INTENT(OUT) :: X(*)
         CALL CLARNV( IDIST, ISEED, N, X(1) )
      END SUBROUTINE CLARNV_X1
!
!-----Natural interface for xLARTV
!
      SUBROUTINE SLARTV_X1Y1C1( N, X, INCX, Y, INCY, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(IN) :: C(*), S(*)
         REAL(WP), INTENT(INOUT) :: X(*), Y(*)
         CALL SLARTV( N, X(1), INCX, Y(1), INCY, C(1), S(1), INCC )
      END SUBROUTINE SLARTV_X1Y1C1
 
      SUBROUTINE CLARTV_X1Y1C1( N, X, INCX, Y, INCY, C, S, INCC )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCC, INCX, INCY, N
         REAL(WP), INTENT(IN) :: C(*)
         COMPLEX(WP), INTENT(IN) :: S(*)
         COMPLEX(WP), INTENT(INOUT) :: X(*), Y(*)
         CALL CLARTV( N, X(1), INCX, Y(1), INCY, C(1), S(1), INCC )
      END SUBROUTINE CLARTV_X1Y1C1
!
!-----Natural interface for xLARZ
!
      SUBROUTINE SLARZ_V1C2W1( SIDE, M, N, L, V, INCV, TAU, C, LDC,
     &                         WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, L, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLARZ( SIDE, M, N, L, V(1), INCV, TAU, C(1,1), LDC,
     &               WORK(1) )
      END SUBROUTINE SLARZ_V1C2W1
 
      SUBROUTINE CLARZ_V1C2W1( SIDE, M, N, L, V, INCV, TAU, C, LDC,
     &                         WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, L, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLARZ( SIDE, M, N, L, V(1), INCV, TAU, C(1,1), LDC,
     &               WORK(1) )
      END SUBROUTINE CLARZ_V1C2W1
!
!-----Natural interface for xLARZB
!
      SUBROUTINE SLARZB_V2T2W2( SIDE, TRANS, DIRECT, STOREV, M, N, K, L,
     &                          V, LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, L, LDC, LDT, LDV, LDWORK, M, N
         REAL(WP), INTENT(IN) :: T(LDT,*), V(LDV,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL SLARZB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V(1,1),
     &                LDV, T(1,1), LDT, C(1,1), LDC, WORK(1,1), LDWORK )
      END SUBROUTINE SLARZB_V2T2W2
 
      SUBROUTINE CLARZB_V2T2W2( SIDE, TRANS, DIRECT, STOREV, M, N, K, L,
     &                          V, LDV, T, LDT, C, LDC, WORK, LDWORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, SIDE, STOREV, TRANS
         INTEGER, INTENT(IN) :: K, L, LDC, LDT, LDV, LDWORK, M, N
         COMPLEX(WP), INTENT(IN) :: T(LDT,*), V(LDV,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(LDWORK,*)
         CALL CLARZB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V(1,1),
     &                LDV, T(1,1), LDT, C(1,1), LDC, WORK(1,1), LDWORK )
      END SUBROUTINE CLARZB_V2T2W2
!
!-----Natural interface for xLARZT
!
      SUBROUTINE SLARZT_V2U1T2( DIRECT, STOREV, N, K, V, LDV, TAU, T,
     &                          LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: V(LDV,*)
         REAL(WP), INTENT(OUT) :: T(LDT,*)
         CALL SLARZT( DIRECT, STOREV, N, K, V(1,1), LDV, TAU(1), T(1,1),
     &                LDT )
      END SUBROUTINE SLARZT_V2U1T2
 
      SUBROUTINE CLARZT_V2U1T2( DIRECT, STOREV, N, K, V, LDV, TAU, T,
     &                          LDT )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, STOREV
         INTEGER, INTENT(IN) :: K, LDT, LDV, N
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
         COMPLEX(WP), INTENT(OUT) :: T(LDT,*)
         CALL CLARZT( DIRECT, STOREV, N, K, V(1,1), LDV, TAU(1), T(1,1),
     &                LDT )
      END SUBROUTINE CLARZT_V2U1T2
!
!-----Natural interface for xLASCL
!
      SUBROUTINE SLASCL_A2( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA,
     &                      INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A(1,1), LDA, INFO)
      END SUBROUTINE SLASCL_A2
 
      SUBROUTINE CLASCL_A2( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA,
     &                      INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A(1,1), LDA, INFO)
      END SUBROUTINE CLASCL_A2
!
!-----Interface for xLASCL with 1-D array
!
      SUBROUTINE SLASCL_A1( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA,
     &                      INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         REAL(WP), INTENT(INOUT) :: A(*)
         CALL SLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A(1), LDA, INFO)
      END SUBROUTINE SLASCL_A1
 
      SUBROUTINE CLASCL_A1( TYPE, KL, KU, CFROM, CTO, M, N, A, LDA,
     &                      INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TYPE
         INTEGER, INTENT(IN) :: KL, KU, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: CFROM, CTO
         COMPLEX(WP), INTENT(INOUT) :: A(*)
         CALL CLASCL( TYPE, KL, KU, CFROM, CTO, M, N, A(1), LDA, INFO)
      END SUBROUTINE CLASCL_A1
!
!-----Natural interface for xLASET
!
      SUBROUTINE SLASET_A2( UPLO, M, N, ALPHA, BETA, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SLASET( UPLO, M, N, ALPHA, BETA, A(1,1), LDA )
      END SUBROUTINE SLASET_A2
 
      SUBROUTINE CLASET_A2( UPLO, M, N, ALPHA, BETA, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, M, N
         COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CLASET( UPLO, M, N, ALPHA, BETA, A(1,1), LDA )
      END SUBROUTINE CLASET_A2
!
!-----Natural interface for xLASR
!
      SUBROUTINE SLASR_C1S1A2( SIDE, PIVOT, DIRECT, M, N, C, S, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, PIVOT, SIDE
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: C(*), S(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SLASR( SIDE, PIVOT, DIRECT, M, N, C(1), S(1), A(1,1), LDA)
      END SUBROUTINE SLASR_C1S1A2
 
      SUBROUTINE CLASR_C1S1A2( SIDE, PIVOT, DIRECT, M, N, C, S, A, LDA )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIRECT, PIVOT, SIDE
         INTEGER, INTENT(IN) :: LDA, M, N
         REAL(WP), INTENT(IN) :: C(*), S(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CLASR( SIDE, PIVOT, DIRECT, M, N, C(1), S(1), A(1,1), LDA)
      END SUBROUTINE CLASR_C1S1A2
!
!-----Natural interface for xLASRT and xLASRT2
!
      SUBROUTINE ILASRT_D1( ID, N, D, INFO )
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: D(*)
         CALL ILASRT( ID, N, D(1), INFO )
      END SUBROUTINE ILASRT_D1
 
      SUBROUTINE ILASRT2_D1K1( ID, N, D, KEY, INFO )
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: D(*), KEY(*)
         CALL ILASRT2( ID, N, D(1), KEY(1), INFO )
      END SUBROUTINE ILASRT2_D1K1
 
      SUBROUTINE SLASRT_D1( ID, N, D, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         REAL(WP), INTENT(INOUT) :: D(*)
         CALL SLASRT( ID, N, D(1), INFO )
      END SUBROUTINE SLASRT_D1
 
      SUBROUTINE SLASRT2_D1K1( ID, N, D, KEY, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: ID
         INTEGER, INTENT(IN) :: INFO, N
         INTEGER, INTENT(INOUT) :: KEY(*)
         REAL(WP), INTENT(INOUT) :: D(*)
         CALL SLASRT2( ID, N, D(1), KEY(1), INFO )
      END SUBROUTINE SLASRT2_D1K1
!
!-----Natural interface for xLASSQ
!
      SUBROUTINE SLASSQ_X1( N, X, INCX, SCL, SUMSQ )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: SCL, SUMSQ
         REAL(WP), INTENT(IN) :: X(*)
         CALL SLASSQ( N, X(1), INCX, SCL, SUMSQ )
      END SUBROUTINE SLASSQ_X1
 
      SUBROUTINE CLASSQ_X1( N, X, INCX, SCL, SUMSQ )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(INOUT) :: SCL, SUMSQ
         COMPLEX(WP), INTENT(IN) :: X(*)
         CALL CLASSQ( N, X(1), INCX, SCL, SUMSQ )
      END SUBROUTINE CLASSQ_X1
!
!-----Natural interface for xLASWP
!
      SUBROUTINE SLASWP_A2I1( N, A, LDA, K1, K2, IPIV, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, K1, K2, LDA, N
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SLASWP( N, A(1,1), LDA, K1, K2, IPIV(1), INCX )
      END SUBROUTINE SLASWP_A2I1
 
      SUBROUTINE CLASWP_A2I1( N, A, LDA, K1, K2, IPIV, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, K1, K2, LDA, N
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CLASWP( N, A(1,1), LDA, K1, K2, IPIV(1), INCX )
      END SUBROUTINE CLASWP_A2I1
!
!-----Natural interface for xLATBS
!
      SUBROUTINE SLATBS_A2X1C1( UPLO, TRANS, DIAG, NORMIN, N, KD, AB,
     &                          LDAB, X, SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: AB(LDAB,*)
         REAL(WP), INTENT(INOUT) :: CNORM(*), X(*)
         CALL SLATBS( UPLO, TRANS, DIAG, NORMIN, N, KD, AB(1,1), LDAB,
     &                X(1), SCALE, CNORM(1), INFO )
      END SUBROUTINE SLATBS_A2X1C1
 
      SUBROUTINE CLATBS_A2X1C1( UPLO, TRANS, DIAG, NORMIN, N, KD, AB,
     &                          LDAB, X, SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: KD, LDAB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM(*)
         COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
         COMPLEX(WP), INTENT(INOUT) :: X(*)
         CALL CLATBS( UPLO, TRANS, DIAG, NORMIN, N, KD, AB(1,1), LDAB,
     &                X(1), SCALE, CNORM(1), INFO )
      END SUBROUTINE CLATBS_A2X1C1
!
!-----Natural interface for xLATPS
!
      SUBROUTINE SLATPS_A1X1C1( UPLO, TRANS, DIAG, NORMIN, N, AP, X,
     &                          SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: CNORM(*), X(*)
         CALL SLATPS( UPLO, TRANS, DIAG, NORMIN, N, AP(1), X(1), SCALE,
     &                CNORM(1), INFO )
      END SUBROUTINE SLATPS_A1X1C1
 
      SUBROUTINE CLATPS_A1X1C1( UPLO, TRANS, DIAG, NORMIN, N, AP, X,
     &                          SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: X(*)
         CALL CLATPS( UPLO, TRANS, DIAG, NORMIN, N, AP(1), X(1), SCALE,
     &                CNORM(1), INFO )
      END SUBROUTINE CLATPS_A1X1C1
!
!-----Natural interface for xLATRS
!
      SUBROUTINE SLATRS_A2X1C1( UPLO, TRANS, DIAG, NORMIN, N, A, LDA, X,
     &                          SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: CNORM(*), X(*)
         CALL SLATRS( UPLO, TRANS, DIAG, NORMIN, N, A(1,1), LDA, X(1),
     &                SCALE, CNORM(1), INFO )
      END SUBROUTINE SLATRS_A2X1C1
 
      SUBROUTINE CLATRS_A2X1C1( UPLO, TRANS, DIAG, NORMIN, N, A, LDA, X,
     &                          SCALE, CNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: DIAG, NORMIN, TRANS, UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(INOUT) :: CNORM(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: X(*)
         CALL CLATRS( UPLO, TRANS, DIAG, NORMIN, N, A(1,1), LDA, X(1),
     &                SCALE, CNORM(1), INFO )
      END SUBROUTINE CLATRS_A2X1C1
!
!-----Natural interface for xRSCL
!
      SUBROUTINE SRSCL_X1( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(IN) :: SA
         REAL(WP), INTENT(INOUT) :: SX( * )
         CALL SRSCL( N, SA, SX(1), INCX )
      END SUBROUTINE SRSCL_X1
 
      SUBROUTINE CRSCL_X1( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         COMPLEX(WP), INTENT(IN) :: SA
         COMPLEX(WP), INTENT(INOUT) :: SX( * )
         CALL CRSCL( N, SA, SX(1), INCX )
      END SUBROUTINE CRSCL_X1
 
      SUBROUTINE CSRSCL_X1( N, SA, SX, INCX )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, N
         REAL(WP), INTENT(IN) :: SA
         COMPLEX(WP), INTENT(INOUT) :: SX( * )
         CALL CSRSCL( N, SA, SX(1), INCX )
      END SUBROUTINE CSRSCL_X1
 
      END MODULE LA_AUXILIARY
