      MODULE LA_XSPTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 24, 2002
!
!  Purpose
!  =======
!
!  LA_XSPTS2 defines a generic interface for xSPTS2.
!
      INTERFACE LA_SPTS2

      SUBROUTINE SSPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SSPTS2

      SUBROUTINE DSPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DSPTS2

      SUBROUTINE CSPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CSPTS2

      SUBROUTINE ZSPTS2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZSPTS2

      MODULE PROCEDURE SSPTS2_A1I1B2
      MODULE PROCEDURE DSPTS2_A1I1B2
      MODULE PROCEDURE CSPTS2_A1I1B2
      MODULE PROCEDURE ZSPTS2_A1I1B2

      MODULE PROCEDURE SSPTS2_A1I1B1
      MODULE PROCEDURE DSPTS2_A1I1B1
      MODULE PROCEDURE CSPTS2_A1I1B1
      MODULE PROCEDURE ZSPTS2_A1I1B1

      END INTERFACE ! LA_SPTS2
      PRIVATE SSPTS2_A1I1B2, DSPTS2_A1I1B2, CSPTS2_A1I1B2, ZSPTS2_A1I1B2
      PRIVATE SSPTS2_A1I1B1, DSPTS2_A1I1B1, CSPTS2_A1I1B1, ZSPTS2_A1I1B1

      CONTAINS

      SUBROUTINE SSPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE SSPTS2_A1I1B2

      SUBROUTINE DSPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE DSPTS2_A1I1B2

      SUBROUTINE CSPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE CSPTS2_A1I1B2

      SUBROUTINE ZSPTS2_A1I1B2( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1,1), LDB)
      END SUBROUTINE ZSPTS2_A1I1B2

      SUBROUTINE SSPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE SSPTS2_A1I1B1

      SUBROUTINE DSPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL DSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE DSPTS2_A1I1B1

      SUBROUTINE CSPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE CSPTS2_A1I1B1

      SUBROUTINE ZSPTS2_A1I1B1( IUPLO, N, NRHS, AP, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL ZSPTS2( IUPLO, N, NRHS, AP(1), IPIV(1), B(1), LDB )
      END SUBROUTINE ZSPTS2_A1I1B1

      END MODULE LA_XSPTS2
