      MODULE LA_XPPTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 17, 2002
!
!  Purpose
!  =======
!
!  LA_XPPTS2 defines a generic interface for xPPTS2.
!
      INTERFACE LA_PPTS2

      SUBROUTINE SPPTS2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPPTS2

      SUBROUTINE DPPTS2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE DPPTS2

      SUBROUTINE CPPTS2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPPTS2

      SUBROUTINE ZPPTS2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE ZPPTS2

      MODULE PROCEDURE SPPTS2_A1B2
      MODULE PROCEDURE DPPTS2_A1B2
      MODULE PROCEDURE CPPTS2_A1B2
      MODULE PROCEDURE ZPPTS2_A1B2

      END INTERFACE ! LA_PPTS2
      PRIVATE SPPTS2_A1B2, DPPTS2_A1B2, CPPTS2_A1B2, ZPPTS2_A1B2

      CONTAINS

      SUBROUTINE SPPTS2_A1B2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPPTS2( IUPLO, N, NRHS, AP(1), B(1,1), LDB )
      END SUBROUTINE SPPTS2_A1B2

      SUBROUTINE DPPTS2_A1B2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: AP(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL DPPTS2( IUPLO, N, NRHS, AP(1), B(1,1), LDB )
      END SUBROUTINE DPPTS2_A1B2

      SUBROUTINE CPPTS2_A1B2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPPTS2( IUPLO, N, NRHS, AP(1), B(1,1), LDB )
      END SUBROUTINE CPPTS2_A1B2

      SUBROUTINE ZPPTS2_A1B2( IUPLO, N, NRHS, AP, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         COMPLEX(WP), INTENT(IN) :: AP(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL ZPPTS2( IUPLO, N, NRHS, AP(1), B(1,1), LDB )
      END SUBROUTINE ZPPTS2_A1B2

      END MODULE LA_XPPTS2
