      MODULE LA_XPBTF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 16, 2002
!
!  Purpose
!  =======
!
!  LA_XPBTF2 defines a generic interface for xPBTF2.
!
      INTERFACE LA_PBTF2

      SUBROUTINE SPBTF2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE SPBTF2

      SUBROUTINE DPBTF2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
      END SUBROUTINE DPBTF2

      SUBROUTINE CPBTF2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE CPBTF2

      SUBROUTINE ZPBTF2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
      END SUBROUTINE ZPBTF2

      MODULE PROCEDURE SPBTF2_A2
      MODULE PROCEDURE DPBTF2_A2
      MODULE PROCEDURE CPBTF2_A2
      MODULE PROCEDURE ZPBTF2_A2

      END INTERFACE ! LA_PBTF2
      PRIVATE SPBTF2_A2, DPBTF2_A2, CPBTF2_A2, ZPBTF2_A2

      CONTAINS

      SUBROUTINE SPBTF2_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL SPBTF2( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE SPBTF2_A2

      SUBROUTINE DPBTF2_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL DPBTF2( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE DPBTF2_A2

      SUBROUTINE CPBTF2_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL CPBTF2( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE CPBTF2_A2

      SUBROUTINE ZPBTF2_A2( UPLO, N, KD, AB, LDAB, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: N, KD, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         CALL ZPBTF2( UPLO, N, KD, AB(1,1), LDAB, INFO )
      END SUBROUTINE ZPBTF2_A2

      END MODULE LA_XPBTF2
