      MODULE LA_XLATDF
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 06, 2002
!
!  Purpose
!  =======
!
!  LA_XLATDF defines generic interfaces for xLATDF.
!
      INTERFACE LA_LATDF

      SUBROUTINE SLATDF( IJOB, N, Z, LDZ, RHS, RDSUM, RDSCAL, IPIV,
     $                   JPIV )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, LDZ, N
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         REAL(WP), INTENT(INOUT) :: RHS(*)
         REAL(WP), INTENT(IN) :: Z(LDZ,*)
      END SUBROUTINE SLATDF

      SUBROUTINE DLATDF( IJOB, N, Z, LDZ, RHS, RDSUM, RDSCAL, IPIV,
     $                   JPIV )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, LDZ, N
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         REAL(WP), INTENT(INOUT) :: RHS(*)
         REAL(WP), INTENT(IN) :: Z(LDZ,*)
      END SUBROUTINE DLATDF

      SUBROUTINE CLATDF( IJOB, N, Z, LDZ, RHS, RDSUM, RDSCAL, IPIV,
     $                   JPIV )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, LDZ, N
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: RHS(*)
         COMPLEX(WP), INTENT(IN) :: Z(LDZ,*)
      END SUBROUTINE CLATDF

      SUBROUTINE ZLATDF( IJOB, N, Z, LDZ, RHS, RDSUM, RDSCAL, IPIV,
     $                   JPIV )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, LDZ, N
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         COMPLEX(WP), INTENT(INOUT) :: RHS(*)
         COMPLEX(WP), INTENT(IN) :: Z(LDZ,*)
      END SUBROUTINE ZLATDF

      END INTERFACE ! LA_LATDF

      END MODULE LA_XLATDF
