      MODULE LA_XLASY2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 04, 2002
!
!  Purpose
!  =======
!
!  LA_XLASY2 defines generic interfaces for xLASY2.
!
      INTERFACE LA_LASY2

      SUBROUTINE SLASY2( LTRANL, LTRANR, ISGN, N1, N2, TL, LDTL, TR,
     $                   LDTR, B, LDB, SCALE, X, LDX, XNORM, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANL, LTRANR
         INTEGER, INTENT(IN) :: ISGN, LDB, LDTL, LDTR, LDX, N1, N2
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: B, TL, TR
         REAL(WP), INTENT(OUT) :: X
      END SUBROUTINE SLASY2

      SUBROUTINE DLASY2( LTRANL, LTRANR, ISGN, N1, N2, TL, LDTL, TR,
     $                   LDTR, B, LDB, SCALE, X, LDX, XNORM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANL, LTRANR
         INTEGER, INTENT(IN) :: ISGN, LDB, LDTL, LDTR, LDX, N1, N2
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: B, TL, TR
         REAL(WP), INTENT(OUT) :: X
      END SUBROUTINE DLASY2

      MODULE PROCEDURE SLASY2_B2T2X2
      MODULE PROCEDURE DLASY2_B2T2X2

      END INTERFACE ! LA_LASY2
      PRIVATE SLASY2_B2T2X2, DLASY2_B2T2X2

      CONTAINS

      SUBROUTINE SLASY2_B2T2X2( LTRANL, LTRANR, ISGN, N1, N2, TL, LDTL,
     $                          TR, LDTR, B, LDB, SCALE, X, LDX, XNORM,
     $                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANL, LTRANR
         INTEGER, INTENT(IN) :: ISGN, LDB, LDTL, LDTR, LDX, N1, N2
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: B(LDB,*), TL(LDTL,*), TR(LDTR,*)
         REAL(WP), INTENT(OUT) :: X(LDX,*)
         CALL SLASY2( LTRANL, LTRANR, ISGN, N1, N2, TL(1,1), LDTL,
     $                TR(1,1), LDTR, B(1,1), LDB, SCALE, X(1,1), LDX,
     $                XNORM, INFO )
      END SUBROUTINE SLASY2_B2T2X2

      SUBROUTINE DLASY2_B2T2X2( LTRANL, LTRANR, ISGN, N1, N2, TL, LDTL,
     $                          TR, LDTR, B, LDB, SCALE, X, LDX, XNORM,
     $                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LTRANL, LTRANR
         INTEGER, INTENT(IN) :: ISGN, LDB, LDTL, LDTR, LDX, N1, N2
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(OUT) :: SCALE, XNORM
         REAL(WP), INTENT(IN) :: B(LDB,*), TL(LDTL,*), TR(LDTR,*)
         REAL(WP), INTENT(OUT) :: X(LDX,*)
         CALL DLASY2( LTRANL, LTRANR, ISGN, N1, N2, TL(1,1), LDTL,
     $                TR(1,1), LDTR, B(1,1), LDB, SCALE, X(1,1), LDX,
     $                XNORM, INFO )
      END SUBROUTINE DLASY2_B2T2X2

      END MODULE LA_XLASY2
