      MODULE LA_XLASDX
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 20, 2002
!
!  Purpose
!  =======
!
!  LA_XLASDX defines generic interfaces for xLASD0 through xLASD9 and
!  xLASDA, xLASDQ, and xLASDT, auxiliary routines used in the
!  divide-and-conquer algorithm for the bidiagonal SVD.
!
      INTERFACE LA_LASD0

      SUBROUTINE SLASD0( N, SQRE, D, E, U, LDU, VT, LDVT, SMLSIZ,
     $                   IWORK, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE SLASD0

      SUBROUTINE DLASD0( N, SQRE, D, E, U, LDU, VT, LDVT, SMLSIZ,
     $                   IWORK, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: U, VT, WORK
      END SUBROUTINE DLASD0

      MODULE PROCEDURE SLASD0_NAT
      MODULE PROCEDURE DLASD0_NAT

      END INTERFACE ! LA_LASD0
      PRIVATE SLASD0_NAT, DLASD0_NAT

      INTERFACE LA_LASD1

      SUBROUTINE SLASD1( NL, NR, SQRE, D, ALPHA, BETA, U, LDU, VT, LDVT,
     $                   IDXQ, IWORK, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(OUT) :: IDXQ, IWORK
         REAL(WP), INTENT(INOUT) :: D, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLASD1

      SUBROUTINE DLASD1( NL, NR, SQRE, D, ALPHA, BETA, U, LDU, VT, LDVT,
     $                   IDXQ, IWORK, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(OUT) :: IDXQ, IWORK
         REAL(WP), INTENT(INOUT) :: D, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLASD1

      MODULE PROCEDURE SLASD1_NAT
      MODULE PROCEDURE DLASD1_NAT

      END INTERFACE ! LA_LASD1
      PRIVATE SLASD1_NAT, DLASD1_NAT

      INTERFACE LA_LASD2

      SUBROUTINE SLASD2( NL, NR, SQRE, K, D, Z, ALPHA, BETA, U, LDU, VT,
     $                   LDVT, DSIGMA, U2, LDU2, VT2, LDVT2, IDXP, IDX,
     $                   IDXC, IDXQ, COLTYP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDU2, LDVT, LDVT2, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(IN) :: IDXQ
         INTEGER, INTENT(OUT) :: COLTYP, IDX, IDXC, IDXP
         REAL(WP), INTENT(INOUT) :: D, U, VT
         REAL(WP), INTENT(OUT) :: DSIGMA, U2, VT2, Z
      END SUBROUTINE SLASD2

      SUBROUTINE DLASD2( NL, NR, SQRE, K, D, Z, ALPHA, BETA, U, LDU, VT,
     $                   LDVT, DSIGMA, U2, LDU2, VT2, LDVT2, IDXP, IDX,
     $                   IDXC, IDXQ, COLTYP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDU2, LDVT, LDVT2, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(IN) :: IDXQ
         INTEGER, INTENT(OUT) :: COLTYP, IDX, IDXC, IDXP
         REAL(WP), INTENT(INOUT) :: D, U, VT
         REAL(WP), INTENT(OUT) :: DSIGMA, U2, VT2, Z
      END SUBROUTINE DLASD2

      MODULE PROCEDURE SLASD2_NAT
      MODULE PROCEDURE DLASD2_NAT

      END INTERFACE ! LA_LASD2
      PRIVATE SLASD2_NAT, DLASD2_NAT

      INTERFACE LA_LASD3

      SUBROUTINE SLASD3( NL, NR, SQRE, K, D, Q, LDQ, DSIGMA, U, LDU, U2,
     $                   LDU2, VT, LDVT, VT2, LDVT2, IDXC, CTOT, Z,
     $                   INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, LDU, LDU2, LDVT, LDVT2, NL, NR,
     $                          SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: CTOT, IDXC
         REAL(WP), INTENT(IN) :: DSIGMA, U, U2, VT, VT2, Z
         REAL(WP), INTENT(OUT) :: D, Q
      END SUBROUTINE SLASD3

      SUBROUTINE DLASD3( NL, NR, SQRE, K, D, Q, LDQ, DSIGMA, U, LDU, U2,
     $                   LDU2, VT, LDVT, VT2, LDVT2, IDXC, CTOT, Z,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, LDU, LDU2, LDVT, LDVT2, NL, NR,
     $                          SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: CTOT, IDXC
         REAL(WP), INTENT(IN) :: DSIGMA, U, U2, VT, VT2, Z
         REAL(WP), INTENT(OUT) :: D, Q
      END SUBROUTINE DLASD3

      MODULE PROCEDURE SLASD3_NAT
      MODULE PROCEDURE DLASD3_NAT

      END INTERFACE ! LA_LASD3
      PRIVATE SLASD3_NAT, DLASD3_NAT

      INTERFACE LA_LASD4

      SUBROUTINE SLASD4( N, I, D, Z, DELTA, RHO, SIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D, Z
         REAL(WP), INTENT(OUT) :: DELTA, WORK
      END SUBROUTINE SLASD4

      SUBROUTINE DLASD4( N, I, D, Z, DELTA, RHO, SIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D, Z
         REAL(WP), INTENT(OUT) :: DELTA, WORK
      END SUBROUTINE DLASD4

      MODULE PROCEDURE SLASD4_NAT
      MODULE PROCEDURE DLASD4_NAT

      END INTERFACE ! LA_LASD4
      PRIVATE SLASD4_NAT, DLASD4_NAT

      INTERFACE LA_LASD5

      SUBROUTINE SLASD5( I, D, Z, DELTA, RHO, SIGMA, WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: I
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) ::DELTA(*), WORK(*)
      END SUBROUTINE SLASD5

      SUBROUTINE DLASD5( I, D, Z, DELTA, RHO, SIGMA, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) ::DELTA(*), WORK(*)
      END SUBROUTINE DLASD5

      END INTERFACE ! LA_LASD5

      INTERFACE LA_LASD6

      SUBROUTINE SLASD6( ICOMPQ, NL, NR, SQRE, D, VF, VL, ALPHA, BETA,
     $                   IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                   LDGNUM, POLES, DIFL, DIFR, Z, K, C, S, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(OUT) :: GIVCOL, IDXQ, IWORK, PERM
         REAL(WP), INTENT(INOUT) :: D, VF, VL
         REAL(WP), INTENT(OUT) :: DIFL, DIFR, GIVNUM, POLES, WORK, Z
      END SUBROUTINE SLASD6

      SUBROUTINE DLASD6( ICOMPQ, NL, NR, SQRE, D, VF, VL, ALPHA, BETA,
     $                   IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                   LDGNUM, POLES, DIFL, DIFR, Z, K, C, S, WORK,
     $                   IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(OUT) :: GIVCOL, IDXQ, IWORK, PERM
         REAL(WP), INTENT(INOUT) :: D, VF, VL
         REAL(WP), INTENT(OUT) :: DIFL, DIFR, GIVNUM, POLES, WORK, Z
      END SUBROUTINE DLASD6

      MODULE PROCEDURE SLASD6_NAT
      MODULE PROCEDURE DLASD6_NAT

      END INTERFACE ! LA_LASD6
      PRIVATE SLASD6_NAT, DLASD6_NAT

      INTERFACE LA_LASD7

      SUBROUTINE SLASD7( ICOMPQ, NL, NR, SQRE, K, D, Z, ZW, VF, VFW, VL,
     $                   VLW, ALPHA, BETA, DSIGMA, IDX, IDXP, IDXQ,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   C, S, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(IN) :: IDXQ
         INTEGER, INTENT(OUT) :: GIVCOL, IDX, IDXP, PERM
         REAL(WP), INTENT(INOUT) :: D, VF, VL
         REAL(WP), INTENT(OUT) :: DSIGMA, GIVNUM, VFW, VLW, Z, ZW
      END SUBROUTINE SLASD7

      SUBROUTINE DLASD7( ICOMPQ, NL, NR, SQRE, K, D, Z, ZW, VF, VFW, VL,
     $                   VLW, ALPHA, BETA, DSIGMA, IDX, IDXP, IDXQ,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   C, S, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(IN) :: IDXQ
         INTEGER, INTENT(OUT) :: GIVCOL, IDX, IDXP, PERM
         REAL(WP), INTENT(INOUT) :: D, VF, VL
         REAL(WP), INTENT(OUT) :: DSIGMA, GIVNUM, VFW, VLW, Z, ZW
      END SUBROUTINE DLASD7

      MODULE PROCEDURE SLASD7_NAT
      MODULE PROCEDURE DLASD7_NAT

      END INTERFACE ! LA_LASD7
      PRIVATE SLASD7_NAT, DLASD7_NAT

      INTERFACE LA_LASD8

      SUBROUTINE SLASD8( ICOMPQ, K, D, Z, VF, VL, DIFL, DIFR, LDDIFR,
     $                   DSIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDDIFR
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA, Z
         REAL(WP), INTENT(INOUT) :: VF, VL
         REAL(WP), INTENT(OUT) :: D, DIFL, DIFR, WORK
      END SUBROUTINE SLASD8

      SUBROUTINE DLASD8( ICOMPQ, K, D, Z, VF, VL, DIFL, DIFR, LDDIFR,
     $                   DSIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDDIFR
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA, Z
         REAL(WP), INTENT(INOUT) :: VF, VL
         REAL(WP), INTENT(OUT) :: D, DIFL, DIFR, WORK
      END SUBROUTINE DLASD8

      MODULE PROCEDURE SLASD8_NAT
      MODULE PROCEDURE DLASD8_NAT

      END INTERFACE ! LA_LASD8
      PRIVATE SLASD8_NAT, DLASD8_NAT

      INTERFACE LA_LASD9

      SUBROUTINE SLASD9( ICOMPQ, LDU, K, D, Z, VF, VL, DIFL, DIFR,
     $                   DSIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA, Z
         REAL(WP), INTENT(INOUT) :: VF, VL
         REAL(WP), INTENT(OUT) :: D, DIFL, DIFR, WORK
      END SUBROUTINE SLASD9

      SUBROUTINE DLASD9( ICOMPQ, LDU, K, D, Z, VF, VL, DIFL, DIFR,
     $                   DSIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA, Z
         REAL(WP), INTENT(INOUT) :: VF, VL
         REAL(WP), INTENT(OUT) :: D, DIFL, DIFR, WORK
      END SUBROUTINE DLASD9

      MODULE PROCEDURE SLASD9_NAT
      MODULE PROCEDURE DLASD9_NAT

      END INTERFACE ! LA_LASD9
      PRIVATE SLASD9_NAT, DLASD9_NAT

      INTERFACE LA_LASDA

      SUBROUTINE SLASDA( ICOMPQ, SMLSIZ, N, SQRE, D, E, U, LDU, VT, K,
     $                   DIFL, DIFR, Z, POLES, GIVPTR, GIVCOL, LDGCOL,
     $                   PERM, GIVNUM, C, S, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDU, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: GIVCOL, GIVPTR, IWORK, K, PERM
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: C, DIFL, DIFR, GIVNUM, POLES, S,
     $                            U, VT, WORK, Z
      END SUBROUTINE SLASDA

      SUBROUTINE DLASDA( ICOMPQ, SMLSIZ, N, SQRE, D, E, U, LDU, VT, K,
     $                   DIFL, DIFR, Z, POLES, GIVPTR, GIVCOL, LDGCOL,
     $                   PERM, GIVNUM, C, S, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDU, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: GIVCOL, GIVPTR, IWORK, K, PERM
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: C, DIFL, DIFR, GIVNUM, POLES, S,
     $                            U, VT, WORK, Z
      END SUBROUTINE DLASDA

      MODULE PROCEDURE SLASDA_NAT
      MODULE PROCEDURE DLASDA_NAT

      END INTERFACE ! LA_LASDA
      PRIVATE SLASDA_NAT, DLASDA_NAT

      INTERFACE LA_LASDQ

      SUBROUTINE SLASDQ( UPLO, SQRE, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     $                   U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C, D, E, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLASDQ

      SUBROUTINE DLASDQ( UPLO, SQRE, N, NCVT, NRU, NCC, D, E, VT, LDVT,
     $                   U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C, D, E, U, VT
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLASDQ

      MODULE PROCEDURE SLASDQ_NAT
      MODULE PROCEDURE DLASDQ_NAT

      END INTERFACE ! LA_LASDQ
      PRIVATE SLASDQ_NAT, DLASDQ_NAT

      INTERFACE LA_LASDT

      SUBROUTINE DLASDT( N, LVL, ND, INODE, NDIML, NDIMR, MSUB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: MSUB, N
         INTEGER, INTENT(OUT) :: LVL, ND
         INTEGER, INTENT(OUT) :: INODE, NDIML, NDIMR
      END SUBROUTINE DLASDT

      MODULE PROCEDURE DLASDT_NAT

      END INTERFACE ! LA_LASDT
      PRIVATE DLASDT_NAT

      CONTAINS

      SUBROUTINE SLASD0_NAT( N, SQRE, D, E, U, LDU, VT, LDVT, SMLSIZ,
     $                       IWORK, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL SLASD0( N, SQRE, D(1), E(1), U(1,1), LDU, VT(1,1), LDVT,
     $                SMLSIZ, IWORK(1), WORK(1), INFO )
      END SUBROUTINE SLASD0_NAT

      SUBROUTINE DLASD0_NAT( N, SQRE, D, E, U, LDU, VT, LDVT, SMLSIZ,
     $                       IWORK, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: U(LDU,*), VT(LDVT,*), WORK(*)
         CALL DLASD0( N, SQRE, D(1), E(1), U(1,1), LDU, VT(1,1), LDVT,
     $                SMLSIZ, IWORK(1), WORK(1), INFO )
      END SUBROUTINE DLASD0_NAT

      SUBROUTINE SLASD1_NAT( NL, NR, SQRE, D, ALPHA, BETA, U, LDU,
     $                       VT, LDVT, IDXQ, IWORK, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(OUT) :: IDXQ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLASD1( NL, NR, SQRE, D(1), ALPHA, BETA, U(1,1), LDU,
     $                VT(1,1), LDVT, IDXQ(1), IWORK(1), WORK(1), INFO )
      END SUBROUTINE SLASD1_NAT

      SUBROUTINE DLASD1_NAT( NL, NR, SQRE, D, ALPHA, BETA, U, LDU,
     $                       VT, LDVT, IDXQ, IWORK, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDVT, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(OUT) :: IDXQ(*), IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLASD1( NL, NR, SQRE, D(1), ALPHA, BETA, U(1,1), LDU,
     $                VT(1,1), LDVT, IDXQ(1), IWORK(1), WORK(1), INFO )
      END SUBROUTINE DLASD1_NAT

      SUBROUTINE SLASD2_NAT( NL, NR, SQRE, K, D, Z, ALPHA, BETA, U, LDU,
     $                       VT, LDVT, DSIGMA, U2, LDU2, VT2, LDVT2,
     $                       IDXP, IDX, IDXC, IDXQ, COLTYP, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDU2, LDVT, LDVT2, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(IN) :: IDXQ(*)
         INTEGER, INTENT(OUT) :: COLTYP(*), IDX(*), IDXC(*), IDXP(*)
         REAL(WP), INTENT(INOUT) :: D(*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: DSIGMA(*), U2(LDU2,*), VT2(LDVT2,*),
     $                            Z(*)
         CALL SLASD2( NL, NR, SQRE, K, D(1), Z(1), ALPHA, BETA, U(1,1),
     $                LDU, VT(1,1), LDVT, DSIGMA(1), U2(1,1), LDU2,
     $                VT2(1,1), LDVT2, IDXP(1), IDX(1), IDXC(1),
     $                IDXQ(1), COLTYP(1), INFO )
      END SUBROUTINE SLASD2_NAT

      SUBROUTINE DLASD2_NAT( NL, NR, SQRE, K, D, Z, ALPHA, BETA, U, LDU,
     $                       VT, LDVT, DSIGMA, U2, LDU2, VT2, LDVT2,
     $                       IDXP, IDX, IDXC, IDXQ, COLTYP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDU, LDU2, LDVT, LDVT2, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         INTEGER, INTENT(IN) :: IDXQ(*)
         INTEGER, INTENT(OUT) :: COLTYP(*), IDX(*), IDXC(*), IDXP(*)
         REAL(WP), INTENT(INOUT) :: D(*), U(LDU,*), VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: DSIGMA(*), U2(LDU2,*), VT2(LDVT2,*),
     $                            Z(*)
         CALL DLASD2( NL, NR, SQRE, K, D(1), Z(1), ALPHA, BETA, U(1,1),
     $                LDU, VT(1,1), LDVT, DSIGMA(1), U2(1,1), LDU2,
     $                VT2(1,1), LDVT2, IDXP(1), IDX(1), IDXC(1),
     $                IDXQ(1), COLTYP(1), INFO )
      END SUBROUTINE DLASD2_NAT

      SUBROUTINE SLASD3_NAT( NL, NR, SQRE, K, D, Q, LDQ, DSIGMA, U, LDU,
     $                       U2, LDU2, VT, LDVT, VT2, LDVT2, IDXC, CTOT,
     $                       Z, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, LDU, LDU2, LDVT, LDVT2, NL, NR,
     $                          SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: CTOT(*), IDXC(*)
         REAL(WP), INTENT(IN) :: DSIGMA(*), U(LDU,*), U2(LDU2,*),
     $                           VT(LDVT,*), VT2(LDVT2,*), Z(*)
         REAL(WP), INTENT(OUT) :: D(*), Q(LDQ,*)
         CALL SLASD3( NL, NR, SQRE, K, D(1), Q(1,1), LDQ, DSIGMA(1),
     $                U(1,1), LDU, U2(1,1), LDU2, VT(1,1), LDVT,
     $                VT2(1,1), LDVT2, IDXC(1), CTOT(1), Z(1), INFO )
      END SUBROUTINE SLASD3_NAT

      SUBROUTINE DLASD3_NAT( NL, NR, SQRE, K, D, Q, LDQ, DSIGMA, U, LDU,
     $                       U2, LDU2, VT, LDVT, VT2, LDVT2, IDXC, CTOT,
     $                       Z, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, LDU, LDU2, LDVT, LDVT2, NL, NR,
     $                          SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: CTOT(*), IDXC(*)
         REAL(WP), INTENT(IN) :: DSIGMA(*), U(LDU,*), U2(LDU2,*),
     $                           VT(LDVT,*), VT2(LDVT2,*), Z(*)
         REAL(WP), INTENT(OUT) :: D(*), Q(LDQ,*)
         CALL DLASD3( NL, NR, SQRE, K, D(1), Q(1,1), LDQ, DSIGMA(1),
     $                U(1,1), LDU, U2(1,1), LDU2, VT(1,1), LDVT,
     $                VT2(1,1), LDVT2, IDXC(1), CTOT(1), Z(1), INFO )
      END SUBROUTINE DLASD3_NAT

      SUBROUTINE SLASD4_NAT( N, I, D, Z, DELTA, RHO, SIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) :: DELTA(*), WORK(*)
         CALL SLASD4( N, I, D(1), Z(1), DELTA(1), RHO, SIGMA, WORK(1),
     $                INFO )
      END SUBROUTINE SLASD4_NAT

      SUBROUTINE DLASD4_NAT( N, I, D, Z, DELTA, RHO, SIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: SIGMA
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) :: DELTA(*), WORK(*)
         CALL DLASD4( N, I, D(1), Z(1), DELTA(1), RHO, SIGMA, WORK(1),
     $                INFO )
      END SUBROUTINE DLASD4_NAT

      SUBROUTINE SLASD6_NAT( ICOMPQ, NL, NR, SQRE, D, VF, VL, ALPHA,
     $                       BETA, IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL,
     $                       GIVNUM, LDGNUM, POLES, DIFL, DIFR, Z, K,
     $                       C, S, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), IDXQ(*), IWORK(*),
     $                           PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: DIFL(*), DIFR(*), GIVNUM(LDGNUM,*),
     $                            POLES(LDGNUM,*), WORK(*), Z(*)
         CALL SLASD6( ICOMPQ, NL, NR, SQRE, D(1), VF(1), VL(1), ALPHA,
     $                BETA, IDXQ(1), PERM(1), GIVPTR, GIVCOL(1,1),
     $                LDGCOL, GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1), Z(1), K, C, S, WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLASD6_NAT

      SUBROUTINE DLASD6_NAT( ICOMPQ, NL, NR, SQRE, D, VF, VL, ALPHA,
     $                       BETA, IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL,
     $                       GIVNUM, LDGNUM, POLES, DIFL, DIFR, Z, K,
     $                       C, S, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), IDXQ(*), IWORK(*),
     $                           PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: DIFL(*), DIFR(*), GIVNUM(LDGNUM,*),
     $                            POLES(LDGNUM,*), WORK(*), Z(*)
         CALL DLASD6( ICOMPQ, NL, NR, SQRE, D(1), VF(1), VL(1), ALPHA,
     $                BETA, IDXQ(1), PERM(1), GIVPTR, GIVCOL(1,1),
     $                LDGCOL, GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1), Z(1), K, C, S, WORK(1), IWORK(1), INFO )
      END SUBROUTINE DLASD6_NAT

      SUBROUTINE SLASD7_NAT( ICOMPQ, NL, NR, SQRE, K, D, Z, ZW, VF, VFW,
     $                       VL, VLW, ALPHA, BETA, DSIGMA, IDX, IDXP,
     $                       IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, C, S, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(IN) :: IDXQ(*)
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), IDX(*), IDXP(*),
     $                           PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: DSIGMA(*), GIVNUM(LDGNUM,*), VFW(*),
     $                            VLW(*), Z(*), ZW(*)
         CALL SLASD7( ICOMPQ, NL, NR, SQRE, K, D(1), Z(1), ZW(1), VF(1),
     $                VFW(1), VL(1), VLW(1), ALPHA, BETA, DSIGMA(1),
     $                IDX(1), IDXP(1), IDXQ(1), PERM(1), GIVPTR,
     $                GIVCOL(1,1), LDGCOL, GIVNUM(1,1), LDGNUM, C, S,
     $                INFO )
      END SUBROUTINE SLASD7_NAT

      SUBROUTINE DLASD7_NAT( ICOMPQ, NL, NR, SQRE, K, D, Z, ZW, VF, VFW,
     $                       VL, VLW, ALPHA, BETA, DSIGMA, IDX, IDXP,
     $                       IDXQ, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, C, S, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDGNUM, NL, NR, SQRE
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(OUT) :: C, S
         INTEGER, INTENT(IN) :: IDXQ(*)
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), IDX(*), IDXP(*),
     $                           PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: DSIGMA(*), GIVNUM(LDGNUM,*), VFW(*),
     $                            VLW(*), Z(*), ZW(*)
         CALL DLASD7( ICOMPQ, NL, NR, SQRE, K, D(1), Z(1), ZW(1), VF(1),
     $                VFW(1), VL(1), VLW(1), ALPHA, BETA, DSIGMA(1),
     $                IDX(1), IDXP(1), IDXQ(1), PERM(1), GIVPTR,
     $                GIVCOL(1,1), LDGCOL, GIVNUM(1,1), LDGNUM, C, S,
     $                INFO )
      END SUBROUTINE DLASD7_NAT

      SUBROUTINE SLASD8_NAT( ICOMPQ, K, D, Z, VF, VL, DIFL, DIFR,
     $                       LDDIFR, DSIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDDIFR
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA(*), Z(*)
         REAL(WP), INTENT(INOUT) :: VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: D(*), DIFL(*), DIFR(LDDIFR,*), WORK(*)
         CALL SLASD8( ICOMPQ, K, D(1), Z(1), VF(1), VL(1), DIFL(1),
     $                DIFR(1,1), LDDIFR, DSIGMA(1), WORK(1), INFO )
      END SUBROUTINE SLASD8_NAT

      SUBROUTINE DLASD8_NAT( ICOMPQ, K, D, Z, VF, VL, DIFL, DIFR,
     $                       LDDIFR, DSIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDDIFR
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA(*), Z(*)
         REAL(WP), INTENT(INOUT) :: VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: D(*), DIFL(*), DIFR(LDDIFR,*), WORK(*)
         CALL DLASD8( ICOMPQ, K, D(1), Z(1), VF(1), VL(1), DIFL(1),
     $                DIFR(1,1), LDDIFR, DSIGMA(1), WORK(1), INFO )
      END SUBROUTINE DLASD8_NAT

      SUBROUTINE SLASD9_NAT( ICOMPQ, LDU, K, D, Z, VF, VL, DIFL, DIFR,
     $                       DSIGMA, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA(*), Z(*)
         REAL(WP), INTENT(INOUT) :: VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: D(*), DIFL(*), DIFR(LDU,*), WORK(*)
         CALL SLASD9( ICOMPQ, LDU, K, D(1), Z(1), VF(1), VL(1), DIFL(1),
     $                DIFR(1,1), DSIGMA(1), WORK(1), INFO )
      END SUBROUTINE SLASD9_NAT

      SUBROUTINE DLASD9_NAT( ICOMPQ, LDU, K, D, Z, VF, VL, DIFL, DIFR,
     $                       DSIGMA, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, K, LDU
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: DSIGMA(*), Z(*)
         REAL(WP), INTENT(INOUT) :: VF(*), VL(*)
         REAL(WP), INTENT(OUT) :: D(*), DIFL(*), DIFR(LDU,*), WORK(*)
         CALL DLASD9( ICOMPQ, LDU, K, D(1), Z(1), VF(1), VL(1), DIFL(1),
     $                DIFR(1,1), DSIGMA(1), WORK(1), INFO )
      END SUBROUTINE DLASD9_NAT

      SUBROUTINE SLASDA_NAT( ICOMPQ, SMLSIZ, N, SQRE, D, E, U, LDU, VT,
     $                       K, DIFL, DIFR, Z, POLES, GIVPTR, GIVCOL,
     $                       LDGCOL, PERM, GIVNUM, C, S, WORK, IWORK,
     $                       INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDU, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), GIVPTR(*), IWORK(*),
     $                           K(*), PERM(LDGCOL,*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: C(*), DIFL(LDU,*), DIFR(LDU,*),
     $                            GIVNUM(LDU,*), POLES(LDU,*), S(*),
     $                            U(LDU,*), VT(LDU,*), WORK(*), Z(LDU,*)
         CALL SLASDA( ICOMPQ, SMLSIZ, N, SQRE, D(1), E(1), U(1,1), LDU,
     $                VT(1,1), K(1), DIFL(1,1), DIFR(1,1), Z(1,1),
     $                POLES(1,1), GIVPTR(1), GIVCOL(1,1), LDGCOL,
     $                PERM(1,1), GIVNUM(1,1), C(1), S(1), WORK(1),
     $                IWORK(1), INFO )
      END SUBROUTINE SLASDA_NAT

      SUBROUTINE DLASDA_NAT( ICOMPQ, SMLSIZ, N, SQRE, D, E, U, LDU, VT,
     $                       K, DIFL, DIFR, Z, POLES, GIVPTR, GIVCOL,
     $                       LDGCOL, PERM, GIVNUM, C, S, WORK, IWORK,
     $                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDGCOL, LDU, N, SMLSIZ, SQRE
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: GIVCOL(LDGCOL,*), GIVPTR(*), IWORK(*),
     $                           K(*), PERM(LDGCOL,*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: C(*), DIFL(LDU,*), DIFR(LDU,*),
     $                            GIVNUM(LDU,*), POLES(LDU,*), S(*),
     $                            U(LDU,*), VT(LDU,*), WORK(*), Z(LDU,*)
         CALL DLASDA( ICOMPQ, SMLSIZ, N, SQRE, D(1), E(1), U(1,1), LDU,
     $                VT(1,1), K(1), DIFL(1,1), DIFR(1,1), Z(1,1),
     $                POLES(1,1), GIVPTR(1), GIVCOL(1,1), LDGCOL,
     $                PERM(1,1), GIVNUM(1,1), C(1), S(1), WORK(1),
     $                IWORK(1), INFO )
      END SUBROUTINE DLASDA_NAT

      SUBROUTINE SLASDQ_NAT( UPLO, SQRE, N, NCVT, NRU, NCC, D, E,
     $                       VT, LDVT, U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C(LDC,*), D(*), E(*), U(LDU,*),
     $                              VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLASDQ( UPLO, SQRE, N, NCVT, NRU, NCC, D(1), E(1),
     $                VT(1,1), LDVT, U(1,1), LDU, C(1,1), LDC, WORK(1),
     $                INFO )
      END SUBROUTINE SLASDQ_NAT

      SUBROUTINE DLASDQ_NAT( UPLO, SQRE, N, NCVT, NRU, NCC, D, E,
     $                       VT, LDVT, U, LDU, C, LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDC, LDU, LDVT, N, NCC, NCVT, NRU, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: C(LDC,*), D(*), E(*), U(LDU,*),
     $                              VT(LDVT,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLASDQ( UPLO, SQRE, N, NCVT, NRU, NCC, D(1), E(1),
     $                VT(1,1), LDVT, U(1,1), LDU, C(1,1), LDC, WORK(1),
     $                INFO )
      END SUBROUTINE DLASDQ_NAT

      SUBROUTINE DLASDT_NAT( N, LVL, ND, INODE, NDIML, NDIMR, MSUB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: MSUB, N
         INTEGER, INTENT(OUT) :: LVL, ND
         INTEGER, INTENT(OUT) :: INODE(*), NDIML(*), NDIMR(*)
         CALL DLASDT( N, LVL, ND, INODE(1), NDIML(1), NDIMR(1), MSUB )
      END SUBROUTINE DLASDT_NAT

      END MODULE LA_XLASDX
