      MODULE LA_XLAQP2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 9, 2002
!
!  Purpose
!  =======
!
!  LA_XLAQP2 defines generic interfaces for xLAQP2 and xLAQPS.
!
      INTERFACE LA_LAQP2

      SUBROUTINE SLAQP2( M, N, OFFSET, A, LDA, JPVT, TAU, VN1, VN2,
     $                   WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, VN1, VN2
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SLAQP2

      SUBROUTINE DLAQP2( M, N, OFFSET, A, LDA, JPVT, TAU, VN1, VN2,
     $                   WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, VN1, VN2
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DLAQP2

      SUBROUTINE CLAQP2( M, N, OFFSET, A, LDA, JPVT, TAU, VN1, VN2,
     $                   WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: VN1, VN2
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CLAQP2

      SUBROUTINE ZLAQP2( M, N, OFFSET, A, LDA, JPVT, TAU, VN1, VN2,
     $                   WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: VN1, VN2
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZLAQP2

      MODULE PROCEDURE SLAQP2_A2V1W1
      MODULE PROCEDURE DLAQP2_A2V1W1
      MODULE PROCEDURE CLAQP2_A2V1W1
      MODULE PROCEDURE ZLAQP2_A2V1W1

      END INTERFACE ! LA_LAQP2
      PRIVATE SLAQP2_A2V1W1, DLAQP2_A2V1W1, CLAQP2_A2V1W1, ZLAQP2_A2V1W1

      INTERFACE LA_LAQPS

      SUBROUTINE SLAQPS( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU, VN1,
     $                   VN2, AUXV, F, LDF )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, AUXV, F, VN1, VN2
         REAL(WP), INTENT(OUT) :: TAU
      END SUBROUTINE SLAQPS

      SUBROUTINE DLAQPS( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU, VN1,
     $                   VN2, AUXV, F, LDF )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: A, AUXV, F, VN1, VN2
         REAL(WP), INTENT(OUT) :: TAU
      END SUBROUTINE DLAQPS

      SUBROUTINE CLAQPS( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU, VN1,
     $                   VN2, AUXV, F, LDF )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: VN1, VN2
         COMPLEX(WP), INTENT(INOUT) :: A, AUXV, F
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE CLAQPS

      SUBROUTINE ZLAQPS( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU, VN1,
     $                   VN2, AUXV, F, LDF )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT
         REAL(WP), INTENT(INOUT) :: VN1, VN2
         COMPLEX(WP), INTENT(INOUT) :: A, AUXV, F
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE ZLAQPS

      MODULE PROCEDURE SLAQPS_A2V1F2
      MODULE PROCEDURE DLAQPS_A2V1F2
      MODULE PROCEDURE CLAQPS_A2V1F2
      MODULE PROCEDURE ZLAQPS_A2V1F2

      END INTERFACE ! LA_LAQPS
      PRIVATE SLAQPS_A2V1F2, DLAQPS_A2V1F2, CLAQPS_A2V1F2, ZLAQPS_A2V1F2

      CONTAINS
!
!-----Natural interface for xLAQP2
!
      SUBROUTINE SLAQP2_A2V1W1( M, N, OFFSET, A, LDA, JPVT, TAU, VN1,
     $                          VN2, WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), VN1(*), VN2(*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SLAQP2( M, N, OFFSET, A(1,1), LDA, JPVT(1), TAU(1),
     $                VN1(1), VN2(1), WORK(1) )
      END SUBROUTINE SLAQP2_A2V1W1

      SUBROUTINE DLAQP2_A2V1W1( M, N, OFFSET, A, LDA, JPVT, TAU, VN1,
     $                          VN2, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), VN1(*), VN2(*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DLAQP2( M, N, OFFSET, A(1,1), LDA, JPVT(1), TAU(1),
     $                VN1(1), VN2(1), WORK(1) )
      END SUBROUTINE DLAQP2_A2V1W1

      SUBROUTINE CLAQP2_A2V1W1( M, N, OFFSET, A, LDA, JPVT, TAU, VN1,
     $                          VN2, WORK )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: VN1(*), VN2(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CLAQP2( M, N, OFFSET, A(1,1), LDA, JPVT(1), TAU(1),
     $                VN1(1), VN2(1), WORK(1) )
      END SUBROUTINE CLAQP2_A2V1W1

      SUBROUTINE ZLAQP2_A2V1W1( M, N, OFFSET, A, LDA, JPVT, TAU, VN1,
     $                          VN2, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N, OFFSET
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: VN1(*), VN2(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZLAQP2( M, N, OFFSET, A(1,1), LDA, JPVT(1), TAU(1),
     $                VN1(1), VN2(1), WORK(1) )
      END SUBROUTINE ZLAQP2_A2V1W1
!
!-----Natural interface for xLAQPS
!
      SUBROUTINE SLAQPS_A2V1F2( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU,
     $                          VN1, VN2, AUXV, F, LDF )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AUXV(*), F(LDF,*), VN1(*),
     $                              VN2(*)
         REAL(WP), INTENT(OUT) :: TAU(*)
         CALL SLAQPS( M, N, OFFSET, NB, KB, A(1,1), LDA, JPVT(1),
     $                TAU(1), VN1(1), VN2(1), AUXV(1), F(1,1), LDF )
      END SUBROUTINE SLAQPS_A2V1F2

      SUBROUTINE DLAQPS_A2V1F2( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU,
     $                          VN1, VN2, AUXV, F, LDF )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*), AUXV(*), F(LDF,*), VN1(*),
     $                              VN2(*)
         REAL(WP), INTENT(OUT) :: TAU(*)
         CALL DLAQPS( M, N, OFFSET, NB, KB, A(1,1), LDA, JPVT(1),
     $                TAU(1), VN1(1), VN2(1), AUXV(1), F(1,1), LDF )
      END SUBROUTINE DLAQPS_A2V1F2

      SUBROUTINE CLAQPS_A2V1F2( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU,
     $                          VN1, VN2, AUXV, F, LDF )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: VN1(*), VN2(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AUXV(*), F(LDF,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL CLAQPS( M, N, OFFSET, NB, KB, A(1,1), LDA, JPVT(1),
     $                TAU(1), VN1(1), VN2(1), AUXV(1), F(1,1), LDF )
      END SUBROUTINE CLAQPS_A2V1F2

      SUBROUTINE ZLAQPS_A2V1F2( M, N, OFFSET, NB, KB, A, LDA, JPVT, TAU,
     $                          VN1, VN2, AUXV, F, LDF )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDF, M, N, NB, OFFSET
         INTEGER, INTENT(OUT) :: KB
         INTEGER, INTENT(INOUT) :: JPVT(*)
         REAL(WP), INTENT(INOUT) :: VN1(*), VN2(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*), AUXV(*), F(LDF,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL ZLAQPS( M, N, OFFSET, NB, KB, A(1,1), LDA, JPVT(1),
     $                TAU(1), VN1(1), VN2(1), AUXV(1), F(1,1), LDF )
      END SUBROUTINE ZLAQPS_A2V1F2

      END MODULE LA_XLAQP2
