      MODULE LA_XLALS0
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 18, 2002
!
!  Purpose
!  =======
!
!  LA_XLALS0 defines generic interfaces for xLALS0.
!
      INTERFACE LA_LALS0

      SUBROUTINE SLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX, LDBX,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   POLES, DIFL, DIFR, Z, K, C, S, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL, PERM
         REAL(WP), INTENT(IN) :: DIFL, DIFR, GIVNUM, POLES, Z
         REAL(WP), INTENT(INOUT) :: B
         REAL(WP), INTENT(OUT) :: BX, WORK
      END SUBROUTINE SLALS0

      SUBROUTINE DLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX, LDBX,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   POLES, DIFL, DIFR, Z, K, C, S, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL, PERM
         REAL(WP), INTENT(IN) :: DIFL, DIFR, GIVNUM, POLES, Z
         REAL(WP), INTENT(INOUT) :: B
         REAL(WP), INTENT(OUT) :: BX, WORK
      END SUBROUTINE DLALS0

      SUBROUTINE CLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX, LDBX,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   POLES, DIFL, DIFR, Z, K, C, S, RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL, PERM
         REAL(WP), INTENT(IN) :: DIFL, DIFR, GIVNUM, POLES, Z
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: B
         COMPLEX(WP), INTENT(OUT) :: BX
      END SUBROUTINE CLALS0

      SUBROUTINE ZLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX, LDBX,
     $                   PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM, LDGNUM,
     $                   POLES, DIFL, DIFR, Z, K, C, S, RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL, PERM
         REAL(WP), INTENT(IN) :: DIFL, DIFR, GIVNUM, POLES, Z
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: B
         COMPLEX(WP), INTENT(OUT) :: BX
      END SUBROUTINE ZLALS0

      MODULE PROCEDURE SLALS0_NAT
      MODULE PROCEDURE DLALS0_NAT
      MODULE PROCEDURE CLALS0_NAT
      MODULE PROCEDURE ZLALS0_NAT

      END INTERFACE ! LA_LALS0
      PRIVATE SLALS0_NAT, DLALS0_NAT, CLALS0_NAT, ZLALS0_NAT

      CONTAINS
!
!-----Natural interface for xLALS0
!
      SUBROUTINE SLALS0_NAT( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX,
     $                       LDBX, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, POLES, DIFL, DIFR, Z, K, C, S,
     $                       WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), PERM(*)
         REAL(WP), INTENT(IN) :: DIFL(*), DIFR(LDGNUM,*),
     $                           GIVNUM(LDGNUM,*), POLES(LDGNUM,*), Z(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         REAL(WP), INTENT(OUT) :: BX(LDBX,*), WORK(*)
         CALL SLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, PERM(1), GIVPTR, GIVCOL(1,1), LDGCOL,
     $                GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1,1), Z(1), K, C, S, WORK(1), INFO )
      END SUBROUTINE SLALS0_NAT

      SUBROUTINE DLALS0_NAT( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX,
     $                       LDBX, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, POLES, DIFL, DIFR, Z, K, C, S,
     $                       WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), PERM(*)
         REAL(WP), INTENT(IN) :: DIFL(*), DIFR(LDGNUM,*),
     $                           GIVNUM(LDGNUM,*), POLES(LDGNUM,*), Z(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         REAL(WP), INTENT(OUT) :: BX(LDBX,*), WORK(*)
         CALL DLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, PERM(1), GIVPTR, GIVCOL(1,1), LDGCOL,
     $                GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1,1), Z(1), K, C, S, WORK(1), INFO )
      END SUBROUTINE DLALS0_NAT

      SUBROUTINE CLALS0_NAT( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX,
     $                       LDBX, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, POLES, DIFL, DIFR, Z, K, C, S,
     $                       RWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), PERM(*)
         REAL(WP), INTENT(IN) :: DIFL(*), DIFR(LDGNUM,*),
     $                           GIVNUM(LDGNUM,*), POLES(LDGNUM,*), Z(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: BX(LDBX,*)
         CALL CLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, PERM(1), GIVPTR, GIVCOL(1,1), LDGCOL,
     $                GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1,1), Z(1), K, C, S, RWORK(1), INFO )
      END SUBROUTINE CLALS0_NAT

      SUBROUTINE ZLALS0_NAT( ICOMPQ, NL, NR, SQRE, NRHS, B, LDB, BX,
     $                       LDBX, PERM, GIVPTR, GIVCOL, LDGCOL, GIVNUM,
     $                       LDGNUM, POLES, DIFL, DIFR, Z, K, C, S,
     $                       RWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: GIVPTR, ICOMPQ, K, LDB, LDBX, LDGCOL,
     $                          LDGNUM, NL, NR, NRHS, SQRE
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: C, S
         INTEGER, INTENT(IN) :: GIVCOL(LDGCOL,*), PERM(*)
         REAL(WP), INTENT(IN) :: DIFL(*), DIFR(LDGNUM,*),
     $                           GIVNUM(LDGNUM,*), POLES(LDGNUM,*), Z(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         COMPLEX(WP), INTENT(OUT) :: BX(LDBX,*)
         CALL ZLALS0( ICOMPQ, NL, NR, SQRE, NRHS, B(1,1), LDB, BX(1,1),
     $                LDBX, PERM(1), GIVPTR, GIVCOL(1,1), LDGCOL,
     $                GIVNUM(1,1), LDGNUM, POLES(1,1), DIFL(1),
     $                DIFR(1,1), Z(1), K, C, S, RWORK(1), INFO )
      END SUBROUTINE ZLALS0_NAT

      END MODULE LA_XLALS0
