      MODULE LA_XLAHQR
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 03, 2002
!
!  Purpose
!  =======
!
!  LA_XLAHQR defines generic interfaces for xLAHQR.
!
      INTERFACE LA_LAHQR

      SUBROUTINE SLAHQR( WANTT, WANTZ, N, ILO, IHI, H, LDH, WR, WI,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H, Z
         REAL(WP), INTENT(OUT) :: WI, WR
      END SUBROUTINE SLAHQR

      SUBROUTINE DLAHQR( WANTT, WANTZ, N, ILO, IHI, H, LDH, WR, WI,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H, Z
         REAL(WP), INTENT(OUT) :: WI, WR
      END SUBROUTINE DLAHQR

      SUBROUTINE CLAHQR( WANTT, WANTZ, N, ILO, IHI, H, LDH, W,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H, Z
         COMPLEX(WP), INTENT(OUT) :: W
      END SUBROUTINE CLAHQR

      SUBROUTINE ZLAHQR( WANTT, WANTZ, N, ILO, IHI, H, LDH, W,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H, Z
         COMPLEX(WP), INTENT(OUT) :: W
      END SUBROUTINE ZLAHQR

      MODULE PROCEDURE SLAHQR_H2W1Z2
      MODULE PROCEDURE DLAHQR_H2W1Z2
      MODULE PROCEDURE CLAHQR_H2W1Z2
      MODULE PROCEDURE ZLAHQR_H2W1Z2

      END INTERFACE ! LA_LAHQR
      PRIVATE SLAHQR_H2W1Z2, DLAHQR_H2W1Z2, CLAHQR_H2W1Z2, ZLAHQR_H2W1Z2

      CONTAINS

      SUBROUTINE SLAHQR_H2W1Z2( WANTT, WANTZ, N, ILO, IHI, H, LDH, WR,
     $                          WI, ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WI(*), WR(*)
         CALL SLAHQR( WANTT, WANTZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     $                WI(1), ILOZ, IHIZ, Z(1,1), LDZ, INFO )
      END SUBROUTINE SLAHQR_H2W1Z2

      SUBROUTINE DLAHQR_H2W1Z2( WANTT, WANTZ, N, ILO, IHI, H, LDH, WR,
     $                          WI, ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         REAL(WP), INTENT(OUT) :: WI(*), WR(*)
         CALL DLAHQR( WANTT, WANTZ, N, ILO, IHI, H(1,1), LDH, WR(1),
     $                WI(1), ILOZ, IHIZ, Z(1,1), LDZ, INFO )
      END SUBROUTINE DLAHQR_H2W1Z2

      SUBROUTINE CLAHQR_H2W1Z2( WANTT, WANTZ, N, ILO, IHI, H, LDH, W,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: W(*)
         CALL CLAHQR( WANTT, WANTZ, N, ILO, IHI, H(1,1), LDH, W(1),
     $                ILOZ, IHIZ, Z(1,1), LDZ, INFO )
      END SUBROUTINE CLAHQR_H2W1Z2

      SUBROUTINE ZLAHQR_H2W1Z2( WANTT, WANTZ, N, ILO, IHI, H, LDH, W,
     $                   ILOZ, IHIZ, Z, LDZ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: WANTT, WANTZ
         INTEGER, INTENT(IN) :: IHI, IHIZ, ILO, ILOZ, LDH, LDZ, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: H(LDH,*), Z(LDZ,*)
         COMPLEX(WP), INTENT(OUT) :: W(*)
         CALL ZLAHQR( WANTT, WANTZ, N, ILO, IHI, H(1,1), LDH, W(1),
     $                ILOZ, IHIZ, Z(1,1), LDZ, INFO )
      END SUBROUTINE ZLAHQR_H2W1Z2

      END MODULE LA_XLAHQR
