      MODULE LA_XLAGV2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 04, 2002
!
!  Purpose
!  =======
!
!  LA_XLAGV2 defines generic interfaces for xLAGV2.
!
      INTERFACE LA_LAGV2

      SUBROUTINE SLAGV2( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA, CSL, SNL,
     $                   CSR, SNR )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA
      END SUBROUTINE SLAGV2

      SUBROUTINE DLAGV2( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA, CSL, SNL,
     $                   CSR, SNR )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI, ALPHAR, BETA
      END SUBROUTINE DLAGV2

      MODULE PROCEDURE SLAGV2_A2B2
      MODULE PROCEDURE DLAGV2_A2B2
      MODULE PROCEDURE SLAGV2_A0B0
      MODULE PROCEDURE DLAGV2_A0B0

      END INTERFACE ! LA_LAGV2
      PRIVATE SLAGV2_A2B2, DLAGV2_A2B2, SLAGV2_A0B0, DLAGV2_A0B0

      CONTAINS
!
!-----Natural interface for xLAGV2
!
      SUBROUTINE SLAGV2_A2B2( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA,
     $                        CSL, SNL, CSR, SNR )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(2), ALPHAR(2), BETA(2)
         CALL SLAGV2( A(1,1), LDA, B(1,1), LDB, ALPHAR(1), ALPHAI(1),
     $                BETA(1), CSL, SNL, CSR, SNR )
      END SUBROUTINE SLAGV2_A2B2

      SUBROUTINE DLAGV2_A2B2( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA,
     $                        CSL, SNL, CSR, SNR )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A(LDA,*), B(LDB,*)
         REAL(WP), INTENT(OUT) :: ALPHAI(2), ALPHAR(2), BETA(2)
         CALL DLAGV2( A(1,1), LDA, B(1,1), LDB, ALPHAR(1), ALPHAI(1),
     $                BETA(1), CSL, SNL, CSR, SNR )
      END SUBROUTINE DLAGV2_A2B2
!
!-----Alternate interface for xLAGV2
!
      SUBROUTINE SLAGV2_A0B0( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA,
     $                          CSL, SNL, CSR, SNR )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI(2), ALPHAR(2), BETA(2)
         CALL SLAGV2( A, LDA, B, LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     $                CSL, SNL, CSR, SNR )
      END SUBROUTINE SLAGV2_A0B0

      SUBROUTINE DLAGV2_A0B0( A, LDA, B, LDB, ALPHAR, ALPHAI, BETA,
     $                        CSL, SNL, CSR, SNR )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDB
         REAL(WP), INTENT(IN) :: CSL, CSR, SNL, SNR
         REAL(WP), INTENT(INOUT) :: A, B
         REAL(WP), INTENT(OUT) :: ALPHAI(2), ALPHAR(2), BETA(2)
         CALL DLAGV2( A, LDA, B, LDB, ALPHAR(1), ALPHAI(1), BETA(1),
     $                CSL, SNL, CSR, SNR )
      END SUBROUTINE DLAGV2_A0B0

      END MODULE LA_XLAGV2
