      MODULE LA_XLAEBZ
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 05, 2002
!
!  Purpose
!  =======
!
!  LA_XLAEBZ defines generic interfaces for xLAEBZ.
!
      INTERFACE LA_LAEBZ

      SUBROUTINE SLAEBZ( IJOB, NITMAX, N, MMAX, MINP, NBMIN, ABSTOL,
     $                   RELTOL, PIVMIN, D, E, E2, NVAL, AB, C, MOUT,
     $                   NAB, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, MINP, MMAX, N, NBMIN, NITMAX
         INTEGER, INTENT(OUT) :: INFO, MOUT
         REAL(WP), INTENT(IN) :: ABSTOL, PIVMIN, RELTOL
         INTEGER, INTENT(INOUT) :: NAB, NVAL
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) ::  D, E, E2
         REAL(WP), INTENT(INOUT) :: AB, C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLAEBZ

      SUBROUTINE DLAEBZ( IJOB, NITMAX, N, MMAX, MINP, NBMIN, ABSTOL,
     $                   RELTOL, PIVMIN, D, E, E2, NVAL, AB, C, MOUT,
     $                   NAB, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, MINP, MMAX, N, NBMIN, NITMAX
         INTEGER, INTENT(OUT) :: INFO, MOUT
         REAL(WP), INTENT(IN) :: ABSTOL, PIVMIN, RELTOL
         INTEGER, INTENT(INOUT) :: NAB, NVAL
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) ::  D, E, E2
         REAL(WP), INTENT(INOUT) :: AB, C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DLAEBZ

      END INTERFACE ! LA_LAEBZ

      CONTAINS
!
!-----Natural interface for xLAEBZ
!
      SUBROUTINE SLAEBZ_D1A2W1( IJOB, NITMAX, N, MMAX, MINP, NBMIN,
     $                          ABSTOL, RELTOL, PIVMIN, D, E, E2, NVAL,
     $                          AB, C, MOUT, NAB, WORK, IWORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, MINP, MMAX, N, NBMIN, NITMAX
         INTEGER, INTENT(OUT) :: INFO, MOUT
         REAL(WP), INTENT(IN) :: ABSTOL, PIVMIN, RELTOL
         INTEGER, INTENT(INOUT) :: NAB(MMAX,*), NVAL(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) ::  D(*), E(*), E2(*)
         REAL(WP), INTENT(INOUT) :: AB(MMAX,*), C(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLAEBZ( IJOB, NITMAX, N, MMAX, MINP, NBMIN, ABSTOL,
     $                RELTOL, PIVMIN, D(1), E(1), E2(1), NVAL(1),
     $                AB(1,1), C(1), MOUT, NAB(1,1), WORK(1), IWORK(1),
     $                INFO )
      END SUBROUTINE SLAEBZ_D1A2W1

      SUBROUTINE DLAEBZ_D1A2W1( IJOB, NITMAX, N, MMAX, MINP, NBMIN,
     $                          ABSTOL, RELTOL, PIVMIN, D, E, E2, NVAL,
     $                          AB, C, MOUT, NAB, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IJOB, MINP, MMAX, N, NBMIN, NITMAX
         INTEGER, INTENT(OUT) :: INFO, MOUT
         REAL(WP), INTENT(IN) :: ABSTOL, PIVMIN, RELTOL
         INTEGER, INTENT(INOUT) :: NAB(MMAX,*), NVAL(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) ::  D(*), E(*), E2(*)
         REAL(WP), INTENT(INOUT) :: AB(MMAX,*), C(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DLAEBZ( IJOB, NITMAX, N, MMAX, MINP, NBMIN, ABSTOL,
     $                RELTOL, PIVMIN, D(1), E(1), E2(1), NVAL(1),
     $                AB(1,1), C(1), MOUT, NAB(1,1), WORK(1), IWORK(1),
     $                INFO )
      END SUBROUTINE DLAEBZ_D1A2W1

      END MODULE LA_XLAEBZ
