      MODULE LA_XHETD2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 6, 2002
!
!  Purpose
!  =======
!
!  LA_XHETD2 defines generic interfaces for xHETD2 and xLATRD.
!
      INTERFACE LA_HETD2

      SUBROUTINE CHETD2( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE CHETD2

      SUBROUTINE ZHETD2( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAU
      END SUBROUTINE ZHETD2

      MODULE PROCEDURE CHETD2_A2D1T1
      MODULE PROCEDURE ZHETD2_A2D1T1

      END INTERFACE ! LA_HETD2
      PRIVATE CHETD2_A2D1T1, ZHETD2_A2D1T1

      INTERFACE LA_LATRD

      SUBROUTINE SLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E, TAU, W
      END SUBROUTINE SLATRD

      SUBROUTINE DLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E, TAU, W
      END SUBROUTINE DLATRD

      SUBROUTINE CLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E
         COMPLEX(WP), INTENT(OUT) :: TAU, W
      END SUBROUTINE CLATRD

      SUBROUTINE ZLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E
         COMPLEX(WP), INTENT(OUT) :: TAU, W
      END SUBROUTINE ZLATRD

      MODULE PROCEDURE SLATRD_A2T1W2
      MODULE PROCEDURE DLATRD_A2T1W2
      MODULE PROCEDURE CLATRD_A2T1W2
      MODULE PROCEDURE ZLATRD_A2T1W2

      END INTERFACE ! LA_LATRD
      PRIVATE SLATRD_A2T1W2, DLATRD_A2T1W2, CLATRD_A2T1W2, ZLATRD_A2T1W2

      CONTAINS
!
!-----Natural interface for xHETD2
!
      SUBROUTINE CHETD2_A2D1T1( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL CHETD2( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), INFO )
      END SUBROUTINE CHETD2_A2D1T1

      SUBROUTINE ZHETD2_A2D1T1( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*)
         CALL ZHETD2( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), INFO )
      END SUBROUTINE ZHETD2_A2D1T1
!
!-----Natural interface for xLAHRD
!
      SUBROUTINE SLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*), TAU(*), W(LDW,*)
         CALL SLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE SLATRD_A2T1W2

      SUBROUTINE DLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*), TAU(*), W(LDW,*)
         CALL DLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE DLATRD_A2T1W2

      SUBROUTINE CLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), W(LDW,*)
         CALL CLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE CLATRD_A2T1W2

      SUBROUTINE ZLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), W(LDW,*)
         CALL ZLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE ZLATRD_A2T1W2

      END MODULE LA_XHETD2
