      MODULE LA_XGESC2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 06, 2002
!
!  Purpose
!  =======
!
!  LA_XGESC2 defines generic interfaces for xGESC2.
!
      INTERFACE LA_GESC2

      SUBROUTINE SGESC2( N, A, LDA, RHS, IPIV, JPIV, SCALE )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: RHS(*)
      END SUBROUTINE SGESC2

      SUBROUTINE DGESC2( N, A, LDA, RHS, IPIV, JPIV, SCALE )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: RHS(*)
      END SUBROUTINE DGESC2

      SUBROUTINE CGESC2( N, A, LDA, RHS, IPIV, JPIV, SCALE )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: RHS(*)
      END SUBROUTINE CGESC2

      SUBROUTINE ZGESC2( N, A, LDA, RHS, IPIV, JPIV, SCALE )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, N
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(IN) :: IPIV(*), JPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: RHS(*)
      END SUBROUTINE ZGESC2

      END INTERFACE ! LA_GESC2

      END MODULE LA_XGESC2
