      MODULE LA_XGELQ2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 26, 2002
!
!  Purpose
!  =======
!
!  LA_XGELQ2 defines generic interfaces for xGELQ2, xORGL2/xUNGL2,
!  and xORML2/xUNML2.
!
      INTERFACE LA_GELQ2

      SUBROUTINE SGELQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGELQ2

      SUBROUTINE DGELQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE DGELQ2

      SUBROUTINE CGELQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGELQ2

      SUBROUTINE ZGELQ2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE ZGELQ2

      MODULE PROCEDURE SGELQ2_A2T1W1
      MODULE PROCEDURE DGELQ2_A2T1W1
      MODULE PROCEDURE CGELQ2_A2T1W1
      MODULE PROCEDURE ZGELQ2_A2T1W1

      END INTERFACE ! LA_GELQ2
      PRIVATE SGELQ2_A2T1W1, DGELQ2_A2T1W1, CGELQ2_A2T1W1, ZGELQ2_A2T1W1

      INTERFACE LA_ORGL2

      SUBROUTINE SORGL2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORGL2

      SUBROUTINE DORGL2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORGL2

      MODULE PROCEDURE SORGL2_A2T1W1
      MODULE PROCEDURE DORGL2_A2T1W1

      END INTERFACE ! LA_ORGL2

      INTERFACE LA_UNGL2

      SUBROUTINE CUNGL2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNGL2

      SUBROUTINE ZUNGL2( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNGL2

      MODULE PROCEDURE CUNGL2_A2T1W1
      MODULE PROCEDURE ZUNGL2_A2T1W1

      END INTERFACE ! LA_UNGL2
      PRIVATE SORGL2_A2T1W1, DORGL2_A2T1W1, CUNGL2_A2T1W1, ZUNGL2_A2T1W1

      INTERFACE LA_ORML2

      SUBROUTINE SORML2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORML2

      SUBROUTINE DORML2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE DORML2

      MODULE PROCEDURE SORML2_A2T1W1
      MODULE PROCEDURE DORML2_A2T1W1

      END INTERFACE ! LA_ORML2

      INTERFACE LA_UNML2

      SUBROUTINE CUNML2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNML2

      SUBROUTINE ZUNML2( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE ZUNML2

      MODULE PROCEDURE CUNML2_A2T1W1
      MODULE PROCEDURE ZUNML2_A2T1W1

      END INTERFACE ! LA_UNML2
      PRIVATE SORML2_A2T1W1, DORML2_A2T1W1, CUNML2_A2T1W1, ZUNML2_A2T1W1

      CONTAINS
!
!-----Natural interface for xGELQ2
!
      SUBROUTINE SGELQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGELQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SGELQ2_A2T1W1

      SUBROUTINE DGELQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL DGELQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DGELQ2_A2T1W1

      SUBROUTINE CGELQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGELQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CGELQ2_A2T1W1

      SUBROUTINE ZGELQ2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL ZGELQ2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZGELQ2_A2T1W1
!
!-----Natural interface for xORGL2/xUNGL2
!
      SUBROUTINE SORGL2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORGL2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SORGL2_A2T1W1

      SUBROUTINE DORGL2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORGL2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE DORGL2_A2T1W1

      SUBROUTINE CUNGL2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNGL2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CUNGL2_A2T1W1

      SUBROUTINE ZUNGL2_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNGL2( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE ZUNGL2_A2T1W1
!
!-----Natural interface for xORML2/xUNML2
!
      SUBROUTINE SORML2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORML2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE SORML2_A2T1W1

      SUBROUTINE DORML2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL DORML2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE DORML2_A2T1W1

      SUBROUTINE CUNML2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNML2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE CUNML2_A2T1W1

      SUBROUTINE ZUNML2_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL ZUNML2( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE ZUNML2_A2T1W1

      END MODULE LA_XGELQ2
