      MODULE LA_XGEHD2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 4, 2002
!
!  Purpose
!  =======
!
!  LA_XGEHD2 defines generic interfaces for xGEHD2 and xLAHRD.
!
      INTERFACE LA_GEHD2

      SUBROUTINE SGEHD2( N, ILO, IHI, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
      END SUBROUTINE SGEHD2

      SUBROUTINE DGEHD2( N, ILO, IHI, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
      END SUBROUTINE DGEHD2

      SUBROUTINE CGEHD2( N, ILO, IHI, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
      END SUBROUTINE CGEHD2

      SUBROUTINE ZGEHD2( N, ILO, IHI, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IHI, ILO, LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
      END SUBROUTINE ZGEHD2

      END INTERFACE ! LA_GEHD2

      INTERFACE LA_LAHRD

      SUBROUTINE SLAHRD( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: T, TAU, Y
      END SUBROUTINE SLAHRD

      SUBROUTINE DLAHRD( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: T, TAU, Y
      END SUBROUTINE DLAHRD

      SUBROUTINE CLAHRD( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: T, TAU, Y
      END SUBROUTINE CLAHRD

      SUBROUTINE ZLAHRD( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: T, TAU, Y
      END SUBROUTINE ZLAHRD

      MODULE PROCEDURE SLAHRD_A2U1T2
      MODULE PROCEDURE DLAHRD_A2U1T2
      MODULE PROCEDURE CLAHRD_A2U1T2
      MODULE PROCEDURE ZLAHRD_A2U1T2

      END INTERFACE ! LA_LAHRD
      PRIVATE SLAHRD_A2U1T2, DLAHRD_A2U1T2, CLAHRD_A2U1T2, ZLAHRD_A2U1T2

      CONTAINS
!
!-----Natural interface for xLAHRD
!
      SUBROUTINE SLAHRD_A2U1T2( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: T(LDT,NB), TAU(NB), Y(LDY,NB)
         CALL SLAHRD( N, K, NB, A(1,1), LDA, TAU(1), T(1,1), LDT,
     &                Y(1,1), LDY )
      END SUBROUTINE SLAHRD_A2U1T2

      SUBROUTINE DLAHRD_A2U1T2( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: T(LDT,NB), TAU(NB), Y(LDY,NB)
         CALL DLAHRD( N, K, NB, A(1,1), LDA, TAU(1), T(1,1), LDT,
     &                Y(1,1), LDY )
      END SUBROUTINE DLAHRD_A2U1T2

      SUBROUTINE CLAHRD_A2U1T2( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: T(LDT,NB), TAU(NB), Y(LDY,NB)
         CALL CLAHRD( N, K, NB, A(1,1), LDA, TAU(1), T(1,1), LDT,
     &                Y(1,1), LDY )
      END SUBROUTINE CLAHRD_A2U1T2

      SUBROUTINE ZLAHRD_A2U1T2( N, K, NB, A, LDA, TAU, T, LDT, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, LDT, LDY, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: T(LDT,NB), TAU(NB), Y(LDY,NB)
         CALL ZLAHRD( N, K, NB, A(1,1), LDA, TAU(1), T(1,1), LDT,
     &                Y(1,1), LDY )
      END SUBROUTINE ZLAHRD_A2U1T2

      END MODULE LA_XGEHD2
