      MODULE LA_XGEBD2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 3, 2002
!
!  Purpose
!  =======
!
!  LA_XGEBD2 defines generic interfaces for xGEBD2 and xLABRD.
!
      INTERFACE LA_GEBD2

      SUBROUTINE SGEBD2( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAUP, TAUQ, WORK
      END SUBROUTINE SGEBD2

      SUBROUTINE DGEBD2( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAUP, TAUQ, WORK
      END SUBROUTINE DGEBD2

      SUBROUTINE CGEBD2( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE CGEBD2

      SUBROUTINE ZGEBD2( M, N, A, LDA, D, E, TAUQ, TAUP, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, WORK
      END SUBROUTINE ZGEBD2

      MODULE PROCEDURE SGEBD2_A2D1W1
      MODULE PROCEDURE DGEBD2_A2D1W1
      MODULE PROCEDURE CGEBD2_A2D1W1
      MODULE PROCEDURE ZGEBD2_A2D1W1

      END INTERFACE ! LA_GEBD2
      PRIVATE SGEBD2_A2D1W1, DGEBD2_A2D1W1, CGEBD2_A2D1W1, ZGEBD2_A2D1W1

      INTERFACE LA_LABRD

      SUBROUTINE SLABRD( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X, LDX, Y,
     $                   LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAUP, TAUQ, X, Y
      END SUBROUTINE SLABRD

      SUBROUTINE DLABRD( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X, LDX, Y,
     $                   LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAUP, TAUQ, X, Y
      END SUBROUTINE DLABRD

      SUBROUTINE CLABRD( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X, LDX, Y,
     $                   LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, X, Y
      END SUBROUTINE CLABRD

      SUBROUTINE ZLABRD( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X, LDX, Y,
     $                   LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E
         COMPLEX(WP), INTENT(OUT) :: TAUP, TAUQ, X, Y
      END SUBROUTINE ZLABRD

      MODULE PROCEDURE SLABRD_A2D1X2
      MODULE PROCEDURE DLABRD_A2D1X2
      MODULE PROCEDURE CLABRD_A2D1X2
      MODULE PROCEDURE ZLABRD_A2D1X2

      END INTERFACE ! LA_LABRD
      PRIVATE SLABRD_A2D1X2, DLABRD_A2D1X2, CLABRD_A2D1X2, ZLABRD_A2D1X2

      CONTAINS
!
!-----Natural interface for xGEBD2
!
      SUBROUTINE SGEBD2_A2D1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     $                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAUP(*), TAUQ(*), WORK(*)
         CALL SGEBD2( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     $                WORK(1), INFO )
      END SUBROUTINE SGEBD2_A2D1W1

      SUBROUTINE DGEBD2_A2D1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     $                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAUP(*), TAUQ(*), WORK(*)
         CALL DGEBD2( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     $                WORK(1), INFO )
      END SUBROUTINE DGEBD2_A2D1W1

      SUBROUTINE CGEBD2_A2D1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     $                          INFO )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL CGEBD2( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     $                WORK(1), INFO )
      END SUBROUTINE CGEBD2_A2D1W1

      SUBROUTINE ZGEBD2_A2D1W1( M, N, A, LDA, D, E, TAUQ, TAUP, WORK,
     $                          INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), WORK(*)
         CALL ZGEBD2( M, N, A(1,1), LDA, D(1), E(1), TAUQ(1), TAUP(1),
     $                WORK(1), INFO )
      END SUBROUTINE ZGEBD2_A2D1W1
!
!-----Natural interface for xLABRD
!
      SUBROUTINE SLABRD_A2D1X2( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X,
     $                          LDX, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAUP(*), TAUQ(*),
     $                            X(LDX,*), Y(LDY,*)
         CALL SLABRD( M, N, NB, A(1,1), LDA, D(1), E(1), TAUQ(1),
     $                TAUP(1), X(1,1), LDX, Y(1,1), LDY )
      END SUBROUTINE SLABRD_A2D1X2

      SUBROUTINE DLABRD_A2D1X2( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X,
     $                          LDX, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAUP(*), TAUQ(*),
     $                            X(LDX,*), Y(LDY,*)
         CALL DLABRD( M, N, NB, A(1,1), LDA, D(1), E(1), TAUQ(1),
     $                TAUP(1), X(1,1), LDX, Y(1,1), LDY )
      END SUBROUTINE DLABRD_A2D1X2

      SUBROUTINE CLABRD_A2D1X2( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X,
     $                          LDX, Y, LDY )
         USE LA_CONSTANTS32, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), X(LDX,*),
     $                               Y(LDY,*)
         CALL CLABRD( M, N, NB, A(1,1), LDA, D(1), E(1), TAUQ(1),
     $                TAUP(1), X(1,1), LDX, Y(1,1), LDY )
      END SUBROUTINE CLABRD_A2D1X2

      SUBROUTINE ZLABRD_A2D1X2( M, N, NB, A, LDA, D, E, TAUQ, TAUP, X,
     $                          LDX, Y, LDY )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, LDX, LDY, M, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*)
         COMPLEX(WP), INTENT(OUT) :: TAUP(*), TAUQ(*), X(LDX,*),
     $                               Y(LDY,*)
         CALL ZLABRD( M, N, NB, A(1,1), LDA, D(1), E(1), TAUQ(1),
     $                TAUP(1), X(1,1), LDX, Y(1,1), LDY )
      END SUBROUTINE ZLABRD_A2D1X2

      END MODULE LA_XGEBD2
