      MODULE LA_XGBTF2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 12, 2002
!
!  Purpose
!  =======
!
!  LA_XGBTF2 defines a generic interface for xGBTF2.
!
      INTERFACE LA_GBTF2

      SUBROUTINE SGBTF2( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE SGBTF2

      SUBROUTINE DGBTF2( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE DGBTF2

      SUBROUTINE CGBTF2( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE CGBTF2

      SUBROUTINE ZGBTF2( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB
         INTEGER, INTENT(OUT) :: IPIV
      END SUBROUTINE ZGBTF2

      MODULE PROCEDURE SGBTF2_A2I1
      MODULE PROCEDURE DGBTF2_A2I1
      MODULE PROCEDURE CGBTF2_A2I1
      MODULE PROCEDURE ZGBTF2_A2I1

      END INTERFACE ! LA_GBTF2
      PRIVATE SGBTF2_A2I1, DGBTF2_A2I1, CGBTF2_A2I1, ZGBTF2_A2I1

      CONTAINS

      SUBROUTINE SGBTF2_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL SGBTF2( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE SGBTF2_A2I1

      SUBROUTINE DGBTF2_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL DGBTF2( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE DGBTF2_A2I1

      SUBROUTINE CGBTF2_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS32, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL CGBTF2( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE CGBTF2_A2I1

      SUBROUTINE ZGBTF2_A2I1( M, N, KL, KU, AB, LDAB, IPIV, INFO )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: M, N, KL, KU, LDAB
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
         INTEGER, INTENT(OUT) :: IPIV(*)
         CALL ZGBTF2( M, N, KL, KU, AB(1,1), LDAB, IPIV(1), INFO )
      END SUBROUTINE ZGBTF2_A2I1

      END MODULE LA_XGBTF2
