#include "lapacknames.inc"
      SUBROUTINE CTPTS2( IUPLO, ITRANS, IDIAG, N, NRHS, AP, B, LDB )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LACGV
      USE LA_BLAS1, ONLY: LA_SCAL
      USE LA_BLAS2, ONLY: LA_GEMV, LA_GERU, LA_TPSV
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-18-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IDIAG, ITRANS, IUPLO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      COMPLEX(WP)        AP( * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CTPTS2 solves a triangular system of the form
*
*     A * X = B,  A**T * X = B,  or  A**H * X = B,
*
*  where A is a triangular matrix of order N stored in packed format,
*  A**T is the transpose of A, A**H is the conjugate transpose of A,
*  and B is an N-by-NRHS matrix.
*
*  Arguments
*  =========
*
*  IUPLO   (input) INTEGER
*          Specifies whether the matrix A is upper or lower triangular.
*          = 1:  Upper triangular
*          = 0:  Lower triangular
*
*  ITRANS  (input) INTEGER
*          Specifies the form of the system of equations.
*          = 0:  A * X = B     (No transpose)
*          = 1:  A**T * X = B  (Transpose)
*          = 2:  A**H * X = B  (Conjugate transpose)
*
*  IDIAG   (input) INTEGER
*          Specifies whether or not the matrix A is unit triangular.
*          = 0:  Non-unit triangular
*          = 1:  Unit triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  AP      (input) COMPLEX array, dimension (N*(N+1)/2)
*          The upper or lower triangular matrix A, packed columnwise in
*          a linear array.  The j-th column of A is stored in the array
*          AP as follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2*n-j)/2) = A(i,j) for j<=i<=n.
*
*  B       (input/output) COMPLEX array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B.
*          On exit, the solution matrix X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            NOUNIT
      CHARACTER          DIAG
      INTEGER            J, KK
*     ..
*     .. Executable Statements ..
*
      NOUNIT = IDIAG.EQ.0
      IF( NOUNIT ) THEN
         DIAG = 'N'
      ELSE
         DIAG = 'U'
      END IF
*
      IF( IUPLO.EQ.1 ) THEN
*
*        Upper triangular matrix
*
         IF( ITRANS.EQ.0 ) THEN
*
*           Solve U*X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Upper', 'No transpose', DIAG, N, AP(1),
     $                       B(1,1), 1 )
            ELSE
               KK = ( N*( N+1 ) ) / 2
               DO 10 J = N, 1, -1
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ),
     $                             LDB )
                  CALL LA_GERU( J-1, NRHS, -CONE, AP( KK-J+1 ), 1,
     $                          B( J, 1 ), LDB, B( 1, 1 ), LDB )
                  KK = KK - J
   10          CONTINUE
            END IF
         ELSE IF( ITRANS.EQ.1 ) THEN
*
*           Solve U^T * X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Upper', 'Transpose', DIAG, N, AP(1),
     $                       B(1,1), 1 )
            ELSE
               KK = 1
               DO 20 J = 1, N
                  CALL LA_GEMV( 'Transpose', J-1, NRHS, -CONE, B(1,1),
     $                          LDB, AP( KK ), 1, CONE, B( J, 1 ), LDB )
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / AP( KK+J-1 ), B( J, 1 ),
     $                             LDB )
                  KK = KK + J
   20          CONTINUE
            END IF
         ELSE
*
*           Solve U^H * X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Upper', 'Conjugate transpose', DIAG, N,
     $                       AP(1), B(1,1), 1 )
            ELSE
               KK = 1
               DO 30 J = 1, N
                  CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
                  CALL LA_GEMV( 'Conjugate transpose', J-1, NRHS, -CONE,
     $                          B( 1, 1 ), LDB, AP( KK ), 1, CONE,
     $                          B( J, 1 ), LDB )
                  CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / CONJG( AP( KK+J-1 ) ),
     $                             B( J, 1 ), LDB )
                  KK = KK + J
   30          CONTINUE
            END IF
         END IF
*
      ELSE
*
*        Lower triangular matrix
*
         IF( ITRANS.EQ.0 ) THEN
*
*           Solve L*X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Lower', 'No transpose', DIAG, N, AP(1),
     $                       B(1,1), 1 )
            ELSE
               KK = 1
               DO 40 J = 1, N - 1
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ),
     $                             LDB )
                  CALL LA_GERU( N-J, NRHS, -CONE, AP( KK+1 ), 1,
     $                          B( J, 1 ), LDB, B( J+1, 1 ), LDB )
                  KK = KK + ( N-J+1 )
   40          CONTINUE
               IF( NOUNIT )
     $            CALL LA_SCAL( NRHS, CONE / AP( KK ), B( N, 1 ), LDB )
            END IF
         ELSE IF( ITRANS.EQ.1 ) THEN
*
*           Solve L^T * X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Lower', 'Transpose', DIAG, N, AP(1),
     $                       B(1,1), 1 )
            ELSE
               KK = ( N*( N+1 ) ) / 2
               IF( NOUNIT )
     $            CALL LA_SCAL( NRHS, CONE / AP( KK ), B( N, 1 ), LDB )
               KK = KK - 2
               DO 50 J = N - 1, 1, -1
                  CALL LA_GEMV( 'Transpose', N-J, NRHS, -CONE,
     $                          B( J+1, 1 ), LDB, AP( KK+1 ), 1, CONE,
     $                          B( J, 1 ), LDB )
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / AP( KK ), B( J, 1 ),
     $                             LDB )
                  KK = KK - ( N-J+2 )
   50          CONTINUE
            END IF
         ELSE
*
*           Solve L^H * X = B
*
            IF( NRHS.EQ.1 ) THEN
               CALL LA_TPSV( 'Lower', 'Conjugate transpose', DIAG, N,
     $                       AP(1), B(1,1), 1 )
            ELSE
               KK = ( N*( N+1 ) ) / 2
               IF( NOUNIT )
     $            CALL LA_SCAL( NRHS, CONE / CONJG( AP( KK ) ),
     $                          B( N, 1 ), LDB )
               KK = KK - 2
               DO 60 J = N - 1, 1, -1
                  CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
                  CALL LA_GEMV( 'Conjugate transpose', N-J, NRHS, -CONE,
     $                          B( J+1, 1 ), LDB, AP( KK+1 ), 1, CONE,
     $                          B( J, 1 ), LDB )
                  CALL LA_LACGV( NRHS, B( J, 1 ), LDB )
                  IF( NOUNIT )
     $               CALL LA_SCAL( NRHS, CONE / CONJG( AP( KK ) ),
     $                             B( J, 1 ), LDB )
                  KK = KK - ( N-J+2 )
   60          CONTINUE
            END IF
         END IF
      END IF
*
      RETURN
*
*     End of CTPTS2
*
      END
